
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from vldb.xg */
#include <vldb.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("vldb.ydr.c generated from vldb.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

char *ydr_encode_bulk(bulk *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
char zero[4] = {0, 0, 0, 0};
memcpy (ptr, (*o).val, (*o).len);
memcpy (ptr + (*o).len, zero, (4 - ((*o).len % 4)) % 4);
ptr += (*o).len + (4 - ((*o).len % 4)) % 4;
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_bulk(bulk *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).len = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
(*o).val = (char *)malloc(sizeof(char ) * (*o).len);
{
memcpy ((*o).val, ptr, (*o).len);
ptr += (*o).len + (4 - ((*o).len % 4)) % 4;
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_bulk(bulk *o)
{
/* printing TVARRAY (*o) */
unsigned int i0;
char *ptr = (*o).val;
printf("0x");for (i0 = 0; i0 < (*o).len; ++i0)
printf("%x", ptr[i0]);return;
}
char *ydr_encode_vldbentry(vldbentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp = htonl((*o).name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).volumeType); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).nServers); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverNumber[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverPartition[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverFlags[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).volumeId[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_vldbentry(vldbentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).name[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeType = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nServers = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverPartition[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverFlags[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeId[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_vldbentry(vldbentry *o)
{
/* printing TSTRUCT (*o) */
{ 
unsigned int i0;
/* printing ARRAY (*o).name */
for (i0 = 0; i0 < 65; ++i0) {
printf("  = %d", (*o).name[i0]);
if (i0 != 65 - 1) printf(",");
}
}

printf(" .volumeType = %d", (*o).volumeType);
printf(" .nServers = %d", (*o).nServers);
{ 
unsigned int i0;
/* printing ARRAY (*o).serverNumber */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverNumber[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverPartition */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverPartition[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverFlags */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverFlags[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).volumeId */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).volumeId[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .cloneId = %d", (*o).cloneId);
printf(" .flags = %d", (*o).flags);
return;
}
char *ydr_encode_nvldbentry(nvldbentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp = htonl((*o).name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).nServers); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverNumber[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverPartition[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverFlags[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).volumeId[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares1); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares2); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares3); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares4); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares5); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares6); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares7); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares8); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares9); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_nvldbentry(nvldbentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).name[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nServers = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverPartition[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverFlags[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeId[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares1 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares2 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares3 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares4 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares5 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares6 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares7 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares8 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares9 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_nvldbentry(nvldbentry *o)
{
/* printing TSTRUCT (*o) */
{ 
unsigned int i0;
/* printing ARRAY (*o).name */
for (i0 = 0; i0 < 65; ++i0) {
printf("  = %d", (*o).name[i0]);
if (i0 != 65 - 1) printf(",");
}
}

printf(" .nServers = %d", (*o).nServers);
{ 
unsigned int i0;
/* printing ARRAY (*o).serverNumber */
for (i0 = 0; i0 < 13; ++i0) {
printf("  = %d", (*o).serverNumber[i0]);
if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverPartition */
for (i0 = 0; i0 < 13; ++i0) {
printf("  = %d", (*o).serverPartition[i0]);
if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverFlags */
for (i0 = 0; i0 < 13; ++i0) {
printf("  = %d", (*o).serverFlags[i0]);
if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).volumeId */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).volumeId[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .cloneId = %d", (*o).cloneId);
printf(" .flags = %d", (*o).flags);
printf(" .spares1 = %d", (*o).spares1);
printf(" .spares2 = %d", (*o).spares2);
printf(" .spares3 = %d", (*o).spares3);
printf(" .spares4 = %d", (*o).spares4);
printf(" .spares5 = %d", (*o).spares5);
printf(" .spares6 = %d", (*o).spares6);
printf(" .spares7 = %d", (*o).spares7);
printf(" .spares8 = %d", (*o).spares8);
printf(" .spares9 = %d", (*o).spares9);
return;
}
char *ydr_encode_vlentry(vlentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).volumeId[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).LockAfsId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).LockTimestamp); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).AssociatedChain); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).nextIdHash[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).nextNameHash); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 2;++i0){
{ int32_t tmp = htonl((*o).spares1[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp = htonl((*o).name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).volumeType); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverNumber[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverPartition[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverFlags[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).RefCount); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 1;++i0){
{ int32_t tmp = htonl((*o).spares2[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_vlentry(vlentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeId[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).LockAfsId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).LockTimestamp = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).AssociatedChain = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nextIdHash[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nextNameHash = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 2;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares1[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).name[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeType = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverPartition[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverFlags[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RefCount = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 1;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares2[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_vlentry(vlentry *o)
{
/* printing TSTRUCT (*o) */
{ 
unsigned int i0;
/* printing ARRAY (*o).volumeId */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).volumeId[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .flags = %d", (*o).flags);
printf(" .LockAfsId = %d", (*o).LockAfsId);
printf(" .LockTimestamp = %d", (*o).LockTimestamp);
printf(" .cloneId = %d", (*o).cloneId);
printf(" .AssociatedChain = %d", (*o).AssociatedChain);
{ 
unsigned int i0;
/* printing ARRAY (*o).nextIdHash */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).nextIdHash[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .nextNameHash = %d", (*o).nextNameHash);
{ 
unsigned int i0;
/* printing ARRAY (*o).spares1 */
for (i0 = 0; i0 < 2; ++i0) {
printf("  = %d", (*o).spares1[i0]);
if (i0 != 2 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).name */
for (i0 = 0; i0 < 65; ++i0) {
printf("  = %d", (*o).name[i0]);
if (i0 != 65 - 1) printf(",");
}
}

printf(" .volumeType = %d", (*o).volumeType);
{ 
unsigned int i0;
/* printing ARRAY (*o).serverNumber */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverNumber[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverPartition */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverPartition[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverFlags */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverFlags[i0]);
if (i0 != 8 - 1) printf(",");
}
}

printf(" .RefCount = %d", (*o).RefCount);
{ 
unsigned int i0;
/* printing ARRAY (*o).spares2 */
for (i0 = 0; i0 < 1; ++i0) {
printf("  = %d", (*o).spares2[i0]);
if (i0 != 1 - 1) printf(",");
}
}

return;
}
char *ydr_encode_disk_vlentry(disk_vlentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).volumeId[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).LockAfsId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).LockTimestamp); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).AssociatedChain); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).nextIdHash[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).nextNameHash); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 2;++i0){
{ int32_t tmp = htonl((*o).spares1[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp = htonl((*o).name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).volumeType); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverNumber[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverPartition[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).serverFlags[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).RefCount); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 1;++i0){
{ int32_t tmp = htonl((*o).spares2[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_disk_vlentry(disk_vlentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeId[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).LockAfsId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).LockTimestamp = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).AssociatedChain = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nextIdHash[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nextNameHash = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 2;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares1[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).name[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeType = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverPartition[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverFlags[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RefCount = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 1;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares2[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_disk_vlentry(disk_vlentry *o)
{
/* printing TSTRUCT (*o) */
{ 
unsigned int i0;
/* printing ARRAY (*o).volumeId */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).volumeId[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .flags = %d", (*o).flags);
printf(" .LockAfsId = %d", (*o).LockAfsId);
printf(" .LockTimestamp = %d", (*o).LockTimestamp);
printf(" .cloneId = %d", (*o).cloneId);
printf(" .AssociatedChain = %d", (*o).AssociatedChain);
{ 
unsigned int i0;
/* printing ARRAY (*o).nextIdHash */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).nextIdHash[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .nextNameHash = %d", (*o).nextNameHash);
{ 
unsigned int i0;
/* printing ARRAY (*o).spares1 */
for (i0 = 0; i0 < 2; ++i0) {
printf("  = %d", (*o).spares1[i0]);
if (i0 != 2 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).name */
for (i0 = 0; i0 < 65; ++i0) {
printf("  = %d", (*o).name[i0]);
if (i0 != 65 - 1) printf(",");
}
}

printf(" .volumeType = %d", (*o).volumeType);
{ 
unsigned int i0;
/* printing ARRAY (*o).serverNumber */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverNumber[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverPartition */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverPartition[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverFlags */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).serverFlags[i0]);
if (i0 != 8 - 1) printf(",");
}
}

printf(" .RefCount = %d", (*o).RefCount);
{ 
unsigned int i0;
/* printing ARRAY (*o).spares2 */
for (i0 = 0; i0 < 1; ++i0) {
printf("  = %d", (*o).spares2[i0]);
if (i0 != 1 - 1) printf(",");
}
}

return;
}
char *ydr_encode_vital_vlheader(vital_vlheader *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).vldbversion); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).headersize); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).freePtr); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).eofPtr); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).allocs); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).frees); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).MaxVolumeId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).totalEntries[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_vital_vlheader(vital_vlheader *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vldbversion = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).headersize = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).freePtr = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).eofPtr = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).allocs = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).frees = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).MaxVolumeId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).totalEntries[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_vital_vlheader(vital_vlheader *o)
{
/* printing TSTRUCT (*o) */
printf(" .vldbversion = %d", (*o).vldbversion);
printf(" .headersize = %d", (*o).headersize);
printf(" .freePtr = %d", (*o).freePtr);
printf(" .eofPtr = %d", (*o).eofPtr);
printf(" .allocs = %d", (*o).allocs);
printf(" .frees = %d", (*o).frees);
printf(" .MaxVolumeId = %d", (*o).MaxVolumeId);
{ 
unsigned int i0;
/* printing ARRAY (*o).totalEntries */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).totalEntries[i0]);
if (i0 != 3 - 1) printf(",");
}
}

return;
}
char *ydr_encode_longarray(longarray *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o)[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_longarray(longarray *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o)[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_longarray(longarray *o)
{
{ 
unsigned int i0;
/* printing ARRAY (*o) */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o)[i0]);
if (i0 != 3 - 1) printf(",");
}
}
return;
}
char *ydr_encode_vlheader(vlheader *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).vital_header.vldbversion); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).vital_header.headersize); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).vital_header.freePtr); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).vital_header.eofPtr); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).vital_header.allocs); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).vital_header.frees); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).vital_header.MaxVolumeId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).vital_header.totalEntries[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ int32_t tmp = htonl((*o).IpMappedAddr[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8191;++i0){
{ int32_t tmp = htonl((*o).VolnameHash[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8191;++i0){
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp = htonl((*o).VolidHash[i0][i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_vlheader(vlheader *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.vldbversion = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.headersize = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.freePtr = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.eofPtr = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.allocs = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.frees = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.MaxVolumeId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).vital_header.totalEntries[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).IpMappedAddr[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8191;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).VolnameHash[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8191;++i0){
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).VolidHash[i0][i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_vlheader(vlheader *o)
{
/* printing TSTRUCT (*o) */
/* printing TSTRUCT (*o).vital_header */
printf(" .vldbversion = %d", (*o).vital_header.vldbversion);
printf(" .headersize = %d", (*o).vital_header.headersize);
printf(" .freePtr = %d", (*o).vital_header.freePtr);
printf(" .eofPtr = %d", (*o).vital_header.eofPtr);
printf(" .allocs = %d", (*o).vital_header.allocs);
printf(" .frees = %d", (*o).vital_header.frees);
printf(" .MaxVolumeId = %d", (*o).vital_header.MaxVolumeId);
{ 
unsigned int i0;
/* printing ARRAY (*o).vital_header.totalEntries */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).vital_header.totalEntries[i0]);
if (i0 != 3 - 1) printf(",");
}
}


{ 
unsigned int i0;
/* printing ARRAY (*o).IpMappedAddr */
for (i0 = 0; i0 < 30; ++i0) {
printf("  = %d", (*o).IpMappedAddr[i0]);
if (i0 != 30 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).VolnameHash */
for (i0 = 0; i0 < 8191; ++i0) {
printf("  = %d", (*o).VolnameHash[i0]);
if (i0 != 8191 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).VolidHash */
for (i0 = 0; i0 < 8191; ++i0) {
{ 
unsigned int i1;
/* printing ARRAY (*o).VolidHash[i0] */
for (i1 = 0; i1 < 3; ++i1) {
printf("  = %d", (*o).VolidHash[i0][i1]);
if (i1 != 3 - 1) printf(",");
}
}

if (i0 != 8191 - 1) printf(",");
}
}

return;
}
char *ydr_encode_VldbUpdateEntry(VldbUpdateEntry *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).Mask); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp = htonl((*o).name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).volumeType); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).ReadOnlyId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).BackupId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).cloneid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).nModifiedRepsites); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).RepsitesMask[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).RepsitesTargetServer[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).RepsitesTargetPart[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).RepsitesNewServer[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).RepsitesNewPart[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp = htonl((*o).RepsitesNewFlags[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_VldbUpdateEntry(VldbUpdateEntry *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).Mask = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).name[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeType = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).ReadOnlyId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).BackupId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).cloneid = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nModifiedRepsites = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RepsitesMask[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RepsitesTargetServer[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RepsitesTargetPart[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RepsitesNewServer[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RepsitesNewPart[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).RepsitesNewFlags[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_VldbUpdateEntry(VldbUpdateEntry *o)
{
/* printing TSTRUCT (*o) */
printf(" .Mask = %d", (*o).Mask);
{ 
unsigned int i0;
/* printing ARRAY (*o).name */
for (i0 = 0; i0 < 65; ++i0) {
printf("  = %d", (*o).name[i0]);
if (i0 != 65 - 1) printf(",");
}
}

printf(" .volumeType = %d", (*o).volumeType);
printf(" .flags = %d", (*o).flags);
printf(" .ReadOnlyId = %d", (*o).ReadOnlyId);
printf(" .BackupId = %d", (*o).BackupId);
printf(" .cloneid = %d", (*o).cloneid);
printf(" .nModifiedRepsites = %d", (*o).nModifiedRepsites);
{ 
unsigned int i0;
/* printing ARRAY (*o).RepsitesMask */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).RepsitesMask[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).RepsitesTargetServer */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).RepsitesTargetServer[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).RepsitesTargetPart */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).RepsitesTargetPart[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).RepsitesNewServer */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).RepsitesNewServer[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).RepsitesNewPart */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).RepsitesNewPart[i0]);
if (i0 != 8 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).RepsitesNewFlags */
for (i0 = 0; i0 < 8; ++i0) {
printf("  = %d", (*o).RepsitesNewFlags[i0]);
if (i0 != 8 - 1) printf(",");
}
}

return;
}
char *ydr_encode_VldbListByAttributes(VldbListByAttributes *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).Mask); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).server); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).partition); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).volumetype); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).volumeid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).flag); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_VldbListByAttributes(VldbListByAttributes *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).Mask = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).server = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).partition = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumetype = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeid = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flag = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_VldbListByAttributes(VldbListByAttributes *o)
{
/* printing TSTRUCT (*o) */
printf(" .Mask = %d", (*o).Mask);
printf(" .server = %d", (*o).server);
printf(" .partition = %d", (*o).partition);
printf(" .volumetype = %d", (*o).volumetype);
printf(" .volumeid = %d", (*o).volumeid);
printf(" .flag = %d", (*o).flag);
return;
}
char *ydr_encode_afsUUID(afsUUID *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).time_low); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).time_mid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).time_hi_and_version); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).clock_seq_hi_and_reserved); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).clock_seq_low); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 6;++i0){
{ int32_t tmp = htonl((*o).node[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_afsUUID(afsUUID *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).time_low = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).time_mid = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).time_hi_and_version = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).clock_seq_hi_and_reserved = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).clock_seq_low = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 6;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).node[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_afsUUID(afsUUID *o)
{
/* printing TSTRUCT (*o) */
printf(" .time_low = %d", (*o).time_low);
printf(" .time_mid = %d", (*o).time_mid);
printf(" .time_hi_and_version = %d", (*o).time_hi_and_version);
printf(" .clock_seq_hi_and_reserved = %d", (*o).clock_seq_hi_and_reserved);
printf(" .clock_seq_low = %d", (*o).clock_seq_low);
{ 
unsigned int i0;
/* printing ARRAY (*o).node */
for (i0 = 0; i0 < 6; ++i0) {
printf("  = %d", (*o).node[i0]);
if (i0 != 6 - 1) printf(",");
}
}

return;
}
char *ydr_encode_uvldbentry(uvldbentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp = htonl((*o).name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).nServers); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverNumber[i0].time_low); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).serverNumber[i0].time_mid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).serverNumber[i0].time_hi_and_version); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).serverNumber[i0].clock_seq_hi_and_reserved); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).serverNumber[i0].clock_seq_low); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 6;++i1){
{ int32_t tmp = htonl((*o).serverNumber[i0].node[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverUnique[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverPartition[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp = htonl((*o).serverFlags[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp = htonl((*o).volumeId[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares1); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares2); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares3); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares4); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares5); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares6); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares7); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares8); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).spares9); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_uvldbentry(uvldbentry *o, char *ptr, size_t *total_len)
{
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).name[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).nServers = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0].time_low = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0].time_mid = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0].time_hi_and_version = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0].clock_seq_hi_and_reserved = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0].clock_seq_low = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 6;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverNumber[i0].node[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverUnique[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverPartition[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).serverFlags[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).volumeId[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares1 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares2 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares3 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares4 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares5 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares6 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares7 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares8 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).spares9 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_uvldbentry(uvldbentry *o)
{
/* printing TSTRUCT (*o) */
{ 
unsigned int i0;
/* printing ARRAY (*o).name */
for (i0 = 0; i0 < 65; ++i0) {
printf("  = %d", (*o).name[i0]);
if (i0 != 65 - 1) printf(",");
}
}

printf(" .nServers = %d", (*o).nServers);
{ 
unsigned int i0;
/* printing ARRAY (*o).serverNumber */
for (i0 = 0; i0 < 13; ++i0) {
/* printing TSTRUCT (*o).serverNumber[i0] */
printf(" .time_low = %d", (*o).serverNumber[i0].time_low);
printf(" .time_mid = %d", (*o).serverNumber[i0].time_mid);
printf(" .time_hi_and_version = %d", (*o).serverNumber[i0].time_hi_and_version);
printf(" .clock_seq_hi_and_reserved = %d", (*o).serverNumber[i0].clock_seq_hi_and_reserved);
printf(" .clock_seq_low = %d", (*o).serverNumber[i0].clock_seq_low);
{ 
unsigned int i1;
/* printing ARRAY (*o).serverNumber[i0].node */
for (i1 = 0; i1 < 6; ++i1) {
printf("  = %d", (*o).serverNumber[i0].node[i1]);
if (i1 != 6 - 1) printf(",");
}
}


if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverUnique */
for (i0 = 0; i0 < 13; ++i0) {
printf("  = %d", (*o).serverUnique[i0]);
if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverPartition */
for (i0 = 0; i0 < 13; ++i0) {
printf("  = %d", (*o).serverPartition[i0]);
if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).serverFlags */
for (i0 = 0; i0 < 13; ++i0) {
printf("  = %d", (*o).serverFlags[i0]);
if (i0 != 13 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).volumeId */
for (i0 = 0; i0 < 3; ++i0) {
printf("  = %d", (*o).volumeId[i0]);
if (i0 != 3 - 1) printf(",");
}
}

printf(" .cloneId = %d", (*o).cloneId);
printf(" .flags = %d", (*o).flags);
printf(" .spares1 = %d", (*o).spares1);
printf(" .spares2 = %d", (*o).spares2);
printf(" .spares3 = %d", (*o).spares3);
printf(" .spares4 = %d", (*o).spares4);
printf(" .spares5 = %d", (*o).spares5);
printf(" .spares6 = %d", (*o).spares6);
printf(" .spares7 = %d", (*o).spares7);
printf(" .spares8 = %d", (*o).spares8);
printf(" .spares9 = %d", (*o).spares9);
return;
}
char *ydr_encode_vldstats(vldstats *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).start_time); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ int32_t tmp = htonl((*o).requests[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ int32_t tmp = htonl((*o).aborts[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 5;++i0){
{ int32_t tmp = htonl((*o).reserved[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_vldstats(vldstats *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).start_time = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).requests[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).aborts[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 5;++i0){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).reserved[i0] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_vldstats(vldstats *o)
{
/* printing TSTRUCT (*o) */
printf(" .start_time = %d", (*o).start_time);
{ 
unsigned int i0;
/* printing ARRAY (*o).requests */
for (i0 = 0; i0 < 30; ++i0) {
printf("  = %d", (*o).requests[i0]);
if (i0 != 30 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).aborts */
for (i0 = 0; i0 < 30; ++i0) {
printf("  = %d", (*o).aborts[i0]);
if (i0 != 30 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY (*o).reserved */
for (i0 = 0; i0 < 5; ++i0) {
printf("  = %d", (*o).reserved[i0]);
if (i0 != 5 - 1) printf(",");
}
}

return;
}
char *ydr_encode_bulkentries(bulkentries *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < (*o).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ int32_t tmp = htonl((*o).val[i0].name[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).val[i0].volumeType); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].nServers); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverPartition[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverFlags[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp = htonl((*o).val[i0].volumeId[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).val[i0].cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_bulkentries(bulkentries *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).len = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
(*o).val = (struct vldbentry *)malloc(sizeof(struct vldbentry ) * (*o).len);
{
int i0;
for(i0 = 0; i0 < (*o).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].name[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].volumeType = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].nServers = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverPartition[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverFlags[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].volumeId[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_bulkentries(bulkentries *o)
{
/* printing TVARRAY (*o) */
unsigned int i0;
for (i0 = 0; i0 < (*o).len; ++i0) {
/* printing TSTRUCT (*o).val[i0] */
{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].name */
for (i1 = 0; i1 < 65; ++i1) {
printf("  = %d", (*o).val[i0].name[i1]);
if (i1 != 65 - 1) printf(",");
}
}

printf(" .volumeType = %d", (*o).val[i0].volumeType);
printf(" .nServers = %d", (*o).val[i0].nServers);
{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverNumber */
for (i1 = 0; i1 < 8; ++i1) {
printf("  = %d", (*o).val[i0].serverNumber[i1]);
if (i1 != 8 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverPartition */
for (i1 = 0; i1 < 8; ++i1) {
printf("  = %d", (*o).val[i0].serverPartition[i1]);
if (i1 != 8 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverFlags */
for (i1 = 0; i1 < 8; ++i1) {
printf("  = %d", (*o).val[i0].serverFlags[i1]);
if (i1 != 8 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].volumeId */
for (i1 = 0; i1 < 3; ++i1) {
printf("  = %d", (*o).val[i0].volumeId[i1]);
if (i1 != 3 - 1) printf(",");
}
}

printf(" .cloneId = %d", (*o).val[i0].cloneId);
printf(" .flags = %d", (*o).val[i0].flags);

if (i0 != (*o).len - 1) printf(",");
}
return;
}
char *ydr_encode_nbulkentries(nbulkentries *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < (*o).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ int32_t tmp = htonl((*o).val[i0].name[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).val[i0].nServers); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverPartition[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverFlags[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp = htonl((*o).val[i0].volumeId[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).val[i0].cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares1); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares2); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares3); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares4); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares5); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares6); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares7); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares8); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares9); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_nbulkentries(nbulkentries *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).len = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
(*o).val = (struct nvldbentry *)malloc(sizeof(struct nvldbentry ) * (*o).len);
{
int i0;
for(i0 = 0; i0 < (*o).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].name[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].nServers = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverPartition[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverFlags[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].volumeId[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares1 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares2 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares3 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares4 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares5 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares6 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares7 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares8 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares9 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_nbulkentries(nbulkentries *o)
{
/* printing TVARRAY (*o) */
unsigned int i0;
for (i0 = 0; i0 < (*o).len; ++i0) {
/* printing TSTRUCT (*o).val[i0] */
{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].name */
for (i1 = 0; i1 < 65; ++i1) {
printf("  = %d", (*o).val[i0].name[i1]);
if (i1 != 65 - 1) printf(",");
}
}

printf(" .nServers = %d", (*o).val[i0].nServers);
{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverNumber */
for (i1 = 0; i1 < 13; ++i1) {
printf("  = %d", (*o).val[i0].serverNumber[i1]);
if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverPartition */
for (i1 = 0; i1 < 13; ++i1) {
printf("  = %d", (*o).val[i0].serverPartition[i1]);
if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverFlags */
for (i1 = 0; i1 < 13; ++i1) {
printf("  = %d", (*o).val[i0].serverFlags[i1]);
if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].volumeId */
for (i1 = 0; i1 < 3; ++i1) {
printf("  = %d", (*o).val[i0].volumeId[i1]);
if (i1 != 3 - 1) printf(",");
}
}

printf(" .cloneId = %d", (*o).val[i0].cloneId);
printf(" .flags = %d", (*o).val[i0].flags);
printf(" .spares1 = %d", (*o).val[i0].spares1);
printf(" .spares2 = %d", (*o).val[i0].spares2);
printf(" .spares3 = %d", (*o).val[i0].spares3);
printf(" .spares4 = %d", (*o).val[i0].spares4);
printf(" .spares5 = %d", (*o).val[i0].spares5);
printf(" .spares6 = %d", (*o).val[i0].spares6);
printf(" .spares7 = %d", (*o).val[i0].spares7);
printf(" .spares8 = %d", (*o).val[i0].spares8);
printf(" .spares9 = %d", (*o).val[i0].spares9);

if (i0 != (*o).len - 1) printf(",");
}
return;
}
char *ydr_encode_ubulkentries(ubulkentries *o, char *ptr, size_t *total_len)
{
{ int32_t tmp = htonl((*o).len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < (*o).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ int32_t tmp = htonl((*o).val[i0].name[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).val[i0].nServers); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1].time_low); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1].time_mid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1].time_hi_and_version); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1].clock_seq_hi_and_reserved); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1].clock_seq_low); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i2;
for(i2 = 0; i2 < 6;++i2){
{ int32_t tmp = htonl((*o).val[i0].serverNumber[i1].node[i2]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverUnique[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverPartition[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp = htonl((*o).val[i0].serverFlags[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp = htonl((*o).val[i0].volumeId[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl((*o).val[i0].cloneId); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares1); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares2); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares3); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares4); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares5); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares6); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares7); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares8); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl((*o).val[i0].spares9); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
char *ydr_decode_ubulkentries(ubulkentries *o, char *ptr, size_t *total_len)
{
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).len = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
(*o).val = (struct uvldbentry *)malloc(sizeof(struct uvldbentry ) * (*o).len);
{
int i0;
for(i0 = 0; i0 < (*o).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].name[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].nServers = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1].time_low = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1].time_mid = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1].time_hi_and_version = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1].clock_seq_hi_and_reserved = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1].clock_seq_low = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i2;
for(i2 = 0; i2 < 6;++i2){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverNumber[i1].node[i2] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverUnique[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverPartition[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].serverFlags[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].volumeId[i1] = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].cloneId = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].flags = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares1 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares2 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares3 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares4 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares5 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares6 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares7 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares8 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); (*o).val[i0].spares9 = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
return ptr;
fail:
errno = EFAULT;
return NULL;}
void ydr_print_ubulkentries(ubulkentries *o)
{
/* printing TVARRAY (*o) */
unsigned int i0;
for (i0 = 0; i0 < (*o).len; ++i0) {
/* printing TSTRUCT (*o).val[i0] */
{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].name */
for (i1 = 0; i1 < 65; ++i1) {
printf("  = %d", (*o).val[i0].name[i1]);
if (i1 != 65 - 1) printf(",");
}
}

printf(" .nServers = %d", (*o).val[i0].nServers);
{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverNumber */
for (i1 = 0; i1 < 13; ++i1) {
/* printing TSTRUCT (*o).val[i0].serverNumber[i1] */
printf(" .time_low = %d", (*o).val[i0].serverNumber[i1].time_low);
printf(" .time_mid = %d", (*o).val[i0].serverNumber[i1].time_mid);
printf(" .time_hi_and_version = %d", (*o).val[i0].serverNumber[i1].time_hi_and_version);
printf(" .clock_seq_hi_and_reserved = %d", (*o).val[i0].serverNumber[i1].clock_seq_hi_and_reserved);
printf(" .clock_seq_low = %d", (*o).val[i0].serverNumber[i1].clock_seq_low);
{ 
unsigned int i2;
/* printing ARRAY (*o).val[i0].serverNumber[i1].node */
for (i2 = 0; i2 < 6; ++i2) {
printf("  = %d", (*o).val[i0].serverNumber[i1].node[i2]);
if (i2 != 6 - 1) printf(",");
}
}


if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverUnique */
for (i1 = 0; i1 < 13; ++i1) {
printf("  = %d", (*o).val[i0].serverUnique[i1]);
if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverPartition */
for (i1 = 0; i1 < 13; ++i1) {
printf("  = %d", (*o).val[i0].serverPartition[i1]);
if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].serverFlags */
for (i1 = 0; i1 < 13; ++i1) {
printf("  = %d", (*o).val[i0].serverFlags[i1]);
if (i1 != 13 - 1) printf(",");
}
}

{ 
unsigned int i1;
/* printing ARRAY (*o).val[i0].volumeId */
for (i1 = 0; i1 < 3; ++i1) {
printf("  = %d", (*o).val[i0].volumeId[i1]);
if (i1 != 3 - 1) printf(",");
}
}

printf(" .cloneId = %d", (*o).val[i0].cloneId);
printf(" .flags = %d", (*o).val[i0].flags);
printf(" .spares1 = %d", (*o).val[i0].spares1);
printf(" .spares2 = %d", (*o).val[i0].spares2);
printf(" .spares3 = %d", (*o).val[i0].spares3);
printf(" .spares4 = %d", (*o).val[i0].spares4);
printf(" .spares5 = %d", (*o).val[i0].spares5);
printf(" .spares6 = %d", (*o).val[i0].spares6);
printf(" .spares7 = %d", (*o).val[i0].spares7);
printf(" .spares8 = %d", (*o).val[i0].spares8);
printf(" .spares9 = %d", (*o).val[i0].spares9);

if (i0 != (*o).len - 1) printf(",");
}
return;
}
