
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from vldb.xg */
#include "vldb.h"

#include "vldb.ss.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("vldb.ss.c generated from vldb.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int _VL_CreateEntry(
struct rx_call *call)
{
int _result;
struct vldbentry newentry;

{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.flags = ntohl (u);
}
_result = VL_CreateEntry(call, &newentry);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_DeleteEntry(
struct rx_call *call)
{
int _result;
int32_t Volid;
int32_t voltype;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
_result = VL_DeleteEntry(call, Volid, voltype);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetEntryByID(
struct rx_call *call)
{
int _result;
int32_t Volid;
int32_t voltype;
struct vldbentry entry;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
_result = VL_GetEntryByID(call, Volid, voltype, &entry);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (entry.volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetEntryByName(
struct rx_call *call)
{
int _result;
char volumename[65];
struct vldbentry entry;

{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 65)
abort();
if(rx_Read(call, volumename, len) != len)
goto fail;
volumename[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = VL_GetEntryByName(call, volumename, &entry);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (entry.volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetNewVolumeId(
struct rx_call *call)
{
int _result;
int32_t bumpcount;
int32_t newvolumid;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
bumpcount = ntohl (u);
}
_result = VL_GetNewVolumeId(call, bumpcount, &newvolumid);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (newvolumid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_ReplaceEntry(
struct rx_call *call)
{
int _result;
int32_t Volid;
int32_t voltype;
struct vldbentry newentry;
int32_t ReleaseType;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
ReleaseType = ntohl (u);
}
_result = VL_ReplaceEntry(call, Volid, voltype, &newentry, ReleaseType);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_UpdateEntry(
struct rx_call *call)
{
int _result;
int32_t Volid;
int32_t voltype;
struct VldbUpdateEntry UpdateEntry;
int32_t ReleaseType;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.Mask = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.ReadOnlyId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.BackupId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.cloneid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.nModifiedRepsites = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.RepsitesMask[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.RepsitesTargetServer[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.RepsitesTargetPart[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.RepsitesNewServer[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.RepsitesNewPart[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
UpdateEntry.RepsitesNewFlags[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
ReleaseType = ntohl (u);
}
_result = VL_UpdateEntry(call, Volid, voltype, &UpdateEntry, ReleaseType);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_SetLock(
struct rx_call *call)
{
int _result;
int32_t Volid;
int32_t voltype;
int32_t voloper;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voloper = ntohl (u);
}
_result = VL_SetLock(call, Volid, voltype, voloper);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_ReleaseLock(
struct rx_call *call)
{
int _result;
int32_t volid;
int32_t voltype;
int32_t ReleaseType;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
ReleaseType = ntohl (u);
}
_result = VL_ReleaseLock(call, volid, voltype, ReleaseType);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_ListEntry(
struct rx_call *call)
{
int _result;
int32_t previous_index;
int32_t count;
int32_t next_index;
struct vldbentry entry;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
previous_index = ntohl (u);
}
_result = VL_ListEntry(call, previous_index, &count, &next_index, &entry);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (count);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (next_index);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl (entry.serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (entry.volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_ListAttributes(
struct rx_call *call)
{
int _result;
struct VldbListByAttributes attributes;
int32_t nentries;
bulkentries blkentries;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.server = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.partition = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.volumetype = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.volumeid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.flag = ntohl (u);
}
_result = VL_ListAttributes(call, &attributes, &nentries, &blkentries);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (nentries);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < blkentries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].name[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverPartition[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverFlags[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].volumeId[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(blkentries.val);
return _result;
fail:
free(blkentries.val);
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetStats(
struct rx_call *call)
{
int _result;
struct vldstats stats;
struct vital_vlheader vital_header;

_result = VL_GetStats(call, &stats, &vital_header);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (stats.start_time);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ u_int32_t u;
u = htonl (stats.requests[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ u_int32_t u;
u = htonl (stats.aborts[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 5;++i0){
{ u_int32_t u;
u = htonl (stats.reserved[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (vital_header.vldbversion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (vital_header.headersize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (vital_header.freePtr);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (vital_header.eofPtr);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (vital_header.allocs);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (vital_header.frees);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (vital_header.MaxVolumeId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (vital_header.totalEntries[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_Probe(
struct rx_call *call)
{
int _result;

_result = VL_Probe(call);
if (_result) goto funcfail;
return _result;
funcfail:
return _result;
}

int _VL_CreateEntryN(
struct rx_call *call)
{
int _result;
struct nvldbentry newentry;

{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares8 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newentry.spares9 = ntohl (u);
}
_result = VL_CreateEntryN(call, &newentry);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetEntryByIDN(
struct rx_call *call)
{
int _result;
int32_t Volid;
int32_t voltype;
struct nvldbentry entry;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
voltype = ntohl (u);
}
_result = VL_GetEntryByIDN(call, Volid, voltype, &entry);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (entry.volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares8);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares9);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetEntryByNameN(
struct rx_call *call)
{
int _result;
char volumename[65];
struct nvldbentry entry;

{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 65)
abort();
if(rx_Read(call, volumename, len) != len)
goto fail;
volumename[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = VL_GetEntryByNameN(call, volumename, &entry);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (entry.volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares8);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares9);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_ListAttributesN(
struct rx_call *call)
{
int _result;
struct VldbListByAttributes attributes;
int32_t nentries;
nbulkentries blkentries;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.server = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.partition = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.volumetype = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.volumeid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.flag = ntohl (u);
}
_result = VL_ListAttributesN(call, &attributes, &nentries, &blkentries);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (nentries);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < blkentries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].name[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverPartition[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverFlags[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].volumeId[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares8);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares9);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(blkentries.val);
return _result;
fail:
free(blkentries.val);
return rx_Error(call);
funcfail:
return _result;
}

int _VL_GetEntryByNameU(
struct rx_call *call)
{
int _result;
char volumename[65];
struct uvldbentry entry;

{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 65)
abort();
if(rx_Read(call, volumename, len) != len)
goto fail;
volumename[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = VL_GetEntryByNameU(call, volumename, &entry);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0].time_low);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.serverNumber[i0].time_mid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.serverNumber[i0].time_hi_and_version);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.serverNumber[i0].clock_seq_hi_and_reserved);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.serverNumber[i0].clock_seq_low);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i1;
for(i1 = 0; i1 < 6;++i1){
{ u_int32_t u;
u = htonl (entry.serverNumber[i0].node[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverUnique[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl (entry.serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl (entry.volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares8);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.spares9);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VL_ListAttributesU(
struct rx_call *call)
{
int _result;
struct VldbListByAttributes attributes;
int32_t nentries;
ubulkentries blkentries;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.server = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.partition = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.volumetype = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.volumeid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
attributes.flag = ntohl (u);
}
_result = VL_ListAttributesU(call, &attributes, &nentries, &blkentries);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (nentries);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < blkentries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].name[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1].time_low);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1].time_mid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1].time_hi_and_version);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1].clock_seq_hi_and_reserved);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1].clock_seq_low);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i2;
for(i2 = 0; i2 < 6;++i2){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverNumber[i1].node[i2]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverUnique[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverPartition[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].serverFlags[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ u_int32_t u;
u = htonl (blkentries.val[i0].volumeId[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares8);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (blkentries.val[i0].spares9);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(blkentries.val);
return _result;
fail:
free(blkentries.val);
return rx_Error(call);
funcfail:
return _result;
}

int VL_ExecuteRequest(struct rx_call *call)
{
unsigned opcode;
int _result;
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
opcode = ntohl (u);
}
switch(opcode) {
case 501: {
_result = _VL_CreateEntry(call);
break;
}
case 502: {
_result = _VL_DeleteEntry(call);
break;
}
case 503: {
_result = _VL_GetEntryByID(call);
break;
}
case 504: {
_result = _VL_GetEntryByName(call);
break;
}
case 505: {
_result = _VL_GetNewVolumeId(call);
break;
}
case 506: {
_result = _VL_ReplaceEntry(call);
break;
}
case 507: {
_result = _VL_UpdateEntry(call);
break;
}
case 508: {
_result = _VL_SetLock(call);
break;
}
case 509: {
_result = _VL_ReleaseLock(call);
break;
}
case 510: {
_result = _VL_ListEntry(call);
break;
}
case 511: {
_result = _VL_ListAttributes(call);
break;
}
case 513: {
_result = _VL_GetStats(call);
break;
}
case 514: {
_result = _VL_Probe(call);
break;
}
case 517: {
_result = _VL_CreateEntryN(call);
break;
}
case 518: {
_result = _VL_GetEntryByIDN(call);
break;
}
case 519: {
_result = _VL_GetEntryByNameN(call);
break;
}
case 522: {
_result = _VL_ListAttributesN(call);
break;
}
case 527: {
_result = _VL_GetEntryByNameU(call);
break;
}
case 530: {
_result = _VL_ListAttributesU(call);
break;
}
default:
fprintf (stderr, "Ignoring %d\n", opcode);
}
return _result;
fail:
return rx_Error(call);
}

