
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from vldb.xg */
#ifndef _VLDB_
#define _VLDB_

#include <atypes.h>
#include <rx/rx.h>
#include <rx/rx_null.h>
#include <arlad/fs_errors.h>
#define VLDB_MAXNAMELEN 65

#define MAXNSERVERS 8

#define NMAXNSERVERS 13

#define MAX_NUMBER_OPCODES 30

#define MAXTYPES 3

#define MAXSERVERID 30

#define HASHSIZE 8191

#define DEFAULTBULK 10000

typedef struct {
unsigned len;
char *val;
} bulk;

char *ydr_encode_bulk(bulk *o, char *ptr, size_t *total_len);
char *ydr_decode_bulk(bulk *o, char *ptr, size_t *total_len);
void ydr_print_bulk(bulk *o);
#define VLLIST_SERVER 1

#define VLLIST_PARTITION 2

#define VLLIST_VOLUMETYPE 4

#define VLLIST_VOLUMEID 8

#define VLLIST_FLAG 16

#define RWVOL 0

#define ROVOL 1

#define BACKVOL 2

#define VLSF_NEWREPSITE 1

#define VLSF_ROVOL 2

#define VLSF_RWVOL 4

#define VLSF_BACKVOL 8

#define VLF_RWEXISTS 4096

#define VLF_ROEXISTS 8192

#define VLF_BOEXISTS 16384

#define VLF_BACKEXISTS 16384

#define VLF_DFSFILESET 32768

#define VL_IDEXIST 363520

#define VL_IO 363521

#define VL_NAMEEXIST 363522

#define VL_CREATEFAIL 363523

#define VL_NOENT 363524

#define VL_EMPTY 363525

#define VL_ENTDELETED 363526

#define VL_BADNAME 363527

#define VL_BADINDEX 363528

#define VL_BADVOLTYPE 363529

#define VL_BADPARTITION 363530

#define VL_BADSERVER 363531

#define VL_REPSFULL 363532

#define VL_NOREPSERVER 363533

#define VL_DUPREPSERVER 363534

#define VL_RWNOTFOUND 363535

#define VL_BADREFCOUNT 363536

#define VL_SIZEEXCEEDED 363537

#define VL_BADENTRY 363538

#define VL_BADVOLIDBUMP 363539

#define VL_IDALREADHASED 363540

#define VL_ENTRYLOCKED 363541

#define VL_BADVOLOPER 363542

#define VL_BADRELLOCKTYPE 363543

#define VL_RERELEASE 363544

#define VL_BADSERVERFLAG 363545

#define VL_PERM 363546

#define VL_NOMEM 363547

struct vldbentry {
     char name[ 65 ];
     int32_t volumeType;
     int32_t nServers;
     int32_t serverNumber[ 8 ];
     int32_t serverPartition[ 8 ];
     int32_t serverFlags[ 8 ];
     u_int32_t volumeId[ 3 ];
     int32_t cloneId;
     int32_t flags;
};
typedef struct vldbentry vldbentry;

#define VLDBENTRY_SIZE 384
char *ydr_encode_vldbentry(vldbentry *o, char *ptr, size_t *total_len);
char *ydr_decode_vldbentry(vldbentry *o, char *ptr, size_t *total_len);
void ydr_print_vldbentry(vldbentry *o);
struct nvldbentry {
     char name[ 65 ];
     int32_t nServers;
     int32_t serverNumber[ 13 ];
     int32_t serverPartition[ 13 ];
     int32_t serverFlags[ 13 ];
     u_int32_t volumeId[ 3 ];
     int32_t cloneId;
     int32_t flags;
     int32_t spares1;
     int32_t spares2;
     int32_t spares3;
     int32_t spares4;
     int32_t spares5;
     int32_t spares6;
     int32_t spares7;
     int32_t spares8;
     int32_t spares9;
};
typedef struct nvldbentry nvldbentry;

#define NVLDBENTRY_SIZE 476
char *ydr_encode_nvldbentry(nvldbentry *o, char *ptr, size_t *total_len);
char *ydr_decode_nvldbentry(nvldbentry *o, char *ptr, size_t *total_len);
void ydr_print_nvldbentry(nvldbentry *o);
struct vlentry {
     u_int32_t volumeId[ 3 ];
     int32_t flags;
     int32_t LockAfsId;
     int32_t LockTimestamp;
     int32_t cloneId;
     int32_t AssociatedChain;
     int32_t nextIdHash[ 3 ];
     int32_t nextNameHash;
     int32_t spares1[ 2 ];
     char name[ 65 ];
     unsigned char volumeType;
     unsigned char serverNumber[ 8 ];
     unsigned char serverPartition[ 8 ];
     unsigned char serverFlags[ 8 ];
     unsigned char RefCount;
     char spares2[ 1 ];
};
typedef struct vlentry vlentry;

#define VLENTRY_SIZE 424
char *ydr_encode_vlentry(vlentry *o, char *ptr, size_t *total_len);
char *ydr_decode_vlentry(vlentry *o, char *ptr, size_t *total_len);
void ydr_print_vlentry(vlentry *o);
struct disk_vlentry {
     u_int32_t volumeId[ 3 ];
     int32_t flags;
     int32_t LockAfsId;
     int32_t LockTimestamp;
     int32_t cloneId;
     int32_t AssociatedChain;
     int32_t nextIdHash[ 3 ];
     int32_t nextNameHash;
     int32_t spares1[ 2 ];
     char name[ 65 ];
     unsigned char volumeType;
     int32_t serverNumber[ 8 ];
     unsigned char serverPartition[ 8 ];
     unsigned char serverFlags[ 8 ];
     unsigned char RefCount;
     char spares2[ 1 ];
};
typedef struct disk_vlentry disk_vlentry;

#define DISK_VLENTRY_SIZE 424
char *ydr_encode_disk_vlentry(disk_vlentry *o, char *ptr, size_t *total_len);
char *ydr_decode_disk_vlentry(disk_vlentry *o, char *ptr, size_t *total_len);
void ydr_print_disk_vlentry(disk_vlentry *o);
struct vital_vlheader {
     int32_t vldbversion;
     int32_t headersize;
     int32_t freePtr;
     int32_t eofPtr;
     int32_t allocs;
     int32_t frees;
     int32_t MaxVolumeId;
     int32_t totalEntries[ 3 ];
};
typedef struct vital_vlheader vital_vlheader;

#define VITAL_VLHEADER_SIZE 40
char *ydr_encode_vital_vlheader(vital_vlheader *o, char *ptr, size_t *total_len);
char *ydr_decode_vital_vlheader(vital_vlheader *o, char *ptr, size_t *total_len);
void ydr_print_vital_vlheader(vital_vlheader *o);
typedef int32_t longarray[ 3 ];

#define LONGARRAY_SIZE 12
char *ydr_encode_longarray(longarray *o, char *ptr, size_t *total_len);
char *ydr_decode_longarray(longarray *o, char *ptr, size_t *total_len);
void ydr_print_longarray(longarray *o);
struct vlheader {
     struct vital_vlheader vital_header;
     u_int32_t IpMappedAddr[ 30 ];
     int32_t VolnameHash[ 8191 ];
     longarray VolidHash[ 8191 ];
};
typedef struct vlheader vlheader;

#define VLHEADER_SIZE 131216
char *ydr_encode_vlheader(vlheader *o, char *ptr, size_t *total_len);
char *ydr_decode_vlheader(vlheader *o, char *ptr, size_t *total_len);
void ydr_print_vlheader(vlheader *o);
struct VldbUpdateEntry {
     u_int32_t Mask;
     char name[ 65 ];
     int32_t volumeType;
     int32_t flags;
     u_int32_t ReadOnlyId;
     u_int32_t BackupId;
     int32_t cloneid;
     int32_t nModifiedRepsites;
     u_int32_t RepsitesMask[ 8 ];
     int32_t RepsitesTargetServer[ 8 ];
     int32_t RepsitesTargetPart[ 8 ];
     int32_t RepsitesNewServer[ 8 ];
     int32_t RepsitesNewPart[ 8 ];
     int32_t RepsitesNewFlags[ 8 ];
};
typedef struct VldbUpdateEntry VldbUpdateEntry;

#define VLDBUPDATEENTRY_SIZE 480
char *ydr_encode_VldbUpdateEntry(VldbUpdateEntry *o, char *ptr, size_t *total_len);
char *ydr_decode_VldbUpdateEntry(VldbUpdateEntry *o, char *ptr, size_t *total_len);
void ydr_print_VldbUpdateEntry(VldbUpdateEntry *o);
struct VldbListByAttributes {
     u_int32_t Mask;
     int32_t server;
     int32_t partition;
     int32_t volumetype;
     int32_t volumeid;
     int32_t flag;
};
typedef struct VldbListByAttributes VldbListByAttributes;

#define VLDBLISTBYATTRIBUTES_SIZE 24
char *ydr_encode_VldbListByAttributes(VldbListByAttributes *o, char *ptr, size_t *total_len);
char *ydr_decode_VldbListByAttributes(VldbListByAttributes *o, char *ptr, size_t *total_len);
void ydr_print_VldbListByAttributes(VldbListByAttributes *o);
struct afsUUID {
     u_int32_t time_low;
     u_int16_t time_mid;
     u_int16_t time_hi_and_version;
     char clock_seq_hi_and_reserved;
     char clock_seq_low;
     char node[ 6 ];
};
typedef struct afsUUID afsUUID;

#define AFSUUID_SIZE 44
char *ydr_encode_afsUUID(afsUUID *o, char *ptr, size_t *total_len);
char *ydr_decode_afsUUID(afsUUID *o, char *ptr, size_t *total_len);
void ydr_print_afsUUID(afsUUID *o);
struct uvldbentry {
     char name[ 65 ];
     int32_t nServers;
     struct afsUUID serverNumber[ 13 ];
     int32_t serverUnique[ 13 ];
     int32_t serverPartition[ 13 ];
     int32_t serverFlags[ 13 ];
     u_int32_t volumeId[ 3 ];
     int32_t cloneId;
     int32_t flags;
     int32_t spares1;
     int32_t spares2;
     int32_t spares3;
     int32_t spares4;
     int32_t spares5;
     int32_t spares6;
     int32_t spares7;
     int32_t spares8;
     int32_t spares9;
};
typedef struct uvldbentry uvldbentry;

#define UVLDBENTRY_SIZE 1048
char *ydr_encode_uvldbentry(uvldbentry *o, char *ptr, size_t *total_len);
char *ydr_decode_uvldbentry(uvldbentry *o, char *ptr, size_t *total_len);
void ydr_print_uvldbentry(uvldbentry *o);
struct vldstats {
     u_int32_t start_time;
     int32_t requests[ 30 ];
     int32_t aborts[ 30 ];
     int32_t reserved[ 5 ];
};
typedef struct vldstats vldstats;

#define VLDSTATS_SIZE 264
char *ydr_encode_vldstats(vldstats *o, char *ptr, size_t *total_len);
char *ydr_decode_vldstats(vldstats *o, char *ptr, size_t *total_len);
void ydr_print_vldstats(vldstats *o);
typedef struct {
unsigned len;
struct vldbentry *val;
} bulkentries;

char *ydr_encode_bulkentries(bulkentries *o, char *ptr, size_t *total_len);
char *ydr_decode_bulkentries(bulkentries *o, char *ptr, size_t *total_len);
void ydr_print_bulkentries(bulkentries *o);
typedef struct {
unsigned len;
struct nvldbentry *val;
} nbulkentries;

char *ydr_encode_nbulkentries(nbulkentries *o, char *ptr, size_t *total_len);
char *ydr_decode_nbulkentries(nbulkentries *o, char *ptr, size_t *total_len);
void ydr_print_nbulkentries(nbulkentries *o);
typedef struct {
unsigned len;
struct uvldbentry *val;
} ubulkentries;

char *ydr_encode_ubulkentries(ubulkentries *o, char *ptr, size_t *total_len);
char *ydr_decode_ubulkentries(ubulkentries *o, char *ptr, size_t *total_len);
void ydr_print_ubulkentries(ubulkentries *o);

#endif /* VLDB */
