
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from vldb.xg */
#include "vldb.h"

#include "vldb.cs.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#include <arlad/fs_errors.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("vldb.cs.c generated from vldb.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int VL_CreateEntry(
struct rx_connection *connection
, const struct vldbentry *newentry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (501);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl ((*newentry).name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*newentry).volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl ((*newentry).volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*newentry).cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_DeleteEntry(
struct rx_connection *connection
, const int32_t Volid
, const int32_t voltype
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (502);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetEntryByID(
struct rx_connection *connection
, const int32_t Volid
, const int32_t voltype
, struct vldbentry *entry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (503);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).flags = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetEntryByName(
struct rx_connection *connection
, const char volumename[65]
, struct vldbentry *entry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (504);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(volumename);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, volumename, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).flags = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetNewVolumeId(
struct rx_connection *connection
, const int32_t bumpcount
, int32_t *newvolumid
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (505);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (bumpcount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*newvolumid) = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_ReplaceEntry(
struct rx_connection *connection
, const int32_t Volid
, const int32_t voltype
, const struct vldbentry *newentry
, const int32_t ReleaseType
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (506);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl ((*newentry).name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*newentry).volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl ((*newentry).volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*newentry).cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (ReleaseType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_UpdateEntry(
struct rx_connection *connection
, const int32_t Volid
, const int32_t voltype
, const struct VldbUpdateEntry *UpdateEntry
, const int32_t ReleaseType
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (507);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).volumeType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).ReadOnlyId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).BackupId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).cloneid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*UpdateEntry).nModifiedRepsites);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).RepsitesMask[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).RepsitesTargetServer[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).RepsitesTargetPart[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).RepsitesNewServer[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).RepsitesNewPart[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
u = htonl ((*UpdateEntry).RepsitesNewFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (ReleaseType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_SetLock(
struct rx_connection *connection
, const int32_t Volid
, const int32_t voltype
, const int32_t voloper
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (508);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voloper);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_ReleaseLock(
struct rx_connection *connection
, const int32_t volid
, const int32_t voltype
, const int32_t ReleaseType
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (509);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (ReleaseType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_ListEntry(
struct rx_connection *connection
, const int32_t previous_index
, int32_t *count
, int32_t *next_index
, struct vldbentry *entry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (510);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (previous_index);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*count) = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*next_index) = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 8;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).flags = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_ListAttributes(
struct rx_connection *connection
, const struct VldbListByAttributes *attributes
, int32_t *nentries
, bulkentries *blkentries
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (511);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).server);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).partition);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).volumetype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).volumeid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).flag);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*nentries) = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).len = ntohl (u);
}
(*blkentries).val = (struct vldbentry *)malloc(sizeof(struct vldbentry ) * (*blkentries).len);
{
int i0;
for(i0 = 0; i0 < (*blkentries).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].name[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].volumeType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].nServers = ntohl (u);
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverPartition[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 8;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverFlags[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].volumeId[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].flags = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetStats(
struct rx_connection *connection
, struct vldstats *stats
, struct vital_vlheader *vital_header
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (513);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stats).start_time = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stats).requests[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 30;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stats).aborts[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 5;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stats).reserved[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).vldbversion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).headersize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).freePtr = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).eofPtr = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).allocs = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).frees = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).MaxVolumeId = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*vital_header).totalEntries[i0] = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_Probe(
struct rx_connection *connection
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (514);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_CreateEntryN(
struct rx_connection *connection
, const struct nvldbentry *newentry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (517);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
u = htonl ((*newentry).name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*newentry).nServers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverNumber[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverPartition[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
u = htonl ((*newentry).serverFlags[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
u = htonl ((*newentry).volumeId[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*newentry).cloneId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares8);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*newentry).spares9);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetEntryByIDN(
struct rx_connection *connection
, const int32_t Volid
, const int32_t voltype
, struct nvldbentry *entry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (518);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (voltype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares8 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares9 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetEntryByNameN(
struct rx_connection *connection
, const char volumename[65]
, struct nvldbentry *entry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (519);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(volumename);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, volumename, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares8 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares9 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_ListAttributesN(
struct rx_connection *connection
, const struct VldbListByAttributes *attributes
, int32_t *nentries
, nbulkentries *blkentries
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (522);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).server);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).partition);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).volumetype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).volumeid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).flag);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*nentries) = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).len = ntohl (u);
}
(*blkentries).val = (struct nvldbentry *)malloc(sizeof(struct nvldbentry ) * (*blkentries).len);
{
int i0;
for(i0 = 0; i0 < (*blkentries).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].name[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].nServers = ntohl (u);
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverPartition[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverFlags[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].volumeId[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares8 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares9 = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_GetEntryByNameU(
struct rx_connection *connection
, const char volumename[65]
, struct uvldbentry *entry
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (527);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(volumename);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, volumename, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 65;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).nServers = ntohl (u);
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0].time_low = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0].time_mid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0].time_hi_and_version = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0].clock_seq_hi_and_reserved = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0].clock_seq_low = ntohl (u);
}
{
int i1;
for(i1 = 0; i1 < 6;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverNumber[i0].node[i1] = ntohl (u);
}
}
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverUnique[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverPartition[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 13;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).serverFlags[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 3;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).volumeId[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares8 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*entry).spares9 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VL_ListAttributesU(
struct rx_connection *connection
, const struct VldbListByAttributes *attributes
, int32_t *nentries
, ubulkentries *blkentries
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (530);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).server);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).partition);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).volumetype);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).volumeid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*attributes).flag);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*nentries) = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).len = ntohl (u);
}
(*blkentries).val = (struct uvldbentry *)malloc(sizeof(struct uvldbentry ) * (*blkentries).len);
{
int i0;
for(i0 = 0; i0 < (*blkentries).len;++i0){
{
int i1;
for(i1 = 0; i1 < 65;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].name[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].nServers = ntohl (u);
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1].time_low = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1].time_mid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1].time_hi_and_version = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1].clock_seq_hi_and_reserved = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1].clock_seq_low = ntohl (u);
}
{
int i2;
for(i2 = 0; i2 < 6;++i2){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverNumber[i1].node[i2] = ntohl (u);
}
}
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverUnique[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverPartition[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 13;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].serverFlags[i1] = ntohl (u);
}
}
}
{
int i1;
for(i1 = 0; i1 < 3;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].volumeId[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].cloneId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares8 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*blkentries).val[i0].spares9 = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
