
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from ubik.xg */
#ifndef _UBIK_
#define _UBIK_

#include <atypes.h>
#include <rx/rx.h>
#include <rx/rx_null.h>
#include <arlad/fs_errors.h>
struct net_tid {
     int32_t epoch;
     int32_t counter;
};
typedef struct net_tid net_tid;

#define NET_TID_SIZE 8
char *ydr_encode_net_tid(net_tid *o, char *ptr, size_t *total_len);
char *ydr_decode_net_tid(net_tid *o, char *ptr, size_t *total_len);
void ydr_print_net_tid(net_tid *o);
typedef struct net_tid net_version;

#define NET_VERSION_SIZE 8
char *ydr_encode_net_version(net_version *o, char *ptr, size_t *total_len);
char *ydr_decode_net_version(net_version *o, char *ptr, size_t *total_len);
void ydr_print_net_version(net_version *o);
struct ubik_debug {
     int32_t now;
     int32_t lastYesTime;
     int32_t lastYesHost;
     int32_t lastYesState;
     int32_t lastYesClaim;
     int32_t lowestHost;
     int32_t lowestTime;
     int32_t syncHost;
     int32_t syncTime;
     net_version syncVersion;
     struct net_tid syncTid;
     int32_t amSyncSite;
     int32_t syncSiteUntil;
     int32_t nServers;
     int32_t lockedPages;
     int32_t writeLockedPages;
     net_version localVersion;
     int32_t activeWrite;
     int32_t tidCounter;
     int32_t anyReadLocks;
     int32_t anyWriteLocks;
     int32_t recoveryState;
     int32_t currentTrans;
     int32_t writeTrans;
     int32_t epochTime;
};
typedef struct ubik_debug ubik_debug;

#define UBIK_DEBUG_SIZE 112
char *ydr_encode_ubik_debug(ubik_debug *o, char *ptr, size_t *total_len);
char *ydr_decode_ubik_debug(ubik_debug *o, char *ptr, size_t *total_len);
void ydr_print_ubik_debug(ubik_debug *o);
struct ubik_sdebug {
     int32_t addr;
     int32_t lastVoteTime;
     int32_t lastBeaconSent;
     int32_t lastVote;
     net_version remoteVersion;
     int32_t currentDB;
     int32_t beaconSinceDown;
     int32_t up;
};
typedef struct ubik_sdebug ubik_sdebug;

#define UBIK_SDEBUG_SIZE 36
char *ydr_encode_ubik_sdebug(ubik_sdebug *o, char *ptr, size_t *total_len);
char *ydr_decode_ubik_sdebug(ubik_sdebug *o, char *ptr, size_t *total_len);
void ydr_print_ubik_sdebug(ubik_sdebug *o);
#define VOTE_BEACON 10000

#define VOTE_DEBUG 10001

#define VOTE_SDEBUG 10002

#define VOTE_GETSYNCSITE 10003


#endif /* UBIK */
