
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from pts.xg */
#include "pts.h"

#include "pts.ss.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("pts.ss.c generated from pts.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int _PR_NameToID(
struct rx_call *call)
{
int _result;
namelist nlist;
idlist ilist;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
nlist.len = ntohl (u);
}
nlist.val = (prname *)malloc(sizeof(prname ) * nlist.len);
{
int i0;
for(i0 = 0; i0 < nlist.len;++i0){
{
int i1;
for(i1 = 0; i1 < 64;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
nlist.val[i0][i1] = ntohl (u);
}
}
}
}
}
_result = PR_NameToID(call, &nlist, &ilist);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (ilist.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < ilist.len;++i0){
{ u_int32_t u;
u = htonl (ilist.val[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(nlist.val);
free(ilist.val);
return _result;
fail:
free(nlist.val);
free(ilist.val);
return rx_Error(call);
funcfail:
return _result;
}

int _PR_IDToName(
struct rx_call *call)
{
int _result;
idlist ilist;
namelist nlist;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
ilist.len = ntohl (u);
}
ilist.val = (int32_t *)malloc(sizeof(int32_t ) * ilist.len);
{
int i0;
for(i0 = 0; i0 < ilist.len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
ilist.val[i0] = ntohl (u);
}
}
}
_result = PR_IDToName(call, &ilist, &nlist);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (nlist.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < nlist.len;++i0){
{
int i1;
for(i1 = 0; i1 < 64;++i1){
{ u_int32_t u;
u = htonl (nlist.val[i0][i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
}
}
free(ilist.val);
free(nlist.val);
return _result;
fail:
free(ilist.val);
free(nlist.val);
return rx_Error(call);
funcfail:
return _result;
}

int _PR_NewEntry(
struct rx_call *call)
{
int _result;
char name[64];
int32_t flag;
int32_t oid;
int32_t id;

{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 64)
abort();
if(rx_Read(call, name, len) != len)
goto fail;
name[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
flag = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
oid = ntohl (u);
}
_result = PR_NewEntry(call, name, flag, oid, &id);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (id);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_INewEntry(
struct rx_call *call)
{
int _result;
char name[ 64 ];
int32_t id;
int32_t oid;

{
int i0;
for(i0 = 0; i0 < 64;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
name[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
oid = ntohl (u);
}
_result = PR_INewEntry(call, name, id, oid);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_ListEntry(
struct rx_call *call)
{
int _result;
int32_t id;
struct prcheckentry entry;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
_result = PR_ListEntry(call, id, &entry);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.id);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.creator);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.ngroups);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nusers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.count);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 5;++i0){
{ u_int32_t u;
u = htonl (entry.reserved[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 64;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_DumpEntry(
struct rx_call *call)
{
int _result;
int32_t pos;
struct prdebugentry entry;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
pos = ntohl (u);
}
_result = PR_DumpEntry(call, pos, &entry);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (entry.flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.id);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.cellid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.next);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 5;++i0){
{ u_int32_t u;
u = htonl (entry.reserved[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 10;++i0){
{ u_int32_t u;
u = htonl (entry.entries[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (entry.nextID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nextname);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.creator);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.ngroups);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nusers);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.count);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.instance);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.owned);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.nextOwned);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.parent);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.sibling);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (entry.child);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 64;++i0){
{ u_int32_t u;
u = htonl (entry.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_ChangeEntry(
struct rx_call *call)
{
int _result;
int32_t id;
char name[64];
int32_t oid;
int32_t newid;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 64)
abort();
if(rx_Read(call, name, len) != len)
goto fail;
name[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
oid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newid = ntohl (u);
}
_result = PR_ChangeEntry(call, id, name, oid, newid);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_SetFieldsEntry(
struct rx_call *call)
{
int _result;
int32_t id;
int32_t mask;
int32_t flags;
int32_t ngroups;
int32_t nusers;
int32_t spare1;
int32_t spare2;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
ngroups = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
nusers = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
spare2 = ntohl (u);
}
_result = PR_SetFieldsEntry(call, id, mask, flags, ngroups, nusers, spare1, spare2);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_Delete(
struct rx_call *call)
{
int _result;
int32_t id;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
_result = PR_Delete(call, id);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_WhereIsIt(
struct rx_call *call)
{
int _result;
int32_t id;
int32_t ps;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
_result = PR_WhereIsIt(call, id, &ps);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (ps);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_AddToGroup(
struct rx_call *call)
{
int _result;
int32_t uid;
int32_t gid;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
uid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
gid = ntohl (u);
}
_result = PR_AddToGroup(call, uid, gid);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_RemoveFromGroup(
struct rx_call *call)
{
int _result;
int32_t id;
int32_t gid;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
gid = ntohl (u);
}
_result = PR_RemoveFromGroup(call, id, gid);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_ListMax(
struct rx_call *call)
{
int _result;
int32_t uid;
int32_t gid;

_result = PR_ListMax(call, &uid, &gid);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (uid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (gid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_SetMax(
struct rx_call *call)
{
int _result;
int32_t uid;
int32_t gflag;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
uid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
gflag = ntohl (u);
}
_result = PR_SetMax(call, uid, gflag);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _PR_ListElements(
struct rx_call *call)
{
int _result;
int32_t id;
prlist elist;
int32_t over;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
_result = PR_ListElements(call, id, &elist, &over);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (elist.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < elist.len;++i0){
{ u_int32_t u;
u = htonl (elist.val[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (over);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
free(elist.val);
return _result;
fail:
free(elist.val);
return rx_Error(call);
funcfail:
return _result;
}

int _PR_GetCPS(
struct rx_call *call)
{
int _result;
int32_t id;
prlist elist;
int32_t over;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
_result = PR_GetCPS(call, id, &elist, &over);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (elist.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < elist.len;++i0){
{ u_int32_t u;
u = htonl (elist.val[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (over);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
free(elist.val);
return _result;
fail:
free(elist.val);
return rx_Error(call);
funcfail:
return _result;
}

int _PR_ListOwned(
struct rx_call *call)
{
int _result;
int32_t id;
prlist elist;
int32_t over;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
id = ntohl (u);
}
_result = PR_ListOwned(call, id, &elist, &over);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (elist.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < elist.len;++i0){
{ u_int32_t u;
u = htonl (elist.val[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (over);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
free(elist.val);
return _result;
fail:
free(elist.val);
return rx_Error(call);
funcfail:
return _result;
}

int _PR_IsAMemberOf(
struct rx_call *call)
{
int _result;
int32_t uid;
int32_t gid;
int32_t flag;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
uid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
gid = ntohl (u);
}
_result = PR_IsAMemberOf(call, uid, gid, &flag);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (flag);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int PR_ExecuteRequest(struct rx_call *call)
{
unsigned opcode;
int _result;
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
opcode = ntohl (u);
}
switch(opcode) {
case 504: {
_result = _PR_NameToID(call);
break;
}
case 505: {
_result = _PR_IDToName(call);
break;
}
case 509: {
_result = _PR_NewEntry(call);
break;
}
case 500: {
_result = _PR_INewEntry(call);
break;
}
case 512: {
_result = _PR_ListEntry(call);
break;
}
case 502: {
_result = _PR_DumpEntry(call);
break;
}
case 513: {
_result = _PR_ChangeEntry(call);
break;
}
case 516: {
_result = _PR_SetFieldsEntry(call);
break;
}
case 506: {
_result = _PR_Delete(call);
break;
}
case 501: {
_result = _PR_WhereIsIt(call);
break;
}
case 503: {
_result = _PR_AddToGroup(call);
break;
}
case 507: {
_result = _PR_RemoveFromGroup(call);
break;
}
case 510: {
_result = _PR_ListMax(call);
break;
}
case 511: {
_result = _PR_SetMax(call);
break;
}
case 514: {
_result = _PR_ListElements(call);
break;
}
case 508: {
_result = _PR_GetCPS(call);
break;
}
case 517: {
_result = _PR_ListOwned(call);
break;
}
case 515: {
_result = _PR_IsAMemberOf(call);
break;
}
default:
fprintf (stderr, "Ignoring %d\n", opcode);
}
return _result;
fail:
return rx_Error(call);
}

