
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from fs.xg */
#include "fs.h"

#include "fs.ss.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("fs.ss.c generated from fs.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int _RXAFS_FetchData(
struct rx_call *call)
{
int _result;
struct AFSFid a_fidToFetchP;
int32_t a_offset;
int32_t a_lenInBytes;
struct AFSFetchStatus a_fidStatP;
struct AFSCallBack a_callBackP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToFetchP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToFetchP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToFetchP.Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_offset = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_lenInBytes = ntohl (u);
}
_result = RXAFS_FetchData(call, &a_fidToFetchP, a_offset, a_lenInBytes, &a_fidStatP, &a_callBackP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_fidStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_FetchACL(
struct rx_call *call)
{
int _result;
struct AFSFid a_dirFidP;
AFSOpaque a_ACLP;
struct AFSFetchStatus a_dirNewStatP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Unique = ntohl (u);
}
_result = RXAFS_FetchACL(call, &a_dirFidP, &a_ACLP, &a_dirNewStatP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_ACLP.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
char zero[4] = {0, 0, 0, 0};
unsigned padlen = (4 - (a_ACLP.len % 4)) % 4;
if(rx_Write (call, a_ACLP.val, a_ACLP.len) != a_ACLP.len)
goto fail;
if(rx_Write (call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
free(a_ACLP.val);
return _result;
fail:
free(a_ACLP.val);
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_FetchStatus(
struct rx_call *call)
{
int _result;
struct AFSFid a_fidToStatP;
struct AFSFetchStatus a_currStatP;
struct AFSCallBack a_callBackP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToStatP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToStatP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToStatP.Unique = ntohl (u);
}
_result = RXAFS_FetchStatus(call, &a_fidToStatP, &a_currStatP, &a_callBackP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_currStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_currStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_StoreData(
struct rx_call *call)
{
int _result;
struct AFSFid a_fidToStoreP;
struct AFSStoreStatus a_fidStatusP;
int32_t a_offset;
int32_t a_lenInBytes;
int32_t a_fileLenInBytes;
struct AFSFetchStatus a_fidStatP;
struct AFSCallBack a_callBackP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToStoreP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToStoreP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidToStoreP.Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidStatusP.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidStatusP.ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidStatusP.Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidStatusP.Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidStatusP.UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidStatusP.SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_offset = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_lenInBytes = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fileLenInBytes = ntohl (u);
}
_result = RXAFS_StoreData(call, &a_fidToStoreP, &a_fidStatusP, a_offset, a_lenInBytes, a_fileLenInBytes, &a_fidStatP, &a_callBackP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_fidStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fidStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_callBackP.CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_StoreACL(
struct rx_call *call)
{
int _result;
struct AFSFid a_dirFidP;
AFSOpaque a_ACLToStoreP;
struct AFSFetchStatus a_dirNewStatP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_ACLToStoreP.len = ntohl (u);
}
a_ACLToStoreP.val = (char *)malloc(sizeof(char ) * a_ACLToStoreP.len);
{
char zero[4] = {0, 0, 0, 0};
unsigned padlen = (4 - (a_ACLToStoreP.len % 4)) % 4;
if(rx_Read (call, a_ACLToStoreP.val, a_ACLToStoreP.len) != a_ACLToStoreP.len)
goto fail;
if(rx_Read (call, zero, padlen) != padlen)
goto fail;
}
_result = RXAFS_StoreACL(call, &a_dirFidP, &a_ACLToStoreP, &a_dirNewStatP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_dirNewStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirNewStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
free(a_ACLToStoreP.val);
return _result;
fail:
free(a_ACLToStoreP.val);
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_StoreStatus(
struct rx_call *call)
{
int _result;
struct AFSFid a_fidP;
struct AFSStoreStatus a_currStatusP;
struct AFSFetchStatus a_srStatusP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidP.Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatusP.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatusP.ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatusP.Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatusP.Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatusP.UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatusP.SegSize = ntohl (u);
}
_result = RXAFS_StoreStatus(call, &a_fidP, &a_currStatusP, &a_srStatusP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_srStatusP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srStatusP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_RemoveFile(
struct rx_call *call)
{
int _result;
struct AFSFid a_dirFidP;
char a_name[256];
struct AFSFetchStatus a_srvStatusP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_name, len) != len)
goto fail;
a_name[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = RXAFS_RemoveFile(call, &a_dirFidP, a_name, &a_srvStatusP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_srvStatusP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_srvStatusP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_CreateFile(
struct rx_call *call)
{
int _result;
struct AFSFid DirFid;
char Name[256];
struct AFSStoreStatus InStatus;
struct AFSFid OutFid;
struct AFSFetchStatus OutFidStatus;
struct AFSFetchStatus OutDirStatus;
struct AFSCallBack CallBack;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
DirFid.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
DirFid.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
DirFid.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, Name, len) != len)
goto fail;
Name[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
InStatus.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
InStatus.ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
InStatus.Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
InStatus.Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
InStatus.UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
InStatus.SegSize = ntohl (u);
}
_result = RXAFS_CreateFile(call, &DirFid, Name, &InStatus, &OutFid, &OutFidStatus, &OutDirStatus, &CallBack, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (OutFid.Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFid.Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFid.Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutFidStatus.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (OutDirStatus.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (CallBack.CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (CallBack.ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (CallBack.CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_Rename(
struct rx_call *call)
{
int _result;
struct AFSFid a_origDirFidP;
char a_origNameP[256];
struct AFSFid a_newDirFidP;
char a_newNameP[256];
struct AFSFetchStatus a_origDirStatusP;
struct AFSFetchStatus a_newDirStatusP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirFidP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_origNameP, len) != len)
goto fail;
a_origNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_newDirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_newDirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_newDirFidP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_newNameP, len) != len)
goto fail;
a_newNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = RXAFS_Rename(call, &a_origDirFidP, a_origNameP, &a_newDirFidP, a_newNameP, &a_origDirStatusP, &a_newDirStatusP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_origDirStatusP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_origDirStatusP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatusP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_Symlink(
struct rx_call *call)
{
int _result;
struct AFSFid a_dirFidP;
char a_nameP[256];
char a_linkContentsP[256];
struct AFSStoreStatus a_origDirStatP;
struct AFSFid a_newFidP;
struct AFSFetchStatus a_newFidStatP;
struct AFSFetchStatus a_newDirStatP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_nameP, len) != len)
goto fail;
a_nameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_linkContentsP, len) != len)
goto fail;
a_linkContentsP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirStatP.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirStatP.ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirStatP.Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirStatP.Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirStatP.UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_origDirStatP.SegSize = ntohl (u);
}
_result = RXAFS_Symlink(call, &a_dirFidP, a_nameP, a_linkContentsP, &a_origDirStatP, &a_newFidP, &a_newFidStatP, &a_newDirStatP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_newFidP.Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidP.Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidP.Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_Link(
struct rx_call *call)
{
int _result;
struct AFSFid a_dirFidP;
char a_nameP[256];
struct AFSFid a_existingFidP;
struct AFSFetchStatus a_newFidStatP;
struct AFSFetchStatus a_newDirStatP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_dirFidP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_nameP, len) != len)
goto fail;
a_nameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_existingFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_existingFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_existingFidP.Unique = ntohl (u);
}
_result = RXAFS_Link(call, &a_dirFidP, a_nameP, &a_existingFidP, &a_newFidStatP, &a_newDirStatP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_newFidStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newFidStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_MakeDir(
struct rx_call *call)
{
int _result;
struct AFSFid a_parentDirFidP;
char a_newDirNameP[256];
struct AFSStoreStatus a_currStatP;
struct AFSFid a_newDirFidP;
struct AFSFetchStatus a_dirFidStatP;
struct AFSFetchStatus a_parentDirStatP;
struct AFSCallBack a_newDirCallBackP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_parentDirFidP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_parentDirFidP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_parentDirFidP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_newDirNameP, len) != len)
goto fail;
a_newDirNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatP.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatP.ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatP.Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatP.Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatP.UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_currStatP.SegSize = ntohl (u);
}
_result = RXAFS_MakeDir(call, &a_parentDirFidP, a_newDirNameP, &a_currStatP, &a_newDirFidP, &a_dirFidStatP, &a_parentDirStatP, &a_newDirCallBackP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_newDirFidP.Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirFidP.Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirFidP.Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_dirFidStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_parentDirStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirCallBackP.CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirCallBackP.ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newDirCallBackP.CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_RemoveDir(
struct rx_call *call)
{
int _result;
struct AFSFid a_parentDirStatP;
char a_dirNameP[256];
struct AFSFetchStatus a_newParentDirStatP;
struct AFSVolSync a_volSyncP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_parentDirStatP.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_parentDirStatP.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_parentDirStatP.Unique = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_dirNameP, len) != len)
goto fail;
a_dirNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = RXAFS_RemoveDir(call, &a_parentDirStatP, a_dirNameP, &a_newParentDirStatP, &a_volSyncP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_newParentDirStatP.InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_newParentDirStatP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volSyncP.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_GiveUpCallBacks(
struct rx_call *call)
{
int _result;
AFSCBFids a_fidArrayP;
AFSCBs a_callBackArrayP;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidArrayP.len = ntohl (u);
}
a_fidArrayP.val = (struct AFSFid *)malloc(sizeof(struct AFSFid ) * a_fidArrayP.len);
{
int i0;
for(i0 = 0; i0 < a_fidArrayP.len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidArrayP.val[i0].Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidArrayP.val[i0].Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_fidArrayP.val[i0].Unique = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_callBackArrayP.len = ntohl (u);
}
a_callBackArrayP.val = (struct AFSCallBack *)malloc(sizeof(struct AFSCallBack ) * a_callBackArrayP.len);
{
int i0;
for(i0 = 0; i0 < a_callBackArrayP.len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_callBackArrayP.val[i0].CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_callBackArrayP.val[i0].ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_callBackArrayP.val[i0].CallBackType = ntohl (u);
}
}
}
_result = RXAFS_GiveUpCallBacks(call, &a_fidArrayP, &a_callBackArrayP);
if (_result) goto funcfail;
free(a_fidArrayP.val);
free(a_callBackArrayP.val);
return _result;
fail:
free(a_fidArrayP.val);
free(a_callBackArrayP.val);
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_GetVolumeStatus(
struct rx_call *call)
{
int _result;
int32_t a_volIDP;
struct AFSFetchVolumeStatus a_volFetchStatP;
char a_volNameP[256];
char a_offLineMsgP[1024];
char a_motdP[1024];

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_volIDP = ntohl (u);
}
_result = RXAFS_GetVolumeStatus(call, a_volIDP, &a_volFetchStatP, a_volNameP, a_offLineMsgP, a_motdP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_volFetchStatP.Vid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.ParentId);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.Online);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.InService);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.Blessed);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.NeedsSalvage);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.Type);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.MinQuota);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.MaxQuota);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.BlocksInUse);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.PartBlocksAvail);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volFetchStatP.PartMaxBlocks);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_volNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_volNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_offLineMsgP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_offLineMsgP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_motdP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_motdP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_SetVolumeStatus(
struct rx_call *call)
{
int _result;
int32_t a_volIDP;
struct AFSStoreVolumeStatus a_volStoreStatP;
char a_volNameP[256];
char a_offLineMsgP[1024];
char a_motdP[1024];

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_volIDP = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_volStoreStatP.Mask = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_volStoreStatP.MinQuota = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
a_volStoreStatP.MaxQuota = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_volNameP, len) != len)
goto fail;
a_volNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 1024)
abort();
if(rx_Read(call, a_offLineMsgP, len) != len)
goto fail;
a_offLineMsgP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 1024)
abort();
if(rx_Read(call, a_motdP, len) != len)
goto fail;
a_motdP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = RXAFS_SetVolumeStatus(call, a_volIDP, &a_volStoreStatP, a_volNameP, a_offLineMsgP, a_motdP);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_GetRootVolume(
struct rx_call *call)
{
int _result;
char a_rootVolNameP[256];

_result = RXAFS_GetRootVolume(call, a_rootVolNameP);
if (_result) goto funcfail;
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_rootVolNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_rootVolNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_GetTime(
struct rx_call *call)
{
int _result;
u_int32_t a_secondsP;
u_int32_t a_uSecondsP;

_result = RXAFS_GetTime(call, &a_secondsP, &a_uSecondsP);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (a_secondsP);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_uSecondsP);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_NGetVolumeInfo(
struct rx_call *call)
{
int _result;
char VolumeName[256];
struct AFSVolumeInfo stuff;

{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, VolumeName, len) != len)
goto fail;
VolumeName[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = RXAFS_NGetVolumeInfo(call, VolumeName, &stuff);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (stuff.Vid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Type);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Type0);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Type1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Type2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Type3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Type4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.ServerCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server0);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Server7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port0);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (stuff.Port7);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_BulkStatus(
struct rx_call *call)
{
int _result;
AFSCBFids FidsArray;
AFSBulkStats StatArray;
AFSCBs CBArray;
struct AFSVolSync Sync;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
FidsArray.len = ntohl (u);
}
FidsArray.val = (struct AFSFid *)malloc(sizeof(struct AFSFid ) * FidsArray.len);
{
int i0;
for(i0 = 0; i0 < FidsArray.len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
FidsArray.val[i0].Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
FidsArray.val[i0].Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
FidsArray.val[i0].Unique = ntohl (u);
}
}
}
_result = RXAFS_BulkStatus(call, &FidsArray, &StatArray, &CBArray, &Sync);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (StatArray.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < StatArray.len;++i0){
{ u_int32_t u;
u = htonl (StatArray.val[i0].InterfaceVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].FileType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].LinkCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].Length);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].DataVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].Author);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].CallerAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].AnonymousAccess);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].ParentVnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].ParentUnique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].ServerModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].SyncCount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (StatArray.val[i0].spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (CBArray.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < CBArray.len;++i0){
{ u_int32_t u;
u = htonl (CBArray.val[i0].CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (CBArray.val[i0].ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (CBArray.val[i0].CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (Sync.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
free(FidsArray.val);
free(StatArray.val);
free(CBArray.val);
return _result;
fail:
free(FidsArray.val);
free(StatArray.val);
free(CBArray.val);
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_SetLock(
struct rx_call *call)
{
int _result;
struct AFSFid Fid;
ViceLockType Type;
struct AFSVolSync Sync;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Type = ntohl (u);
}
_result = RXAFS_SetLock(call, &Fid, Type, &Sync);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (Sync.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_ExtendLock(
struct rx_call *call)
{
int _result;
struct AFSFid Fid;
struct AFSVolSync Sync;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Unique = ntohl (u);
}
_result = RXAFS_ExtendLock(call, &Fid, &Sync);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (Sync.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _RXAFS_ReleaseLock(
struct rx_call *call)
{
int _result;
struct AFSFid Fid;
struct AFSVolSync Sync;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
Fid.Unique = ntohl (u);
}
_result = RXAFS_ReleaseLock(call, &Fid, &Sync);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (Sync.spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare4);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare5);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Sync.spare6);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int RXAFS_ExecuteRequest(struct rx_call *call)
{
unsigned opcode;
int _result;
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
opcode = ntohl (u);
}
switch(opcode) {
case 130: {
_result = _RXAFS_FetchData(call);
break;
}
case 131: {
_result = _RXAFS_FetchACL(call);
break;
}
case 132: {
_result = _RXAFS_FetchStatus(call);
break;
}
case 133: {
_result = _RXAFS_StoreData(call);
break;
}
case 134: {
_result = _RXAFS_StoreACL(call);
break;
}
case 135: {
_result = _RXAFS_StoreStatus(call);
break;
}
case 136: {
_result = _RXAFS_RemoveFile(call);
break;
}
case 137: {
_result = _RXAFS_CreateFile(call);
break;
}
case 138: {
_result = _RXAFS_Rename(call);
break;
}
case 139: {
_result = _RXAFS_Symlink(call);
break;
}
case 140: {
_result = _RXAFS_Link(call);
break;
}
case 141: {
_result = _RXAFS_MakeDir(call);
break;
}
case 142: {
_result = _RXAFS_RemoveDir(call);
break;
}
case 147: {
_result = _RXAFS_GiveUpCallBacks(call);
break;
}
case 149: {
_result = _RXAFS_GetVolumeStatus(call);
break;
}
case 150: {
_result = _RXAFS_SetVolumeStatus(call);
break;
}
case 151: {
_result = _RXAFS_GetRootVolume(call);
break;
}
case 153: {
_result = _RXAFS_GetTime(call);
break;
}
case 154: {
_result = _RXAFS_NGetVolumeInfo(call);
break;
}
case 155: {
_result = _RXAFS_BulkStatus(call);
break;
}
case 156: {
_result = _RXAFS_SetLock(call);
break;
}
case 157: {
_result = _RXAFS_ExtendLock(call);
break;
}
case 158: {
_result = _RXAFS_ReleaseLock(call);
break;
}
default:
fprintf (stderr, "Ignoring %d\n", opcode);
}
return _result;
fail:
return rx_Error(call);
}

