
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from fs.xg */
#include "fs.h"

#include "fs.cs.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#include <arlad/fs_errors.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("fs.cs.c generated from fs.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int StartRXAFS_FetchData(
struct rx_call *call
, struct AFSFid *a_fidToFetchP
, int32_t a_offset
, int32_t a_lenInBytes
)
{
{ u_int32_t u;
u = htonl (130);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToFetchP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToFetchP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToFetchP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_offset);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_lenInBytes);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return 0;
fail:
return conv_to_arla_errno(rx_Error(call));
}

int EndRXAFS_FetchData(
struct rx_call *call
, struct AFSFetchStatus *a_fidStatP
, struct AFSCallBack *a_callBackP
, struct AFSVolSync *a_volSyncP
)
{
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).CallBackType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return 0;
fail:
return conv_to_arla_errno(rx_Error(call));
}

int RXAFS_FetchACL(
struct rx_connection *connection
, const struct AFSFid *a_dirFidP
, AFSOpaque *a_ACLP
, struct AFSFetchStatus *a_dirNewStatP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (131);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_ACLP).len = ntohl (u);
}
(*a_ACLP).val = (char *)malloc(sizeof(char ) * (*a_ACLP).len);
{
char zero[4] = {0, 0, 0, 0};
unsigned padlen = (4 - ((*a_ACLP).len % 4)) % 4;
if(rx_Read (call, (*a_ACLP).val, (*a_ACLP).len) != (*a_ACLP).len)
goto fail;
if(rx_Read (call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_FetchStatus(
struct rx_connection *connection
, const struct AFSFid *a_fidToStatP
, struct AFSFetchStatus *a_currStatP
, struct AFSCallBack *a_callBackP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (132);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToStatP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToStatP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToStatP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_currStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).CallBackType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int StartRXAFS_StoreData(
struct rx_call *call
, struct AFSFid *a_fidToStoreP
, struct AFSStoreStatus *a_fidStatusP
, int32_t a_offset
, int32_t a_lenInBytes
, int32_t a_fileLenInBytes
)
{
{ u_int32_t u;
u = htonl (133);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToStoreP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToStoreP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidToStoreP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidStatusP).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidStatusP).ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidStatusP).Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidStatusP).Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidStatusP).UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidStatusP).SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_offset);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_lenInBytes);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_fileLenInBytes);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return 0;
fail:
return conv_to_arla_errno(rx_Error(call));
}

int EndRXAFS_StoreData(
struct rx_call *call
, struct AFSFetchStatus *a_fidStatP
, struct AFSCallBack *a_callBackP
, struct AFSVolSync *a_volSyncP
)
{
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_fidStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_callBackP).CallBackType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return 0;
fail:
return conv_to_arla_errno(rx_Error(call));
}

int RXAFS_StoreACL(
struct rx_connection *connection
, const struct AFSFid *a_dirFidP
, const AFSOpaque *a_ACLToStoreP
, struct AFSFetchStatus *a_dirNewStatP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (134);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_ACLToStoreP).len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
char zero[4] = {0, 0, 0, 0};
unsigned padlen = (4 - ((*a_ACLToStoreP).len % 4)) % 4;
if(rx_Write (call, (*a_ACLToStoreP).val, (*a_ACLToStoreP).len) != (*a_ACLToStoreP).len)
goto fail;
if(rx_Write (call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirNewStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_StoreStatus(
struct rx_connection *connection
, const struct AFSFid *a_fidP
, const struct AFSStoreStatus *a_currStatusP
, struct AFSFetchStatus *a_srStatusP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (135);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatusP).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatusP).ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatusP).Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatusP).Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatusP).UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatusP).SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srStatusP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_RemoveFile(
struct rx_connection *connection
, const struct AFSFid *a_dirFidP
, const char a_name[256]
, struct AFSFetchStatus *a_srvStatusP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (136);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_name);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_name, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_srvStatusP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_CreateFile(
struct rx_connection *connection
, const struct AFSFid *DirFid
, const char Name[256]
, const struct AFSStoreStatus *InStatus
, struct AFSFid *OutFid
, struct AFSFetchStatus *OutFidStatus
, struct AFSFetchStatus *OutDirStatus
, struct AFSCallBack *CallBack
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (137);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*DirFid).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*DirFid).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*DirFid).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(Name);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, Name, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
u = htonl ((*InStatus).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*InStatus).ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*InStatus).Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*InStatus).Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*InStatus).UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*InStatus).SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFid).Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFid).Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFid).Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutFidStatus).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*OutDirStatus).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CallBack).CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CallBack).ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CallBack).CallBackType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_Rename(
struct rx_connection *connection
, const struct AFSFid *a_origDirFidP
, const char a_origNameP[256]
, const struct AFSFid *a_newDirFidP
, const char a_newNameP[256]
, struct AFSFetchStatus *a_origDirStatusP
, struct AFSFetchStatus *a_newDirStatusP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (138);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_origNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_origNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_newDirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_newDirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_newDirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_newNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_newNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_origDirStatusP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatusP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_Symlink(
struct rx_connection *connection
, const struct AFSFid *a_dirFidP
, const char a_nameP[256]
, const char a_linkContentsP[256]
, const struct AFSStoreStatus *a_origDirStatP
, struct AFSFid *a_newFidP
, struct AFSFetchStatus *a_newFidStatP
, struct AFSFetchStatus *a_newDirStatP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (139);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_nameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_nameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_linkContentsP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_linkContentsP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirStatP).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirStatP).ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirStatP).Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirStatP).Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirStatP).UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_origDirStatP).SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidP).Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidP).Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidP).Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_Link(
struct rx_connection *connection
, const struct AFSFid *a_dirFidP
, const char a_nameP[256]
, const struct AFSFid *a_existingFidP
, struct AFSFetchStatus *a_newFidStatP
, struct AFSFetchStatus *a_newDirStatP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (140);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_dirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_nameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_nameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_existingFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_existingFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_existingFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newFidStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_MakeDir(
struct rx_connection *connection
, const struct AFSFid *a_parentDirFidP
, const char a_newDirNameP[256]
, const struct AFSStoreStatus *a_currStatP
, struct AFSFid *a_newDirFidP
, struct AFSFetchStatus *a_dirFidStatP
, struct AFSFetchStatus *a_parentDirStatP
, struct AFSCallBack *a_newDirCallBackP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (141);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_parentDirFidP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_parentDirFidP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_parentDirFidP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_newDirNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_newDirNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatP).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatP).ClientModTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatP).Owner);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatP).Group);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatP).UnixModeBits);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_currStatP).SegSize);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirFidP).Volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirFidP).Vnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirFidP).Unique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_dirFidStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_parentDirStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirCallBackP).CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirCallBackP).ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newDirCallBackP).CallBackType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_RemoveDir(
struct rx_connection *connection
, const struct AFSFid *a_parentDirStatP
, const char a_dirNameP[256]
, struct AFSFetchStatus *a_newParentDirStatP
, struct AFSVolSync *a_volSyncP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (142);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_parentDirStatP).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_parentDirStatP).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_parentDirStatP).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_dirNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_dirNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_newParentDirStatP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volSyncP).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_GiveUpCallBacks(
struct rx_connection *connection
, const AFSCBFids *a_fidArrayP
, const AFSCBs *a_callBackArrayP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (147);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidArrayP).len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < (*a_fidArrayP).len;++i0){
{ u_int32_t u;
u = htonl ((*a_fidArrayP).val[i0].Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidArrayP).val[i0].Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_fidArrayP).val[i0].Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl ((*a_callBackArrayP).len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < (*a_callBackArrayP).len;++i0){
{ u_int32_t u;
u = htonl ((*a_callBackArrayP).val[i0].CallBackVersion);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_callBackArrayP).val[i0].ExpirationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_callBackArrayP).val[i0].CallBackType);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_GetVolumeStatus(
struct rx_connection *connection
, const int32_t a_volIDP
, struct AFSFetchVolumeStatus *a_volFetchStatP
, char a_volNameP[256]
, char a_offLineMsgP[1024]
, char a_motdP[1024]
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (149);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volIDP);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).Vid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).ParentId = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).Online = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).InService = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).Blessed = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).NeedsSalvage = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).Type = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).MinQuota = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).MaxQuota = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).BlocksInUse = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).PartBlocksAvail = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_volFetchStatP).PartMaxBlocks = ntohl (u);
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_volNameP, len) != len)
goto fail;
a_volNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 1024)
abort();
if(rx_Read(call, a_offLineMsgP, len) != len)
goto fail;
a_offLineMsgP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 1024)
abort();
if(rx_Read(call, a_motdP, len) != len)
goto fail;
a_motdP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_SetVolumeStatus(
struct rx_connection *connection
, const int32_t a_volIDP
, const struct AFSStoreVolumeStatus *a_volStoreStatP
, const char a_volNameP[256]
, const char a_offLineMsgP[1024]
, const char a_motdP[1024]
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (150);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (a_volIDP);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_volStoreStatP).Mask);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_volStoreStatP).MinQuota);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*a_volStoreStatP).MaxQuota);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_volNameP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_volNameP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_offLineMsgP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_offLineMsgP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(a_motdP);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, a_motdP, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_GetRootVolume(
struct rx_connection *connection
, char a_rootVolNameP[256]
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (151);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, a_rootVolNameP, len) != len)
goto fail;
a_rootVolNameP[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_GetTime(
struct rx_connection *connection
, u_int32_t *a_secondsP
, u_int32_t *a_uSecondsP
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (153);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_secondsP) = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*a_uSecondsP) = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_NGetVolumeInfo(
struct rx_connection *connection
, const char VolumeName[256]
, struct AFSVolumeInfo *stuff
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (154);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(VolumeName);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, VolumeName, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Vid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Type = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Type0 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Type1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Type2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Type3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Type4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).ServerCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server0 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Server7 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port0 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port6 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*stuff).Port7 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_BulkStatus(
struct rx_connection *connection
, const AFSCBFids *FidsArray
, AFSBulkStats *StatArray
, AFSCBs *CBArray
, struct AFSVolSync *Sync
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (155);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*FidsArray).len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < (*FidsArray).len;++i0){
{ u_int32_t u;
u = htonl ((*FidsArray).val[i0].Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*FidsArray).val[i0].Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*FidsArray).val[i0].Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).len = ntohl (u);
}
(*StatArray).val = (struct AFSFetchStatus *)malloc(sizeof(struct AFSFetchStatus ) * (*StatArray).len);
{
int i0;
for(i0 = 0; i0 < (*StatArray).len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].InterfaceVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].FileType = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].LinkCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].Length = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].DataVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].Author = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].Owner = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].CallerAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].AnonymousAccess = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].UnixModeBits = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].ParentVnode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].ParentUnique = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].SegSize = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].ClientModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].ServerModTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].Group = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].SyncCount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*StatArray).val[i0].spare4 = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CBArray).len = ntohl (u);
}
(*CBArray).val = (struct AFSCallBack *)malloc(sizeof(struct AFSCallBack ) * (*CBArray).len);
{
int i0;
for(i0 = 0; i0 < (*CBArray).len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CBArray).val[i0].CallBackVersion = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CBArray).val[i0].ExpirationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*CBArray).val[i0].CallBackType = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_SetLock(
struct rx_connection *connection
, const struct AFSFid *Fid
, const ViceLockType Type
, struct AFSVolSync *Sync
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (156);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (Type);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_ExtendLock(
struct rx_connection *connection
, const struct AFSFid *Fid
, struct AFSVolSync *Sync
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (157);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int RXAFS_ReleaseLock(
struct rx_connection *connection
, const struct AFSFid *Fid
, struct AFSVolSync *Sync
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (158);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Vnode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*Fid).Unique);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare3 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare4 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare5 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*Sync).spare6 = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
