/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */



#include "milko_locl.h"

RCSID("$Id: volser.c,v 1.11 1998/10/07 21:16:22 lha Exp $");

/*
 * Network functions, this should be broken out
 */

#define N_SECURITY_OBJECTS 3

static struct rx_service *volserservice;
static struct rx_securityClass *(securityObjects[N_SECURITY_OBJECTS]);

static char *srvtab_filename = "/etc/srvtab";
static int use_kerberos = 1;

/* XXX HACK */
struct filesystem ufs_filesystem;

/*
 * The volser implemention
 */

int
VOLSER_AFSVolCreateVolume(struct rx_call *call, const int32_t partition, 
			  const char *name, const int32_t type,
			  const int32_t parent, 
			  int32_t *volid, int32_t *trans)
{
    printf("VolCreateVolume\n");

    *volid = 0;
    *trans = 0x4711;

    return 0;
}

int
VOLSER_AFSVolTransCreate(struct rx_call *call, const int32_t volume, 
			 const int32_t partition, const int32_t flags, 
			 int32_t *trans)
{
    printf("VolTransCreate\n");
    return 0;
}

int
VOLSER_AFSVolEndTrans(struct rx_call *call, const int32_t trans, 
		      int32_t *rcode)
{
    printf("VolEndTrans Trans 0x%x\n", trans);
    *rcode = ENOMEM;
    return 0;
}

int
VOLSER_AFSVolGetFlags(struct rx_call *call, const int32_t trans, 
		      int32_t *flags)
{
    printf("VolGetFlags\n");
    return 0;
}

int
VOLSER_AFSVolSetFlags(struct rx_call *call, const int32_t trans, 
		      const int32_t flags)
{
    printf("VolSetFlags\n");
    printf("Trans: 0x%x flags: 0x%x\n", trans, flags);
    return 0;
}

int
VOLSER_AFSVolGetName(struct rx_call *call, const int32_t tid, char *tname)
{
    printf("VolGetName\n");
    return 0;
}

int
VOLSER_AFSVolSetDate(struct rx_call *call, const int32_t tid, 
		     const int32_t newDate)
{
    printf("VolSetDate\n");
    return 0;
}

/* XXX */

int
VOLSER_AFSVolListPartitions(struct rx_call *call, struct pIDs *partIDs)
{
    printf("VolListPartitions\n");
    memset(partIDs, 0, sizeof(*partIDs));
    
    partIDs->partIds[0] = 'a';

    return 0;
}

int
VOLSER_AFSVolPartitionInfo(struct rx_call *call, const char *name, 
			   struct diskPartition *partition)
{
    printf("VolPartionInfo\n");
    return 0;
}

int
VOLSER_AFSVolListVolumes(struct rx_call *call, const int32_t partID, 
			 const int32_t flags, volEntries *resultEntries)
{
    printf("VolListVolumes\n");
    return 0;
}

int
VOLSER_AFSVolListOneVolume(struct rx_call *call, const int32_t partID, 
			   const int32_t volid, volEntries *resultEntries)
{
    printf("ListOneVolume\n");
    return 0;
}

int
VOLSER_AFSVolMonitor(struct rx_call *call, transDebugEntries *result)
{
    printf("VolMonitor\n");
    return 0;
}

/*
 * Network function, this should be broken out
 */


#ifdef KERBEROS
static int
milko_get_key(void *appl, int kvno, des_cblock *key)
{
    /* 
     * XXX this is not really good, since I think read_service_key
     * does not exist in MIT-kerberos
     */
    return read_service_key("afs", "", "STACKEN.KTH.SE", 
			    0, srvtab_filename, (char *)key);
}
#endif

static void
network_init(void)
{
    int maxsec = 1;

    if (rx_Init(0) != 0) 
	errx(1, "Cant open serverport port\n") ;
    
    securityObjects[0] = rxnull_NewServerSecurityObject();   /* XXX 0 */
    if (securityObjects[0] == NULL ) 
	errx(1, "cant create security object") ;

#ifdef KERBEROS
    if (use_kerberos) {
	maxsec = 2;
	securityObjects[2] = rxkad_NewServerSecurityObject(rxkad_auth,
							   NULL,
							   milko_get_key,
							   NULL);
	if (securityObjects[2] == NULL)
	    errx(1, "init_network: can't init rxkad server-security-object");
    }
#endif

    volserservice = rx_NewService(VOLSERSERVERPORT, VOLSER_SERVICE_ID, 
				  "volser", 
				  securityObjects, maxsec, 
				  VOLSER_ExecuteRequest);
    
    if (volserservice == NULL) 
	errx(1, "Cant create volser service");

}

int main(void) 
{
    network_init();
    volser_init(8196);

    printf("Starting to serve...\n");

    rx_SetMaxProcs(volserservice,5) ;
    rx_StartServer(1) ;

    abort() ; /* should not get here */
    return 0;
}

