/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "milko_locl.h"
#include <sl.h>

RCSID("$Id: volmgr.c,v 1.5 1998/11/07 20:22:12 map Exp $");

#define ONTOP_NUMVNODES	100

/*
 * Handles bootstrapping of volumes
 */ 

int 
null_cmd(int argc, char **argv)
{
    printf("I do nothing\n");
    return 0;
}

static int
print_sizes(int argc, char **argv)
{
    ontop_print_sizes();
    return 0;
}

/*
 *
 */

/*
 *
 */

int
generate_ontop_volume(int argc, char **argv)
{
    int error;
    int32_t volid;
    struct ontop_part *part;

    if (argc != 3)
	errx(1, "gen-ontop-vol: <partition-name> <volume-id>");

    error = ontop_open_part(argv[1], &part);
    if (error)
	err(1, "gen-ontop-vol");

    volid = atoi(argv[2]);

    error = ontop_create_volume(part, volid);
    if (error)
	errx(1, "gen-ontop-vol: ontop_create_volume returned %d", error);

    ontop_release_part(part);

    return 0;
}

/*
 *
 */

static int
parse_ontop_volume(int argc, char **argv)
{
    int error;
    char *volname;
    struct ontop_vol *vol;
    struct ontop_part *part;
    int32_t volid;

    if (argc != 3)
	errx(1, "parse-ontop-volume <part-path> <volid>");

    part = calloc(1, sizeof(struct ontop_part));
    volname = argv[1];
    strncpy(part->name, argv[1], sizeof(part->name));
    part->name[sizeof(part->name)-1] = '\0';
    part->refcount = 1;

    volid = atoi(argv[2]);
	
    error = ontop_open_volume(part, volid, &vol);
    if (error)
	errx(1, "ontop_open_voume: %s (%d)", strerror(error), error);

    error = ontop_close_volume(vol);
    if (error)
	errx(1, "ontop_close_volume: %d\n", error);

    return 0;
}

/*
 *
 */

static SL_cmd cmds[] = {
    {"null",		
     null_cmd,	
     "do nothing"},
    {"size",
     print_sizes,
     "print sizes"},
    {"gen-ontop-vol", 	
     generate_ontop_volume, 
     "generate a ontop-volume"},
    {"parse-ontop-vol",  
     parse_ontop_volume, 
     "parse vnode-table for a ontop-volume"},
    { NULL, NULL }
};

/*
 *
 */

int 
main(int argc, char **argv)
{
    set_progname(argv[0]);

    fhprobe();
    
    if (argc > 1)
	sl_command(cmds, argc - 1, argv + 1);
    else
	sl_help(cmds, 1, NULL);
    
    return 0;
}

