/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#ifndef __ONTOP_SUBR_H
#define __ONTOP_SUBR_H

#define ONTOP_VNODETABLE "vnode-table"
#define ONTOP_NEWVNODES 40
#define ONTOP_NEWVNODESLIMIT 10

struct ontop_part {
    char refcount;
    char name[MAXPATHLEN];
};

struct ontop_vol {
    char name[MAXPATHLEN];
    int32_t volid;
    ontop_header header;
    int refcount;
    int fd;
    struct {
	long rwp:1;
	long validp:1;
	long precreate:1;
	long wantsignal:1;
    } flags ;
    struct ontop_part *part;
    struct Lock hdrlock;  /* lock for header */
    struct Lock vollock;  /* lock for volume */
} ;

int ontop_initworker(void);
int ontop_print_sizes(void);
int ontop_attach(struct ontop_vol *vol);
int ontop_release(struct ontop_vol *vol);
int ontop_create_vnode(struct ontop_vol *vol, struct ontop_vnode *vnode);
int ontop_open_vnode(struct ontop_vol *vol, int32_t ino,
		 ontop_vnode **vnode, int *rfd);
int ontop_close_vnode(struct ontop_vol *vol, int32_t ino,
		 ontop_vnode *vnode, int fd, int updatep);
int ontop_create_volume(struct ontop_part *part, int32_t volid);
int ontop_alloc_vnode(struct ontop_vol *vol, int dirp, int32_t *rino);
int ontop_free_vnode(struct ontop_vol *vol, int32_t ino);
int ontop_open_volume(struct ontop_part *part, int32_t volid, 
		      struct ontop_vol **vol);
int ontop_close_volume(struct ontop_vol *vol);
int ontop_open_part(char *path, struct ontop_part **part);
int ontop_use_part(struct ontop_part *part);
int ontop_release_part(struct ontop_part *part);


#endif /* __ONTOP_SUBR_H */
