/*
 * Copyright (c) 1995, 1996, 1997 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */



#include "milko_locl.h"

RCSID("$Id: milko.c,v 1.14 1998/11/05 09:26:24 lha Exp $");

#define N_SECURITY_OBJECTS 3

static struct rx_service *fsservice;
static struct rx_securityClass *(securityObjects[N_SECURITY_OBJECTS]);

static char *srvtab_filename = "/etc/srvtab";
static int use_kerberos = 1;

#ifdef KERBEROS
static int
milko_get_key(void *appl, int kvno, des_cblock *key)
{
    /* 
     * XXX this is not really good, since I think read_service_key
     * does not exist in MIT-kerberos
     */
    return read_service_key("afs", "milko", "STACKEN.KTH.SE", 
			    0, srvtab_filename, (char *)key);
}
#endif

static void
network_init(void)
{
    int maxsec = 1;

    if (rx_Init(0) != 0) 
	errx(1, "Cant open serverport port\n") ;
    
    securityObjects[0] = rxnull_NewServerSecurityObject();   /* XXX 0 */
    if (securityObjects[0] == NULL ) 
	errx(1, "cant create security object") ;

#ifdef KERBEROS
    if (use_kerberos) {
	maxsec = 2;
	securityObjects[2] = rxkad_NewServerSecurityObject(rxkad_auth,
							   NULL,
							   milko_get_key,
							   NULL);
	if (securityObjects[2] == NULL)
	    errx(1, "init_network: can't init rxkad server-security-object");
    }
#endif

    fsservice = rx_NewService(FSSERVERPORT, FS_SERVICE_ID, "fs", 
			      securityObjects, maxsec, 
			      RXAFS_ExecuteRequest);
    if (fsservice == NULL)
	errx(1, "Cant create FS services");
}

int main(void) 
{
    printf("Milko %s starting:", VERSION);

    printf(" network"); fflush(stdout);
    network_init();

    printf(" fhget"); fflush(stdout);
    fhprobe();
    
    printf(" volser"); fflush(stdout);
    volser_init(100);
    printf(" bufcache"); fflush(stdout);
    bufcache_init(10);

    printf(".\n"); fflush(stdout);

#ifdef USE_MILKO_SYSCALL
    syscallnum = findmilkosyscall();
    printf("Using milkosyscall at %d version: \n", syscallnum);
    fflush(stdout);
    iversion();
#endif

    printf("milko-fileserver started\n");
    rx_SetMaxProcs(fsservice,5) ;
    rx_StartServer(5) ;

    abort() ; /* should not get here */
    return 0;
}




