/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include <err.h>

#include <sl.h>

#include "msys.h"

static int
iopen_cmd(int argc, char **argv)
{
    ino_t ino = 202;
    int fd, basefd, len;
    char str[2048];  /* XXX large enough for dirent */
    struct stat sb;

    if (argc != 3)
	errx(1, "iopen <base-path> <inode>");

    basefd = open(argv[1], O_RDONLY);
    if (basefd < 0)
	err(1, "open");

    if (sscanf(argv[2], "%d", &ino) != 1)
	errx(1, "iopen: inode parse error");

    fd = iopen(basefd, ino, O_RDONLY);
    if (fd < 0)
	err(1, "iopen");

    if (fstat(fd, &sb) == -1)
	err(1, "fstat");

    if (S_ISREG(sb.st_mode) || S_ISLNK(sb.st_mode)) {
	while ((len = read(fd, str, sizeof(str))) > 0)
	    if (write(1, str, len) != len)
		err(1, "write");
    } else if (S_ISDIR(sb.st_mode)) {
	struct dirent *dp;
	long basep;
	int count;

	if (lseek(fd, 0, SEEK_SET) == -1)
	    err(1, "lseek");

	while((len = getdirentries(fd, str, sizeof(str), &basep)) > 0) {
	    dp = (struct dirent *) str;

	    count = 0;

	    while (len > count) {
		printf("name: %s num: %u\n", dp->d_name, dp->d_fileno);
		count += dp->d_reclen;
		((char *)dp) += dp->d_reclen;
	    }
	}
	if (len == -1)
	    err(1, "getdirentries");
    } else
	errx(1, "Unknown filetype");

    close(fd);
    close(basefd);

    return 0;
}

static int
istatpath_cmd(int argc, char **argv)
{
    int basefd;
    struct stat sb;
    int error;

    if (argc != 3)
	errx(1, "iopen <base-path> <path-to-stat>");

    basefd = open(argv[1], O_RDONLY);
    if (basefd < 0)
	err(1, "open");

    error = istatpath(basefd, argv[2], &sb);
    if (error < 0)
	err(1, "ipathstat");

    printf("Type: ");
    if (S_ISDIR(sb.st_mode))
	printf("dir   ");
    else if (S_ISREG(sb.st_mode))
	printf("file  ");
    else if (S_ISLNK(sb.st_mode))
	printf("link  ");
    else
	printf("other ");
    
    printf("Size: %d\n", sb.st_size);

    close(basefd);

    return 0;
}

static SL_cmd cmds[] = {
    {"iopen",  iopen_cmd,	 "open a inode"},
    {"istatpath", istatpath_cmd, "stat a path"}, 
    { NULL, NULL }
};

int main(int argc, char **argv)
{
    findmilkosyscall();

    if (argc > 1)
	sl_command(cmds, argc - 1, argv + 1);
    else
	sl_help(cmds, 1, NULL);

    return 0;
}
