/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* $Id: fileserver.h,v 1.11 1998/11/08 14:50:07 lha Exp $ */

#ifndef __FILESERVER_H
#define __FILESERVER_H

typedef struct {
    long uid ;
    int ngroups;		/* if < 1 group is undefined */
    u_int32_t *group;
    time_t timeout;		/* when this cred will timeout */
    unsigned refcount;
    struct {
	unsigned administrator:1; /* system:anyuser */
	unsigned authuser:1;	/* system:authuser */
	unsigned killme:1;	/* entry invalid but still in use */
    } bits;
} MilkoCred;

/*
 * Filesystem operations
 *
 *  We should proably not pass CallBacks and Volsync's since that
 * is the work of the upper layer of the fileserver.
 */

typedef int (*fsinit)(char *, void **);
typedef int (*fsclose)(void *, int reson);
typedef int (*getstatus)(const MilkoCred *cred, void *data, 
			 const AFSFid *fid, AFSFetchStatus *status);
typedef int (*setstatus)(const MilkoCred *cred, void *data, 
			 const AFSFid *fid, const AFSStoreStatus *sstatus,
			 AFSFetchStatus *status);
typedef int (*getdata)(const MilkoCred *cred, void *, struct rx_call *rxcall,
		       const AFSFid *fid, const int32_t offset, 
		       const int32_t len, AFSFetchStatus *status);
typedef int (*putdata)(const MilkoCred *cred, void *, struct rx_call *rxcall,
		       const AFSFid *fid, const AFSStoreStatus *sstatus, 
		       const int32_t offset, const int32_t len,
		       AFSFetchStatus *status, int32_t a_fileLenInBytes);
typedef int (*giveupcallback)(const MilkoCred *cred, void *data,
			      const AFSCBFids *fidArray,
			      const AFSCBs *callBackArray);
typedef int (*storeacl)(const MilkoCred *cred, void *data,
			const AFSFid *a_dirFidP,
			const AFSOpaque *a_ACLToStoreP,
			AFSFetchStatus *a_dirNewStatP,
			AFSVolSync *a_volSyncP);
typedef int (*fetchacl)(const MilkoCred *cred,
			void *data,
			const AFSFid *fid,
			AFSOpaque *opaque,
			AFSFetchStatus *a_dirNewStatP);
typedef int (*makedir)(const MilkoCred *cred, void *data, struct rx_call *call,
		       const AFSFid *parentfid, const char *name, 
		       const AFSStoreStatus *storestatus,
		       AFSFid *newfid, AFSFetchStatus *statusfid,
		       AFSFetchStatus *statusparentfid, 
		       AFSCallBack *callbackfid, AFSVolSync *volsync);
typedef int (*removedir) (const MilkoCred *cred, void *data,
			  struct rx_call *call, const AFSFid *parentfid,
			  const char *dirname, AFSFetchStatus *dirstatus,
			  AFSVolSync *volsync);
typedef int (*createfile) (const MilkoCred *cred, void *data,
			   struct rx_call *call, const AFSFid *DirFid,
			   const char *Name,
			   const AFSStoreStatus *InStatus,
			   AFSFid *OutFid,
			   AFSFetchStatus *OutFidStatus,
			   AFSFetchStatus *OutDirStatus,
			   AFSCallBack *CallBack,
			   AFSVolSync *a_volSyncP);
typedef int (*removefile) (const MilkoCred *cred, void *data,
			   struct rx_call *call,
			   const AFSFid *a_dirFidP,
			   const char *a_name,
			   AFSFetchStatus *a_srvStatusP,
			   AFSVolSync *a_volSyncP);
typedef int (*fsrename) (const MilkoCred *cred, void *data,
			 struct rx_call *call,
			 const AFSFid *a_origDirFidP,
			 const char *a_origNameP,
			 const AFSFid *a_newDirFidP,
			 const char *a_newNameP,
			 AFSFetchStatus *a_origDirStatusP,
			 AFSFetchStatus *a_newDirStatusP,
			 AFSVolSync *a_volSyncP);

typedef int (*fssymlink) (const MilkoCred *cred, void *data,
			  struct rx_call *call,
			  const AFSFid *parentfid,
			  const char *name,
			  const char *contents,
			  const AFSStoreStatus *storestatus,
			  AFSFid *newfid,
			  AFSFetchStatus *status,
			  AFSFetchStatus *parentstatus,
			  AFSVolSync *volsync);

typedef int (*fslink)(const MilkoCred *cred, void *data, struct rx_call *call,
		      const AFSFid *parentfid,
		      const char *name,
		      const AFSFid *existingfid,
		      AFSFetchStatus *status,
		      AFSFetchStatus *existingstatus,
		      AFSVolSync *volsync);

struct filesystem {
    char *name;
    char *info;

    fsinit    fs_init;
    fsclose   fs_close;

    getstatus fs_getstatus;
    setstatus fs_setstatus;

    getdata   fs_getdata;
    putdata   fs_putdata;

    makedir   fs_makedir;
    removedir fs_removedir;

    createfile fs_createfile;
    fsrename    fs_rename;
    removefile fs_removefile;

    fssymlink fs_symlink;
    fslink    fs_link;

    fetchacl  fs_fetchacl;
    storeacl  fs_storeacl;

    giveupcallback fs_giveupcallback;
} ;

#ifdef FILESYSTEM_READONLY
extern struct filesystem rom_filesystem;
#endif
#ifdef FILESYSTEM_UFS
extern struct filesystem ufs_filesystem;
#endif
#ifdef FILESYSTEM_ONTOP
extern struct filesystem ontop_filesystem;
#endif

#endif
