/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "milko_locl.h"

RCSID("$Id: fhget.c,v 1.2 1998/10/15 13:22:15 lha Exp $");

static int fhopen_working = -1;

void
fhprobe(void)
{
    fhopen_working = k_hasafs(); 
}


int
fhopen (xfs_cache_handle *handle, int flags)
{
    int ret = 0;

    if (fhopen_working) {
	struct ViceIoctl vice_ioctl;
	
	vice_ioctl.in      = (caddr_t)handle;
	vice_ioctl.in_size = sizeof(*handle);
	
	ret = k_pioctl (NULL, VIOC_FHOPEN, &vice_ioctl, flags);
	
	if (!(ret < 0 && errno == EINVAL))
	    return ret;
    }
    if (!ret)
	errno = EOPNOTSUPP;
    return -1;
}

/*
 * get the handle of `filename'
 */

int
fhget (char *filename, xfs_cache_handle *handle)
{
    struct ViceIoctl vice_ioctl;

    if (fhopen_working == -1) {
	errno = EOPNOTSUPP;
	return -1;
    }

    vice_ioctl.out      = (caddr_t)handle;
    vice_ioctl.out_size = sizeof(*handle);

    return k_pioctl (filename, VIOC_FHGET, &vice_ioctl, 0);
}

/*
 * Convert a `xfs_cache_handle' to numbers
 */

struct xfs_fh_arg {
    fsid_t fsid;
    long   fileid;
    long   gen;
};

void
fhtonum(xfs_cache_handle *handle, fsid_t *fs, long *ino, long *gen)
{
    struct xfs_fh_arg *fharg;

    fharg = (struct xfs_fh_arg *) handle;

    if (fs)
	*fs = fharg->fsid;
    if (ino)
	*ino = fharg->fileid;
    if (gen)
	*gen = fharg->gen;
}

void
numtofh(fsid_t fs, long ino, long gen, xfs_cache_handle *handle)
{
    struct xfs_fh_arg *fharg;

    fharg = (struct xfs_fh_arg *) handle;

    fharg->fsid = fs;
    fharg->fileid = ino;
    fharg->gen = gen;
}



