/*
 * Emulate the vax instructions for queue insertion and deletion, somewhat.
 * A std_queue structure is defined here and used by these routines.  These
 * routines use caddr_ts so they can operate on any structure.  The std_queue
 * structure is used rather than proc structures so that when the proc struct
 * changes only process management code breaks.  The ideal solution would be
 * to define a std_queue as a global type which is part of all the structures
 * which are manipulated by these routines.  This would involve considerable
 * effort...
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#ifdef HAVE_CONFIG_H
#include <config.h>
RCSID("$Id: q.c,v 1.7 1998/02/12 01:03:14 assar Exp $") ;
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif
#include <utime.h>

/* Ansified, made more readable, and mayby fixed /lha */

struct std_queue {
	struct std_queue *q_link;
	struct std_queue *q_rlink;
} ;

void lwp_insque(void *elementp, void *quep)
{
    struct std_queue *que = (struct std_queue *) quep ;
    struct std_queue *element = (struct std_queue *) elementp ;

    element->q_link = que->q_link;
    element->q_rlink = que;
    
    que->q_link->q_rlink = element;
    que->q_link = element;
}

void lwp_remque(void *elementp)
{
    struct std_queue *element = (struct std_queue *) elementp ;

    element->q_link->q_rlink = element->q_rlink;
    element->q_rlink->q_link = element->q_link;
    
    element->q_rlink = element->q_link = (struct std_queue *) 0;
}

