#!/bin/sh
#
# make-process.o.sh
#  Try to make process.o various ways.
#
#  $Id: make-process.o.sh.in,v 1.8 1998/12/05 11:56:14 assar Exp $
#

srcdir=.

CC="gcc"
GCC="yes"
CPP="gcc -E"
AS=as
RM=rm
HOST_CPU="i386"
HOST_OS="openbsd2.5"
LN_S="ln -s"

#
# Here is a test to check if we manage to build process.o
#  (use this because some sh doesn't have functions)
#
# $CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
# $RM -f process.o

#
# Options that you may need to override for your CPU/OS
#

PROCESS_S="process.S"
USE_AS="no"
MYDEF=""


#
# Clean out the process.o
#

$RM -f process.o

# 
# Add CPUDEFs that you CPU needs
#

case "$HOST_CPU" in
    sparc) CPUDEF="-Dsparc" ;;
    i*86*) CPUDEF="-DAFS_386i_ENV" ;;
    m68k)  CPUDEF="-Dmc68000" ;;
    mips)  CPUDEF="-Dmips" ;;
    alpha) CPUDEF="-Dalpha" ;;
    hppa*) CPUDEF="" ;;
    powerpc) CPUDEF="-D__powerpc__" ;;
    rs6000) CPUDEF="-DRIOS" ;;
    f301) ;;
    *)  echo "Unknown host_cpu, good luck" ;;
esac 

#
# Add OSDEF your OS need
#

case "$HOST_OS" in 
    *bsd*) OSDEF="-DHAVE_PIC -DAFS_BSD_ENV" ;; 
    *linux*) OSDEF="-DAFS_LINUX_ENV" ;; 
    *dux* | *osf*) OSDEF="-DAFS_OSF_ENV" ;; 
    *solaris*) OSDEF="-DAFS_SUN5_ENV -D_ASM" USE_AS="yes" ;; 
    *irix*) OSDEF="-Dsgi -n32 -DHAVE_PIC"; ASDEF="-n32" ;; 
    *hpux*) OSDEF="-DAFS_HPUX_ENV" PROCESS_S="process.s.hpux" ;; 
    rhapsody*) OSDEF="-DAFS_BSD_ENV" ;; 
    aix*) CPUDEF="-DRIOS"; OSDEF="" ;; 
    uxpv*) 
	$CPP -P ${srcdir}/process-vpp.s > foo.s
	$AS -o process.o foo.s && $RM -f foo.s && exit 0
	$RM -f foo.s
	exit 1
	;;
    *) ;; 
esac 

#
# Now try to do the magic stuff.
#


#
# Can we use $CC to do the asm for us ? (GCC)
#   

if test "$GCC" = "yes" -a "$USE_AS" = "no"; then 
    ${CC} -I../include $MYDEF $CPUDEF $OSDEF -c ${srcdir}/${PROCESS_S} ; 

# process.o there ?
    $CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
    $RM -f process.o
fi

#
# Try to use $AS -P for assably 
#

$AS -P -I../include $MYDEF $CPUDEF $OSDEF ${srcdir}/${PROCESS_S} -o process.o

# process.o there ?
$CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
$RM -f process.o


#
# Some $AS does "intresting" things, like ignorings the -o flag
# and creats a .i file that is preprocessed. (Digital Unix)
#

if test -s process.i ; then
    $AS $ASDEF process.i -o process.o
    $RM -f process.i

    # process.o there ?
    $CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
    $RM -f process.o
fi

#
# Try to use $AS (without -P) for assably 
#

$AS -I../include $MYDEF $CPUDEF $OSDEF ${srcdir}/${PROCESS_S} -o process.o

# process.o there ?
$CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
$RM -f process.o


#
# Some $AS does "intresting" things, like ignorings the -o flag
# and creats a .i file that is preprocessed. (Digital Unix)
#

if test -s process.i ; then
    $AS process.i -o process.o
    $RM -f process.i

    # process.o there ?
    $CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
    $RM -f process.o
fi

#
# Try to fool $CC by adding a .c extension. 
#

$RM -f foo.c && $LN_S ${srcdir}/${PROCESS_S} foo.c 
$CPP -I../include $MYDEF $CPUDEF $OSDEF foo.c > process.ss 
$AS process.ss -o process.o 
$RM -f process.ss

# process.o there ?
$CC -o testprocess testprocess.o process.o preempt.o lwp.o && exit 0
$RM -f process.o

echo "WE HAVE NO process.o !"
exit 1





