/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* $Id: xfs_message.h,v 1.2 1998/12/31 11:04:10 itoi Exp itoi $ */

#ifndef _xmsg_h
#define _xmsg_h

#ifdef NI
#define SCMaxDataLen	4096
#endif /* NI */

#if !defined(__LINUX__) && !defined(HAVE_GLIBC)
#include <sys/types.h>
#include <sys/param.h>
#else
#include <linux/types.h>
#include <linux/param.h>
#endif

#include <xfs_attr.h>
#include "fid.h"

/* Temporary hack? */
#define MAX_XMSG_SIZE (1024*64)

typedef u_int32_t pag_t;

/*
 * The xfs_cred, if pag == 0, use uid 
 */
typedef struct xfs_cred {
    __kernel_uid_t uid;
    pag_t pag;
} xfs_cred;

#define MAXHANDLE (4*4)
#define MAXRIGHTS 8

#define XFS_ANONYMOUSID 32766

#ifndef DIRENT_LEN
#define DIRENT_LEN 1024
#endif /* DIRENT_LEN */

typedef unsigned char xfs_handle [FID_LEN];

#define xfs_handle_eq(p, q) \
     ((*p)[0] == (*q)[0] && (*p)[1] == (*q)[1] && \
      (*p)[2] == (*q)[2] && (*p)[3] == (*q)[3] && \
      (*p)[4] == (*q)[4] && (*p)[5] == (*q)[5] && \
      (*p)[6] == (*q)[6] && (*p)[7] == (*q)[7])

/*
 * This should be the maximum size of any `file handle'
 */

#define CACHEHANDLESIZE 76

typedef struct xfs_cache_handle {
    u_char data[CACHEHANDLESIZE];
} xfs_cache_handle;

/*
 * Tokens that apply to nodes, open modes and attributes. Shared
 * reading might be used for exec and exclusive write for remove.
 */
#define XFS_OPEN_MASK	0x000f
#define XFS_OPEN_NR	0x0001	       /* Normal reading, data might change */
#define XFS_OPEN_SR	0x0002	       /* Shared reading, data won't change */
#define XFS_OPEN_NW	0x0004	       /* Normal writing, multiple writers */
#define XFS_OPEN_EW	0x0008	       /* Exclusive writing (open really) */

#define XFS_ATTR_MASK	0x0030
#define XFS_ATTR_R	0x0010	       /* Attributes valid */
#define XFS_ATTR_W	0x0020	       /* Attributes valid and modifiable */

/*
 * Tokens that apply to node data.
 */
#define XFS_DATA_MASK	0x00c0
#define XFS_DATA_R	0x0040	       /* Data valid */
#define XFS_DATA_W	0x0080	       /* Data valid and modifiable */
#define XFS_LOCK_MASK	0x0300
#define XFS_LOCK_R	0x0100	       /* Data Shared locks? */
#define XFS_LOCK_W	0x0200	       /* Data Exclusive locks? */

#define XFS_ATTR_VALID		XFS_ATTR_R
#define XFS_DATA_VALID		XFS_DATA_W

/* xfs_node.flags */
#define XFS_DATA_DIRTY	0x0001
#define XFS_ATTR_DIRTY	0x0002

/* Are necessary tokens available? */
#define XFS_TOKEN_GOT(xn, tok)		((xn)->tokens & (tok))
#define XFS_TOKEN_SET(xn, tok, mask)	((xn)->tokens |= ((tok) & (mask)))
#define XFS_TOKEN_CLEAR(xn, tok, mask)	((xn)->tokens &= ~((tok) & (mask)))

/* definitions for the rights fields */
#define XFS_RIGHT_R	0x01		/* may read? */
#define XFS_RIGHT_W	0x02		/* may write? */
#define XFS_RIGHT_X	0x04		/* may execute? */

struct xfs_msg_node {
    xfs_handle handle;
    u_int tokens;
    struct xfs_attr attr;
    pag_t id[MAXRIGHTS];
    u_char rights[MAXRIGHTS];
    u_char anonrights;
};

/*
 * Messages passed through the  xfs_dev.
 */
struct xfs_message_header {
  u_int size;
  u_int opcode;
  u_int sequence_num;		/* Private */
};

/*
 * Used by putdata flag
 */
enum { XFS_READ = 1, XFS_WRITE = 2, XFS_NONBLOCK = 4, XFS_APPEND = 8};

/*
 * Flags for inactivenode
 */
enum { XFS_NOREFS = 1, XFS_DELETE = 2 };

/*
 * Flags for installdata
 */

enum { XFS_INVALID_DNLC = 1 };

/*
 * Defined message types and their opcodes.
 */
#define XFS_MSG_VERSION		0
#define XFS_MSG_WAKEUP		1

#define XFS_MSG_GETROOT		2
#define XFS_MSG_INSTALLROOT	3

#define XFS_MSG_GETNODE		4
#define XFS_MSG_INSTALLNODE	5

#define XFS_MSG_GETATTR		6
#define XFS_MSG_INSTALLATTR	7

#define XFS_MSG_GETDATA		8
#define XFS_MSG_INSTALLDATA	9

#define XFS_MSG_INACTIVENODE	10
#define XFS_MSG_INVALIDNODE	11
		/* XXX Must handle dropped/revoked tokens better */

#define XFS_MSG_OPEN		12

#define XFS_MSG_PUTDATA		13
#define XFS_MSG_PUTATTR		14

/* Directory manipulating messages. */
#define XFS_MSG_CREATE		15
#define XFS_MSG_MKDIR		16
#define XFS_MSG_LINK		17
#define XFS_MSG_SYMLINK		18

#define XFS_MSG_REMOVE		19
#define XFS_MSG_RMDIR		20

#define XFS_MSG_RENAME		21

#define XFS_MSG_PIOCTL		22
#define XFS_MSG_WAKEUP_DATA	23
#define XFS_MSG_UPDATEFID	24
#ifdef NI
#define XFS_MSG_MOUNT		25
#define XFS_MSG_READDIR		26
#define XFS_MSG_INSTALLDIRENT	27
#define XFS_MSG_READSC		28
#define XFS_MSG_WRITESC		29
#define XFS_MSG_SETATTR		30
#define XFS_MSG_UNMOUNT		31
#define XFS_MSG_MNTAGAIN	32
#define XFS_MSG_COUNT		33
#else 
#define XFS_MSG_COUNT		25
#endif


/* XFS_MESSAGE_WAKEUP */
struct xfs_message_wakeup {
  struct xfs_message_header header;
  int sleepers_sequence_num;	/* Where to send wakeup */
  int error;			/* Return value */
};

/* XFS_MESSAGE_GETROOT */
struct xfs_message_getroot {
  struct xfs_message_header header;
  struct xfs_cred cred;
};

/* XFS_MESSAGE_INSTALLROOT */
struct xfs_message_installroot {
  struct xfs_message_header header;
  struct xfs_msg_node node;
};

/* XFS_MESSAGE_GETNODE */
struct xfs_message_getnode {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
};

/* XFS_MESSAGE_INSTALLNODE */
struct xfs_message_installnode {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  struct xfs_msg_node node;
  int rec_flag;
};

/* XFS_MESSAGE_GETATTR */
struct xfs_message_getattr {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle handle;
};

/* XFS_MESSAGE_INSTALLATTR */
struct xfs_message_installattr {
  struct xfs_message_header header;
  struct xfs_msg_node node;
};

/* XFS_MESSAGE_GETDATA */
struct xfs_message_getdata {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle handle;
  u_int tokens;
};

/* XFS_MESSAGE_INSTALLDATA */
struct xfs_message_installdata {
  struct xfs_message_header header;
  struct xfs_msg_node node;
  struct xfs_cache_handle cache_handle;
  char cache_name[256];         /* XXX */
  u_int flag;
#ifdef NI
  char data[SCMaxDataLen];
  u_int size;
  unsigned char *buf;
  u_int *sc_error;
  u_int *sc_length;
  u_int tmp_error;
#endif
};

/* XFS_MSG_INACTIVENODE */
struct xfs_message_inactivenode {
  struct xfs_message_header header;
  xfs_handle handle;
  u_int flag;
};

/* XFS_MSG_INVALIDNODE */
struct xfs_message_invalidnode {
  struct xfs_message_header header;
  xfs_handle handle;
};

/* XFS_MSG_OPEN */
struct xfs_message_open {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle handle;
  u_int tokens;
};

/* XFS_MSG_PUTDATA */
struct xfs_message_putdata {
  struct xfs_message_header header;
  xfs_handle handle;
  struct xfs_attr attr;		/* XXX ??? */
  struct xfs_cred cred;
  u_int flag;
};

/* XFS_MSG_PUTATTR */
struct xfs_message_putattr {
  struct xfs_message_header header;
  xfs_handle handle;
  struct xfs_attr attr;
  struct xfs_cred cred;
};

/* XFS_MSG_CREATE */
struct xfs_message_create {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  struct xfs_attr attr;
  int mode;
  struct xfs_cred cred;
};

/* XFS_MSG_MKDIR */
struct xfs_message_mkdir {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  struct xfs_attr attr;
  struct xfs_cred cred;
};

/* XFS_MSG_LINK */
struct xfs_message_link {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  xfs_handle from_handle;
  struct xfs_cred cred;
};

/* XFS_MSG_SYMLINK */
struct xfs_message_symlink {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  char contents[2048];		/* XXX */
  struct xfs_attr attr;
  struct xfs_cred cred;
};

/* XFS_MSG_REMOVE */
struct xfs_message_remove {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  struct xfs_cred cred;
};

/* XFS_MSG_RMDIR */
struct xfs_message_rmdir {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  char name[256];		/* XXX */
  struct xfs_cred cred;
};

/* XFS_MSG_RENAME */
struct xfs_message_rename {
  struct xfs_message_header header;
  xfs_handle old_parent_handle;
  char old_name[256];		/* XXX */
  xfs_handle new_parent_handle;
  char new_name[256];		/* XXX */
  struct xfs_cred cred;
  dev_t t_dev; /* controlling terminal for PIN input */
};

/* XFS_MSG_PIOCTL */
struct xfs_message_pioctl {
  struct xfs_message_header header;
  int opcode ;
  xfs_cred cred;
  int insize;
  int outsize;
  char msg[2048] ;    /* XXX */
  xfs_handle handle;
};


/* XFS_MESSAGE_WAKEUP_DATA */
struct xfs_message_wakeup_data {
  struct xfs_message_header header;
  int sleepers_sequence_num;	/* Where to send wakeup */
  int error;			/* Return value */
  int len;
  char msg[2048] ;    /* XXX */
};

/* XFS_MESSAGE_UPDATEFID */
struct xfs_message_updatefid {
  struct xfs_message_header header;
  xfs_handle old_handle;
  xfs_handle new_handle;
};

#ifdef NI
/* XFS_MSG_MOUNT */
struct xfs_message_mount {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle handle;
  u_int tokens;
};

/* XFS_MSG_READDIR */
struct xfs_message_readdir {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle fid;
  char *buf;
  u_int *sc_error;
  u_int tmp_error;
  xfs_handle parent_fid;
};

/* XFS_MESSAGE_INSTALLDIRENT */
struct xfs_message_installdirent {
  struct xfs_message_header header;
  struct xfs_msg_node node;
  struct xfs_cache_handle cache_handle;
  char data[DIRENT_LEN];
  char *buf;
  u_int *sc_error;
  u_int tmp_error;
};

/* XFS_MSG_READSC */
struct xfs_message_readsc {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle fid;
  /*u_int tokens;*/
  u_int size;
  u_int offset;
  char *buf;
  u_int *sc_error;
  u_int *sc_length;
  u_int tmp_error;
  dev_t t_dev; /* controlling terminal for PIN input */
  /* for record file */
  u_int rec_flag;
  xfs_handle parent_fid;
};

/* XFS_MSG_WRITESC */
struct xfs_message_writesc {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle fid;
  /*u_int tokens;*/
  u_int size;
  u_int offset;
  char data[SCMaxDataLen];
  dev_t t_dev; /* controlling terminal for PIN input */
  /* for record file */
  u_int rec_flag;
  xfs_handle parent_fid;
};

/* XFS_MSG_SETATTR */
struct xfs_message_setattr {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle fid;
  xfs_handle parent_fid;
  u_int tokens;
  struct xfs_attr attr;
};

/* XFS_MSG_UNMOUNT */
struct xfs_message_unmount {
  struct xfs_message_header header;
  struct xfs_cred cred;
  xfs_handle handle;
  u_int tokens;
};

/* XFS_MESSAGE_MNTAGAIN */
struct xfs_message_mntagain {
  struct xfs_message_header header;
  xfs_handle parent_handle;
  struct xfs_msg_node node;
  int rec_flag;
};

#endif /* NI */
#endif /* _xmsg_h */
