
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#ifndef __SCFS_PIOCTL_H
#define __SCFS_PIOCTL_H

/*#include "scfs.h"*/
/*#include <stdio.h>*/

#define SCFS_CREAT		_VICEIOCTL(57)
#define SCFS_VERIFYKEY		_VICEIOCTL(58)
#define SCFS_CREATE_DIR		_VICEIOCTL(59)
#define MAX_SCFS_PATH		30
#define MAX_KEY_LENGTH		8
#define ACL_LEN			3

#include "xfs_message.h"
#include "scfs.h"

/* data structures */
/* SCFS_CREAT */
struct scfs_creat_arg
{
  char path[MAX_SCFS_PATH];
  char acl[ACL_LEN];
  int size;
};

/* SCFS_VERIFYKEY */
struct scfs_verifykey_arg
{
  int keynum;
  int keysize; 
  char key[MAX_KEY_LENGTH];
};

/* forward declarations */
int scfs_verifykey(int kernel_fd, struct xfs_message_pioctl *h, u_int size);
int scfs_creat(struct scfs_creat_arg *ca, unsigned char *parent_handle);
int scfs_create_dir(int kernel_fd, struct xfs_message_pioctl *h, u_int size);
int scfs_create_sub(struct scfs_creat_arg *ca, struct scdnode *parent_node);

#endif /* __SCFS_PIOCTL_H */
