
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/*
    scfs.h
    Included in scfs.c
    NI, 5/29, 1998
*/

#ifndef _SCFS_H_
#define _SCFS_H_

#ifndef KERNEL
#include <stdio.h>
#include <unistd.h>
#include "arla_local.h"
#endif /* KERNEL */

#include "fid.h"

/* Constants */
/* for all */
#define DIRENT_LEN 1024

#define SCFS_IS_NOT_RECORD	0
#define SCFS_IS_RECORD		1

#define DIRENT_FILE0		0x2e
#define DIRENT_FILE1		0x69

#define MaxPINLen  8

/* Constants */
/* for mount */
#define	SCFSMNT_MNTAGAIN 1  /* mount the filesystem after unmounting it */
#define FLAG_NOT_MOUNTED 0
#define FLAG_MOUNTED 1

/* for scfs_init(), scfs_mount() */
#define FILE_OPEN		 1
#define NO_FILE_OPEN		 0

/* for scfs.c */
#define FILE_NAME_LEN	2
#define MaxNumChildren	4 /* 4 children per directory */
#define NI_ALLVALID	XA_V_MODE | XA_V_NLINK | XA_V_SIZE | XA_V_UID | XA_V_GID | XA_V_ATIME | XA_V_MTIME | XA_V_CTIME | XA_V_FILEID | XA_V_TYPE
#define SCMaxRWLen 0xff
     
/* for scdir.c */
#define SCFS_TYPE_NULL		0
#define SCFS_TYPE_ELFILE	1
#define SCFS_TYPE_RECFILE	2
#define SCFS_TYPE_DIR		3
#define Separator		".,:; \t\n\0"
#define MaxNumScdNodes		64
#define MaxDepth		5
#define STR_ATR			"ATR"
#define STR_CARDNAME		"CARDNAME"
#define STR_MULTIFLEXPIN	"MULTIFLEXPIN"
#define STR_MULTIFLEXGETRES	"MULTIFLEXGETRES"
#define STR_DIR			"DIR"
#define STR_DEFAULT		"CLA_DEFAULT"
#define STR_VERIFYKEY		"CLA_VERIFYKEY"
#define STR_VERIFYPIN		"CLA_VERIFYPIN"
#define STR_READBINARY		"CLA_READBINARY"
#define STR_UPDATEBINARY	"CLA_UPDATEBINARY"
#define STR_CREATE		"CLA_CREATE"
#define STR_DELETEFILE		"CLA_DELETEFILE"
#define STR_READRECORD		"CLA_READRECORD"
#define STR_UPDATERECORD	"CLA_UPDATERECORD"
#define STR_SELECT		"SELECT"
#define STR_INAUTH		"INAUTH"
#define STR_EXAUTH		"EXAUTH"
#define STR_GETRESPONSE		"GETRESPONSE"
#define STR_GETCHALLENGE	"GETCHALLENGE"
#define STR_HASRECORD		"HASRECORD"
#define STR_CREATETYPE		"CREATE_TYPE"
#define CLA_NOSUPP		-1
#define CLA_UNDEFINED		-2
#define SCDFILE		"/usr/scfs/etc/scfs.scdb"
#define CREATE_TYPE_MULTIFLEX	0
#define CREATE_TYPE_CYBERFLEXACCESS	1

struct fileent {
  unsigned char fid[FID_LEN]; /* file number of entry */
  u_int8_t  d_type;	      /* file type, follow UNIX */
			      /* SCFS_TYPE_NULL		0
				 SCFS_TYPE_ELFILE	1
				 SCFS_TYPE_RECFILE	2
				 SCFS_TYPE_DIR	3 */
  u_int16_t p_size;	      /* physical length of the file */
  u_int16_t l_size;	      /* logical length of the file */
  u_int16_t data;	      /* reserved */
};

struct scfs_response {
  int size;
  int read_PIN_protected;
  int write_PIN_protected;
};

struct scdnode {
  struct fileent fileent;
  struct scdnode *parent;
  struct scdnode *child[MaxNumChildren + 1]; /* +1 for .i */
  int num_children;
};

/* Smartcard configuration data structure */
struct scconfig {
  char name[256];	/* name, e.g. "MultiFlex" or "PayFlex" */
  int multiflexpin;	/* 1 if it has MultiFlex type PIN.  0 otherwise */
  int multiflexgetres;	/* 1 if it has MultiFlex type getresponse.  0 otherwise */
  struct scdnode *scdnodes[MaxNumScdNodes];	/* pointer to a directory structure */
  int cla_default;	/* 1 byte CLA code */
  int cla_verifykey;
  /* 1 byte CLA, -1 if not supported, or -2 if undefined */
  int cla_verifypin;    /* same as cla_verifykey */
  int cla_select;	/* same as cla_verifykey */
  int cla_readbinary;	/* same as cla_verifykey */
  int cla_updatebinary; /* same as cla_verifykey */
  int cla_create;	/* same as cla_verifykey */
  int cla_deletefile;	/* same as cla_verifykey */
  int cla_remove;	/* same as cla_verifykey */	
  int cla_readrecord;	/* same as cla_verifykey */
  int cla_updaterecord; /* same as cla_verifykey */
  int cla_inauth;	/* same as cla_verifykey */
  int cla_exauth;	/* same as cla_verifykey */
  int cla_getresponse;	/* same as cla_verifykey */
  int cla_getchallenge;	/* same as cla_verifykey */
  int num_nodes;
  int create_type;
};

/* Function Prototypes */
/* from scfs.c */
int scfs_init(int port, int flag); 
//void dump_reply(char *p, int n);
int scfs_mount (int port, char *buf, int flag);
int scfs_unmount ();
int scfs_open_file();
int open_file(int fd, int f0, int f1);
int a2h(char c, char d, unsigned char *f);
int scfs_read(unsigned char *fid, int offset, int length, unsigned char *buf, int rec_flag, unsigned char *parent_fid, dev_t t_dev);
int scfs_write(unsigned char *fid, int offset, int length, char *buf, int rec_flag, unsigned char *parent_fid, dev_t t_dev);
int scfs_remove(xfs_handle parent_fid, char *name);
int scfs_rmdir(xfs_handle parent_fid, char *name);
int scfs_rename(xfs_handle old_parent_fid, char *old_name,
		xfs_handle new_parent_fid, char *new_name,
		dev_t t_dev);
int name_to_fid(xfs_handle parent_fid, char *name, xfs_handle *child_fid);
int scfs_update_dirent(struct scdnode *node);
int scfs_add_dirent(struct scdnode *parent_node, struct scdnode *new_node);
int find_child_in_parent(struct scdnode *parent_node, struct scdnode *child_node);
int update_ith_dirent(struct scdnode *parent_node, int ith, struct fileent *fe);
int remove_node(struct scdnode *parent_node, unsigned char *child_fid);
int scfs_verifypin(int insize, char *pin);
/*int scfs_verifykey(int keynum, int insize, char *pin);*/
int scfs_verifykey(int fd, struct xfs_message_pioctl *h, u_int size);
int scfs_inauth(int keynum, int insize, char *pin);
int scfs_getresponse(char *str, int outsize);
int scfs_exauth(int keynum, int insize, char *response);
int scfs_getchallenge(char *str, int outsize);
int scfs_tcl_readpin(char *pin);
int scfs_query_file(struct scfs_response *scfs_res, struct scdnode *node);
int godown(struct scdnode *node);

/* from scdir.c */
int scdir_init(unsigned char *atr, char *filename);
struct scdnode *get_scdnode(unsigned char *);
struct scdnode *new_scdnode(struct fileent *fe, struct scdnode *parent);
void print_path (struct scdnode *);
int name2fid (char *name, unsigned char *fid, int *recnum);
int scfs_getdirent(unsigned char *fid, unsigned char *parent_fid, char *dirent);
#ifndef KERNEL
int config_smartcard(FILE *fd, int *line);
#endif /* KERNEL */
void scconfig_setdefault(struct scconfig *scc);
int isyes(char *str);
void print_scconfig(struct scconfig *scc);
int scdir_installroot();
int new_dir(struct scdnode *node);
int scdir_free();
int free_dir(struct scdnode *node);
struct scdnode *add_node(struct scdnode *parent_node, char *file_name, int type, int size);
/* from ttyname.c */
char *scfs_ttyname(dev_t t_dev);

/* from scpin.c */
char *getpin(const char *termname, const char *prompt);

#endif /* _SCFS_H_ */
