
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* FID related Macros and Constants */
#ifndef _FID_H
#define _FID_H

#define FID_LEN 8
#define fidcpy(x, y) {\
  x[0] = y[0]; x[1] = y[1]; x[2] = y[2]; x[3] = y[3];\
						       x[4] = y[4]; x[5] = y[5]; x[6] = y[6]; x[7] = y[7];}
#define fidlet(x, y0, y1, y2, y3, y4, y5, y6, y7) {\
  x[0] = y0; x[1] = y1; x[2] = y2; x[3] = y3;\
					       x[4] = y4; x[5] = y5; x[6] = y6; x[7] = y7;}
#define fideq(x, y0, y1, y2, y3, y4, y5, y6, y7)\
(x[0] == y0 && x[1] == y1 &&\
 x[2] == y2 && x[3] == y3 &&\
 x[4] == y4 && x[5] == y5 &&\
 x[6] == y6 && x[7] == y7)
#define fidcmp(x, y)\
(x[0] == y[0] && x[1] == y[1] &&\
 x[2] == y[2] && x[3] == y[3] &&\
 x[4] == y[4] && x[5] == y[5] &&\
 x[6] == y[6] && x[7] == y[7])
#define fid2inode(x) (x[0] << (8*3)) + (x[1] << (8*2)) + (x[2] << (8*1)) + (x[3] << (8*0));

#endif /* _FID_H */
