
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/*
    scpio.c
    Pioctls for scfs
    NI, 1/5, 1999
*/

#include "scfs.h"
#include "scrw.h"
#include "scfs_pioctl.h"

extern struct scconfig scconfig;
extern int fd; /* fd to talk to a smartcard */
extern struct scdnode *root_node; /* in scdir.c */

int scfs_creat(struct scfs_creat_arg *ca, unsigned char *parent_fid)
{
  int rv; 
  struct scdnode *parent_node;

  /*arla_warnx (ADEBMSG, "scfs_create parent_fid %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x, data %s, size %d.",
	      parent_fid[0], parent_fid[1], parent_fid[2], parent_fid[3],
	      parent_fid[4], parent_fid[5], parent_fid[6], parent_fid[7], 
	      ca->path, ca->size);*/

  /* get parent node */
  if ((parent_node = get_scdnode(parent_fid)) == NULL) {
    arla_warnx (ADEBERROR, "scfs_creat: cannot find %02x.%02x",
		parent_fid[0], parent_fid[1]);
    return ENOENT;
  }

  if ((rv = scfs_create_sub(ca, parent_node))) return rv;

  return 0; 
}

int scfs_create_sub(struct scfs_creat_arg *ca, struct scdnode *parent_node)
{
  char buf[18];
  unsigned char *parent_fid = parent_node->fileent.fid;
  int sw1, sw2, rv;
  struct scdnode *new_node;
  
  /* does the parent have room? */
  
  if (parent_node->num_children >= MaxNumChildren + 1){
    arla_warnx (ADEBERROR, "scfs_creat: %02x.%02x already has maximum %d files.",parent_fid[0], parent_fid[1], parent_node->num_children);
    arla_warnx(ADEBMSG, "scfs_create: root's #children=%d",
	       root_node->num_children);
    return ENOTTY;
  }

  /* select the parent */
  if (godown(parent_node) == -1) return ENOENT;

  /* create the file */
  if (scconfig.create_type == CREATE_TYPE_MULTIFLEX){
    buf[0] = (char)0xff; /* unused */
    buf[1] = (char)0xff; /* unused */
    buf[2] = (char)(ca->size >> 8) & 0xff; /* file size */
    buf[3] = (char)ca->size & 0xff;
    buf[4] = (char)ca->path[0]; /* fid */
    buf[5] = (char)ca->path[1];
    buf[6] = (char)0x01; /* type, transparent file = 1 */
    buf[7] = (char)0xff; /* unused */
    buf[8] = (char)ca->acl[0];
    buf[9] = (char)ca->acl[1];
    buf[10] = (char)ca->acl[2];
    buf[11] = (char)0x01; /* status, currently unblocked */
    buf[12] = (char)0x05; /* 5 byte data follows */
    buf[13] = (char)0x03; /* ? */
    buf[14] = (char)0x00; /* ? */
    buf[15] = (char)0x00; /* ? */
    buf[16] = (char)0x02; /* ? */
    buf[17] = (char)0x00; /* ? */

    rv = scwrite(fd, scconfig.cla_create, 0xe0,
		 0x00, 0x00, 0x12,
		 buf, &sw1, &sw2);
  }
  else if (scconfig.create_type == CREATE_TYPE_CYBERFLEXACCESS){
    /*printf("CREATE - Cyberflex Access \n");*/
    buf[0] = (char)(ca->size >> 8) & 0xff; /* file size */
    buf[1] = (char)ca->size & 0xff;
    buf[2] = (char)ca->path[0]; /* fid */
    buf[3] = (char)ca->path[1];
    buf[4] = (char)0x02; /* type, transparent file = 2 */
    buf[5] = (char)0x01; /* status */
    buf[6] = (char)0x00; /* ACL */
    buf[7] = (char)0x00;
    buf[8] = (char)0xff;
    buf[9] = (char)0x00;
    buf[10] = (char)0x00;
    buf[11] = (char)0x00;
    buf[12] = (char)0x00;
    buf[13] = (char)0x00;
    buf[14] = (char)0x00;
    buf[15] = (char)0x00;

    rv = scwrite(fd, scconfig.cla_create, 0xe0,
		 0x00, 0x00, 0x10,
		 buf, &sw1, &sw2);
  } else {
    arla_warnx(ADEBERROR, "CREATE - CARD NOT SUPPORTED \n");
    return EIO;
  }
  
  if (sw1 == 0x69 || sw2 == 0x82) {
    return EACCES;
  }
  if (rv == -1 || sw1 != 0x90 || sw2 != 0x00) {
    arla_warnx (ADEBERROR, "create error.  smartcard returns 0x%x 0x%x", sw1, sw2);
    return EIO;
  }

  /* add a file entry for the new file in the scfs database */
  if (!(new_node = add_node(parent_node, ca->path, SCFS_TYPE_ELFILE, ca->size))){
    arla_warnx (ADEBERROR, "create error.  add_node failed.");
    return EIO;
  }
  
  /* write it to a smartcard */
  if ((rv = scfs_add_dirent(parent_node, new_node))) {
    arla_warnx (ADEBERROR, "create error.  scfs_add_dirent failed.");
    return rv;
  }
  parent_node->num_children++;
  
  return 0; 
}

int scfs_verifykey(int kernel_fd, struct xfs_message_pioctl *h, u_int size)
     /*int scfs_verifykey(int keynum, int insize, char *key)*/
{
  int len, sw1, sw2;
  struct scfs_verifykey_arg *arg;
  
  arg = (struct scfs_verifykey_arg *)h->msg;

  /*arla_warnx (ADEBERROR, "verify KEY keynum %d, keylen %d, key %02x %02x %02x %02x %02x %02x %02x %02x\n",
	      arg->keynum, arg->keysize,
	      arg->key[0], arg->key[1], arg->key[2], arg->key[3],
	      arg->key[4], arg->key[5], arg->key[6], arg->key[7]);*/
  if (scconfig.cla_verifykey == CLA_NOSUPP) {
    arla_warnx (ADEBERROR, "verify KEY APDU is not supported in this smartcard.");
    return EINVAL;
  }

  len = scwrite(fd, scconfig.cla_verifykey, 0x2a, 0, arg->keynum,
    arg->keysize, arg->key, &sw1, &sw2);

  /*arla_warnx (ADEBERROR, "verifikey: smartcard returns 0x%x 0x%x", sw1, sw2);*/
  if (sw1 == 144 && sw2 == 0) {
    return 0;
  }
  else {
    arla_warnx (ADEBERROR, "verify KEY -> scwrite returns len %d %02x %02x", len, sw1, sw2);
    return EINVAL;
  }
  
  return 0;
}

/* Add a file entry for a file file_name in a directory parent_fid. */
/* make node */

struct scdnode *add_node(struct scdnode *parent_node, char *file_name, int type, int size)
{
  struct fileent fe;
  struct scdnode *new_node;
  char *parent_fid = parent_node->fileent.fid;
  int i; 

  /* set fid */
  fe.fid[0] = file_name[0];
  fe.fid[1] = file_name[1];
  for (i=0; i<FID_LEN-2; i++) fe.fid[i+2] = parent_fid[i];
  fe.d_type = type;
  fe.p_size = size;
  if (type == SCFS_TYPE_DIR) fe.l_size = size;
  else fe.l_size = 0; 
  fe.data = 0;
  if (!(new_node = new_scdnode(&fe, parent_node))) return NULL;
  parent_node->child[parent_node->num_children] = new_node;
  
  return new_node;
}

/* create DF
   writte by Naomaru Itoi, 1/12/1998 */

int scfs_create_dir(int kernel_fd, struct xfs_message_pioctl *h, u_int size)
{
  struct scfs_creat_arg *ca; /* create arg */
  struct scdnode *parent_node, *new_node;
  unsigned char *parent_fid;
  char buf[64];
  int rv, sw1, sw2, i;
  struct fileent fe_doti; /* fe for .i */
  
  /*memcpy(&ca, h->msg, sizeof(ca));*/
  ca = (struct scfs_creat_arg *)h->msg;
  parent_fid = h->handle;
  /*arla_warnx (ADEBMSG, "scfs_create parent_fid %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x, data %s, size %d.",
	      parent_fid[0], parent_fid[1], parent_fid[2], parent_fid[3],
	      parent_fid[4], parent_fid[5], parent_fid[6], parent_fid[7], 
	      ca->path, ca->size);*/

  /* get parent node */
  if ((parent_node = get_scdnode(parent_fid)) == NULL) {
    arla_warnx (ADEBERROR, "scfs_creat: cannot find %02x.%02x",
		parent_fid[0], parent_fid[1]);
    return ENOENT;
  }
  
  /* does the parent have room? */
  if (parent_node->num_children >= MaxNumChildren + 1){
    arla_warnx (ADEBERROR, "scfs_creat: %02x.%02x already has maximum %d files.",parent_fid[0], parent_fid[1], parent_node->num_children);
    return ENOTTY;
  }

  /* select the parent */
  if (godown(parent_node) == -1) return ENOENT;

  /* create the file */
  if (scconfig.create_type == CREATE_TYPE_MULTIFLEX){
    buf[0] = (char)0xff; /* unused */
    buf[1] = (char)0xff; /* unused */
    buf[2] = (char)(ca->size >> 8) & 0xff; /* file size */
    buf[3] = (char)ca->size & 0xff;
    buf[4] = (char)ca->path[0]; /* fid */
    buf[5] = (char)ca->path[1];
    buf[6] = (char)0x38; /* type, directory file = 0x38 */
    buf[7] = (char)0xff; /* unused */
    buf[8] = (char)0x0; /* no access control */
    buf[9] = (char)0x0;
    buf[10] = (char)0x0;
    buf[11] = (char)0x01; /* status, currently unblocked */
    buf[12] = (char)0x05; /* 5 byte data follows */
    buf[13] = (char)0x03; /* ? */
    buf[14] = (char)0x00; /* ? */
    buf[15] = (char)0x00; /* ? */
    buf[16] = (char)0x02; /* ? */
    buf[17] = (char)0x00; /* ? */
	  
    rv = scwrite(fd, scconfig.cla_create, 0xe0,
		 0x00, 0x00, 0x12,
		 buf, &sw1, &sw2);
  }
  else if (scconfig.create_type == CREATE_TYPE_CYBERFLEXACCESS){
    /*printf("CREATE - Cyberflex Access \n");*/
    buf[0] = (char)(ca->size >> 8) & 0xff; /* file size */
    buf[1] = (char)ca->size & 0xff;
    buf[2] = (char)ca->path[0]; /* fid */
    buf[3] = (char)ca->path[1];
    buf[4] = (char)0x20; /* type, transparent file = 2 */
    buf[5] = (char)0x01; /* status */
    buf[6] = (char)0x00; /* ACL */
    buf[7] = (char)0x00;
    buf[8] = (char)0xff;
    buf[9] = (char)0x00;
    buf[10] = (char)0x00;
    buf[11] = (char)0x00;
    buf[12] = (char)0x00;
    buf[13] = (char)0x00;
    buf[14] = (char)0x00;
    buf[15] = (char)0x00;
    
    rv = scwrite(fd, scconfig.cla_create, 0xe0,
		 0x00, 0x00, 0x10,
		 buf, &sw1, &sw2);
  } else {
    arla_warnx(ADEBERROR, "CREATE - CARD NOT SUPPORTED \n");
    return EIO;
  }
    
  if (sw1 == 0x69 || sw2 == 0x82) {
    return EACCES;
  }
  if (rv == -1 || sw1 != 0x90 || sw2 != 0x00) {
    arla_warnx (ADEBERROR, "create_dir error.  smartcard returns 0x%x 0x%x", sw1, sw2);
    return EIO;
  }
  /*arla_warnx (ADEBMSG, "create_dir succeeded!!! :) %02x %02x", sw1, sw2);*/

  /* Now create meta data */
  if (open_file(fd, (char)ca->path[0], (char)ca->path[1]) != 0) {
    arla_warnx (ADEBERROR, "Cannot open directory entry %02x.%02x??",
		(char)ca->path[0], (char)ca->path[1]);
    return EIO;
  }

  if (scconfig.create_type == CREATE_TYPE_MULTIFLEX){
    buf[0] = (char)0xff; /* unused */
    buf[1] = (char)0xff; /* unused */
    buf[2] = (char)0x00; /* file size */
    buf[3] = (char)(sizeof(struct fileent) * MaxNumChildren); /* file size */
    buf[4] = DIRENT_FILE0; /* fid */
    buf[5] = DIRENT_FILE1;
    buf[6] = (char)0x01; /* type, transparent file = 1 */
    buf[7] = (char)0xff; /* unused */
    buf[8] = (char)0x0; /* no access control */
    buf[9] = (char)0x0;
    buf[10] = (char)0x0;
    buf[11] = (char)0x01; /* status, currently unblocked */
    buf[12] = (char)0x05; /* 5 byte data follows */
    buf[13] = (char)0x03; /* ? */
    buf[14] = (char)0x00; /* ? */
    buf[15] = (char)0x00; /* ? */
    buf[16] = (char)0x02; /* ? */
    buf[17] = (char)0x00; /* ? */

    rv = scwrite(fd, scconfig.cla_create, 0xe0, 0x00, 0x00, 0x12,
		 buf, &sw1, &sw2);
  } else if (scconfig.create_type == CREATE_TYPE_CYBERFLEXACCESS){
    /*printf("CREATE - Cyberflex Access \n");*/
    buf[0] = (char)0x00; /* file size */
    buf[1] = (char)(sizeof(struct fileent) * MaxNumChildren) + 0x10; /* file size */
    buf[2] = DIRENT_FILE0; /* fid */
    buf[3] = DIRENT_FILE1; 
    buf[4] = (char)0x02; /* type, transparent file = 2 */
    buf[5] = (char)0x01; /* status */
    buf[6] = (char)0x00; /* ACL */
    buf[7] = (char)0x00;
    buf[8] = (char)0xff;
    buf[9] = (char)0x00;
    buf[10] = (char)0x00;
    buf[11] = (char)0x00;
    buf[12] = (char)0x00;
    buf[13] = (char)0x00;
    buf[14] = (char)0x00;
    buf[15] = (char)0x00;

    rv = scwrite(fd, scconfig.cla_create, 0xe0,
		 0x00, 0x00, 0x10,
		 buf, &sw1, &sw2);
  } else {
    arla_warnx (ADEBERROR, "CREATE - CARD NOT SUPPORTED \n");
    return EIO;
  }

  if (sw1 == 0x69 || sw2 == 0x82) {
    return EACCES;
  }
  if (rv == -1 || sw1 != 0x90 || sw2 != 0x00) {
    arla_warnx (ADEBERROR, "create_dir error.  cannot create meta data?  smartcard returns 0x%x 0x%x", sw1, sw2);
    return EIO;
  }

  /* fill zero in .i */
  if (scconfig.create_type == CREATE_TYPE_CYBERFLEXACCESS){
    if ((rv = open_file(fd, DIRENT_FILE0, DIRENT_FILE1)) < 0) {
      arla_warnx(ADEBERROR, "cannot select .i?\n");
      return EIO;
    }
    for (i=0; i<sizeof(struct fileent) * MaxNumChildren; i++)
      buf[i] = 0x0; 
    rv = scwrite(fd, scconfig.cla_updatebinary, 0xd6,
		 0x0, 0x0,
		 (unsigned char)(sizeof(struct fileent) * MaxNumChildren),
		 buf, &sw1, &sw2);
  }

  /* add a file entry for the new file in the scfs database */
  if (!(new_node = add_node(parent_node, ca->path, SCFS_TYPE_DIR, ca->size)))
    return EIO;
  /* write it to a smartcard */
  if ((rv = scfs_add_dirent(parent_node, new_node))) return rv;

  parent_node->num_children++;

  /* create an entry for .i */
  fe_doti.fid[0] = DIRENT_FILE0;
  fe_doti.fid[1] = DIRENT_FILE1;
  for (i=0; i<FID_LEN-2; i++) {
    fe_doti.fid[i+2] = new_node->fileent.fid[i];
  }
  fe_doti.d_type = SCFS_TYPE_ELFILE;
  fe_doti.p_size = 0x40;
  fe_doti.l_size = 0x40;
  new_node->child[0] = new_scdnode(&fe_doti, new_node);
  new_node->num_children = 1;
  
  return 0;

}
