/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "arla_local.h"
RCSID("$Id: irix-subr.c,v 1.14 1998/11/10 04:08:40 assar Exp $");

static long blocksize = 1024;	/* XXX */

struct args {
     int fd;
     off_t off;
     char *buf;
     char *ptr;
     struct dirent64 *last;
};

static void
flushbuf (struct args *args)
{
     unsigned inc = blocksize - (args->ptr - args->buf);

     args->last->d_reclen += inc;
     args->last->d_off    += inc;
     if (write (args->fd, args->buf, blocksize) != blocksize)
	  arla_warn (ADEBWARN, errno, "write");
     args->ptr = args->buf;
     args->last = NULL;
}

static void
write_dirent(VenusFid *fid, const char *name, void *arg)
{
     struct dirent64 dirent, *real;
     struct args *args = (struct args *)arg;
     size_t namelen = strlen (name);

     dirent.d_reclen = DIRENT64SIZE(namelen);

     if (args->ptr + dirent.d_reclen > args->buf + blocksize)
	  flushbuf (args);
     real = (struct dirent64 *)args->ptr;

     real->d_reclen = dirent.d_reclen;
     real->d_ino = afsfid2inode (fid);
     strcpy (real->d_name, name);
     args->ptr += real->d_reclen;
     args->off += real->d_reclen;
     real->d_off = args->off;
     args->last = real;
}

Result
conv_dir (FCacheEntry *e, CredCacheEntry *ce, u_int tokens,
	  xfs_cache_handle *cache_handle,
	  char *cache_name, size_t cache_name_sz)
{
     struct args args;
     Result res;

     e->flags.extradirp = TRUE;
     fcache_extra_file_name (e, cache_name, cache_name_sz);
     res.tokens = e->tokens |= XFS_DATA_R | XFS_OPEN_NR;

     args.fd = open (cache_name, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666);
     if (args.fd == -1) {
	  arla_warn (ADEBWARN, errno, "open %s", cache_name);
	  res.res = -1;
	  res.error = errno;
	  return res;
     }
     fcache_fhget (cache_name, cache_handle);

     args.off  = 0;
     args.buf  = (char *)malloc (blocksize);
     if (args.buf == NULL) {
	 arla_warn (ADEBWARN, errno, "malloc %u", blocksize);
	 res.res = -1;
	 res.error = errno;
	 close (args.fd);
	 return res;
     }
     args.ptr  = args.buf;
     args.last = NULL;
     ReleaseWriteLock (&e->lock);
     adir_readdir (e->fid, write_dirent, (void *)&args, ce);
     ObtainWriteLock (&e->lock);
     if (args.last)
	  flushbuf (&args);
     free (args.buf);
     if (res.res = close (args.fd))
	  res.error = errno;
     return res;
}
