
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* $Id: darla.h,v 1.2 1998/12/06 17:04:40 assar Exp $ */

#ifndef _DARLA_H
#define _DARLA_H

#include <lock.h>

typedef struct _DARLA_file {
	int	fd;	/*file descriptor of the current file */
	long 	offset; /*current byte offset */
	struct  Lock 	bs_lock; /*lock to synchronize access */
	long 	log_entries;	/*number of entries  */
} DARLA_file;

int DARLA_Open(DARLA_file *Dfp, char *fname, int oflag);
int DARLA_Close(DARLA_file *Dfp);
int DARLA_Read(DARLA_file *Dfp, char *cp, int len);
int DARLA_Write(DARLA_file *Dfp, char *cp, int len);
int DARLA_Seek(DARLA_file *Dfp, int offset, int whence);

#endif /* _DARLA_H */
