
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#include "arla_local.h"

RCSID("$Id: darla.c,v 1.4 1998/12/06 17:05:13 assar Exp $");

int DARLA_Open(DARLA_file *Dfp, char *fname, int oflag)
{

  int fd;

  fd = open(fname, oflag);
  arla_log(ADEBMISC, "DARLA_Open: errno=%d\n", errno); 
  if (fd > 0)
  {
    Dfp->fd = fd;
    Dfp->offset=0;
    Dfp->log_entries = 0;
  }

  return fd;
}

int DARLA_Close(DARLA_file *Dfp)
{
  int ret;
  
  ret = close(Dfp->fd);
  Dfp->fd = 0;
  Dfp->offset =0;
  arla_log(ADEBMISC, "DARLA_Close: ret=%d\n", ret);
  return ret;
}

int DARLA_Read(DARLA_file *Dfp, char *cp, int len)
{
  ssize_t read_size;
  
  if (Dfp->fd)
  {
    read_size = read (Dfp->fd, cp, len);
  }
  else
    read_size = 0;

  return read_size;
}

int DARLA_Write(DARLA_file *Dfp, char *cp, int len)
{
  ssize_t write_size;

  if (Dfp->fd)
  {
    write_size = write(Dfp->fd, cp, len);
  }
  else
    write_size = 0;
  
  return write_size;
}

int DARLA_Seek(DARLA_file *Dfp, int offset, int whence)
{

  off_t lseek_off;

  if (Dfp->fd)
  {
    lseek_off = lseek(Dfp->fd, offset, whence);
  }
  else
    lseek_off = 0;

  return lseek_off;
}
