#include "stdio.h"
#include <scrw.h>
#include <string.h>
#include "shs.h"
#include <openssl/des.h>
#include "nfsproto.h"
#include "admproto.h"
#include "cfs.h"
#include <sys/time.h>
#include <unistd.h>

extern int scfd;
extern int sccla;

#ifdef SC_COUNT
static int sc_count; 
#endif /* SC_COUNT */

int init_smartcard(int port, unsigned char *pin)
{
  int n, err, r1, r2, i;
  unsigned char buf [256];

#ifdef SC_COUNT
  sc_count = 0; 
#endif /* SC_COUNT */
 
  scfd = scopen(port, 0, NULL);

  if (scfd < 0) {
    fprintf(stderr, "cannot open port %d\n", port);
    return -1; 
  }
#ifdef DEBUG
  printf ("scfd = %d\n", scfd);
#endif DEBUG

  n = scxreset(scfd, SCRFORCE, buf, &err);

  if (err != SCEOK) {
    fprintf(stderr, "%s\n", scerrtab[err]);
    return -1; 
  }

  if (n == 0) {
    fprintf(stderr, "no ATR?\n");
    return -1;
  }

#ifdef DEBUG
  printf ("smartcard ATR: ");
  dump_reply(buf, n, 0, 0);
#endif /* DEBUG */

  /* figure out 00 or f0 card  */
  buf[0] = 0x3f;
  buf[1] = 0x00; 

  /* try CLA 00 */
  n = scwrite(scfd, 0, 0xa4, 0, 0, 2, buf, &r1, &r2);
  if (n < 0) {
    fprintf (stderr, "scwrite failed.\n");
    dump_reply (buf, 0, r1, r2); 
    return -1; 
  }
  if (r1 == 0x90 || r1 == 0x61) {
    sccla = 0;
#ifdef DEBUG
    printf ("This is a Cyberflex 00 card.\n");
#endif /* DEBUG */
    goto CLASS_FOUND; 
  }
  
  /* try CLA F0 */
  n = scwrite(scfd, 0xf0, 0xa4, 0, 0, 2, buf, &r1, &r2);
  if (n < 0) {
    fprintf (stderr, "scwrite failed.\n");
    dump_reply (buf, 0, r1, r2); 
    return -1; 
  }
  if (r1 == 0x90 || r1 == 0x61) {
    sccla = 0xf0;
#ifdef DEBUG
    printf ("This is a Cyberflex F0 card.\n");
#endif /* DEBUG */
    goto CLASS_FOUND; 
  }

  fprintf (stderr, "This card is neither Cyberflex 00 nor Cyberflex F0.\n");
  fdump_reply(stderr, NULL, 0, r1, r2); 
  return -1;
 
 CLASS_FOUND:
  
  /* now select the applet "CITI-cfs" */
  n = scwrite(scfd, sccla, 0xa4, 0x04, 0, strlen (APPNAME), APPNAME, &r1, &r2);
  if (n < 0) {
    fprintf (stderr, "scwrite failed.\n");
    dump_reply (buf, 0, r1, r2); 
    return -1; 
  }
  if (r1 != 0x90 && r1 != 0x61) {
    fprintf (stderr, "cannot select applet \'%s\'\n", APPNAME);
    return -1; 
  }

#ifdef DEBUG
  printf ("applet \'%s\' selected.\n", APPNAME);
#endif /* DEBUG */

  /* then check PIN */
  for (i = 0 ; i < 8 ; i ++) buf[i] = 0xff;
  bcopy (pin, buf, strlen (pin));
#ifdef DEBUGXX
  printf ("send PIN : ");
  for (i = 0 ; i < 8 ; i ++) printf ("%02x ", buf[i]);
  printf ("\n");
#endif /* DEBUG */
  n = scwrite(scfd, CLA_CFS, INS_CHECK_PIN, 0, 0, 8, buf, &r1, &r2);
  if (n < 0) {
    fprintf (stderr, "scwrite failed.\n");
    dump_reply (buf, 0, r1, r2); 
    return -1; 
  }
  if (r1 != 0x90 && r1 != 0x61) {
    fprintf (stderr, "PIN verification failed.\n");
    return -1; 
  }

  return 0; 
}

/*
  generate 8 byte DES key from given 8 byte hash
  if "r_flag" is 1, this is read request, so check out the cache
 */
int generate_key (int r_flag, unsigned char *seed, 
		  unsigned char key[])
{
    int rv, n, r1, r2, i; 
    unsigned char buf[256];

#ifdef KEY_CACHE
    if (r_flag == 1) {
      rv = kc_retrieve (seed, key);
      if (rv == 1) return 0; /* if kc_retrieve() returns 1,
				it found the key */

      /* otherwise, go ask smartcard */
    }
#endif /* KEY_CACHE */

#ifdef SC_COUNT
    sc_count++;
    printf ("sc_count = %d\n", sc_count);
#endif /* SC_COUNT */

    /* send to smartcard:
       0 - 7  : seed
       8 - 23 : 0

       recv from smartcard:
       0 - 19 : session key 
    */

    bzero(buf, SEED_LEN + KEY_LEN);
    bcopy (seed, buf, SEED_LEN);

#ifdef DEBUGXX
    printf ("scfd = %d, sccla = %x, len = %d\n", scfd, (unsigned int)sccla,
	    SEED_LEN + KEY_LEN);
#endif /* DEBUG */
    
    n = scwrite (scfd, CLA_CFS, INS_GET_KEY, 0, 0,
		 SEED_LEN + KEY_LEN, buf, &r1, &r2);
    if (n < 0) {
	fprintf (stderr, "scwrite failed 1.\n");
	dump_reply (buf, 0, r1, r2); 
	goto err_out; 
    }
    if (r1 != 0x90 && r1 != 0x61) {
	fprintf (stderr, "Key generation APDU failed.\n");
	goto err_out; 
    }

    /* issue get response */
    n = scread (scfd, sccla, INS_GET_RESPONSE, 0, 0,
		SHA1_LEN, buf, &r1, &r2);
    if (n < 0) {
	fprintf (stderr, "scread failed.\n");
	dump_reply (buf, 0, r1, r2); 
	goto err_out; 
    }
    if (r1 != 0x90 && r1 != 0x61) {
	fprintf (stderr, "get response APDU failed.\n");
	goto err_out; 
    }

    /* XOR 20 byte -> 8 byte */
    for (i = 1 ; i <DES_LEN ; i ++) {
      buf[i] ^= buf[DES_LEN + i]; 
    }
    for (i = 1 ; i <DES_LEN / 2 ; i ++) {
      buf[i] ^= buf[DES_LEN * 2 + i]; 
    }

    /* set parity */
    for (i = 0 ; i < DES_LEN; i ++) {
	buf[i] ^= ~((buf[i]>>7) ^ (buf[i]>>6) ^ (buf[i]>>5) ^
		    (buf[i]>>4) ^ (buf[i]>>3) ^ (buf[i]>>2) ^
		    (buf[i]>>1) ^ buf[i]) & 0x1;
    }

    bcopy (buf, key, DES_LEN);
    memset (buf, 0, 256);
#ifdef KEY_CACHE
    kc_add (seed, key);
#endif /* KEY_CACHE */

    return 0;

 err_out:
    return -1; 
    
}

/* encryption / decryption function */
extern char zerovect[];

int smartcard_encrypt(unsigned char *in, unsigned char *out,
		      unsigned char key[],
		      unsigned long len, int decrypt_flag)
{
  des_key_schedule sched;
  int i; 
  /*unsigned char *tmp; */
  
  /*tmp = (unsigned char *) malloc (len + 8);*/
#ifdef DEBUGXX
  printf ("smartcard_encrypt () key : "); 
  for (i = 0 ; i < 8 ; i ++)
    printf ("%02x ", key[i]);
  printf ("\n");
#endif /* DEBUGXX */
    
  des_set_key ((const_des_cblock *)key, sched); 
  des_cbc_encrypt (in, out, len,
		   sched, (des_cblock *)&zerovect,
		   decrypt_flag == 0 ? DES_ENCRYPT : DES_DECRYPT);
  /*bcopy (tmp, buf, len); 
  free (tmp); */

  return 0; 
}


/* generate seed for a directory master key,
   symlink it into .pvect
*/

int smartcard_dir_seed (unsigned char *vect, unsigned char *dir_name,
			unsigned long inode, int *err)
{
  int rv;
  struct timeval tv;
  unsigned char vectname[1024];
  union{
    u_char ch[VECTLEN_CHARS + 1];
    u_long i[2];
  } hash_union;
  
  rv = gettimeofday (&tv, NULL);
  if (rv < 0) {
    perror ("gettimeofday");
    *err = NFSERR_IO; 
    return -1; 
  }

  
  hash_union.i[0] = (unsigned long)inode;
  hash_union.i[1] = (unsigned long)tv.tv_sec;
  q_block_cipher(FIXED_KEY, &hash_union, 0);

  sprintf(vect, "%02x%02x%02x%02x%02x%02x%02x%02x",
	  hash_union.ch[0], hash_union.ch[1],
	  hash_union.ch[2], hash_union.ch[3],
	  hash_union.ch[4], hash_union.ch[5],
	  hash_union.ch[6], hash_union.ch[7]);

  printf ("generated dir_seed %x\n", vect);

  return 0; 
}

int smartcard_save_dir_seed (unsigned char *vect, unsigned char *dir_name)
{
  unsigned char vectname [1024];
  
  sprintf(vectname, "%s/.pvect_...", dir_name);
  printf ("vectname \"%s\" < vect \"%s\"\n",
	  vectname, vect);

  unlink (vectname); 

  if (symlink(vect, vectname) != 0) {
    perror ("symlink");
    strcpy (vectname, "/NOWHERE/null");
    bcopy (zerovect, vect, VECTLEN_CHARS);
    return -1; 
  }
}

int smartcard_read_dir_seed (unsigned char *vect, unsigned char *dir_name)
{
  int rv;
  unsigned char vectname [1024];
  
  sprintf(vectname, "%s/.pvect_...", dir_name);
  
  rv = readlink(vectname, vect, VECTLEN_CHARS + 1);
  if (rv != VECTLEN_CHARS) {
#ifdef DEBUG
    printf ("XXXXX readlink 2\n");
#endif /* DEBUG */
    bcopy((char *)zerovect,(char *)vect, VECTLEN_CHARS);
    return -1; 
  }
  
  return 0; 
}
