#include "stdio.h"
#include <scrw.h>
#include <string.h>
#include "shs.h"
#include <openssl/des.h>
#include "nfsproto.h"
#include "admproto.h"
#include "cfs.h"
#include <sys/time.h>
#include <unistd.h>

int scfd; /* FD for smartcard */
int port = 1;
int sccla = 0;


/*
  generate 20 byte SHA1 hash from given
  inode number, file syze, and modification time (seconds and micro seconds)
*/
#define HASH_BUF_LEN 16
#define PAD_VAL 0xf0
#define UINT_SIZE 4

int generate_hash (unsigned int inode, unsigned int file_size,
		   unsigned int mtime_sec, unsigned int mtime_usec,
		   unsigned char *result)
{
  SHS_CTX shs_ctxt;
  unsigned char hash_buf[HASH_BUF_LEN], *sha1_result; 
  int i; 

  /* fill in buf, which will be hashed
     
     buffer format:
     inode #   : 0 - 3
     size      : 4 - 7
     mtime sec : 8 - 11
     mtime usec: 12 - 15

     The rest of the buffer is filled with 0xf0. 
  */

  for (i = 0 ; i < HASH_BUF_LEN ; i ++) hash_buf[i] = PAD_VAL;
  hash_buf[0] = inode / 0x1000000 & 0xff;
  hash_buf[1] = inode / 0x10000 & 0xff;
  hash_buf[2] = inode / 0x100 & 0xff;
  hash_buf[3] = inode & 0xff;
  hash_buf[4] = file_size / 0x1000000 & 0xff;
  hash_buf[4 + 1] = file_size / 0x10000 & 0xff;
  hash_buf[4 + 2] = file_size / 0x100 & 0xff;
  hash_buf[4 + 3] = file_size & 0xff;
  hash_buf[8] = mtime_sec / 0x1000000 & 0xff;
  hash_buf[8 + 1] = mtime_sec / 0x10000 & 0xff;
  hash_buf[8 + 2] = mtime_sec / 0x100 & 0xff;
  hash_buf[8 + 3] = mtime_sec & 0xff;
  hash_buf[12] = mtime_usec / 0x1000000 & 0xff;
  hash_buf[12 + 1] = mtime_usec / 0x10000 & 0xff;
  hash_buf[12 + 2] = mtime_usec / 0x100 & 0xff;
  hash_buf[12 + 3] = mtime_usec & 0xff;
  
  sha1_result = qshs (hash_buf, HASH_BUF_LEN);
  bcopy (sha1_result, result, SHA1_LEN);
  
  return 0; 
}

extern char zerovect[]; 

/* generate a new seed, symlink it */
int smartcard_newseed (cfs_fileid *fid, unsigned long inode, int *err)
{
  int rv;
  struct timeval tv; 
  union{
    u_char ch[VECTLEN_CHARS + 1];
    u_long i[2];
  } hash_union;

  rv = gettimeofday (&tv, NULL);
  if (rv < 0) {
    perror ("gettimeofday");
    *err = cfsno(errno);
    return -1; 
  }

  hash_union.i[0] = (unsigned long)inode;
  hash_union.i[1] = (unsigned long)tv.tv_sec;
  q_block_cipher(FIXED_KEY, &hash_union, 1);

  sprintf(fid->vect, "%02x%02x%02x%02x%02x%02x%02x%02x",
	  hash_union.ch[0], hash_union.ch[1],
	  hash_union.ch[2], hash_union.ch[3],
	  hash_union.ch[4], hash_union.ch[5],
	  hash_union.ch[6], hash_union.ch[7]);

  if (unlink (fid->vectname) != 0) {
    perror ("unlink");
  }
		  
  if (symlink(fid->vect, fid->vectname) != 0) {
    perror ("symlink");
    strcpy(fid->vectname, "/NOWHERE/null");
    bcopy((char *)zerovect, (char *)fid->vect, VECTLEN_CHARS);
  }
  
  return 0; 
}
