/* list.c */
/* Made by Haruna Takahashi, Oct.11.1998 */
/* Modified by Naomaru Itoi, Sep. 2000 */

#include "list.h"
#include <assert.h>

void hlist_initialize(hlist_str *list)
{
  list->head = NULL;
  list->tail = NULL;
  list->size = 0; 
  
  return; 
}

void hlist_dumpset(hlist_str *list)

{
  int i;
  hnode *s = list->head; 
  
  while(s) {
    printf ("vect: ");
    for (i = 0 ; i < SEED_LEN ; i++) 
      printf ("%02x ", s->vect[i]);
    printf (", key: ");
    for (i = 0 ; i < DES_LEN ; i++) 
      printf ("%02x ", s->key[i]);
    printf ("\n");
    s=s->next;
  }
  printf("\n");
}

void hlist_dump_reverse (hlist_str *list)
{
  int i;
  hnode *s = list->tail; 

  printf ("dump_reverse\n");
  
  while(s) {
    printf ("vect: ");
    for (i = 0 ; i < SEED_LEN ; i++) 
      printf ("%02x ", s->vect[i]);
    printf (", key: ");
    for (i = 0 ; i < DES_LEN ; i++) 
      printf ("%02x ", s->key[i]);
    printf ("\n");
    s=s->prev;
  }
  printf("\n");
}

/* malloc a new node */
hnode *makehnode()
     /*int n;*/
{
  hnode *p;
  
  p = (hnode*) malloc(sizeof(hnode));
  return p;
}

/* make a new node, put it at the top,
   and return the pointer points to it. */
hlist hinsert(hlist_str *list, unsigned char *vect, unsigned char *key)
{
  hnode * new; 

  assert (vect != NULL && key != NULL);
  new = makehnode() ;
  assert (new != NULL);

  /* if there is list->head, set its prev */

  new->next = list->head ;
  if (new->next != NULL) {
    new->next->prev = new;
  }
  new->prev = NULL;

  list->head = new;
  /* if this is a new list, this is also a tail */
  if (list->tail == NULL) list->tail = new; 
  
  memcpy (new->vect, vect, SEED_LEN);
  memcpy (new->key, key, DES_LEN);

  /* take care of cache overflow */
  if (list->size < MAX_LIST_LEN) {
    /* there still is room. */
    list->size++;
  } else {
    /* no room.  get rid of the tail. */
    list->tail = list->tail->prev;
    free (list->tail->next);
    list->tail->next = NULL; 
  }
      
  return new ;  
}

/*
  find a list node with vector "vect", and return its key in "key".
  then move the node to the top of the list.

  return 1 if the entry is found.
  return 0 if not. 
 */
int hfind (hlist_str *list, unsigned char *vect, unsigned char *key)
{
  hnode *tmp; /*, *tmp_prev; */
  
  assert (vect != NULL && key != NULL);

  for (tmp = list->head; tmp != NULL ; tmp = tmp->next) {
    if (memcmp (tmp->vect, vect, SEED_LEN) == 0) {
      /* found! :) */
      memcpy (key, tmp->key, DES_LEN);

      /* if tmp is at the head, return. */
      if (tmp == list->head) {
#ifdef DEBUG
	printf ("found at head\n");
#endif /* DEBUG */
	return 1;
      }

      /* if tmp is at the tail, put it at the head */
      if (tmp == list->tail) {
#ifdef DEBUG
	printf ("found at tail\n");
#endif /* DEBUG */
	
	list->tail = tmp->prev;
	
	tmp->prev->next = NULL;

	tmp->next = list->head;
	tmp->prev = NULL;
	list->head->prev = tmp;
	list->head = tmp;

	return 1; 
      }

      /* otherwise, put tmp at the head */
#ifdef DEBUG
      printf ("found in the middle\n");
#endif /* DEBUG */
      tmp->prev->next = tmp->next;
      tmp->next->prev = tmp->prev; 

      tmp->next = list->head;
      tmp->prev = NULL;
      list->head->prev = tmp; 
      list->head = tmp; 
      return 1; 
    }
  }
  /* not found. :( */
  return 0;   
}

#ifdef HLIST_TEST
hlist_str list;

unsigned char *v1 = "1111111111111111", *v2 = "2222222222222222",
  *v3 = "3333333333333333", *v4 = "4444444444444444",
  *v5 = "5555555555555555", *v6 = "6666666666666666",
  *ka = "aaaaaaa", *kb = "bbbbbbb", *kc = "ccccccc",
  *kd = "ddddddd", *ke = "eeeeeee", *kf = "fffffff";

main()
{
  hnode *tmp;
  unsigned char key[DES_LEN];
    
  hlist_initialize (&list);

  /* test insert */
  tmp = hinsert (&list, v1, ka);
  tmp = hinsert (&list, v2, kb);
  tmp = hinsert (&list, v3, kc);
  hlist_dumpset (&list); /* order should be c-b-a */
 
  /* test find */
  hfind (&list, v3, key);
  printf ("key found %s\n", key); /* should return "ccccccc" */
  hlist_dumpset (&list); /* order shouldn't change here */

   
  hfind (&list, v2, key);
  printf ("key found %s\n", key); /* should return "bbbbbbb" */
  hlist_dumpset (&list); /* order should be b-c-a */

  hfind (&list, v1, key);
  printf ("key found %s\n", key); /* should return "aaaaaaa" */
  hlist_dumpset (&list); /* order should be a-b-c */

  hinsert (&list, v4, kd);
  hinsert (&list, v5, ke);
  hinsert (&list, v6, kf);
  hlist_dumpset (&list); /* order should be f-e-d */
  return 0; 
}

#endif HLIST_TEST
