/* Naomaru Itoi
   September, 2000

   This file contains global variables and functions for the key cache.
   A prefix "kc" stands for "key cache". 
*/

#ifdef KEY_CACHE

#include "stdio.h"
#include "list.h"

/* kc_node kc_table[KC_TABLE_SIZE]; /* the key cache itself */
/* int kc_num_keys; /* the number of keys.
		    start with 0, goes up to KC_TABLE_SIZE. */
/* int kc_key_idx;  /* key index. 
		    start with 0, gets incrememted whenever new key
		    enters the cache. */
hlist_str key_list;

/* initialize the key cache */
void kc_init()
{
#ifdef DEBUG
  printf ("kc_init()\n");
#endif /* DEBUG */

  hlist_initialize (&key_list);

  return; 
}

#define print_buf(x, n) {\
    int pb_i;\
    for (pb_i = 0 ; pb_i < n ; pb_i++)\
      printf ("%02x ", x[pb_i]);\
}

void kc_add(u_char *vect, u_char *key)
{
  int i;

#ifdef DEBUG
  printf ("kc_add (vect=");
  print_buf (vect, SEED_LEN);
  printf (", key=");
  print_buf (key, DES_LEN);
  printf (")\n");
#endif /* DEBUG */

  hinsert (&key_list, vect, key); 
    
  return; 
}

/* fills "key" and returns 1 if a key for vect "vect" is found.
   return 0 otherwise. */
int kc_retrieve (u_char *vect, u_char *key)
{
  int i, rv;
  
  rv = hfind (&key_list, vect, key);

#ifdef DEBUG
  printf ("kc_retrieve : ");
  if (rv == 0) printf ("miss.\n");
  else printf ("hit!\n");
#endif /* DEBUG */

  return rv; 
}

#endif /* KEY_CACHE */
