
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

// cfs.java
// Kerberos 5 / Smartcard project.  Works! :)
//
// NI, 6/24/2000
// 
// class 30
// ins 10 (check pin), 20 (get key)
//
//
// "CITI-cfs"
// jl -a 434954492d636673 cfs.bin
// 43 49 54 49 2d 63 66 73

import javacard.framework.*;
import javacardx.framework.*;
import javacardx.crypto.*;

public class cfs extends javacard.framework.Applet { 
    
    // constants
    final short BUFSIZE = (short)248;
    final short SEED_SIZE = (short)8;
    final short KEY_SIZE = (short)16; 
    final short SHA1_SIZE = (short)20;
    final short key_file_name = (short) 0x6b65;
    
    // CLA byte in the command APDU header 
    final byte CFS_CLA =(byte)0x30;
    
    // INS byte in the command APDU header
    final byte CHECK_PIN = (byte) 0x10;
    final byte GET_KEY = (byte) 0x20;
    final byte GET_RESPONSE = (byte) 0xc0;
    final byte SELECT = (byte) 0xa4; 

    /* instance variables declaration */ 
    byte apdu_buffer[]; // APDU buffer
    boolean chv_state = false; // CHV not verified
    MessageDigest hash;

    private cfs() {
	hash = new Sha1MessageDigest();
	register();
    } // end of the constructor 
    
    public static void install(APDU apdu){
	// create a cfs applet instance
	new cfs();
    } // end of install method
    
    public boolean select() { 
	chv_state = false; 
	    
	return true; 
    }// end of select method 

    public static void main(String args[]) {
	ISOException.throwIt((short) 0x7264);
    }
    
    public void process(APDU apdu) { 
	apdu_buffer = apdu.getBuffer();

	// NI: change suggested by Wayne Dyksen, Purdue
	if (apdu_buffer[ISO.OFFSET_INS] == ISO.INS_SELECT) {
	    ISOException.throwIt(ISO.SW_NO_ERROR);
	}
		
	switch (apdu_buffer[ISO.OFFSET_INS]) {
	case GET_RESPONSE: return;
	case SELECT: return;
	case CHECK_PIN: check_pin (apdu); return;
	case GET_KEY: get_key (apdu); return;
	default: ISOException.throwIt (ISO.SW_INS_NOT_SUPPORTED); 
	} 

        } // end of process method

    /* 
       INPUT:  seed  : 0 - 7 
               space : 8 - 23
       WORK:   read the key file
               put the key file into buf 8 - 23
	       compute session key
       OUTPUT: session key (8 byte) */
    
    private void get_key (APDU apdu) {
	byte rv;
	    
	short byteRead = (short)(apdu.setIncomingAndReceive());
	if (byteRead != (short)(SEED_SIZE + KEY_SIZE)) 
	    ISOException.throwIt(ISO.SW_WRONG_LENGTH);

	// first, check if PIN has been verified
	if (chv_state == false) 
	    ISOException.throwIt((short)0x6982); // access denied

	// then read the key file
	CyberflexFile.selectRoot();
	// select "ke" 
	rv = CyberflexFile.selectFile(key_file_name);
	if (rv != ST.SUCCESS) {
	    ISOException.throwIt(ISO.SW_FILE_NOT_FOUND);
	}
	// read "ke" 
	rv = CyberflexOS.readBinaryFile (apdu_buffer,
					 (short)(ISO.OFFSET_CDATA + SEED_SIZE),
					 (short)0,
					 KEY_SIZE);

	hash.generateDigest (apdu_buffer, (short)(ISO.OFFSET_CDATA),
			     (short)(SEED_SIZE + KEY_SIZE),
			     apdu_buffer, (short)(ISO.OFFSET_CDATA));

	apdu.setOutgoing (); 
	apdu.setOutgoingLength (SHA1_SIZE); 
	apdu.sendBytesLong (apdu_buffer, (short)ISO.OFFSET_CDATA,
			    (SHA1_SIZE)); 
 
        } // end of get_key method

    /* check_pin
      
       INPUT:  PIN, 8 byte
       WORK:   check PIN
       OUTPUT: OK or not */
    private void check_pin (APDU apdu) {
	byte rv;

	// is input 8 byte?
	short byteRead = (short)(apdu.setIncomingAndReceive());
	if (byteRead != (short)8) 
	    ISOException.throwIt(ISO.SW_WRONG_LENGTH);

	// check PIN
	rv = CyberflexOS.verifyCHV ((byte)1, /* CHV 1 */
				    apdu_buffer, (short)ISO.OFFSET_CDATA,
				    (byte)0 /* CHV, not unblocking CFV */);
	if (rv == ST.SUCCESS) {
	    chv_state = true;
	    ISOException.throwIt((short)0x9000); // success
	} else {
	    chv_state = false;
	    ISOException.throwIt((short)0x6982); // access denied
	}
	return; 
    } // end of get_key method
} // end of class cfs 
