/*
 *
 * NAME:
 *      atr.h
 *      Copyright (C) 1998 Carlos Prados
 *
 * DESCRIPTION:
 *      Header of the module that implements ISO-7816-3
 *      answer to reset decodification procedures
 *
 * AUTHOR:
 *      Carlos Prados Bocos, October 1998.
 *      cprados@atos-ods.es
 *
 * LICENSE:
 *      See file COPYING
 */

#ifndef _ATR_
#define _ATR_

#include "defines.h"

/* 
 * Maximum size of ATR in bytes
 */

#define ATR_MAX_SIZE MAX_BUFFER_SIZE

/*
 * Module functions return codes
 */

#define ATR_OK 		0
#define ATR_NOTFOUND 	1
#define ATR_MALFORMED 	2


/*
 * Card Protocols
 */

#define ATR_PROTOCOL_T0 0
#define ATR_PROTOCOL_T1 1

/*
 * Determines the transport protocol of a card, given it's ATR
 * Parameter:
 *      atr: Answer to reset of the card
 *	length: length of the ATR
 *      protocol: returned protocol
 * Returns:
 *	ATR_OK: Protocol can be determined
 *	ATR_MALFORMED: Malformed ATR
 */

extern int 
ATR_Protocol(BYTE atr[ATR_MAX_SIZE],int length,BYTE* protocol);

/*
 * Returns the historical bytes of an ATR
 * Parameters:
 *      atr: Answer to reset of the card
 *	latr: length of the ATR
 *	hist: returned historical bytes
 *	lhist: length of returned historical bytes
 * Returns:
 *	ATR_OK: Hystorical bytes can be determined
 *	ATR_NOTFOUND: There is no historycal bytes
 *	ATR_MALFORMED: Malformed ATR
 */

extern int
ATR_HistoricalBytes(BYTE atr[ATR_MAX_SIZE], int latr, 
                    BYTE hist[ATR_MAX_SIZE], int* lhist);

/*
 * Return the specified interface byte
 * Parameters:
 *      atr: Answer to reset of the card
 *      latr: length of the ATR
 *	character: 'A' for TAi, 'B' for TBi, 'C' for TCi, 'D' for TDi 
 *      index: index i of the TXi interface byte
 *      int_byte: returned interface byte
 * Returns:
 *	ATR_OK: Interface byte can be determined
 *	ATR_NOTFOUND: Interface byte cannot be determined
 *	ATR_MALFORMED: Malformed ATR
 */

extern int
ATR_InterfaceByte(BYTE atr[ATR_MAX_SIZE], int latr, char character, 
                  int index, BYTE* int_byte); 

#endif /* _ATR_ */
