/* $Id: scct.c,v 1.20 2000/07/29 21:45:12 rees Exp $ */

/*
copyright 2001
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/

#ifndef __palmos__
#include <sys/types.h>
#include <sys/time.h>
#else
#include <Common.h>
#include <SystemMgr.h>
#include <string.h>
#endif
#include <stdlib.h>
#include <stdio.h>

#include "sectok.h"
#include "sc7816.h"
#include "ctapi.h"

struct scparam scparam[4];

#ifndef __palmos__
void
scsleep(int ms)
{
    struct timeval tv;

    if (!ms)
	return;
    tv.tv_sec = (ms + 1) / 1000;
    tv.tv_usec = (ms % 1000) * 1000;

    select(0, NULL, NULL, NULL, &tv);
}
#else
void
scsleep(int ms)
{
    long ticks;

    if (ms <= 0)
	return;
    ticks = ((long) ms * (long) SysTicksPerSecond() + 999L) / 1000L;
    SysTaskDelay(ticks);
}
#endif

/* Stuff needed to use this with the Towitoko driver */

extern int IO_blocktime; /* milliseconds */

extern int Towitoko_CardCommand(unsigned char* buffer, int size);
extern int IO_Read(int readsize, unsigned char *response);

int
scputblk(int ttyn, unsigned char *bp, int n)
{
    return Towitoko_CardCommand(bp, n) ? SCEOK : SCTIMEO;
}

int
scgetc(int ttyn, unsigned char *cp, int ms)
{
    int t, r;

#ifdef __palmos__
    t = IO_blocktime;
    IO_blocktime = ms;
#endif

    r = IO_Read(1, cp) ? SCEOK : SCTIMEO;

#ifdef __palmos__
    IO_blocktime = t;
#endif
    return r;
}
