/*
 * Shim for apps written to sc7816, to use ctapi.
 *
 * Jim Rees, University of Michigan, December 1998
 */
static char *rcsid = "$Id: scct.c,v 1.20 2000/07/29 21:45:12 rees Exp $";

#include <stdlib.h>
#include <stdio.h>
#ifndef __palmos__
#include <sys/types.h>
#include <sys/time.h>
#else
#include <Common.h>
#include <SystemMgr.h>
#include <string.h>
#endif

#include "sectok.h"
#include "ctapi.h"

/* error table */
char *scerrtab[] = {
    "ok",
    "no such tty",
    "out of memory",
    "timeout",
    "slag!",
    "card type not supported",
    "no card in reader",
};

/* this should be in scparam */
int scatrto;

int
scopen(int ttyn, int flags, int *ep)
{
    int cterr;

    if ((cterr = CT_init(1, ttyn)) != OK) {
#ifdef DEBUG
	printf("CT_init failed\n");
#endif
	if (cterr == ERR_TRANS)
	    /* Towitoko driver sloppily leaves the port open in this case */
	    CT_close(1);
	if (ep)
	    *ep = SCENOTTY;
	return -1;
    }
#ifdef DEBUG
    printf("opened %d\n", ttyn);
#endif
    scdtr(ttyn, 1);

    return ttyn;
}

int
scsetflags(int ttyn, int flags, int mask)
{
    return 0;
}

int
scsetspeed(int ttyn, int speed)
{
    return 0;
}

int
scclose(int ttyn)
{
    scdtr(ttyn, 0);
    CT_close(1);
}

/* reset the card, and return answer to reset (atr) */

int
screset(int ttyn, unsigned char *atr, int *ep)
{
    return scxreset(ttyn, 0, atr, ep);
}

int
scxreset(int ttyn, int flags, unsigned char *atr, int *ep)
{
    int i, nhb, c;
    unsigned char dad = 1, sad = 2;
    unsigned int n;
    static unsigned char cmd[] = {0x20, 0x11, 0x00, 0x01};
    unsigned char buf[36];

    if (ep)
	*ep = SCEOK;

    if (!atr)
	atr = buf;

    /* Reset card */
    n = sizeof buf;
    if (CT_data(1, &dad, &sad, sizeof cmd, cmd, &n, atr)) {
#ifndef __palmos__
	if (flags & SCRV)
	    printf("reset failed\n");
#endif
	if (ep)
	    *ep = SCESLAG;
	return 0;
    }

#ifndef __palmos__
    if (flags & SCRV) {
	for (i = 0; i < n - 2; i++)
	    printf("%d:%x ", i + 1, atr[i]);
	printf("\n");
	nhb = atr[1] & 0xf;
	if (nhb) {
	    printf("%d historical bytes:", nhb);
	    for (i = n - 2 - nhb; i < n - 2; i++) {
		c = atr[i];
		if (c >= ' ' && c <= '~')
		    printf(" %c", c);
		else
		    printf(" %02x", c);
	    }
	    printf("\n");
	}
    }
#endif

    /* Fill in scparam with defaults; should parse atr */
    scparam[ttyn].etu = 100;
    scparam[ttyn].cwt = 100;
    scparam[ttyn].bwt = 200;

    return (n - 2);
}

int
scrw(int ttyn, int cla, int ins, int p1, int p2, int ilen, unsigned char *ibuf, int olen, unsigned char *obuf, int *sw1p, int *sw2p)
{
    unsigned char dad = 0, sad = 2, cmd[5+255], tbuf[256+2];
    unsigned int n;
    int code;

    ilen &= 0xff;

    cmd[0] = cla;
    cmd[1] = ins;
    cmd[2] = p1;
    cmd[3] = p2;
    cmd[4] = ilen ? ilen : olen;
    if (ilen && ibuf)
	memcpy(&cmd[5], ibuf, ilen);

    n = sizeof tbuf;

    code = CT_data(1, &dad, &sad, 5 + ilen, cmd, &n, tbuf);
#ifdef DEBUG
    printf("wrote %d, read %d, code %d\n", ilen, n, code);
#endif
    if (code)
	return code;

    *sw1p = tbuf[n-2];
    *sw2p = tbuf[n-1];
    n -= 2;

    if (!code && *sw1p == 0x61 && olen >= *sw2p && obuf) {
	/* Response available; get it */
	return scrw(ttyn, cla, 0xc0, 0, 0, 0, NULL, *sw2p, obuf, sw1p, sw2p);
    }

    if (n && olen && obuf)
	memcpy(obuf, tbuf, (n < olen) ? n : olen);

    return n;
}

int
scwrite(int ttyn, int cla, int ins, int p1, int p2, int p3, unsigned char *buf, int *sw1p, int *sw2p)
{
    return (scrw(ttyn, cla, ins, p1, p2, p3, buf, 0, NULL, sw1p, sw2p) >= 0) ? p3 : -1;
}

int
scread(int ttyn, int cla, int ins, int p1, int p2, int p3, unsigned char *buf, int *sw1p, int *sw2p)
{
    return scrw(ttyn, cla, ins, p1, p2, 0, NULL, p3, buf, sw1p, sw2p);
}

/* find out if there is a card in the reader */

int
sccardpresent(int ttyn)
{
    unsigned char dad = 1, sad = 2, buf[4];
    unsigned int n;
    static unsigned char cmd[] = {0x20, 0x13};
    int code;

    /* Get status */
    n = sizeof buf;
    code = CT_data(1, &dad, &sad, sizeof cmd, cmd, &n, buf);
    return (!code && n >= 3 && (buf[0] == 0x01));
}

int
scdtr(int ttyn, int howto)
{
    unsigned char dad = 1, sad = 2, buf[4];
    unsigned int n;
    static unsigned char cmd[] = {0x20, 0x12};
    int code;

    cmd[1] = howto ? 0x12 : 0x15;
    n = sizeof buf;
    code = CT_data(1, &dad, &sad, sizeof cmd, cmd, &n, buf);
#ifdef DEBUG
    if (code)
	printf("scdtr %d failed %d\n", howto, code);
#endif
}

/*
copyright 1998, 1999
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
