/* $Id: ifdwrapper.c,v 1.1 2003/06/19 22:40:53 rees Exp $ */

/*
copyright 2003
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/

/* ifdwrapper by Hans-Joerg Hoexer <Hans-Joerg.Hoexer@yerbouti.franken.de> */

#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#include "sectok.h"
#include "ifdhandler.h"
#include "ifdwrapper.h"

unsigned long
IFDOpenIFD(readerInfo *reader)
{
    unsigned long ret;
    void *func;

    unsigned long (*IO_create_channel)(unsigned long);
    unsigned long (*IFDH_create_channel)(unsigned long, unsigned long);

    func = reader->open;
    if (reader->version == IFDH_VERSION_1_0) {
	IO_create_channel = (unsigned long (*)(unsigned long)) func;
	ret = (*IO_create_channel)(reader->channelID);
    } else {
	IFDH_create_channel = (unsigned long (*)(unsigned long,
						 unsigned long)) func;
	ret = (*IFDH_create_channel)(reader->lun, reader->channelID);
    }

    return ret;
}

unsigned long
IFDCloseIFD(readerInfo *reader)
{
    unsigned long ret;
    void *func;

    unsigned long (*IO_close_channel)();
    unsigned long (*IFDH_close_channel)(unsigned long);

    func = reader->close;
    if (reader->version == IFDH_VERSION_1_0) {
	IO_close_channel = (unsigned long (*)()) func;
	ret = (*IO_close_channel)();
    } else {
	IFDH_close_channel = (unsigned long (*)(unsigned long)) func;
	ret = (*IFDH_close_channel)(reader->lun);
    }

    return ret;
}

unsigned long
IFDPowerICC(readerInfo *reader, unsigned long action,
	    unsigned char *atr, unsigned long *atrlength)
{
    unsigned long ret;
    void *func;
    unsigned char dummy_atr[MAX_ATR_SIZE];
    unsigned long dummy_atrlength;
    unsigned char *patr;
    unsigned long *patrlength;

    unsigned long (*IFD_power_icc)(unsigned long);
    unsigned long (*IFDH_power_icc)(unsigned long, unsigned long,
				    unsigned char *, unsigned long *);

    func = reader->power;
    if (reader->version == IFDH_VERSION_1_0) {
	IFD_power_icc = (unsigned long (*)(unsigned long)) func;
	ret = (*IFD_power_icc)(action);
    } else {
	if (atr != NULL) {
	    patr = atr;
	} else {
	    patr = dummy_atr;
	}
	if (atrlength != NULL) {
	    patrlength = atrlength;
	} else {
	    patrlength = &dummy_atrlength;
	}

	IFDH_power_icc = (unsigned long (*)(unsigned long, unsigned long,
					    unsigned char *, unsigned long*)) func;
	ret = (*IFDH_power_icc)(reader->lun, action, patr, patrlength);
    }

    return ret;
}

unsigned long
IFDTransmit(readerInfo *reader, SCARD_IO_HEADER txpci,
	    unsigned char *txbuffer, unsigned long txlength,
	    unsigned char *rxbuffer, unsigned long *rxlength,
	    SCARD_IO_HEADER *rxpci)
{
    unsigned long ret;
    void *func;

    unsigned long (*IFD_transmit_to_icc)(SCARD_IO_HEADER, unsigned char *,
					 unsigned long, unsigned char *, unsigned long *,
					 SCARD_IO_HEADER *);
    unsigned long (*IFDH_transmit_to_icc)(unsigned long, SCARD_IO_HEADER,
					  unsigned char *, unsigned long, unsigned char *,
					  unsigned long *, SCARD_IO_HEADER *);

    func = reader->data;
    if (reader->version == IFDH_VERSION_1_0) {
	IFD_transmit_to_icc = (unsigned long (*)(SCARD_IO_HEADER,
						 unsigned char *, unsigned long,
						 unsigned char *, unsigned long *,
						 SCARD_IO_HEADER *)) func;
	ret = (*IFD_transmit_to_icc)(txpci, txbuffer, txlength,
				     rxbuffer, rxlength, rxpci);
    } else {
	IFDH_transmit_to_icc = (unsigned long (*)(unsigned long,
						  SCARD_IO_HEADER, unsigned char *,
						  unsigned long, unsigned char *,
						  unsigned long *, SCARD_IO_HEADER *))
	    func;
	ret = (*IFDH_transmit_to_icc)(reader->lun, txpci, txbuffer,
				      txlength, rxbuffer, rxlength, rxpci);
    }

    return ret;
}

unsigned long
IFDSetCapabilities(readerInfo *reader, unsigned long tag, unsigned long length,
		   unsigned char *value)
{
    unsigned long ret;
    void *func;

    unsigned long (*IFD_set_capabilities)(unsigned long, unsigned char *);
    unsigned long (*IFDH_set_capabilities)(unsigned long, unsigned long,
					   unsigned long, unsigned char*);

    func = reader->setcapa;
    if (reader->version == IFDH_VERSION_1_0) {
	IFD_set_capabilities = (unsigned long (*)(unsigned long,
						  unsigned char *)) func;
	ret = (*IFD_set_capabilities)(tag, value);
    } else {
	IFDH_set_capabilities = (unsigned long (*)(unsigned long,
						   unsigned long, unsigned long,
						   unsigned char *)) func;
	ret = (*IFDH_set_capabilities)(reader->lun, tag, length, value);
    }

    return ret;
}

unsigned long
IFDGetCapabilities(readerInfo *reader, unsigned long tag, unsigned long *length,
		   unsigned char *value)
{
    unsigned long ret;
    void *func;

    unsigned long (*IFD_get_capabilities)(unsigned long, unsigned char *);
    unsigned long (*IFDH_get_capabilities)(unsigned long, unsigned long,
					   unsigned long *, unsigned char *);

    func = reader->getcapa;
    if (reader->version == IFDH_VERSION_1_0) {
	IFD_get_capabilities = (unsigned long (*)(unsigned long,
						  unsigned char *)) func;
	ret = (*IFD_get_capabilities)(tag, value);
    } else {
	IFDH_get_capabilities = (unsigned long (*)(unsigned long,
						   unsigned long, unsigned long *,
						   unsigned char *)) func;
	ret = (*IFDH_get_capabilities)(reader->lun, tag, length, value);
    }

    return ret;
}

unsigned long
IFDPresent(readerInfo *reader)
{
    unsigned long ret;
    void *func;

    unsigned long (*IFD_icc_present)();
    unsigned long (*IFDH_icc_presence)(unsigned long);

    func = reader->cardpresent;
    if (reader->version == IFDH_VERSION_1_0) {
	IFD_icc_present = (unsigned long (*)()) func;
	ret = (*IFD_icc_present)();
    } else {
	IFDH_icc_presence = (unsigned long (*)(unsigned long)) func;
	ret = (*IFDH_icc_presence)(reader->lun);
    }

    return ret;
}
