#!/bin/sh
#
#  Kerberos / Smartcard integration project 
#  Initialize and customize the smartcard
#
#  Usage: kscinit.sh [username]

KEY_CONFIG_FILE="kcfg"
APPLET_NAME=Krb.bin
#AID=CITI-krb5
AID=434954492d6b726235
FILE_ID=77.70
INSTANCE_DIRECTORY_FID=77.77
DATA_CONTAINER_SIZE=1024
DATA_DIRECTORY_SIZE=1152

get_userinfo()
{
    echo -n "reader port number (1/2): "
    read PORT
    echo ""
    echo -n "first realm: "
    read REALM1
    echo -n "second realm: "
    read REALM2
}

generate_key_config_file()
{
    # Generate the key configuration file (KEY_CONFIG_FILE)
    echo "#princ@realm            key#    PIN" > $KEY_CONFIG_FILE
    echo "$USERNAME@$REALM1    6       NULL" >> $KEY_CONFIG_FILE
    echo "$USERNAME@$REALM2    7       NULL" >> $KEY_CONFIG_FILE

    # get the length of KEY_CONFIG_FILE
    KCFG_LEN_UPPER=`wc -c $KEY_CONFIG_FILE | awk '{printf("%02x", $1/256);}'`
    KCFG_LEN_LOWER=`wc -c $KEY_CONFIG_FILE | awk '{printf("%02x", $1%256);}'`
}

get_pay()
{
    echo "which pay do you want to use? [" `which pay` "]"
    read PAY
    if [ "x$PAY" = "x" ]; then PAY=`which pay`;
    fi
    echo "using " $PAY
}

get_keys()
{
#    echo "Password for "$USERNAME\@$REALM1":"
#    if KEY1=`kinit -K $USERNAME\@$REALM1 | grep -v "key"`
#	then echo "OK";
#    else exit 1
#    fi
#    echo "Password for "$USERNAME\@$REALM2":"
#    if KEY2=`kinit -K $USERNAME\@$REALM2 | grep -v "key"`
#	then echo "OK";
#    else exit 1
#    fi

    echo "Password for "$USERNAME\@$REALM1":"
    if kinit -K $USERNAME\@$REALM1 > tmp
	then KEY1=`tail -n 1 tmp`; 
    else rm tmp; exit 1
    fi
    rm tmp

    echo "Password for "$USERNAME\@$REALM2":"
    if kinit -K $USERNAME\@$REALM2 > tmp
	then KEY2=`tail -n 1 tmp`; 
	else rm tmp; exit 1
    fi
    rm tmp
}

reset_card()
{
	$PAY <<- EOF
	$PORT
	jk 2		/* delete this? */
	jq
	ju
	q
	EOF
}

load_keys()
{
	echo "loading keys ..."
	$PAY <<- EOF
	$PORT
	jk 2
	$KEY1
	$KEY2
	q
	EOF
}

load_key_config_file()
{
	CRAP=`hexdump -v -e'/1 "%x "' $KEY_CONFIG_FILE`

	$PAY <<- EOF
	$PORT
	j
	f 3f.0
	i e4 00 00 02	/* delete old ky ; it's fine for this to fail */
	6b 79
	i e0 00 00 10	/* now create ky */
	00 f0 6b 79 02 01 00 00 FF 00 00 00 00 00 00 00
	f 6b.79
	i d6 0 $KCFG_LEN_UPPER $KCFG_LEN_LOWER
	$CRAP
	q
	EOF
}

format_card()
{
echo "Formatting .i file in the card..."

	$PAY <<- EOF
	$PORT
	j		/* verify AUT0 */
	f 3f.0		/* select root */
	i e4 00 00 02	/* delete old .i ; it's fine for this to fail */
	2e 69
	i e0 00 00 10	/* now create .i */
	00 90 2e 69 02 01 00 00 FF 00 00 00 00 00 00 00
	f 2e.69	        /* select .i */
	i d6 0 0 80	/* initialize .i with 0s */
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	q
	EOF
}

load_applet()
{
	$PAY <<- EOF
	$PORT
	ju -p $FILE_ID -c $INSTANCE_DIRECTORY_FID -a $AID
	jl -p $FILE_ID -c $INSTANCE_DIRECTORY_FID -a $AID -i $DATA_CONTAINDER_SIZE -s $DATA_DIRECTORY_SIZE $APPLET_NAME
	q	/* should we also reset default app? */
	EOF
}

update_dot_i()
{
	$PAY <<- EOF
	$PORT
	j
	f 3f.0
	f 2e.69
	i d6 0 0 10     /* initialize .i with 0s */
	6b 79 3f 0 ff ff ff ff 1 0 0 1 $KCFG_LEN_LOWER $KCFG_LEN_UPPER 0 0
	q
	EOF
}

case $# in
0) USERNAME=$USER ;;
1) USERNAME=$1 ;;
*) echo "Usage: kscinit.sh [username]" ; exit 1 ;;
esac

echo "Initialize smartcard for $USERNAME\n"

# call procedures
get_pay
get_userinfo
generate_key_config_file
get_keys
reset_card
load_keys
load_key_config_file
format_card
load_applet
update_dot_i

rm $KEY_CONFIG_FILE

exit 0

