//
//
// Krb.java
// Kerberos 5 / Smartcard project.  Works! :)
//
// NI, 3/20/1999
// 3/23, optimized
// 1/25/2000 working with table look up
// 7/4/2000 stop parsing key table in applet
// 
// "CITI-krb5"
// jl -a 434954492d6b726235 Krb.bin

import javacard.framework.*;
import javacardx.framework.*;
import javacardx.crypto.*;

public class Krb extends javacard.framework.Applet { 
    
    /* constants declaration */

    // buffer size
    final short bufsiz = (short)248;
    
    // CLA byte in the command APDU header 
    final byte Krb_CLA =(byte)0x03;
    
    // INS byte in the command APDU header
    final byte Decrypt = (byte) 0x10;
    final byte GetKeyNum = (byte) 0x20;
    final byte SET_KEY_NUM = (byte) 0x30;
    final byte GetResponse = (byte) 0xc0;
    final byte Select = (byte) 0xa4; 

    // Files, SCFS stuff
    final short dot_i = (short) 0x2e69;
    final short key_file = (short) 0x6b79;
    final short doti_size = (byte) 0x10; 
    final byte SCFS_OFFSET_FILELEN = 12;

      /* states:
     0  try to match principal name
     1  try to match realm name // unused 
     2  get key number
     3  get PIN */
    final static byte STATE_PRINC = 0;
    //private static final byte STATE_REALM = 1;
    final static byte STATE_KEY_NUM = 2;
    final static byte STATE_PIN = 3;
    final static byte KEY_BASE = 6; 
    
    /* instance variables declaration */ 
    byte apdu_buffer[]; // APDU buffer
    byte IV[];
    byte doti_buffer[]; // buffer for reading .i
    static byte pin[]; // buffer for reading key_file
    static byte pin_exist;
    static byte state;
    static byte null_str[];
    
    static byte des_key_num = KEY_BASE;
    // DES key table
    DES_Key deskey[];
    
    private Krb() { 
	// It is good programming practice to allocate
	// all the memory that an applet needs during its
	// lifetime inside the constructor
	//inbuf = new byte[bufsiz];
	//outbuf = new byte[bufsiz]; 

	doti_buffer = new byte [16]; // buffer for reading .i
	pin = new byte [8]; // buffer for PIN
	null_str = new byte [4]; // buffer for PIN
	null_str[0] = 0x4e;
	null_str[1] = 0x55;
	null_str[2] = 0x4c;
	null_str[3] = 0x4c;
	IV = new byte[64];
	IV[0] = (byte)0x0;
	IV[1] = (byte)0x0;
	IV[2] = (byte)0x0;
	IV[3] = (byte)0x0;
	IV[4] = (byte)0x0;
	IV[5] = (byte)0x0;
	IV[6] = (byte)0x0;
	IV[7] = (byte)0x0;

	// instantiate the DES key table
	deskey = new DES_Key[4];
	deskey[0] = new DES_Key((short)KEY_BASE);
	deskey[1] = new DES_Key((short)(KEY_BASE+1));
	//deskey[2] = new DES_Key((short)des_key_num);
	//deskey[3] = new DES_Key((short)des_key_num);
	deskey[0].setICV (IV, (short)0); // allocate the ICV location
	deskey[0].clearICV();
	deskey[1].setICV (IV, (short)0); // allocate the ICV location
	deskey[1].clearICV();
		
	register();
    } // end of the constructor 
    
    public static void install(APDU apdu){
	// create a Krb applet instance (card) 
	new Krb();
    } // end of install method
    
    public boolean select() { 
	// returns true to JCRE to indicate that the applet 
	// is ready to accept incoming APDUs.
	return true; 
	
    }// end of select method 
    
    public void process(APDU apdu) { 
	// APDU object carries a byte array (buffer) to 
	// transfer incoming and outgoing APDU header 
	// and data bytes between card and CAD
                apdu_buffer = apdu.getBuffer();
                // verify that if the applet can accept this
                // APDU message 
		// NI: change suggested by Wayne Dyksen, Purdue
		if ((apdu_buffer[ISO.OFFSET_CLA] == ISO.CLA_ISO) &&
		    (apdu_buffer[ISO.OFFSET_INS] == ISO.INS_SELECT)){
		    ISOException.throwIt(ISO.SW_NO_ERROR);
		}
		
                switch (apdu_buffer[ISO.OFFSET_INS]) {
		case GetResponse: return;
		case Select: return;
		case Decrypt: decrypt(apdu); return;
		case GetKeyNum: get_key_num (apdu); return;
		case SET_KEY_NUM: set_key_num (apdu); return; 
		default: ISOException.throwIt (ISO.SW_INS_NOT_SUPPORTED); 
                } 

        } // end of process method

    // Decrypt method
    private void decrypt(APDU apdu) {
	short byteRead = (short)(apdu.setIncomingAndReceive());
	if (byteRead > bufsiz || byteRead % (short)8 != 0) 
	    ISOException.throwIt(ISO.SW_WRONG_LENGTH);

	// DES decrypt
	//deskey.encryptECB(inbuf, (short)0, (short)8, inbuf, (short)0);
	//deskey.setICV (IV, (short)0); // allocate the ICV location
	//deskey.clearICV();
	deskey[des_key_num-KEY_BASE].decryptCBC(apdu_buffer, (short)ISO.OFFSET_CDATA, byteRead,
			  apdu_buffer, (short)ISO.OFFSET_CDATA);

	// inform system that the applet has finished processing
	// the command and the system should now prepare to 
	// construct a response APDU which contains data field
	
	apdu.setOutgoing(); 
	
	// indicate the number of bytes in the data field
	apdu.setOutgoingLength((short)(byteRead)); 

	// send return data at offset 8 in the APDU buffer
	apdu.sendBytesLong(apdu_buffer, (short)ISO.OFFSET_CDATA,
			   (short)(byteRead)); 
 
        } // end of Decrypt method
    // Get Key Number method
    /* initally, I just want to select the file
       specified by the 2 byte input from APDU. */
    /* actually, even before going there, let's select the root. */
    private void get_key_num(APDU apdu) {
	short byteRead = (short)apdu.setIncomingAndReceive();
	
	short file_to_select;
	short rv, i = 0, key_file_len = 0;
	pin_exist = (byte)0;

	// is the input length appropriate?
	if (byteRead > bufsiz) 
	    ISOException.throwIt(ISO.SW_WRONG_LENGTH);

		// is the input length appropriate?
	if (byteRead > bufsiz) 
	    ISOException.throwIt(ISO.SW_WRONG_LENGTH);

	// select root (3f.00)
	CyberflexFile.selectRoot();

	// select .i 
	rv = CyberflexFile.selectFile(dot_i);
	if (rv != ST.SUCCESS) {
	    ISOException.throwIt(ISO.SW_FILE_NOT_FOUND);
	}

	// find entry for "ky"
	// read on until readBinary() returns ST.INVALID_OFFSET
	for (i = (byte) 0; ; i++ ) {
	  rv = CyberflexOS.readBinaryFile(doti_buffer,
					  (short)0,
					  (short)(doti_size * i),
					  (short)(doti_size));
	  if (doti_buffer[0] == (byte)(key_file / 0x100) &&
	      doti_buffer[1] == (byte)(key_file % 0x100))
	    break; 
	  if (rv == ST.INVALID_OFFSET) {
	    ISOException.throwIt(ISO.SW_FILE_NOT_FOUND);
	  }
	  else if (rv != ST.SUCCESS) {
	    ISOException.throwIt(ISO.SW_FILE_INVALID);
	  }
	}

	// what's the length of "ky"?
	key_file_len = (short) doti_buffer[SCFS_OFFSET_FILELEN];

	// select "ky"
	rv = CyberflexFile.selectFile(key_file);
	if (rv != ST.SUCCESS) {
	  ISOException.throwIt(ISO.SW_FILE_NOT_FOUND);
	}

	// now read "ky"
	rv = CyberflexOS.readBinaryFile(apdu_buffer,
					(short)0,
					(short)0,
					key_file_len);
	if (rv != ST.SUCCESS) {
	    ISOException.throwIt(ISO.SW_FILE_INVALID);
	}

	// parse "ky" and look for principal@realm string


	/*apdu.setOutgoing(); 
	apdu.setOutgoingLength (key_file_len); 
	apdu.sendBytesLong (apdu_buffer, (short)0, 
	key_file_len);*/

	apdu.setOutgoingAndSend((short)0, key_file_len);
	
	return; 
    }

    // Set Key Number method
    // read 1 byte and set it to des_key_num. 
    private void set_key_num(APDU apdu) {
	short byteRead = (short)apdu.setIncomingAndReceive();

	if (byteRead != (short)1) 
	  ISOException.throwIt((short)0x6701);

	des_key_num = apdu_buffer [ISO.OFFSET_CDATA];
	ISOException.throwIt((short)0x9000);
    }
} // end of class Krb 
