/* XCard - 1.0 X Windows Smartcard formatting Utility
 *
 *   Copyright 1998 by David Corcoran
 *   Tk/Tcl / C
 *
 *   Modifications to support Open16K, Copyright 1998 Schlumberger, All Rights Reserved.
 *
 *   Danny Kumamoto 2-Nov-1998 Make it work for Open16K/Simens
 *   Modified by Carlos Prados to use CT-API shared library
 *   Modified by Danny Kumamoto, 25-Feb-2000 to work with CT-API and Access and
 *     now support for PCSC with Dave Corcoran's help.
 *
 * This software is covered under the GNU public LICENSE.
 *           See LICENSE for more information
 *
 */

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include "./drv/dbiiso.h"
#include "./drv/filesystem.h"
#include "./drv/security.h"
#include "./drv/operation.h"
#include <des.h>
#ifdef PCSCLITE_READER_CONF
#define PCSC_READER_CONF PCSCLITE_READER_CONF
#else
#define PCSC_READER_CONF "/etc/reader.conf"
#endif /* PCSCLITE_READER_CONF */

struct BinData bindata;

BYTE Status;
BYTE Init;
BYTE FileType;
BYTE SelFile[2] = {0x3F, 0x00};
BYTE AID[MAX_AID_LENGTH];
BYTE AID_len = 0;

char CardletName[MAX_PATH_LEN];
char CardletAID[MAX_BUFFER_SIZE];
char CardletFileID[MAX_BUFFER_SIZE];
char CardletContainerID[MAX_BUFFER_SIZE];
char CardletDataSize[MAX_BUFFER_SIZE];
char CardletSignKey[MAX_BUFFER_SIZE];
char VerifyKeyString[MAX_BUFFER_SIZE];
char XcardReader[MAX_PATH_LEN];
#define MAX_SC_READER 24
char ReaderList[MAX_SC_READER][MAX_BUFFER_SIZE];
int ReaderListCounter;

void clean_line(char *workstring)
{
  char * s, *t;

  for (s = workstring, t = workstring; *t; t++) {
    if (isspace((int) *t))
      continue;
    *s++ = *t /*(char)toupper((int)*t)*/;
  }
  *s = 0; /* make sure the string is closed off correctly */
}


void PlaceImage(BYTE filetype, BYTE *FileName) { /* Put correct picture on screen */

	/* File or Directory image ?????? */

   if ((filetype == 0x38)&&((FileName[0]==0x3F)&&(FileName[1]==0x00))) {
       ET( .f2.lblrd configure -image rootdir );
   } 
   else if (filetype == 0x1 || filetype == 0x2) {
    ET( .f2.lblrd configure -image dir );
   } 
   else if ((FileName[0] == 0x00) && (FileName[1] == 0x11)) {
    ET( .f2.lblrd configure -image key );
   } 
   else if ((FileName[0] == 0x00) && (FileName[1] == 0x01)) {
    ET( .f2.lblrd configure -image key );
   } 
   else if ((FileName[0] == 0x00) && (FileName[1] == 0x00)) {
    ET( .f2.lblrd configure -image pin );
   } 
   else {
    ET( .f2.lblrd configure -image regfile );
   }

}

BYTE * StringToHex (BYTE *passed, int size) {
  
  int i;
  BYTE hexvalue;
  static BYTE buffer[MAX_BUFFER_SIZE];
  int counter = 0;
  int len = strlen(passed);
  BYTE c[MAX_BUFFER_SIZE];
  
  if (size & 1) {
    printf("%warning: sized passed into StringToHex was %d but forced to be even\n", size++);
    /* we should always be even number */
  }
  if (len < size) {     /* if user enters less than max, then pad with zeros */
    int diff = size - len;
    for (i = 0; i < diff; i++)
      c[i] = '0';
    strcpy(&c[diff], passed);
  }
  else {
    strcpy(c, passed);
    c[size] = 0; /* if too big, just truncate it at the max "size" */
  }
  for (i=0; i < size; i+=2) {
    switch (c[i]) {
    case 'A': case 'a':
      hexvalue = 0xa0; 
      break;
    case 'B': case 'b':
      hexvalue = 0xb0;
      break;
    case 'C': case 'c':
      hexvalue = 0xc0;
      break;
    case 'D': case 'd':
      hexvalue = 0xd0;
      break;
    case 'E': case 'e':
      hexvalue = 0xe0;
      break;
    case 'F': case 'f':
      hexvalue = 0xf0;
      break;
      
    default:
      if (c[i] >= '0' && c[i] <= '9')
	hexvalue = 16 * (c[i] - 48);
      else {
	hexvalue = 0;    
	printf("?invalid hex number %c\n", c[i]);
      }
      break;
    }
    
    switch (c[i+1]) {
    case 'A': case 'a':
      hexvalue += 0x0a; 
      break;
    case 'B': case 'b':
      hexvalue += 0x0b;
      break;
    case 'C': case 'c':
      hexvalue += 0x0c;
      break;
    case 'D': case 'd':
      hexvalue += 0x0d;
      break;
    case 'E': case 'e':
      hexvalue += 0x0e;
      break;
    case 'F': case 'f':
      hexvalue += 0x0f;
      break;
      
    default:
      if (c[i+1] >= '0' && c[i+1] <= '9')
	hexvalue += c[i+1] - 48;
      else
	printf("?invalid hex number %c\n", c[i+1]);
      break;
    }
    
    buffer[counter++] = hexvalue;
    
  }
  
  return buffer;
}


char *HexToString (BYTE *c, int size) {
  
  int i;
  static char buffer[MAX_BUFFER_SIZE];
  int count = 0;
  int value1, value2;
  
  for (i=0; i < size; i++) {
    value1 = c[i] / 16;
    value2 = c[i] % 16;
    
    switch (value1) {
    case 10: buffer[count++] = 'A'; break;
    case 11: buffer[count++] = 'B'; break;
    case 12: buffer[count++] = 'C'; break;
    case 13: buffer[count++] = 'D'; break;
    case 14: buffer[count++] = 'E'; break;
    case 15: buffer[count++] = 'F'; break;
    default:
      buffer[count++] = value1 + 48; break;
    }
    
    switch (value2) {
    case 10: buffer[count++] = 'A'; break;
    case 11: buffer[count++] = 'B'; break;
    case 12: buffer[count++] = 'C'; break;
    case 13: buffer[count++] = 'D'; break;
    case 14: buffer[count++] = 'E'; break;
    case 15: buffer[count++] = 'F'; break;
    default:
      buffer[count++] = value2 + 48; break;
    }
    
  }
  
  buffer[count++] = '\0';
  
  return buffer;
}

char *HexToASCII (BYTE *c, int size) {
  
  int i;
  static char buffer[MAX_BUFFER_SIZE];
  int count = 0;
  int value1, value2;
  
  for (i=0; i < size; i++) {
    if (c[i] == 0x5c) {
      buffer[count++] = '\\';
      buffer[count++] = '\\';
    }
    else if (c[i] >= 0x20 && c[i] <= 0x7e) {
      buffer[count++] = c[i];
    }
    else {
      buffer[count++] = '\\';
      buffer[count++] = '0';
      buffer[count++] = '0' + (BYTE) (c[i] >> 6 & 0x7);
      buffer[count++] = '0' + (BYTE) (c[i] >> 3 & 0x7);
      buffer[count++] = '0' + (BYTE) (c[i] & 0x7);
    }
  }
  
  buffer[count++] = '\0';
  
  return buffer;
}

/* return 1 if bad file ID */
static int checkFileID(fileid, idtype)
BYTE *fileid;
char *idtype;
{
  if ((((BYTE)0x3F) == fileid[0] && ((BYTE)0x00) == fileid[1]) ||
      (((BYTE)0xFF) == fileid[0] && ((BYTE)0xFF) == fileid[1]) ||
      (((BYTE)0x00) == fileid[0] && ((BYTE)0x01) == fileid[1]) ||
      (((BYTE)0x00) == fileid[0] && ((BYTE)0x00) == fileid[1])
      ) {
    ET( tk_messageBox -default ok -icon info -message \
	{%s(idtype) ID must not be 3F00, 0000, 0001, FFFF} \
	-title {invalid ID} -type ok );
    return TRUE;
  }
  return FALSE;
}


static int convert_AID_str_to_byte(char *aidstr, BYTE *aidbyte, int errorFlag) {
  int aid_len;

  aid_len = strlen(aidstr);
  if (aid_len > 2 && aidstr[0] == '"' && aidstr[aid_len - 1] == '"') {
    /* just copy the bytes, since we have ASCII text */
    aid_len -= 2;
    if (aid_len > MAX_AID_LENGTH)
      aid_len = MAX_AID_LENGTH;
    memcpy(aidbyte, &aidstr[1], aid_len);
  }
  else {
    char tempStr[MAX_BUFFER_SIZE];
    BYTE * return_val;

    if (aid_len > MAX_AID_LENGTH*2)
      aid_len = MAX_AID_LENGTH*2;
    if (aid_len & 1) {
      /* make sure we get an even number */
      strcpy(tempStr, "0"); /* start with zero */
      strcpy(&tempStr[1], aidstr); /* append the rest */
      aidstr = tempStr;
      aid_len++; 
    }
    return_val= StringToHex(aidstr, aid_len);
    aid_len /= 2;
    memcpy(aidbyte, return_val, aid_len);
  }
  if (aid_len < 5) {
    int i;
    if (errorFlag) {
      ET( tk_messageBox -default ok -icon info -message \
         {AID must be greater than 4 bytes} \
         -title {small aid} -type ok );
    }
    for (i = 0; i < MAX_AID_LENGTH; i++) {
      aidbyte[i] = 0;
    }
    aid_len = 0;
  }
  return aid_len;
} /* convert_AID_str_to_byte() */

BYTE global_status[2];



bool Tk_Check_Warning(bool ShowSuccess) {	/* Checks Command Status to determine the warning window */
  char statusString[MAX_BUFFER_SIZE];

  DBI_IsoGet(ISO_GET_SW, global_status);

  sprintf(statusString, "SC Status Word: %2.2X%2.2X", global_status[0],
	  global_status[1]);
  ET( .f1.textMesg delete 0 end );
  ET( .f1.textMesg insert 0 "%s(statusString)" );

  if ((global_status[0] == 0x90) && (global_status[1] == 0x00)) {
    if (ShowSuccess) {
      ET( tk_dialog .warning "Confirm" "Command Successful" warning 0 OK Cancel );
    }
    return TRUE;
    
  } else if (global_status[0] == SC_MORE_INFO) {
    if (ShowSuccess) {
      ET( tk_dialog .warning "Confirm" "Command Successfull" warning 0 OK Cancel );
    }
    return TRUE;
  } else if (global_status[0] == 0x69 && global_status[1] == 0x82) {
    
    ET( tk_dialog .warning "Priviledges" "Access Priviledges\n   Not Fullfilled" warning 0 OK Cancel );
    return FALSE;
    
  } else {

    printf("?Error returned: %#2.2X%2.2X !\n", global_status[0], global_status[1]);
    ET( tk_dialog .warning "Confirm" "Command Failed !" warning 0 OK Cancel );
    return FALSE;
  }
  
}

void Show_Warning(char *message) {	/* Places a Dialog Window */
  
      ET( tk_dialog .warning "Message" %q(message) warning 0 OK Cancel );
}    

ET_PROC( Type ) {	/* Resets and turns on reader */

  BYTE Atr[50];
  int Length;
  char *atr;
  
  if (DBI_IsoReset(Atr, &Length) == DBI_FAST_OK) {
    atr = HexToString(Atr,8);
    SelFile[0] = 0x3F; SelFile[1] = 0x00;
    ET( .f1.textMesg delete 0 end );
    ET( .f1.textMesg insert 0 "Reader Activated " );
    ET( .f2.lblcf configure -text "3F00" );
    ET( .f2.lblrd configure -image rootdir );
    ET( .status configure -text "ATR: %s(atr)" );

  }
  else {
    ET( .f1.textMesg delete 0 end );
    ET( .f1.textMesg insert 0 "Reader Fault " );
  }

  return ET_OK;
}

static actual_DeActivate() {
  if (DBI_IsoOff() == DBI_FAST_OK) {
    ET( .f1.textMesg delete 0 end );
    ET( .f1.textMesg insert 0 "Reader Deactivated " );
  }
  else {
    ET( .f1.textMesg delete 0 end );
    ET( .f1.textMesg insert 0 "Reader Fault " );
  }
}
ET_PROC( DeActivate ) {	/* Deactivates smartcard Reader */
  
  actual_DeActivate();
  return ET_OK;
}

ET_PROC( CreateNow ) { 	/* Creates New File on Card */
  
  BYTE *size; BYTE *fileid; BYTE *conditions; BYTE *acckeys; BYTE *rlength; BYTE *numrec;
  
  BYTE Size[2]; BYTE FileId[2]; BYTE Conditions[8]; BYTE AccessKeys[3];
  BYTE NumRecords; BYTE RLength;
  char *buttons; 
  int i;
  
  buttons = ET_STR( set filetype );
  
  switch (buttons[0]) {
  case '1':
    FileType = ISO_FILE_DEDICATED; break;
  case '2':
    FileType = ISO_FILE_APPLICATION; break;
  case '3':
    FileType = ISO_FILE_BINARY; break;
  case '4':
    FileType = ISO_FILE_PROGRAM; break;
  case '5':
    FileType = ISO_FILE_CYCLIC; break;
  case '6':
    FileType = ISO_FILE_VARIABLE_RECORD; break;
  case '7':
    FileType = ISO_FILE_FIXED_RECORD; break;
    
  default:
    ET( destroy .wincf ); break;
  }
  
  buttons = ET_STR( set zero );
  
  if (buttons[0] == '1')
    Init = 0x00;
  else
    Init = 0xFF;
  
buttons = ET_STR( set valid );
 
 if (buttons[0] == '1')
   Status = 0x01;
 else
   Status = 0x00;
 
 size  = StringToHex(ET_STR( .wincf.f.f1.entby get ), 4);
 memcpy(Size,size,2);
 
 fileid = StringToHex(ET_STR( .wincf.f.f2.entfi get ), 4);
 memcpy(FileId,fileid,2);
 
 conditions = StringToHex(ET_STR( .wincf.f.f3.entac get ), 16);
 memcpy(Conditions,conditions,8);
 
 /* acckeys = StringToHex(ET_STR( .wincf.f.f4.entak get ), 6);
    memcpy(AccessKeys,acckeys,3);*/
 AccessKeys[0] = 0; /* these are ignored for now anyway */
 AccessKeys[1] = 0;
 AccessKeys[2] = 0;
 
 numrec = StringToHex(ET_STR( .wincf.f.f5.entnr get ), 2);
 NumRecords = numrec[0];
 
 rlength = StringToHex(ET_STR( .wincf.f.f6.entrl get ), 2);
 RLength = rlength[0];
 
 if (File_CreateFile (Init, NumRecords, Size, FileId, FileType, 
			    Conditions, Status, AccessKeys, RLength, &bindata)) {
   
   if (DBI_IsoCase3 (bindata.Header, bindata.TxBuffer)) {
     
     if (Tk_Check_Warning(TRUE)) {
       ET( destroy .wincf );
       ET( .f1.textMesg delete 0 end );
       ET( .f1.textMesg insert 0 "File Created Successfully" );
       return ET_OK;
     }
   }
   
 }
 
 Tk_Check_Warning(FALSE);
 return ET_OK;
}


ET_PROC( DeleteFile ) { 	/* Deletes existing file on Card */
  BYTE status[2];
  BYTE Return[MAX_BUFFER_SIZE];

  if (checkFileID(SelFile, "To DELETE, the selected file")) {
    return ET_OK;
  }

  /* read file header, if application, delete carefully, if dir, delete all files first,
     if element, delete it -- but only if the last file in the list */
  File_Select(2, SelFile, &bindata);
  DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
  if (!Tk_Check_Warning(FALSE))
    return ET_OK;
  DBI_IsoGet(ISO_GET_SW, status);
  if (status[0] == SC_MORE_INFO) {
    Operation_GetResponse(status[1],&bindata);
    DBI_IsoCase2(bindata.Header,Return);
    if (Return[6] == ISO_FILETYPE_DEDICATED && status[1] == 0x28) {
      /* we have an applet */
      File_SelectDF(&bindata);
      DBI_IsoCase1(bindata.Header);
      if (!Tk_Check_Warning(FALSE))
	return ET_OK;
      File_DeleteFile(2, SelFile, &bindata);
      DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
      DBI_IsoGet(ISO_GET_SW, status);
      if (status[0] == 0x6F && status[1] == 0x11) {
	/* if dir not empty, keep trying... */
	File_Select(2, SelFile, &bindata);
	DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;
	File_DeleteAll(&bindata);
	DBI_IsoCase1(bindata.Header);
	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;
	File_SelectDF(&bindata);
	DBI_IsoCase1(bindata.Header);
	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;
	File_DeleteFile(2, SelFile, &bindata);
	DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
      } /* keep trying only if dir is not empty error */
      Tk_Check_Warning(TRUE);
    }
    else {
      ET( tk_messageBox -default ok -icon info -message \
	  {Cannot delete non-applet for now} \
	  -title {Not delete non-applet} -type ok );
    }
  }
  return ET_OK;
}
  
ET_PROC( CreateFile ) { 	/* Creates New File on Card */
  
  ET( global filetype );
  ET( toplevel .wincf );
  ET( wm title .wincf "Create New File" );
  ET( wm transient .wincf . );
  ET( wm geometry .wincf +$winw+$winh );
  
  ET( frame .wincf.mb -relief groove -borderwidth 2 );

  ET( frame .wincf.f0 -relief groove -borderwidth 2 );
  ET( frame .wincf.f -relief groove -borderwidth 2 );
  ET( frame .wincf.f1 -relief groove -borderwidth 2 );
  ET( frame .wincf.f2 -relief groove -borderwidth 2 );
  
  ET( frame .wincf.f0.f1 -relief groove -borderwidth 0 );
  ET( frame .wincf.f0.f2 -relief groove -borderwidth 0 );
  ET( frame .wincf.f0.f3 -relief groove -borderwidth 0 );
  ET( frame .wincf.f0.f4 -relief groove -borderwidth 0 );
  ET( frame .wincf.f0.f5 -relief groove -borderwidth 0 );
 
  ET( label .wincf.f0.f5.fileimg -image regfile; pack .wincf.f0.f5.fileimg -side left );
  ET( label .wincf.f0.f5.dirimg -image dir; pack .wincf.f0.f5.dirimg -side left );

  /* Create the Menu Bar */
 
  ET( menubutton .wincf.mb.menufile -text "File" -menu .wincf.mb.menufile.menu; pack .wincf.mb.menufile -side left );
  ET( menubutton .wincf.mb.menuAdmin -text "Administrative" -menu .wincf.mb.menuAdmin.menu; pack .wincf.mb.menuAdmin -side left );
  ET( menubutton .wincf.mb.menuhelp -text "Help" -menu .wincf.mb.menuhelp.menu; pack .wincf.mb.menuhelp -side right );
  
  ET( menu .wincf.mb.menufile.menu );
  ET( menu .wincf.mb.menuAdmin.menu );
  ET( menu .wincf.mb.menuhelp.menu );
  
  ET( .wincf.mb.menufile.menu add command -label "Close" -command { destroy .wincf } );  

  ET( .wincf.mb.menuAdmin.menu add command -label " APDU Manager " -command APDU_Manager );
  /*  ET( .wincf.mb.menuAdmin.menu add command -label " Create PIN " -command PINGen );*/
  ET( .wincf.mb.menuAdmin.menu add command -label " Verify Key " -command VerifyKey );
  /* ET( .wincf.mb.menuAdmin.menu add command -label " Verify CHV " -command VerifyCHV );*/
  /*  ET( .wincf.mb.menuAdmin.menu add command -label " Verify PIN " -command VerifyPIN );*/

  ET( .wincf.mb.menuhelp.menu add command -label " Help Topics " -command HelpTopics );
  ET( .wincf.mb.menuhelp.menu add command -label " About XCard " -command HelpXCard );


  ET( label .wincf.f0.lblnw -text "Create New File Type"; pack .wincf.f0.lblnw );
  
  ET( radiobutton .wincf.f0.f1.radde -text "Dedicated (dir) File" -variable filetype -value 1 -anchor w; pack .wincf.f0.f1.radde -side left );
  ET( radiobutton .wincf.f0.f1.radap -text "Application File" -variable filetype -value 2 -anchor w; pack .wincf.f0.f1.radap -side left );
  ET( radiobutton .wincf.f0.f2.radbf -text "Binary File" -variable filetype -value 3 -anchor w; pack .wincf.f0.f2.radbf -side left );
  ET( radiobutton .wincf.f0.f2.radpf -text "Program File" -variable filetype -value 4 -anchor w; pack .wincf.f0.f2.radpf -side left );
  ET( radiobutton .wincf.f0.f3.radcy -text "Cyclic File" -variable filetype -value 5 -anchor w; pack .wincf.f0.f3.radcy -side left );
  ET( radiobutton .wincf.f0.f3.radvr -text "Variable Rec. File" -variable filetype -value 6 -anchor w; pack .wincf.f0.f3.radvr -side left );
  ET( radiobutton .wincf.f0.f3.radfr -text "Fixed Rec. File" -variable filetype -value 7 -anchor w; pack .wincf.f0.f3.radfr -side left );
  ET( checkbutton .wincf.f0.f4.chkin -text "Write Zeros ?" -variable zero; pack .wincf.f0.f4.chkin -side left );
  ET( checkbutton .wincf.f0.f4.chkvl -text "Validate ?" -variable valid ; .wincf.f0.f4.chkvl select; pack .wincf.f0.f4.chkvl -side right );
  ET( pack .wincf.f0.lblnw .wincf.f0.f1 .wincf.f0.f2 .wincf.f0.f3 -fill x);
  ET( pack .wincf.f0.f4 -side bottom -fill x );
  ET( pack .wincf.f0.f5  -side bottom );
  
  ET( button .wincf.f2.butok -text "  Create  " -command CreateNow; pack .wincf.f2.butok -side left );
  ET( button .wincf.f2.butcn -text "  Cancel  " -command { destroy .wincf }; pack .wincf.f2.butcn -side right );
  ET( pack .wincf.f2 -fill x);
  
  ET( frame .wincf.f.f1 -relief groove -borderwidth 2 );
  ET( frame .wincf.f.f2 -relief groove -borderwidth 2 );
  ET( frame .wincf.f.f3 -relief groove -borderwidth 2 );
  ET( frame .wincf.f.f4 -relief groove -borderwidth 2 );
  ET( frame .wincf.f.f5 -relief groove -borderwidth 2 );
  ET( frame .wincf.f.f6 -relief groove -borderwidth 2 );
  
  ET( label .wincf.f.f1.lblby -text "Size (bytes in hex)"; pack .wincf.f.f1.lblby -side left );
  ET( entry .wincf.f.f1.entby -width 4; pack .wincf.f.f1.entby -side right );
  
  ET( label .wincf.f.f2.lblfi -text "File Id"; pack .wincf.f.f2.lblfi -side left );
  ET( entry .wincf.f.f2.entfi -width 4; pack .wincf.f.f2.entfi -side right );
  
  ET( label .wincf.f.f3.lblac -text "Access Bytes (8)"; pack .wincf.f.f3.lblac -side left );
  ET( entry .wincf.f.f3.entac -width 16; pack .wincf.f.f3.entac -side right );
  
  /*  ET( label .wincf.f.f4.lblak -text "Access Keys"; pack .wincf.f.f4.lblak -side left );
      ET( entry .wincf.f.f4.entak -width 6; pack .wincf.f.f4.entak -side right );*/
  
  ET( label .wincf.f.f5.lblnr -text "Number of Records"; pack .wincf.f.f5.lblnr -side left );
  ET( entry .wincf.f.f5.entnr -width 2; pack .wincf.f.f5.entnr -side right );
  
  ET( label .wincf.f.f6.lblrl -text "Record Length"; pack .wincf.f.f6.lblrl -side left );
  ET( entry .wincf.f.f6.entrl -width 2; pack .wincf.f.f6.entrl -side right );
  
  ET( pack .wincf.f.f1 .wincf.f.f2 .wincf.f.f3 .wincf.f.f4 .wincf.f.f5 .wincf.f.f6 -fill x);
  

  ET( grid config .wincf.mb -column 0 -row 0 -columnspan 2 -sticky snew );  
  ET( grid config .wincf.f0 -column 0 -row 1 -sticky snew );
  ET( grid config .wincf.f -column 1 -row 1 -sticky snew );
  ET( grid config .wincf.f1 -column 0 -row 2 -sticky snew );
  ET( grid config .wincf.f2 -column 0 -row 3 -sticky snew -columnspan 2 );
  
  return ET_OK;	
}


ET_PROC( SendNow ) { /* send the APDU to the card */
  BYTE *return_val;
  BYTE send_only;
  char work_buff[MAX_BUFFER_SIZE];
  int i;
  
  return_val = StringToHex(ET_STR(.winam.f1.entcl get), 2);
  bindata.Header[0] = return_val[0];
  
  return_val = StringToHex(ET_STR(.winam.f2.entcm get), 2);
  bindata.Header[1] = return_val[0];

  return_val = StringToHex(ET_STR(.winam.f3.entp1 get), 2);
  bindata.Header[2] = return_val[0];
  
  return_val = StringToHex(ET_STR(.winam.f4.entp2 get), 2);
  bindata.Header[3] = return_val[0];

  return_val = ET_STR( set direction );
  switch (return_val[0]) {
  case '1':
    send_only = TRUE;
    break;
  case '2':
  default:
    send_only = FALSE;
    break;
  }

  if (send_only) {
    char * work_str = ET_STR(.winam.f7.txt get 0.0 end);
    int len;

    strcpy(work_buff, work_str);
    clean_line(work_buff);
    len = strlen(work_buff);
    if (len > 0) {
      if (len & 1)
	len++; /* make sure we get an even count */
      if (len > 0x40*2)
	len = 0x40*2;
      return_val = StringToHex(work_buff, len);
      memcpy(bindata.TxBuffer, return_val, len/2);
      bindata.Header[4] = len/2;
    }
    else
      bindata.Header[4] = 0;
  }
  else {
    return_val = StringToHex(ET_STR(.winam.f6.entp3 get), 2);
    bindata.Header[4] = return_val[0];
    if (! bindata.Header[4])
      send_only = TRUE; /* turn this into case 1, since no data is coming back */
  }
  
  printf("Sending ");
  if (send_only) {
    if (bindata.Header[4]) {
      printf("case4: %2.2X %2.2X %2.2X %2.2X, %2.2X,",
	     bindata.Header[0], bindata.Header[1], bindata.Header[2],
	     bindata.Header[3], bindata.Header[4]);
      for (i = 0; i < bindata.Header[4]; i++)
	printf(" %2.2X", bindata.TxBuffer[i]);
      printf(",\n");
      DBI_IsoCase3(bindata.Header, bindata.TxBuffer);
    }
    else {
      printf("case1: %2.2X %2.2X %2.2X %2.2X, %2.2X,,\n",
	     bindata.Header[0], bindata.Header[1], bindata.Header[2],
	     bindata.Header[3], bindata.Header[4]);
      DBI_IsoCase1(bindata.Header);
    }
    Tk_Check_Warning(TRUE);
    printf("Return status: %2.2X%2.2X\n", global_status[0], global_status[1]);
  }
  else {
    BYTE Return[MAX_BUFFER_SIZE];

      printf("case2: %2.2X %2.2X %2.2X %2.2X,,,%2.2X\n",
	     bindata.Header[0], bindata.Header[1], bindata.Header[2],
	     bindata.Header[3], bindata.Header[4]);
    DBI_IsoCase2(bindata.Header, Return);
    Tk_Check_Warning(TRUE);
    printf("Return:");
    for (i = 0; i < bindata.Header[4]; i++)
      printf(" %2.2X", Return[i]);
    printf(" %2.2X%2.2X\n", global_status[0], global_status[1]);
  }
  return ET_OK;
}

ET_PROC( APDU_Manager ) {
  
  ET( toplevel .winam );
  ET( wm title .winam "APDU manager" );
  ET( wm transient .winam . );
  ET( wm geometry .winam +$winw+$winh );
  ET( frame .winam.f1 -relief groove -borderwidth 2 );
  ET( frame .winam.f2 -relief groove -borderwidth 2 );
  ET( frame .winam.f3 -relief groove -borderwidth 2 );
  ET( frame .winam.f4 -relief groove -borderwidth 2 );
  ET( frame .winam.f5 -relief groove -borderwidth 2 );
  ET( frame .winam.f6 -relief groove -borderwidth 2 );
  ET( frame .winam.f7 -relief groove -borderwidth 2 );
  ET( frame .winam.f8 -relief groove -borderwidth 2 );
  /*  ET( frame .winam.f5 -relief raised -borderwidth 2 );*/

  /* no image so far: ET( label .winam.f5.key -image key; pack .winam.f5.key );  */

  ET( label .winam.f1.lblcl -text "Class"; pack .winam.f1.lblcl -side left );
  ET( entry .winam.f1.entcl -width 2; pack .winam.f1.entcl -side right );
  ET( .winam.f1.entcl insert 0 "00" );

  ET( label .winam.f2.lblcm -text "Command"; pack .winam.f2.lblcm -side left );
  ET( entry .winam.f2.entcm -width 2; pack .winam.f2.entcm -side right );
  ET( .winam.f2.entcm insert 0 "00" );  
  
  ET( label .winam.f3.lblp1 -text "Param 1"; pack .winam.f3.lblp1 -side left );
  ET( entry .winam.f3.entp1 -width 2; pack .winam.f3.entp1 -side right );
  ET( .winam.f3.entp1 insert 0 "00" );  

  ET( label .winam.f4.lblp2 -text "Param 2"; pack .winam.f4.lblp2 -side left );
  ET( entry .winam.f4.entp2 -width 2; pack .winam.f4.entp2 -side right );
  ET( .winam.f4.entp2 insert 0 "00" );  

  ET( radiobutton .winam.f5.radsn -text "Send" -variable direction -value 1 -anchor w; pack .winam.f5.radsn -side left );
  ET( radiobutton .winam.f5.radrc -text "Receive" -variable direction -value 2 -anchor w; pack .winam.f5.radrc -side left );
  ET( .winam.f5.radrc select );

  ET( label .winam.f6.lblp3 -text "Length (auto for Send)"; pack .winam.f6.lblp3 -side left );
  ET( entry .winam.f6.entp3 -width 2; pack .winam.f6.entp3 -side right );
  ET( .winam.f6.entp3 insert 0 "00" );  

  ET( label .winam.f7.lbl -text "Data (max\n 64 bytes)" );
  ET( text .winam.f7.txt -width 10 -height 3 -wrap word -yscrollcommand ".winam.f7.scroll set" );
  ET( scrollbar .winam.f7.scroll -command ".winam.f7.txt yview" );
  ET( pack .winam.f7.lbl -side left );
  ET( pack .winam.f7.txt -side right );
  ET( pack .winam.f7.scroll -side right -fill y );

  ET( button .winam.f8.butvr -text "  Send APDU  " -command SendNow; pack .winam.f8.butvr -side left );
  ET( button .winam.f8.butcn -text "  Cancel  " -command {destroy .winam}; pack .winam.f8.butcn -side right );
  
  /*  ET( pack .winam.f5 -side left -fill y );*/
  ET( pack .winam.f1 -fill x );
  ET( pack .winam.f2 -fill x );
  ET( pack .winam.f3 -fill x );
  ET( pack .winam.f4 -fill x );
  ET( pack .winam.f5 -fill x );
  ET( pack .winam.f6 -fill x );
  ET( pack .winam.f7 -fill x );
  ET( pack .winam.f8 -fill x );
  
  return ET_OK;
}

ET_PROC( VerifyNow ) {
  
  BYTE *keynum; BYTE *keysize; BYTE *key;
  BYTE KeyNum; BYTE KeySize; BYTE Key[20];
  char *keystr;
  int i;
  
  keynum = StringToHex(ET_STR(.winvk.f1.entkn get), 2);
  KeyNum = keynum[0];
  
  keysize = StringToHex(ET_STR(.winvk.f2.entks get), 2);
  KeySize = keysize[0];
  
  keystr = ET_STR(.winvk.f3.entky get);
  if (strcmp(VerifyKeyString, keystr)) {
    strcpy(VerifyKeyString, keystr); /* save if new key */
  }
  key = StringToHex(keystr, KeySize*2);
  memcpy(Key,key,KeySize);
  
  if (Security_VerifyKey (KeyNum,KeySize,Key,&bindata)) {
    if (DBI_IsoCase3 (bindata.Header, bindata.TxBuffer)) {
      if (Tk_Check_Warning(FALSE)) {
	ET( destroy .winvk );
	return ET_OK;
      }
    }
  }
  
  Tk_Check_Warning(FALSE);
  return ET_OK;	
}

ET_PROC( VerifyKey ) { /* verify key command (AUT0 is needed for download */
  
  ET( toplevel .winvk );
  ET( wm title .winvk "Key Verification" );
  ET( wm transient .winvk . );
  ET( wm geometry .winvk +$winw+$winh );
  ET( frame .winvk.f1 -relief groove -borderwidth 2 );
  ET( frame .winvk.f2 -relief groove -borderwidth 2 );
  ET( frame .winvk.f3 -relief groove -borderwidth 2 );
  ET( frame .winvk.f4 -relief groove -borderwidth 2 );
  ET( frame .winvk.f5 -relief raised -borderwidth 2 );

  ET( label .winvk.f5.key -image key; pack .winvk.f5.key );  

  ET( label .winvk.f1.lblkn -text "Key Number (Hex XX)"; pack .winvk.f1.lblkn -side left );
  ET( entry .winvk.f1.entkn -width 2; pack .winvk.f1.entkn -side right );
  /*  ET( .winvk.f1.entkn insert 0 "01" );  */
  ET( .winvk.f1.entkn insert 0 "00" );

  ET( label .winvk.f2.lblks -text "Key size (Hex XX)"; pack .winvk.f2.lblks -side left );
  ET( entry .winvk.f2.entks -width 2; pack .winvk.f2.entks -side right );
  ET( .winvk.f2.entks insert 0 "08" );  
  
  ET( label .winvk.f3.lblky -text "Key (Hex No Spaces)"; pack .winvk.f3.lblky -side left );
  ET( entry .winvk.f3.entky -width 20; pack .winvk.f3.entky -side right );
  ET( .winvk.f3.entky insert 0 %s(VerifyKeyString) );

  ET( button .winvk.f4.butvr -text "  Verify  " -command VerifyNow; pack .winvk.f4.butvr -side left );
  ET( button .winvk.f4.butcn -text "  Cancel  " -command {destroy .winvk}; pack .winvk.f4.butcn -side right );
  
  ET( pack .winvk.f5 -side left -fill y );
  ET( pack .winvk.f1 -fill x );
  ET( pack .winvk.f2 -fill x );
  ET( pack .winvk.f3 -fill x );
  ET( pack .winvk.f4 -fill x );
  
  return ET_OK;
}

ET_PROC( PINNow ) {	/* Verifies a PIN number */

  BYTE *pinsize; BYTE *pin;
  BYTE PinSize; 
  BYTE Pin[8];
  int r;  

  pinsize = ET_STR(.winpv.f1.entps get);
  PinSize = pinsize[0] - 48;

  pin = (BYTE *)strdup(ET_STR(.winpv.f2.entpn get));

  for (r=0; r < PinSize; r++)
    Pin[r] = pin[r] + 0;

  for (r=PinSize; r < 8; r++)
    Pin[r] = 0xff;

  if (Security_VerifyPIN (0x08,Pin,&bindata)) {
    if (DBI_IsoCase3 (bindata.Header, bindata.TxBuffer)) {
      if (Tk_Check_Warning(TRUE)) {
	ET( destroy .winpv );
	return ET_OK;
      }
    }
  }

  Tk_Check_Warning(FALSE);
  return ET_OK;	
}

ET_PROC( VerifyPIN ) {	/* Verifies a PIN number */

  ET( toplevel .winpv );
  ET( wm title .winpv "PIN" );
  ET( wm transient .winpv . );
  ET( wm geometry .winpv +$winw+$winh );
  ET( frame .winpv.f1 -relief groove -borderwidth 2 );
  ET( frame .winpv.f2 -relief groove -borderwidth 2 );
  ET( frame .winpv.f3 -relief groove -borderwidth 2 );
  ET( frame .winpv.f4 -relief raised -borderwidth 2 );

  ET( label .winpv.f4.pin -image pin; pack .winpv.f4.pin );

  ET( label .winpv.f1.lblps -text "PIN Size (1-8)"; pack .winpv.f1.lblps -side left );
  ET( entry .winpv.f1.entps -width 1; pack .winpv.f1.entps -side right );

  ET( label .winpv.f2.lblpn -text "PIN Number"; pack .winpv.f2.lblpn -side left );
  ET( entry .winpv.f2.entpn -show "*" -width 8; pack .winpv.f2.entpn -side right );
  
  ET( button .winpv.f3.butvr -text "  Verify  " -command PINNow; pack .winpv.f3.butvr -side left );
  ET( button .winpv.f3.butcn -text "  Cancel  " -command {destroy .winpv}; pack .winpv.f3.butcn -side right );
  

  ET( pack .winpv.f4 -side left -fill y );
  ET( pack .winpv.f1 -fill x );
  ET( pack .winpv.f2 -fill x );
  ET( pack .winpv.f3 -fill x );

return ET_OK;
}

ET_PROC( VerifyCHV ) {	/* Verifies a CHV */

  ET( tk_messageBox -default ok -icon info -message \
    { VerifyCHV not currently available. } \
	-title {Help Topics} -type ok );

return ET_OK;
}

static void really_change_port(char *reader) {
}

ET_PROC( ChangePort ) { 
  if (argc == 2) {
    ET( .f1.textMesg delete 0 end );
    if (strcmp(XcardReader, argv[1])) {
      int port;
      ET( .f1.textMesg insert 0 "Please wait for reader off." );
      strcpy(XcardReader, argv[1]);
      DBI_IsoOff();
      DisposeReaderPort();
      port = InitializeReaderPort(9600,8,'E', XcardReader);
      ET( .f1.textMesg delete 0 end );
      ET( .f1.textMesg insert 0 "Please press 'ON'. " );
      ET( .scrn config -text "%s(XcardReader)" );
      ET( .status config -text "Previous reader turned off" );
    }
    else {
      ET( .f1.textMesg insert 0 "Reader unchanged." );
    }
  }
  return ET_OK;
}

ET_PROC( Reset ) {	/* Performs a Reset on the card */
  
  BYTE Atr[50];
  BYTE *atr;
  int Length, i, r=0;
  
  if (DBI_IsoReset(Atr, &Length) == DBI_FAST_OK) {
    SelFile[0] = 0x3F; SelFile[1] = 0x00;
    
    ET( .f1.textMesg delete 0 end );
    atr = HexToString(Atr,Length);
    ET( .f1.textMesg insert 0 "Reset Complete" );
    ET( .f2.lblcf configure -text "3F00" );
    ET( .f2.lblrd configure -image rootdir );
    ET( .status config -text "ATR: %s(atr)" );
    
  }
  
  return ET_OK;
}

ET_PROC( Refresh ) {
  char *filename;

  filename = (char *)strdup(HexToString (SelFile, 2));
  ET( set currfile %q(filename) );
  ET( SelectFile );

  return ET_OK;
}

ET_PROC( SelectFile ) {
  
  const int MAX_READ_SIZE = 250;
  BYTE arg1;
  BYTE Return[MAX_BUFFER_SIZE];
  BYTE buffer[MAX_BUFFER_SIZE];
  BYTE FileName[2];
  BYTE FileSize[2];
  BYTE FileType;
  BYTE BytesToRead;
  char *filename;
  char *filesize;
  char *filetype;
  char *structtype;
  char *currfile;
  char *restrict;
  char *access;
  int Size;
  int r,i;
  int c=0;
  char *file;
  int listselect, runs, left, buttons;
  BYTE status[2];
  
  file = (char *)strdup(ET_STR( set currfile ));

  filename = StringToHex(file,4);

  memcpy(FileName,filename,2);
  
  buttons = ET_INT( set winrm );


  ET( destroy .winvf.can.0 );

  for (r=1; r <= buttons; r++) {
    ET( destroy .winvf.can.%d(r) );
  }  

   if (File_Select(2,FileName,&bindata)) {
      if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
        ET( .f2.lblcf configure -text "%q(file)" );
	memcpy(SelFile,&FileName[0],2);

        DBI_IsoGet(ISO_GET_SW, status);
	arg1 = status[1];

	if (Operation_GetResponse(arg1,&bindata)) {
	if (DBI_IsoCase2(bindata.Header,Return)) {
		
	/* Check to see if Directory or File */

	PlaceImage(Return[6],SelFile);	/* Put correct picture on screen */

	AID_len = 0;
    if (Return[6] == ISO_FILETYPE_MASTER || Return[6] == ISO_FILETYPE_DEDICATED) {


      ET( wm title .winvf "Directory %q(file)" );

#ifdef NOT_NEEDED
          DBI_IsoGet(ISO_GET_SW, status);
	  arg1 = status[1];
	  if (Operation_GetResponse(arg1,&bindata)) {
	    if (DBI_IsoCase2(bindata.Header,Return)) {
		

#endif /* NOT_NEEDED */

ET(	set fcount 0;							\
	set x 50;							\
	set y 50;							\
        frame .winvf.can.0; 					        \
	label .winvf.can.0.tx -text "3F00"; 		                \
	image create photo .winvf.0 -file "images/rootdir.gif";         \
	button .winvf.can.0.im -image .winvf.0    		        \
	-command { set currfile "3F00"; SelectFile } -relief flat;      \
	pack .winvf.can.0.im .winvf.can.0.tx -side top; 	        \
	.winvf.can create window $x $y -window .winvf.can.0;            \
	set x [expr $x + 100]; 						\
	set fcount 1;           					\
	);

 if (arg1 == 0x28) { /* application returns 0x28 bytes of data, while normal dir only returns 0x17 */
   BYTE len;
   char *aid_name;

   ET( frame .winvf.can.1 -relief groove -borderwidth 2 );

   filename = HexToString(&Return[4],2);  
   ET( label .winvf.can.1.lbl1 -text "File Name     : %q(filename)" );

   filesize = HexToString(&Return[2],2);
   ET( label .winvf.can.1.lbl2 -text "Free space   : %q(filesize)" );

   ET( label .winvf.can.1.lbl3 -text "File Type      : Cardlet" );

   len = Return[23];

   memcpy(AID, &Return[24], len);
   AID_len = len;

   aid_name = HexToString(&Return[24], len);
   ET( label .winvf.can.1.lbl4 -text "Aid (hex)      : %q(aid_name)" );

   aid_name = HexToASCII(&Return[24], len);
   ET( label .winvf.can.1.lbl5 -text "Aid (ASCII)   : \"%q(aid_name)\"" );
   

   ET( pack .winvf.can.1.lbl1 -side top -anchor w );
   ET( pack .winvf.can.1.lbl2 -side top -anchor w );
   ET( pack .winvf.can.1.lbl3 -side top -anchor w );
   ET( pack .winvf.can.1.lbl4 -side top -anchor w );
   ET( pack .winvf.can.1.lbl5 -side top -anchor w );
   ET( .winvf.can create window 200 150 -window .winvf.can.1 );
   ET( set y 250 );
   ET( set x 50 );

   c += 2;
 }

 arg1 = Return[14] + Return[15]; /* add up DF's and EF's under the current dir */ 

 for (r = 1; r <= arg1; r++) {
   if (File_Dir(r, &bindata)) {
     if (DBI_IsoCase2(bindata.Header, Return)) {
       if (!Tk_Check_Warning(FALSE)) 
	 return ET_OK;
	  
       FileType    = Return[6];
       FileName[0] = Return[4]; FileName[1] = Return[5];
       filename = (char *)strdup(HexToString (FileName, 2));

       c++;	/* Count up the images/filenames/etc */
	
   ET( frame .winvf.can.%d(c) );
   ET( label .winvf.can.%d(c).tx -text %s(filename) );    

	/* File or Directory image ?????? */

   if (FileType == ISO_FILETYPE_MASTER || FileType == ISO_FILETYPE_DEDICATED) { /* was x38 */
       ET( image create photo .winvf.%d(c) -file "images/dir.gif" );      
   } 
   else if ((FileName[0] == 0x00) && (FileName[1] == 0x11)) {
       ET( image create photo .winvf.%d(c) -file "images/keyfile.gif" );
   } 
   else if ((FileName[0] == 0x00) && (FileName[1] == 0x01)) {
       ET( image create photo .winvf.%d(c) -file "images/keyfile.gif" );
   } 
   else if ((FileName[0] == 0x00) && (FileName[1] == 0x00)) {
       ET( image create photo .winvf.%d(c) -file "images/pinfile.gif" );
   } 
   else {
       ET( image create photo .winvf.%d(c) -file "images/file.gif" );
   }

   ET( button .winvf.can.%d(c).im -image .winvf.%d(c) -command { set currfile %s(filename); SelectFile } -relief flat );
   ET( pack .winvf.can.%d(c).im .winvf.can.%d(c).tx -side top );

   ET( .winvf.can create window $x $y -window .winvf.can.%d(c) );

   ET( set x [expr $x + 100] );
  
   ET(   if { $x > 300 } { 						\
	  set x 50; 							\
	  set y [expr $y + 100]; 					\
         } 								\
      );

 }

 ET(
    set w 900; set h [expr $y+80]; set winrm %d(c); 			\
    .winvf.can configure -scrollregion "0 0 $w $h"; 			\
    );


   }
 }
 /* make sure the "SelFile" is really selected so that file creation will work OK */
 if (AID_len > 0) {
   BYTE root_file[2] = { 0x3f, 0x00 };
   File_Select(2, root_file, &bindata);
   DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
   DBI_IsoGet(ISO_GET_SW, status);
   if (status[0] == SC_MORE_INFO) {
     Operation_GetResponse(status[1],&bindata);
     DBI_IsoCase2(bindata.Header,Return);
     File_SelectApplet(AID_len, AID, &bindata); /* select by AID so applet would run */
   }
 }
 else 
   File_Select(2, SelFile, &bindata);
 DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
 DBI_IsoGet(ISO_GET_SW, status);
 if (status[0] == SC_MORE_INFO) {
   Operation_GetResponse(status[1],&bindata);
   DBI_IsoCase2(bindata.Header,Return);
 }
    return ET_OK;	    
#ifdef NOT_NEEDED
	}
      }
#endif /* NOT_NEEDED */


    } else {               /* Must be of file type */

  ET( wm title .winvf "File %q(file)" );

ET(	set fcount 0;							\
	set x 50;							\
	set y 50;							\
        frame .winvf.can.0; 					        \
	label .winvf.can.0.tx -text "3F00"; 		                \
	image create photo .winvf.0 -file "images/rootdir.gif";         \
	button .winvf.can.0.im -image .winvf.0    		        \
	-command { set currfile "3F00"; SelectFile } -relief flat;      \
	pack .winvf.can.0.im .winvf.can.0.tx -side top; 	        \
	.winvf.can create window $x $y -window .winvf.can.0;            \
	);

  ET( frame .winvf.can.1 -relief groove -borderwidth 2 );
  ET( frame .winvf.can.2 -relief groove -borderwidth 2 );

    FileSize[0] = Return[2]; FileSize[1] = Return[3];

    filename = HexToString(&Return[4],2);  
    ET( label .winvf.can.2.lbl1 -text "File Name     : %q(filename)" );

    filesize = HexToString(&Return[2],2);
    ET( label .winvf.can.2.lbl2 -text "File Size       : %q(filesize)" );

    filetype = HexToString(&Return[6],1);
    ET( label .winvf.can.2.lbl3 -text "File Type      : %q(filetype)" );

    structtype = HexToString(&Return[13],1);
    ET( label .winvf.can.2.lbl4 -text "Struct Type   : %q(structtype)" );

#ifdef NOT_USED
    restrict = HexToString(&Return[7],1);
    ET( label .winvf.can.2.lbl4 -text "Restrictions  : %q(restrict)" );
#endif /* NOT_USED */

    access = HexToString(&Return[8],3);
    ET( label .winvf.can.2.lbl5 -text "Access Cond : %q(access)" );


#ifdef NOT_USED
    ET( label .winvf.can.1.lbl -text "File Contents" );
    ET( text .winvf.can.1.txt -width 30 -height 6 -wrap word -yscrollcommand ".winvf.can.1.scroll set" );
    ET( scrollbar .winvf.can.1.scroll -command ".winvf.can.1.txt yview" );
        

 Size = Return[3] + (Return[2] * 256); /* Calculate File Size */
    
 runs = Size / 250;
 left = Size % 250;

for (r=0; r < runs; r++) {
    
    if (File_ReadBin(0,r,MAX_READ_SIZE,&bindata)) {
      if (DBI_IsoCase2(bindata.Header, buffer )) {

	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;

	  file = HexToString(buffer,MAX_READ_SIZE);
	  ET( .winvf.can.1.txt insert end %s(file) ); 		

      }
    }    
  }
/* Take care of the remainers or the only if < MAX_READ_SIZE */

    if (File_ReadBin(0,r,left,&bindata)) {
      if (DBI_IsoCase2(bindata.Header, buffer )) {

	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;

	  file = HexToString(buffer,left);
	  ET( .winvf.can.1.txt insert end "%s(file)" ); 		
      }
    }
#endif /* NOT_USED */

	  ET( pack .winvf.can.2.lbl1 -side top -anchor w );
	  ET( pack .winvf.can.2.lbl2 -side top -anchor w );
	  ET( pack .winvf.can.2.lbl3 -side top -anchor w );
	  ET( pack .winvf.can.2.lbl4 -side top -anchor w );
	  ET( pack .winvf.can.2.lbl5 -side top -anchor w );

#ifdef NOT_USED
	  ET( pack .winvf.can.1.lbl -side top -anchor center );
	  ET( pack .winvf.can.1.txt -side left );
	  ET( pack .winvf.can.1.scroll -side left -fill y );

#endif /* NOT_USED */
   	  ET( .winvf.can create window 185 75 -window .winvf.can.2 );
   	  ET( .winvf.can create window 150 220 -window .winvf.can.1 );


 ET(
    set w 500; set h [expr $y+80]; set winrm 2; 			\
    .winvf.can configure -scrollregion "0 0 $w $h"; 			\
    );
	
          Tk_Check_Warning(FALSE);
	  return ET_OK;
     }
    }
   }
  }
 }
  
  Tk_Check_Warning(FALSE);
  return ET_OK;
}

ET_PROC( ViewFile ) {	/* Shows Card Directory Structure */

  BYTE arg1;
  BYTE Return[MAX_BUFFER_SIZE];
  BYTE FileName[2] = {0x3f, 0x00};
  BYTE FileType;
  char *filename;
  int r;
  int c=0;
  BYTE status[2];


  ET( 
     toplevel .winvf;                                                      \
     wm title .winvf "Directory 3F00";                                     \
     wm transient .winvf .;                                                \
     wm geometry .winvf +$winw+$winh;					   \
    );

  ET( frame .winvf.fm -relief groove -borderwidth 2 );

  ET( menubutton .winvf.fm.menuFile -text "File" -menu .winvf.fm.menuFile.menu; pack .winvf.fm.menuFile -side left );
  ET( menubutton .winvf.fm.menuView -text "View" -menu .winvf.fm.menuView.menu; pack .winvf.fm.menuView -side left );
  ET( menubutton .winvf.fm.menuAdmin -text "Administrative" -menu .winvf.fm.menuAdmin.menu; pack .winvf.fm.menuAdmin -side left );
  ET( menubutton .winvf.fm.menuHelp -text "Help" -menu .winvf.fm.menuHelp.menu; pack .winvf.fm.menuHelp -side right );
  
  ET( menu .winvf.fm.menuFile.menu );
  ET( menu .winvf.fm.menuView.menu );
  ET( menu .winvf.fm.menuAdmin.menu );
  ET( menu .winvf.fm.menuHelp.menu );
  
  ET( .winvf.fm.menuFile.menu add command -label "Create File" -command CreateFile );
  ET( .winvf.fm.menuFile.menu add command -label "Delete File" -command DeleteFile );
  /*  ET( .winvf.fm.menuFile.menu add command -label "Download File" -command DownloadFile );*/
  ET( .winvf.fm.menuFile.menu add command -label "Close" -command { destroy .winvf } );

  ET( .winvf.fm.menuView.menu add command -label " Refresh " -command { Refresh } );

  ET( .winvf.fm.menuAdmin.menu add command -label " APDU Manager " -command APDU_Manager );
  /* ET( .winvf.fm.menuAdmin.menu add command -label " Create Key " -command KeyGen );*/
  /*  ET( .winvf.fm.menuAdmin.menu add command -label " Create PIN " -command PINGen );*/
  ET( .winvf.fm.menuAdmin.menu add command -label " Verify Key " -command VerifyKey );
  /*  ET( .winvf.fm.menuAdmin.menu add command -label " Verify CHV " -command VerifyCHV );*/
  /*  ET( .winvf.fm.menuAdmin.menu add command -label " Verify PIN " -command VerifyPIN );*/

  ET( .winvf.fm.menuHelp.menu add command -label " Help Topics " -command HelpTopics );
  ET( .winvf.fm.menuHelp.menu add command -label " About XCard " -command HelpXCard );

  ET( canvas .winvf.can -width 300 -height 300 -xscrollcommand "           \
     .winvf.hscr set"  -yscrollcommand ".winvf.vscr set"; 		   \
     
     scrollbar .winvf.hscr -command ".winvf.can xview" -orient horizontal; \
     
     scrollbar .winvf.vscr -command ".winvf.can yview"; 		   \
     
     pack .winvf.fm -side top -fill x;					   \
     pack .winvf.vscr -side right -fill y; 				   \
     pack .winvf.hscr -side bottom -fill x; 				   \
     pack .winvf.can -side left -expand yes -fill both; 		   \
     );
  
  if (File_Select(2,FileName,&bindata)) {
    if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {

      DBI_IsoGet(ISO_GET_SW, status);
      arg1 = status[1]; /* DNK -- get response for select */

      ET( .f2.lblcf configure -text "3F00" );
      memcpy(SelFile,&FileName[0],2);

      ET( .f2.lblrd configure -image rootdir ); /* Put the right image */
      if (Operation_GetResponse(arg1,&bindata)) {
	if (DBI_IsoCase2(bindata.Header,Return)) {

#ifdef NOT_NEEDED

	  if (File_Dir(1, &bindata)) {
	    if (DBI_IsoCase2(bindata.Header, Return)) {
	  
	      if (!Tk_Check_Warning(FALSE)) {
		ET( destroy .winvf );
		return ET_OK;
	      }
	  
	  
	      DBI_IsoGet(ISO_GET_SW, status);
	      if (status[0] != SC_MORE_INFO)
		/* should have warning here */;
	      arg1 = status[1];

	      if (Operation_GetResponse(arg1,&bindata)) {
		if (DBI_IsoCase2(bindata.Header,Return)) {
		
#endif /* NOT_NEEDED */

ET( 	global fcount x y currfile winrm;				\
	set currfile "3F00";						\
	set fcount 0;							\
	set x 50;							\
	set y 50;							\
	set winrm 0;							\
        frame .winvf.can.0; 					        \
	label .winvf.can.0.tx -text "3F00"; 		                \
	image create photo .winvf.0 -file "images/rootdir.gif";         \
	button .winvf.can.0.im -image .winvf.0    		        \
	-command { set currfile "3F00"; SelectFile } -relief flat;      \
	pack .winvf.can.0.im .winvf.can.0.tx -side top; 	        \
	.winvf.can create window $x $y -window .winvf.can.0;            \
	set x [expr $x + 100]; 						\
	set fcount 1;           					\
	);

    arg1 = Return[14] + Return[15]; /* add up DF's and EF's under the current dir */ 
    for (r=1; r <= arg1; r++) { 
      File_Dir(r, &bindata);
      DBI_IsoCase2(bindata.Header, Return);
      if (!Tk_Check_Warning(FALSE)) 
	return ET_OK;

      FileName[0] = Return[4]; FileName[1] = Return[5];
      FileType    = Return[6];
      filename = (char *)strdup(HexToString (FileName, 2));

      c++;	/* Count up the images/filenames/etc */
	
      ET( frame .winvf.can.%d(c) );
      ET( label .winvf.can.%d(c).tx -text %s(filename) );    

      /* File or Directory image ?????? */

      if (FileType == ISO_FILETYPE_MASTER || FileType == ISO_FILETYPE_DEDICATED) { /* was x38 */
	ET( image create photo .winvf.%d(c) -file "images/dir.gif" );      
      } 
      else if ((FileName[0] == 0x00) && (FileName[1] == 0x11)) {
	ET( image create photo .winvf.%d(c) -file "images/keyfile.gif" );
      } 
      else if ((FileName[0] == 0x00) && (FileName[1] == 0x01)) {
	ET( image create photo .winvf.%d(c) -file "images/keyfile.gif" );
      } 
      else if ((FileName[0] == 0x00) && (FileName[1] == 0x00)) {
	ET( image create photo .winvf.%d(c) -file "images/pinfile.gif" );
      } 
      else {
	ET( image create photo .winvf.%d(c) -file "images/file.gif" );
      }

      ET( button .winvf.can.%d(c).im -image .winvf.%d(c) -command { set currfile %s(filename); SelectFile } -relief flat );
      ET( pack .winvf.can.%d(c).im .winvf.can.%d(c).tx -side top );

      ET( .winvf.can create window $x $y -window .winvf.can.%d(c) );

      ET( set x [expr $x + 100] );
  
   ET(   if { $x > 300 } { 						\
	  set x 50; 							\
	  set y [expr $y + 100]; 					\
        } 								\
      );

		 }
 ET(
    set w 900; set h [expr $y+80]; set winrm %d(c); 			\
    .winvf.can configure -scrollregion "0 0 $w $h"; 			\
    );


 /* make sure the "SelFile" is really selected so that file creation will work OK */
 File_Select(2, SelFile, &bindata);
 DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
 DBI_IsoGet(ISO_GET_SW, status);
 if (status[0] == SC_MORE_INFO) {
   Operation_GetResponse(status[1],&bindata);
   DBI_IsoCase2(bindata.Header,Return);
 }
 return ET_OK;	    
#ifdef NOT_NEEDED
		}
	      }
	    }
	  }
#endif /* NOT_NEEDED */
	}
      }
    }
  }

  Tk_Check_Warning(FALSE);

  return ET_OK;
}

ET_PROC( SelectCardlet ) {	/* Shows UNIX Directory to select .bin file */

  char *filename;
  FILE *filep;
  int readsize, r, readcount=0;
  
  ET( set initialdir [pwd] );
  ET( set file_types { { "Solo Programs" { .bin .BIN } } { "Text Files"  { .txt .TXT } } { "All Files" * } } );
  
  ET( set filename [tk_getOpenFile -initialdir $initialdir -filetypes $file_types -title "Select Cardlet" -parent .] );
  ET( if {$filename != ""} { set initialdir [file dirname $filename] } );
  

  filename = (char *)strdup(ET_STR( set filename ));
  
  if (filename) {
    ET( .winrj.f1.entcn insert 0 "%s(filename)" );
    if (strlen(filename)) {
      filep = fopen (filename,"r");
      if (!filep) {
	printf("Bad File Request %s\n", filename);
	free(filename);
	return ET_OK;
      }
      fclose(filep);
    }
    free(filename);
  }
  return ET_OK;
}

ET_PROC( UploadFile ) {	/* uploads cardlet to Java Card SC */
  const int READSIZE=0x64;
  BYTE pname[2] = { 0x22, 0x22};
  char *return_val;
  char buffer[MAX_BUFFER_SIZE];
  char Return[MAX_BUFFER_SIZE];
  int readsize, r, readcount=0;
  unsigned int filesize;
  unsigned int containersize;
  unsigned int totalsize;
  struct stat filestat;
  BYTE data_size[4];
  BYTE fileid[2];
  BYTE contid[2];
  BYTE aid[MAX_AID_LENGTH];
  BYTE aid_len;
  BYTE status[2];
#ifdef OPEN16K
  FILE *filep;
#else
#ifdef ACCESS /* we have an Access card */

#define MAX_BUF_SIZE 256
#define MAX_APP_SIZE 16384 /* 16k is max for now */
#define MAX_APDU_SIZE 0xfa
#define BLOCK_SIZE 8
#define MAX_NUM_ARGS 16
#define MAX_ARG_SIZE 32
  BYTE app_data[MAX_APP_SIZE];
  int filep;
  BYTE sign_size;
  des_cblock des_key;
  des_cblock tmp;
  des_key_schedule schedule;
#endif /* ACCESS */
#endif /* not OPEN16K */


  strcpy(CardletName, ET_STR( .winrj.f1.entcn get ));
  strcpy(CardletAID, ET_STR( .winrj.f2.entai get ));
  strcpy(CardletFileID, ET_STR( .winrj.f3.entfn get ));
  strcpy(CardletDataSize, ET_STR( .winrj.f4.entds get ));
#ifdef ACCESS
  strcpy(CardletContainerID, ET_STR( .winrj.f3a.entcn get ));
  strcpy(CardletSignKey, ET_STR( .winrj.f1a.entky get ));
#endif /* ACCESS */

#ifdef OPEN16K
  r = open(CardletName, O_RDONLY);
  if (fstat(r, &filestat)) {
    ET( tk_messageBox -default ok -icon info -message \
	{File %s(CardletName) cannot be opened for read } \
	-title {bad file} -type ok );
    return ET_OK;
  }
  close(r);
  filesize = (unsigned int) filestat.st_size;
  if (! filesize) {
    ET( tk_messageBox -default ok -icon info -message \
	{bin file %s(CardletName) is empty } \
	-title {empty file} -type ok );
    return ET_OK;
  }
  
  return_val = StringToHex(CardletDataSize, 4);
  memcpy(data_size, return_val, 2);
  totalsize = filesize + (data_size[0] << 8) + data_size[1] + 0x60; /* don't forget header size */
  /* extra 16 bytes for an Open16K workaround */
  
  aid_len = convert_AID_str_to_byte(CardletAID, aid, TRUE);
  if (aid_len < 5) {
    return ET_OK;
  }
  return_val = StringToHex(CardletFileID, 4);
  memcpy(fileid, return_val, 2);

  bindata.Header[0] = CARD_CLASS;
  bindata.Header[1] = 0x08;
  bindata.Header[2] = 0x00;
  bindata.Header[3] = 0x00;
  bindata.Header[4] = 0x3a + aid_len;

  bindata.TxBuffer[0x00] = (BYTE)(totalsize >> 8);
  bindata.TxBuffer[0x01] = (BYTE)totalsize;
  bindata.TxBuffer[0x02] = fileid[0];
  bindata.TxBuffer[0x03] = fileid[1];
  bindata.TxBuffer[0x04] = 0xAA;
  bindata.TxBuffer[0x05] = 0xAA;
  bindata.TxBuffer[0x06] = 0xAA;
  bindata.TxBuffer[0x07] = 0xAA;
  bindata.TxBuffer[0x08] = 0xFF;
  bindata.TxBuffer[0x09] = ACL_NON_AUT0;
  bindata.TxBuffer[0x0a] = ACL_NON_AUT0;
  bindata.TxBuffer[0x0b] = ACL_NON_AUT0;
  bindata.TxBuffer[0x0c] = ACL_NON_AUT0;
  bindata.TxBuffer[0x0d] = ACL_NON_AUT0;
  bindata.TxBuffer[0x0e] = ACL_NON_AUT0;
  bindata.TxBuffer[0x0f] = ACL_NON_AUT0;
  bindata.TxBuffer[0x10] = (BYTE)(filesize >> 8);
  bindata.TxBuffer[0x11] = (BYTE)filesize;
  bindata.TxBuffer[0x12] = 0xAA;
  bindata.TxBuffer[0x13] = 0xAA;
  bindata.TxBuffer[0x14] = 0xAA;
  bindata.TxBuffer[0x15] = 0xAA;
  bindata.TxBuffer[0x16] = 0xAA;
  bindata.TxBuffer[0x17] = 0xAA;
  bindata.TxBuffer[0x18] = 0xFF;
  bindata.TxBuffer[0x19] = ACL_NON_AUT0;
  bindata.TxBuffer[0x1a] = ACL_NON_AUT0;
  bindata.TxBuffer[0x1b] = ACL_NON_AUT0;
  bindata.TxBuffer[0x1c] = ACL_NON_AUT0;
  bindata.TxBuffer[0x1d] = ACL_NON_AUT0;
  bindata.TxBuffer[0x1e] = ACL_NON_AUT0;
  bindata.TxBuffer[0x1f] = ACL_NON_AUT0;
  bindata.TxBuffer[0x20] = data_size[0];
  bindata.TxBuffer[0x21] = data_size[1];
  bindata.TxBuffer[0x22] = 0xAA;
  bindata.TxBuffer[0x23] = 0xAA;
  bindata.TxBuffer[0x24] = 0xAA;
  bindata.TxBuffer[0x25] = 0xAA;
  bindata.TxBuffer[0x26] = 0x00;
  bindata.TxBuffer[0x27] = 0x00;
  bindata.TxBuffer[0x28] = 0xFF;
  bindata.TxBuffer[0x29] = ACL_NON_AUT0;
  bindata.TxBuffer[0x2a] = ACL_NON_AUT0;
  bindata.TxBuffer[0x2b] = ACL_NON_AUT0;
  bindata.TxBuffer[0x2c] = ACL_NON_AUT0;
  bindata.TxBuffer[0x2d] = ACL_NON_AUT0;
  bindata.TxBuffer[0x2e] = ACL_NON_AUT0;
  bindata.TxBuffer[0x2f] = ACL_NON_AUT0;
  bindata.TxBuffer[0x30] = 0x02; /* not sure what this is for */
  bindata.TxBuffer[0x31] = 0xFF;
  bindata.TxBuffer[0x32] = 0xFF;
  bindata.TxBuffer[0x33] = 0xFF;
  bindata.TxBuffer[0x34] = 0x00;
  bindata.TxBuffer[0x35] = 0x00;
  bindata.TxBuffer[0x36] = 0xAA;
  bindata.TxBuffer[0x37] = 0xAA;
  bindata.TxBuffer[0x38] = 0x00;
  bindata.TxBuffer[0x39] = aid_len;
  memcpy(&bindata.TxBuffer[0x3a], aid, aid_len);
  DBI_IsoCase3(bindata.Header, bindata.TxBuffer);
  if (!Tk_Check_Warning(FALSE)) {
    return ET_OK; /* we cannot continue, since we may have priviledge problem */
  }

  File_Select(2, pname, &bindata);
  DBI_IsoCase3(bindata.Header, pname);
  DBI_IsoGet(ISO_GET_SW, status);
  if (status[0] != SC_MORE_INFO) {
    printf("?Expected 0x%2.2XXX but got: %#2.2X%2.2X\n", SC_MORE_INFO, status[0], status[1]);
    return ET_OK;
  }
  Operation_GetResponse(status[1], &bindata);
  DBI_IsoCase2(bindata.Header, Return);
  filep = fopen(CardletName,"r");
  if (! filep){
    printf("?File %s cannot be opened.\n", CardletName);
    return ET_OK;
  }

  while (1) {
    
    readsize = fread(buffer,1,READSIZE,filep);
    
    if (readsize < 1) { break; }
    
    if (File_UpdateBin((BYTE)(readcount >> 8),(BYTE)(readcount & 0x00FF),
		       readsize,buffer,&bindata)) {
      if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;
      }
    }
    
    readcount += readsize; 		/* Keeps track of file position pointer */
    
  }
  
  fclose (filep);
  
  bindata.Header[0] = CARD_CLASS;
  bindata.Header[1] = 0x08;
  bindata.Header[2] = 0x06;
  bindata.Header[3] = 0x00;
  bindata.Header[4] = 0x00;
  DBI_IsoCase1(bindata.Header); /* validate applet */
  if (!Tk_Check_Warning(FALSE))
    return ET_OK;
  bindata.Header[0] = CARD_CLASS;
  bindata.Header[1] = 0xAE;
  bindata.Header[2] = 0x13;
  bindata.Header[3] = 0x00;
  bindata.Header[4] = 0x00;
  DBI_IsoCase1(bindata.Header); /* install applet */
  if (!Tk_Check_Warning(FALSE))
    return ET_OK;
  bindata.Header[0] = CARD_CLASS;
  bindata.Header[1] = 0xAE;
  bindata.Header[2] = 0x14;
  bindata.Header[3] = 0x00;
  bindata.Header[4] = 0x00;
  DBI_IsoCase1(bindata.Header); /* register applet */
#else
#ifdef ACCESS /* we have an Access card */
  r = open(CardletName, O_RDONLY);
  if (fstat(r, &filestat)) {
    ET( tk_messageBox -default ok -icon info -message \
	{File %s(CardletName) cannot be opened for read } \
	-title {bad file} -type ok );
    return ET_OK;
  }
  close(r);
  filesize = (unsigned int) filestat.st_size;
  if (! filesize) {
    ET( tk_messageBox -default ok -icon info -message \
	{bin file %s(CardletName) is empty } \
	-title {empty file} -type ok );
    return ET_OK;
  }
  
  
  /* get signing key */
  return_val = StringToHex(CardletSignKey, sizeof(des_cblock)*2);
  if (0 != return_val[0]) {
    sign_size = sizeof(des_cblock);
    memcpy(&des_key, return_val, (int)sign_size);
  }
  else {
    sign_size = 0;
  }

  aid_len = convert_AID_str_to_byte(CardletAID, aid, TRUE);
  if (aid_len < 5) {
    return ET_OK;
  }

  /* get and check file ID */
  return_val = StringToHex(CardletFileID, 4);
  memcpy(fileid, return_val, 2);
  if (checkFileID(fileid, "For creating cardlet, File")) {
    return ET_OK;
  }

  /* get and check container ID */
  return_val = StringToHex(CardletContainerID, 4);
  memcpy(contid, return_val, 2);
  if (checkFileID(contid, "For creating cardlet, Container")) {
    return ET_OK;
  }

  filep = open(CardletName, O_RDONLY, NULL);
  if (filep == -1) {
    ET( tk_messageBox -default ok -icon info -message \
	{File %s(CardletName) cannot be opened for read } \
	-title {bad file} -type ok );
    return ET_OK;
  }
  filesize = read (filep, app_data, MAX_APP_SIZE);
  if (filesize == 0) {
    ET( tk_messageBox -default ok -icon info -message \
	{File %s(CardletName) is empty } \
	-title {bad file} -type ok );
    return ET_OK;
  }
  if (filesize == -1) {
    ET( tk_messageBox -default ok -icon info -message \
	{Error reading file %s(CardletName)} \
	-title {bad file} -type ok );
    return ET_OK;
  }

  /* initialize the result buffer */
  for (r = 0; r < BLOCK_SIZE; r++ ) {
    tmp[r] = 0;
  }
  if (sign_size) {
    int i, j;
    int extrasize = filesize % BLOCK_SIZE;
    /* pad the applet to make it fit in the block_size */
    if (extrasize) {
      for (i = 0; i < extrasize; i++)
	app_data[filesize + i] = 0;
      filesize += extrasize;
    }

    des_set_key (&des_key, schedule);
    for (i = 0; i < filesize/BLOCK_SIZE; i++) {
      for (j = 0; j < BLOCK_SIZE; j++ ){
	tmp[j] = tmp[j] ^ app_data[i*BLOCK_SIZE + j]; 
      }
      des_ecb_encrypt (&tmp, &tmp, schedule, DES_ENCRYPT);
    }

#ifdef DEBUG
    /* print out the signature */
    printf ("signature ");
    for (j = 0; j < BLOCK_SIZE; j++ ) {
      printf ("%02x", tmp[j]);
    }
    printf ("\n");
#endif /* DEBUG */
  }

  /* get data size */
  return_val = StringToHex(CardletDataSize, 4);
  memcpy(data_size, return_val, 2);
  containersize = (data_size[0] << 8) + data_size[1] + 0x80;

  /* calculate filesize */
  totalsize = filesize + 0x20; /* don't forget header size */
  /* extra 16 bytes for an Open16K workaround */

  /* create the file for the applet */
  bindata.TxBuffer[0] = (totalsize) / 256; /* size, upper byte */
  bindata.TxBuffer[1] = (totalsize) % 256; /* size, lower byte */
  bindata.TxBuffer[2] = fileid[0]; /* FID, upper */
  bindata.TxBuffer[3] = fileid[1]; /* FID, lower */
  bindata.TxBuffer[4] = 0x03; /* file type = 3 (program file) */
  bindata.TxBuffer[5] = 0x01; /* status = 1 */
  bindata.TxBuffer[6] = bindata.TxBuffer[7] = 0x00; /* record related */
  bindata.TxBuffer[8] = 0xFF; /* ACL can do everything with AUT0 */
  for (r = 9; r < 16; r++ ) {
    bindata.TxBuffer[r] = ACL_NON_AUT0; /* ACL based on #define */
  }
  bindata.Header[0] = CARD_CLASS;
  bindata.Header[1] = 0xe0;
  bindata.Header[2] = bindata.Header[3] = 0x00;
  bindata.Header[4] = 0x10;
  if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
    if (!Tk_Check_Warning(FALSE))
      return ET_OK;
  }
  File_Select(2, fileid, &bindata);
  if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
    if (!Tk_Check_Warning(FALSE))
      return ET_OK;
  }

  /* update binary of the applet */
  for (r = 0; r < filesize; r += MAX_APDU_SIZE) {
    int send_size;

    /* compute the size to be sent */
    if (filesize - r > MAX_APDU_SIZE) {
      send_size = MAX_APDU_SIZE;
    }
    else {
      send_size = filesize - r;
    }

    if (File_UpdateBin((BYTE)(r / 256), (BYTE)(r % 256),
		       send_size, app_data + r, &bindata)) {
      if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;
      }
    } /* update binary */
  }

  /* validate, using DES signature */
  if (File_ManageProgramValidate(sign_size, (BYTE*)tmp, &bindata)) {
    if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
      if (!Tk_Check_Warning(FALSE))
	return ET_OK;
    }
  } /* validate */

  /* select default loader */
  File_SelectApplet(0, 0, &bindata);
  if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
    if (!Tk_Check_Warning(FALSE))
      return ET_OK;
  }
  
  /* execute method -- call the install() method in the cardlet.
     cardlet type 01 (applet, not application)
     program ID (7777)
     instance container size (0800 (1152))
     instance container ID (7778)
     instance data size (0400 (1024))
     AID length (0005 (5 byte))
     AID (7777777777) */
  
  bindata.TxBuffer[0] = 0x01; /* cardlet type = 1 (applet, not application) */
  bindata.TxBuffer[1] = fileid[0]; /* FID, upper */
  bindata.TxBuffer[2] = fileid[1]; /* FID, lower */
  bindata.TxBuffer[3] = containersize / 256; /* instance container size upper */
  bindata.TxBuffer[4] = containersize % 256; /* instance container size lower */
  bindata.TxBuffer[5] = contid[0]; /* container ID (7778), upper */
  bindata.TxBuffer[6] = contid[1]; /* container ID (7778), lower */
  bindata.TxBuffer[7] = data_size[0]; /* instance size upper */
  bindata.TxBuffer[8] = data_size[1]; /* instance size lower */
  bindata.TxBuffer[9] = 0x00; /* AID length 0x0005, upper */
  bindata.TxBuffer[10] = aid_len; /* AID length 0x0005, lower */
  for (r = 0; r < aid_len; r++) 
    bindata.TxBuffer[r + 11] = aid[r];       /* AID */
  
  bindata.Header[0] = CARD_CLASS;
  bindata.Header[1] = 0x0c;
  bindata.Header[2] = 0x13;
  bindata.Header[3] = 0x00;
  bindata.Header[4] = 11 + aid_len;
  if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
    if (!Tk_Check_Warning(FALSE))
      return ET_OK;
  }
#else
  !!! compile error !!!;
  Unknown Java Card type -- must specify either OPEN16K or ACCESS_00/F0 at
    compile time! ;
#endif /* nonAccess */
#endif /* nonCyberflex? */

  if (Tk_Check_Warning(FALSE)) {
    ET( destroy .winrj );
  }
  return ET_OK;
}

ET_PROC( SelectCardletInstance ) {	/* Select a Cardlet instance */
  File_SelectApplet(0, 0, &bindata);
  if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
    BYTE root_file[2] = { 0x3f, 0x00 };
    BYTE AID[MAX_AID_LENGTH];
    BYTE len;

    if (!Tk_Check_Warning(FALSE))
      return ET_OK;
    File_Select(2, root_file, &bindata);
    DBI_IsoCase3(bindata.Header, bindata.TxBuffer);
    strcpy(CardletAID, ET_STR( .winsj.f1.entai get ));
    len = convert_AID_str_to_byte(CardletAID, AID, TRUE);
    if (len < 5) {
      return ET_OK;
    }
    File_SelectApplet(len, AID, &bindata);
    if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
      if (Tk_Check_Warning(FALSE)) {
	ET( destroy .winsj );
      }
      /* should we care? */
    }
  }
  return ET_OK;
}

ET_PROC( DeleteCardlet ) {	/* Delete Cardlet */
  /* select default loader first */
  File_SelectApplet(0, 0, &bindata);
  if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
    BYTE root_file[2] = { 0x3f, 0x00 };
    BYTE AID[MAX_AID_LENGTH];
    BYTE len;
    BYTE fileid[2];
    char *return_val;


    if (!Tk_Check_Warning(FALSE)) {
      printf ("You might try resetting the card first!\n");
      return ET_OK; /* if not success, we are locked up! */
    }
    File_Select(2, root_file, &bindata);
    DBI_IsoCase3(bindata.Header, bindata.TxBuffer);

#ifdef ACCESS
    /* reset the program */
    strcpy(CardletFileID, ET_STR( .windj.f1.entfn get ));    
    return_val = StringToHex(CardletFileID, 4);
    memcpy(fileid, return_val, 2);
    File_Select(2, fileid, &bindata);
    DBI_IsoCase3(bindata.Header, bindata.TxBuffer);
    if (!Tk_Check_Warning(FALSE)) {
      return ET_OK; 
    }

    File_ManageProgramReset(&bindata);
    DBI_IsoCase3(bindata.Header, bindata.TxBuffer);
    if (!Tk_Check_Warning(FALSE)) {
      return ET_OK; 
    }

    File_DeleteFile(2, fileid, &bindata);
    DBI_IsoCase3(bindata.Header,bindata.TxBuffer);
    if (!Tk_Check_Warning(FALSE)) {
      return ET_OK; 
    }

    /* delete instance also */
    strcpy(CardletContainerID, ET_STR( .windj.f2.entcn get ));    
    return_val = StringToHex(CardletContainerID, 4);
    memcpy(fileid, return_val, 2);
    File_DeleteFile(2, fileid, &bindata);
    DBI_IsoCase3(bindata.Header,bindata.TxBuffer); /* delete container */
    if (Tk_Check_Warning(FALSE)) {
      ET( destroy .windj );
    }
#endif /* ACCESS */
#ifdef NOT_NEEDED_FOR_ACCESS
    strcpy(CardletAID, ET_STR( .windj.f3.entai get ));
    len = convert_AID_str_to_byte(CardletAID, AID, TRUE);
    if (len < 5) {
      return ET_OK;
    }
    File_SelectApplet(len, AID, &bindata);
    if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
      if (!Tk_Check_Warning(FALSE))
	;
      /* should we care? */
    }
#endif /* NOT_NEEDED_FOR_ACCESS */
  }
  return ET_OK;
}



ET_PROC( DownloadFile ) {	/* Downloads a File */

  const int MAX_READ_SIZE = 250;
  BYTE Return[MAX_BUFFER_SIZE];
  BYTE buffer[MAX_BUFFER_SIZE];
  BYTE status[2];
  BYTE arg1; 
  int Size;
  char *filename;
  FILE *filep;
  int readsize, r, readcount=0;
  int runs, left, writesize;

  
  ET( set initialdir [pwd] );
  ET( set file_types { { "Text Files"  { .txt .TXT } } { "All Files"  * } } );
  
  ET( set filename [tk_getSaveFile -initialdir $initialdir -filetypes $file_types -title "Download" -parent .] );
  ET( if {$filename != ""} { set initialdir [file dirname $filename] } );
  
  filename = (char *)strdup(ET_STR( set filename ));
  
  printf("%s \n",filename);
  
  filep = fopen (filename, "wb");
  
  if (!filep) {
    printf("Bad File Request\n");
    return ET_OK;
  }
  
   if (File_Select(2,SelFile,&bindata)) {
      if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {

        DBI_IsoGet(ISO_GET_SW, status);
	arg1 = status[1];

	if (Operation_GetResponse(arg1,&bindata)) {
	if (DBI_IsoCase2(bindata.Header,Return)) {

	  Size = Return[3] + (Return[2] * 256); /* Calculate File Size */
    
        }
       }
     }
    }

 runs = Size / 250;
 left = Size % 250;

for (r=0; r < runs; r++) {
    
    if (File_ReadBin(0,r,MAX_READ_SIZE,&bindata)) {
      if (DBI_IsoCase2(bindata.Header, buffer )) {

	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;

         writesize = fwrite(buffer,sizeof(unsigned char),MAX_READ_SIZE,filep);

      }
    }    
  }

/* Take care of the remainers or the only if < MAX_READ_SIZE */

    if (File_ReadBin(0,r,left,&bindata)) {
      if (DBI_IsoCase2(bindata.Header, buffer )) {

	if (!Tk_Check_Warning(FALSE))
	  return ET_OK;

         writesize = fwrite(buffer,sizeof(unsigned char),left,filep);
	 printf("Writing out %d bytes \n",writesize);
      }
    }

 
  fclose (filep);

  Tk_Check_Warning(TRUE);
  return ET_OK;
}

ET_PROC( SelectNow ) 	/* Selects a File */
{
  BYTE *FileName;
  BYTE Return[MAX_BUFFER_SIZE];
  BYTE status[2];
  BYTE arg1;
  char *filename;


  FileName = StringToHex(ET_STR( .f2.entsla get ), 4);
  filename = HexToString(FileName,2);

  if (File_Select(2,FileName,&bindata)) {
    if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {

        DBI_IsoGet(ISO_GET_SW, status);
	arg1 = status[1];

	if (Operation_GetResponse(arg1,&bindata)) {
	if (DBI_IsoCase2(bindata.Header,Return)) {

	if (!Tk_Check_Warning(FALSE))
		return ET_OK;
   
        ET( .f2.lblcf configure -text "%q(filename)" );	
	memcpy(SelFile,&FileName[0],2);

	PlaceImage(Return[6],SelFile);	/* Put correct picture on screen */
    }
   }
  }
 }

Tk_Check_Warning(TRUE);
return ET_OK;
}


ET_PROC( SetRun ) {

  /* removed for now */  
  return ET_OK;
}


ET_PROC( JavaApp ) {	/* Loads Java App on Card */
  
  char *filename = HexToString(SelFile,2);

  if (SelFile[0] != 0x3F || SelFile[1] != 0x00) {
    ET( tk_messageBox -default ok -icon info -message \
	{Currently selected filename must be the root '3F00'} \
	-title {Must be 3F00} -type ok );
    return ET_OK;
  }

  /* select default loader */
  File_SelectApplet(0, 0, &bindata);
  if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
    BYTE status[2];
    BYTE root_file[2] = { 0x3f, 0x00 };
    DBI_IsoGet(ISO_GET_SW, status);
    File_Select(2, root_file, &bindata);
    DBI_IsoCase3(bindata.Header, bindata.TxBuffer);
    DBI_IsoGet(ISO_GET_SW, status);
    /* we assume we don't have to if (status[0] == SC_MORE_INFO) */
  }
  else {
    ET( tk_messageBox -default ok -icon info -message \
	{Could not select the default loader on the card!} \
	-title {No default loader} -type ok );
    return ET_OK;
  }
  /*	printf("Current File %x %x \n",SelFile[0],SelFile[1]);*/

  ET( toplevel .winrj );
  ET( wm title .winrj "Upload Java Cardlet" );
  ET( wm transient .winrj . );
  ET( wm geometry .winrj +$winw+$winh );

  ET( frame .winrj.f1 -relief groove -borderwidth 2 );
#ifdef ACCESS
  ET( frame .winrj.f1a -relief groove -borderwidth 2 );
#endif /* ACCESS */
  ET( frame .winrj.f2 -relief groove -borderwidth 2 );
  ET( frame .winrj.f3 -relief groove -borderwidth 2 );
#ifdef ACCESS
  ET( frame .winrj.f3a -relief groove -borderwidth 2 );
#endif /* ACCESS */
  ET( frame .winrj.f4 -relief groove -borderwidth 2 );

  ET( label .winrj.f1.lblcn -text "Cardlet path:"; pack .winrj.f1.lblcn -side left);
  ET( entry .winrj.f1.entcn -width 28; pack .winrj.f1.entcn -side left );
  ET( .winrj.f1.entcn insert 0 "%s(CardletName)" );
  ET( button .winrj.f1.butcn -text "..." -command SelectCardlet );
  ET( pack .winrj.f1.butcn -side left );

#ifdef ACCESS
  ET( label .winrj.f1a.lblky -text "Signing Key (Hex No Spaces)"; pack .winrj.f1a.lblky -side left );
  ET( entry .winrj.f1a.entky -width 20; pack .winrj.f1a.entky -side right );
  ET( .winrj.f1a.entky insert 0 "%s(CardletSignKey)" );
#endif /* ACCESS */

  ET( label .winrj.f2.lblai -text "AID:"; pack .winrj.f2.lblai -side left);
  ET( entry .winrj.f2.entai -width 32; pack .winrj.f2.entai -side left );
  if ('"' == CardletAID[0]) {
    char aidtemp[MAX_BUFFER_SIZE];
    int i, j;

    for (i = 0, j = 0; i < strlen(CardletAID); i++) {
      if ('"' == CardletAID[i]) {
	aidtemp[j++] = '\\';
      }
      aidtemp[j++] = CardletAID[i];
    }
    ET( .winrj.f2.entai insert 0 "%s(aidtemp)" );
  }
  else
    ET( .winrj.f2.entai insert 0 "%s(CardletAID)" );

  ET( label .winrj.f3.lblfn -text "File ID:"; pack .winrj.f3.lblfn -side left);
  ET( entry .winrj.f3.entfn -width 8; pack .winrj.f3.entfn -side left );
  ET( .winrj.f3.entfn insert 0 "%s(CardletFileID)" );

#ifdef ACCESS
  ET( label .winrj.f3a.lblcn -text "Container ID:"; pack .winrj.f3a.lblcn -side left );
  ET( entry .winrj.f3a.entcn -width 8; pack .winrj.f3a.entcn -side right );
  ET( .winrj.f3a.entcn insert 0 "%s(CardletContainerID)" );
#endif /* ACCESS */

  ET( entry .winrj.f4.entds -width 4; pack .winrj.f4.entds -side right );
  ET( label .winrj.f4.lblds -text "Data Size:"; pack .winrj.f4.lblds -side right);
  ET( .winrj.f4.entds insert 0 "%s(CardletDataSize)" );

  ET( button .winrj.butup -text "Create Cardlet" -command UploadFile );
  ET( button .winrj.butvk -text "Verify Key" -command VerifyKey );
  ET( button .winrj.butcn -text " Cancel  " -command { destroy .winrj } );

  ET( label .winrj.jvimage -image javacup );
	      
  ET( grid config .winrj.jvimage -column 0 -row 0 -rowspan 4 );

  ET( grid config .winrj.f1 -column 1 -row 0 -columnspan 3 -sticky snew );
#ifdef ACCESS
  ET( grid config .winrj.f1a -column 1 -row 1 -columnspan 3 -sticky snew );
#endif /* ACCESS */
  ET( grid config .winrj.f2 -column 1 -row 2 -columnspan 3 -sticky snew );
  ET( grid config .winrj.f3 -column 1 -row 3 -sticky snew );
#ifdef ACCESS
  ET( grid config .winrj.f3a -column 2 -row 3 -sticky snew );
#endif /* ACCESS */
  ET( grid config .winrj.f4 -column 3 -row 3 -sticky snew );

  ET( grid config .winrj.butup -column 4 -row 0 -sticky snew );
  ET( grid config .winrj.butvk -column 4 -row 1 -sticky snew );
  ET( grid config .winrj.butcn -column 4 -row 3 -sticky snew );

  return ET_OK;
}

ET_PROC( SelectApp ) {	/* Selects installed Cardlet */
  
  ET( toplevel .winsj );
  ET( wm title .winsj "Select Cardlet" );
  ET( wm transient .winsj . );
  ET( wm geometry .winsj +$winw+$winh );

  ET( frame .winsj.f1 -relief groove -borderwidth 2 );

  ET( label .winsj.f1.lblai -text "AID:"; pack .winsj.f1.lblai -side left);
  ET( entry .winsj.f1.entai -width 32; pack .winsj.f1.entai -side left );
  if ('"' == CardletAID[0]) {
    char aidtemp[MAX_BUFFER_SIZE];
    int i, j;

    for (i = 0, j = 0; i < strlen(CardletAID); i++) {
      if ('"' == CardletAID[i]) {
	aidtemp[j++] = '\\';
      }
      aidtemp[j++] = CardletAID[i];
    }
    ET( .winsj.f1.entai insert 0 "%s(aidtemp)" );
  }
  else
    ET( .winsj.f1.entai insert 0 "%s(CardletAID)" );

  ET( button .winsj.butup -text "Select Cardlet" -command SelectCardletInstance );
  ET( button .winsj.butvk -text "Verify Key" -command VerifyKey );
  ET( button .winsj.butcn -text " Cancel  " -command { destroy .winsj } );

  ET( grid config .winsj.f1 -column 0 -row 0 -columnspan 3 -sticky snew );
  ET( grid config .winsj.butup -column 0 -row 1 -sticky snew );
  ET( grid config .winsj.butvk -column 1 -row 1 -sticky snew );
  ET( grid config .winsj.butcn -column 2 -row 1 -sticky snew );


return ET_OK;
}

ET_PROC( DeleteApp ) {	/* Delete Cardlet */
  
  ET( toplevel .windj );
  ET( wm title .windj "Delete Cardlet" );
  ET( wm transient .windj . );
  ET( wm geometry .windj +$winw+$winh );

  ET( frame .windj.f1 -relief groove -borderwidth 2 );
  ET( frame .windj.f2 -relief groove -borderwidth 2 );
  ET( frame .windj.f3 -relief groove -borderwidth 2 );

  ET( label .windj.f1.lblfn -text "File ID:"; pack .windj.f1.lblfn -side left);
  ET( entry .windj.f1.entfn -width 8; pack .windj.f1.entfn -side left );
  ET( .windj.f1.entfn insert 0 "%s(CardletFileID)" );

  ET( label .windj.f2.lblcn -text "Container ID:"; pack .windj.f2.lblcn -side left );
  ET( entry .windj.f2.entcn -width 8; pack .windj.f2.entcn -side right );
  ET( .windj.f2.entcn insert 0 "%s(CardletContainerID)" );

  ET( label .windj.f3.lblai -text "AID:"; pack .windj.f3.lblai -side left);
  ET( entry .windj.f3.entai -width 32; pack .windj.f3.entai -side left );
  if ('"' == CardletAID[0]) {
    char aidtemp[MAX_BUFFER_SIZE];
    int i, j;

    for (i = 0, j = 0; i < strlen(CardletAID); i++) {
      if ('"' == CardletAID[i]) {
	aidtemp[j++] = '\\';
      }
      aidtemp[j++] = CardletAID[i];
    }
    ET( .windj.f3.entai insert 0 "%s(aidtemp)" );
  }
  else
    ET( .windj.f3.entai insert 0 "%s(CardletAID)" );

  ET( button .windj.butup -text "Delete Cardlet" -command DeleteCardlet );
  ET( button .windj.butvk -text "Verify Key" -command VerifyKey );
  ET( button .windj.butcn -text " Cancel  " -command { destroy .windj } );

  ET( grid config .windj.f1 -column 0 -row 0 -columnspan 3 -sticky snew );
  ET( grid config .windj.f2 -column 3 -row 0 -columnspan 3 -sticky snew );
  ET( grid config .windj.f3 -column 0 -row 1 -columnspan 6 -sticky snew );
  ET( grid config .windj.butup -column 0 -row 2 -columnspan 2 -sticky snew );
  ET( grid config .windj.butvk -column 2 -row 2 -columnspan 2 -sticky snew );
  ET( grid config .windj.butcn -column 4 -row 2 -columnspan 2 -sticky snew );


  return ET_OK;
}

ET_PROC( KeyGen ) {	/* key gen */
  
  ET( tk_messageBox -default ok -icon info -message \
    { Key Generation not yet implemented ( ~ 2 Weeks ) } \
	-title {Key Generation} -type ok );

/*
char *filename = HexToString(SelFile,2);

	      ET( toplevel .winkj );
	      ET( wm title .winkj "RSA Key Generation" );
	      ET( wm transient .winkj . );
	      ET( wm geometry .winkj +$winw+$winh );

	ET( label .winkj.lblkg -image muscleman );

	ET( pack .winkj.lblkg );
*/


 return ET_OK;
}

ET_PROC( CreatePIN ) {	/* Creates PIN file in currently dir */

  const int MAX_PIN_SIZE=8;	/* Maximum PIN  */
  BYTE *pinsize;		/* Size of PIN 	*/
  BYTE PinSize;			/* PIN Size	*/
  char *pina;			/* PIN once	*/
  char *pinb;			/* PIN twice	*/
  char *unblock;		/* Unblock Key	*/
  BYTE *unblockkey;		/* Final Unblock*/
  BYTE *blockunbl;		/* Unblock Attempts */
  BYTE *blockpin;		/* Unblock Attemtps */
  BYTE pin[8];			/* Final Pin	    */
  BYTE FileName[2];		/* File Name	    */
  BYTE *blockkeyatt;		/* Unblock Attempts */
  BYTE *blockpinatt;		/* Unblock Attempts */
  BYTE bk;			/* Unblock Attempts */
  BYTE bp;			/* Unblock Attempts */
  BYTE pinwrite[25];		/* Data for PIN file*/
  int  r;			/* Counter Var      */

  /* Create PIN File Attributes */

  char size[2]   = {0x00, 0x17};
  char fileid[2] = {0x00, 0x00};
  char access[4] = {0x3F, 0x44, 0xFF, 0x44};
  char keys[3]   = {0x11, 0xFF, 0x11};

 if (File_CreateFile (0x00,0xFF,size,fileid,0x01,access,0x01,keys,0xFF,&bindata)) {   
   if (DBI_IsoCase3 (bindata.Header, bindata.TxBuffer)) {
     
     if (!Tk_Check_Warning(TRUE)) {
	return ET_OK;		/* FIX: Check if file exists (update bin) */
     }
   }   
 }

  /* Get Tk entry values and copy them to dynamic C vars */

  pinsize = (BYTE *)strdup(ET_STR( .winpc.f2.entps get ));
  PinSize = pinsize[0] - 48;

  pina    = (char *)strdup(ET_STR( .winpc.f2.entpn get ));
  pinb    = (char *)strdup(ET_STR( .winpc.f2.entpa get ));

  blockunbl = (char *)strdup(ET_STR( .winpc.f2.entub get ));
  blockpin  = (char *)strdup(ET_STR( .winpc.f2.entpb get ));

  /* Initialize the Final PIN */

  for (r=0; r < MAX_PIN_SIZE; r++)
    pin[r] = 0xFF;


  if (!strcmp(pina, pinb)) {
    for (r=0; r < PinSize; r++) {
      pin[r] = pina[r] + 0;
    }
  }
  else {
    Show_Warning("PINS_Do_Not_Match");
    return ET_OK;
  }

  for (r=0; r < MAX_PIN_SIZE; r++)
    printf("%x ", pin[r]);

   printf("\n");

  blockpinatt = StringToHex(blockpin,2);
  blockkeyatt = StringToHex(blockunbl,2);

  bk = blockkeyatt[0];
  bp = blockpinatt[0];

  unblock = (BYTE *)strdup(ET_STR( .winpc.f2.entuk get ));
  unblockkey = StringToHex(unblock,16);

  /* Formatting Data for Write Binary of PIN File */

  pinwrite[0] = 0x01; pinwrite[1] = 0xFF; pinwrite[2] = 0xFF;
  
  for (r=0; r < MAX_PIN_SIZE; r++) {
    pinwrite[r+3] = pin[r];
  }

  pinwrite[11] = bp;
  pinwrite[12] = bp;
  
  for (r=0; r < MAX_PIN_SIZE; r++) {
    pinwrite[r+13] = unblockkey[r];
  }

  pinwrite[21] = bk;
  pinwrite[22] = bk;

  FileName[0] = 0x00; FileName[1] = 0x00;

   if (File_Select(2,FileName,&bindata)) {
      if (DBI_IsoCase3(bindata.Header,bindata.TxBuffer)) {
        ET( .f2.lblcf configure -text "0000" );
	memcpy(SelFile,&FileName[0],2);

	PlaceImage(0x01,SelFile);	/* Put correct picture on screen */

    if (File_UpdateBin(0,0,23,pinwrite,&bindata)) {
      if (DBI_IsoCase3(bindata.Header, bindata.TxBuffer)) {
	if (!Tk_Check_Warning(TRUE))
	  return ET_OK;
      }
    }
  }
 }

  Tk_Check_Warning(FALSE);
  return ET_OK;

}

ET_PROC( PINGen ) {	/* Gets Create PIN information */
  
  ET( toplevel .winpc );
  ET( wm title .winpc "Create PIN File" );
  ET( wm transient .winpc . );
  ET( wm geometry .winpc +$winw+$winh );

  ET( frame .winpc.f1 -relief groove -borderwidth 2 );
  ET( frame .winpc.f2 -relief groove -borderwidth 2 );
  ET( frame .winpc.f3 -relief raised -borderwidth 2 );

  ET( label .winpc.f3.pin -image pin; pack .winpc.f3.pin -side left );

  ET( label .winpc.f1.lblps -text "PIN Size (1-8)"; pack .winpc.f1.lblps -side top -anchor w );
  ET( label .winpc.f1.lblpb -text "PIN Attempts "; pack .winpc.f1.lblpb -side top -anchor w );
  ET( label .winpc.f1.lblpn -text "PIN Number"; pack .winpc.f1.lblpn -side top -anchor w );
  ET( label .winpc.f1.lblpa -text "PIN Again "; pack .winpc.f1.lblpa -side top -anchor w );
  ET( label .winpc.f1.lblub -text "Unblock Attempts "; pack .winpc.f1.lblub -side top -anchor w );
  ET( label .winpc.f1.lbluk -text "Unblocking Key (8 bytes)"; pack .winpc.f1.lbluk -side top -anchor w );
  ET( entry .winpc.f2.entps -width 1; pack .winpc.f2.entps -side top );
  ET( entry .winpc.f2.entpb -width 2; pack .winpc.f2.entpb -side top );
  ET( entry .winpc.f2.entpn -show "*" -width 8; pack .winpc.f2.entpn -side top );
  ET( entry .winpc.f2.entpa -show "*" -width 8; pack .winpc.f2.entpa -side top );
  ET( entry .winpc.f2.entub -width 2; pack .winpc.f2.entub -side top );
  ET( entry .winpc.f2.entuk -width 16; pack .winpc.f2.entuk -side top );
  /*  ET( button .winpc.butok -text "  Create  " -command CreatePIN );*/
  ET( button .winpc.butcn -text "  Cancel  " -command { destroy .winpc } );

   /* Show some defaults */

  ET( .winpc.f2.entps insert 0 "4" );
  ET( .winpc.f2.entpb insert 0 "05" );
  ET( .winpc.f2.entpn insert 0 "8591" );
  ET( .winpc.f2.entpa insert 0 "8591" );
  ET( .winpc.f2.entub insert 0 "05" );
  ET( .winpc.f2.entuk insert 0 "0102030405060708" );
  

  ET( grid config .winpc.f3 -column 0 -row 0 -sticky snew );
  ET( grid config .winpc.f1 -column 1 -row 0 -sticky snew );
  ET( grid config .winpc.f2 -column 2 -row 0 -sticky snew );
  ET( grid config .winpc.butok -column 1 -row 1 );
  ET( grid config .winpc.butcn -column 2 -row 1 );


return ET_OK;
}

ET_PROC( HelpXCard ) {	/* Describes Software  */

  ET( tk_messageBox -default ok -icon info -message \
    { XCard, a simple X front end to smartcards written \
	by David Timothy Corcoran. corcordt@cs.purdue.edu.\
See http://www.linuxnet.com/ for more info.\
Modified extensively by Danny Kumamoto, Danny.Kumamoto@slb.com,\
to work with Cyberflex Open16K and Access. Access support code mainly from\
CITI, UofMich, CT-API support from Carlos Prados.} \
	-title {About XCard} -type ok );

return ET_OK;
}

ET_PROC( HelpTopics ) {	/* Help Screen */

  ET( tk_messageBox -default ok -icon info -message \
    { Help not currently available. } \
	-title {Help Topics} -type ok );

return ET_OK;
}

ET_PROC( Nice_preexit ) { /* reset card, turn off the reader and close port */
  BYTE Atr[50];
  int Length;
  
  DBI_IsoReset(Atr, &Length); /* we don't care of status since we're exiting */
  DBI_IsoOff();
  DisposeReaderPort();

  return ET_OK;
}

ET_PROC( Close_port ) {	/* Closes Reader Port  */

  DisposeReaderPort();
  return ET_OK;
}

static char *parse_name(char *tokenp, char *readp, char *writep)
{
  if ('#' == readp[0])
    return NULL; /* if we have a comment char, forget it */
  if (strstr(readp, tokenp)) {
    char *q1, *q2;

    q1 = strchr(readp, '"');
    if (q1) {
      q2 = strrchr(readp + strlen(readp) - 2, '"');
      if (q2) {
	*q2 = 0;
	strncpy(writep, q1 + 1, q2 - q1);
	return writep;
      } /* found the second quote */
    } /* found the first quote */
  } /* found the key tag */
  return NULL;
} /* parse_name() */

static void setup_reader_names() {
  FILE *fp;
  char readBuffer[MAX_BUFFER_SIZE];
  char writeBuffer[MAX_BUFFER_SIZE];
  char *cp;

  fp = fopen(PCSC_READER_CONF, "r");
  if (! fp) {
    printf("PCSC not installed correctly -- '%s' missing\n",
	   PCSC_READER_CONF);
    exit(1); /* abort */
  }    
  ReaderListCounter = 0;
  while (cp = fgets(readBuffer, sizeof(readBuffer), fp)) {
    if (parse_name("FRIENDLYNAME", cp, writeBuffer)) {
      if (ReaderListCounter < MAX_SC_READER)
	strcpy(ReaderList[ReaderListCounter++], writeBuffer);
    }
  }
  fclose(fp);
  if (ReaderListCounter > 0) {
    char *home = getenv("HOME");

    if (home) {
      char rcname[MAX_PATH_LEN];
      sprintf(rcname, "%s/.xcardrc", home);
      fp = fopen(rcname, "r");
      if (fp) {
	while (cp = fgets(readBuffer, sizeof(readBuffer), fp)) {
	  if (parse_name("FRIENDLYNAME", cp, writeBuffer)) {
	    strcpy(XcardReader, writeBuffer);
	    return;
	  }
	}
      }
    }
    /* by default, take the first reader found in reader_conf file */
    strcpy(XcardReader, ReaderList[0]);
  }
  else {
    printf("No card reader found in '%s'.\n", PCSC_READER_CONF);
    exit(1);
  }
}

int main (int argc, char **argv) {

  int i;
  int port;	  /* Handle for serial port      */ 
  BYTE Atr[50];   /* Grabs Reader Atr from Reset */
  int Length;     /* Size of Atr		 */
  char *atr;      /* Text atr                    */
  
  strcpy(CardletName, "");
  strcpy(CardletAID, "");
  strcpy(CardletFileID, "");
  strcpy(CardletContainerID, "");
  strcpy(CardletDataSize, "0200");
  strcpy(CardletSignKey, "6A2136F5D80C4783");
  strcpy(VerifyKeyString, "AD9F61FEFA20CE63");
  /* See README/INSTALL if confused about port settings */

  setup_reader_names();
  port = InitializeReaderPort(9600,8,'E', XcardReader);
  

  /* All of the Windowing and Widgets done through embedded Tk using et */
  
  Et_Init(&argc,argv);
  ET_INSTALL_COMMANDS;
  
  ET( global winw, winh );
  ET( global initialdir,filename,file_types );
  ET( set initialdir 0; set filename 0; set file_types 0 );

  /*  ET( wm protocol . WM_DELETE_WINDOW "Close_port" );*/
  ET( wm protocol . WM_DELETE_WINDOW "Nice_preexit; exit" );

  ET( set winw [winfo screenwidth .]; set winh [winfo screenwidth .] );
  ET( set winw [expr $winw/2-200]; set winh [expr $winh/2-200] );

  ET( wm geometry . +$winw+$winh );

		/* Load some pics */

  ET( image create photo xcard -file images/xcard.gif );
  ET( image create photo javacup -file images/javacup.gif );
  ET( image create photo rootdir -file images/rootdir.gif );
  ET( image create photo dir -file images/dir.gif );
  ET( image create photo key -file images/keyfile.gif );
  ET( image create photo pin -file images/pinfile.gif );
  ET( image create photo regfile -file images/file.gif );


  ET( frame .fm -relief groove -borderwidth 2 );
  ET( frame .f1 -relief groove -borderwidth 3 );
  ET( frame .f2 -relief groove -borderwidth 3 );
  ET( frame .lp -relief groove -borderwidth 2 );
  ET( frame .bb -relief groove -borderwidth 2 );
  
  ET( menubutton .fm.menufile -text "File" -menu .fm.menufile.menu; pack .fm.menufile -side left );
  ET( menubutton .fm.menuSettings -text "Settings" -menu .fm.menuSettings.menu; pack .fm.menuSettings -side left );
  ET( menubutton .fm.menuAdmin -text "Administrative" -menu .fm.menuAdmin.menu; pack .fm.menuAdmin -side left );
  ET( menubutton .fm.menuJava -text "Java" -menu .fm.menuJava.menu; pack .fm.menuJava -side left );
  ET( menubutton .fm.menuHelp -text "Help" -menu .fm.menuHelp.menu; pack .fm.menuHelp -side right );
  
  ET( menu .fm.menufile.menu );
  ET( menu .fm.menuSettings.menu );
  ET( menu .fm.menuAdmin.menu );
  ET( menu .fm.menuJava.menu );
  ET( menu .fm.menuHelp.menu );
  
  ET( .fm.menufile.menu add command -label "Create File" -command CreateFile );
  ET( .fm.menufile.menu add command -label "View Directory" -command ViewFile );
  /*  ET( .fm.menufile.menu add command -label "Upload File" -command UploadFile );*/
  /*  ET( .fm.menufile.menu add command -label "Download File" -command DownloadFile );*/
  ET( .fm.menufile.menu add command -label "Quit (leave reader on)" -command { Close_port; exit } );
  ET( .fm.menufile.menu add command -label "Exit (reset+reader off)" -command { Nice_preexit; exit } );
  
  ET( .fm.menuSettings.menu add cascade -label "Reader Settings" -menu .fm.menuSettings.menu.comport );
  
  ET( menu .fm.menuSettings.menu.comport );
  for (i = 0; i < ReaderListCounter; i++) {
    ET( .fm.menuSettings.menu.comport add command -label "%s(ReaderList[i])" -command { ChangePort "%s(ReaderList[i])" } );
  }
  
  ET( .fm.menuAdmin.menu add command -label " APDU Manager " -command APDU_Manager );
  /*  ET( .fm.menuAdmin.menu add command -label " Create Key " -command KeyGen );*/
  /*  ET( .fm.menuAdmin.menu add command -label " Create PIN " -command PINGen );*/
  ET( .fm.menuAdmin.menu add command -label " Verify Key " -command VerifyKey );
  /* ET( .fm.menuAdmin.menu add command -label " Verify CHV " -command VerifyCHV );*/
  /*  ET( .fm.menuAdmin.menu add command -label " Verify PIN " -command VerifyPIN ); */

  ET( .fm.menuJava.menu add command -label " Load Cardlet " -command JavaApp );
  ET( .fm.menuJava.menu add command -label " Select Cardlet " -command SelectApp );
  ET( .fm.menuJava.menu add command -label " Delete Cardlet " -command DeleteApp );

  ET( .fm.menuHelp.menu add command -label " Help Topics " -command HelpTopics );
  ET( .fm.menuHelp.menu add command -label " About XCard " -command HelpXCard );


  /* Read in the button bar image maps */

  ET( image create photo rdron -file images/on.gif );
  ET( image create photo rdroff -file images/off.gif );
  ET( image create photo rdrrst -file images/reset.gif );
  ET( image create photo viewdr -file images/open.gif );
  ET( image create photo creatf -file images/new.gif );
  /*  ET( image create photo upload -file images/upload.gif );*/
  /*  ET( image create photo dnload -file images/download.gif );*/
  ET( image create photo vrfyky -file images/key.gif );
  /*  ET( image create photo vrfypn -file images/pin.gif );*/
  ET( image create photo javacp -file images/java.gif );
  ET( image create photo hlpscr -file images/help.gif );

  ET( button .bb.b1 -image rdron -command Type; pack .bb.b1 -side left );
  ET( button .bb.b2 -image rdroff -command DeActivate; pack .bb.b2 -side left);
  ET( button .bb.b3 -image rdrrst -command Reset; pack .bb.b3 -side left );
  ET( button .bb.b4 -image viewdr -command ViewFile; pack .bb.b4 -side left );
  ET( button .bb.b5 -image creatf -command CreateFile; pack .bb.b5 -side left );
  /*  ET( button .bb.b6 -image upload -command UploadFile; pack .bb.b6 -side left );*/
  /*  ET( button .bb.b7 -image dnload -command DownloadFile; pack .bb.b7 -side left );*/
  ET( button .bb.b8 -image vrfyky -command VerifyKey; pack .bb.b8 -side left );
  /*  ET( button .bb.b9 -image vrfypn -command VerifyPIN; pack .bb.b9 -side left );*/
  ET( button .bb.b10 -image javacp -command JavaApp; pack .bb.b10 -side left );
  ET( button .bb.b11 -image hlpscr -command HelpTopics; pack .bb.b11 -side left );

  ET( label .f1.lbltm -text "Reader Status"; pack .f1.lbltm -side top );
  ET( entry .f1.textMesg -width 30;  pack .f1.textMesg -side top -pady 20 );
  ET( button .f1.buttonOn -text {  On   } -command Type; pack .f1.buttonOn -side left );
  ET( button .f1.buttonReset -text { Reset } -command Reset; pack .f1.buttonReset -side left );
  ET( button .f1.buttonDeActivate -text {  Off  } -command DeActivate; pack .f1.buttonDeActivate -side left );
  
  ET( entry .f2.entsla -width 5 );
  ET( button .f2.butsl -text { Select } -command SelectNow );
  ET( label .f2.lblrd -image rootdir );
  ET( label .f2.lblcf -text "3F00" );
  ET( label .f2.lbltx -text "Current File" );

  ET( grid config .f2.lbltx -column 0 -row 0 );
  ET( grid config .f2.lblrd -column 3 -row 0 );
  ET( grid config .f2.lblcf -column 3 -row 1 );
  ET( grid config .f2.butsl -column 0 -row 2 );
  ET( grid config .f2.entsla -column 3 -row 2 -padx 40 );

  ET( label .scrn -relief sunken -anchor w -borderwidth 2 ); 
  ET( label .status -relief sunken -anchor w -borderwidth 2 ); 

  /* Create the XCard Image */

  ET( label .lp.xcimage -image xcard; pack .lp.xcimage -side left );


  ET( grid config .fm -column 0 -row 0 -columnspan 2 -sticky ew );
  ET( grid config .bb -column 0 -row 1 -columnspan 2 -sticky ew );
  ET( grid config .lp -column 0 -row 2 -rowspan 2 -sticky snew );
  ET( grid config .f1 -column 1 -row 2 -sticky snew );
  ET( grid config .f2 -column 1 -row 3 -sticky snew );
  ET( grid config .scrn -column 0 -row 4 -sticky ew );
  ET( grid config .status -column 1 -row 4 -sticky ew );

  ET( tk appname "XCard" );

  ET( .scrn config -text "%s(XcardReader)" );

  /* Starts up the reader...Error if not found */
  if (DBI_IsoReset(Atr, &Length) == DBI_FAST_OK) {
    atr = HexToString(Atr,Length);
    SelFile[0] = 0x3F; SelFile[1] = 0x00;
    ET( .f1.textMesg insert 0 "Smartcard Reader Ready " );
    ET( .status config -text "ATR: %s(atr)" );

  }
  else {
    ET( .f1.textMesg delete 0 end );
    ET( .f1.textMesg insert 0 "Reader Fault " );
  }
  
  Et_MainLoop(); 

  return 0;
}
