/* DO NOT EDIT! 
** This file has been automatically generated from "et80.c" */
#ifdef __cplusplus
#  define EXTERN extern "C"
#else
#  define EXTERN extern
#endif
EXTERN int Et_Eval(const char *,int,const char*,...);
EXTERN int Et_EvalInt(const char *,int,const char*,...);
EXTERN char *Et_EvalString(const char *,int,const char*,...);
EXTERN double Et_EvalDouble(const char *,int,const char*,...);
EXTERN void Et_EvalInclude(const char *,char *);
EXTERN void Et_Init(int *, char **);
EXTERN void Et_MainLoop(void);
EXTERN void Et_ReadStdin(void);
EXTERN struct Tcl_Interp *Et_Interp;
EXTERN struct Tk_Window_ *Et_MainWindow;
EXTERN struct _XDisplay *Et_Display;
#define ET_OK 0
#define ET_ERROR 1
#undef EXTERN
#define UNIX 1
#define WIN32 0
#line 1 "et80.c"
/* IMPORTANT: Read the comment below on how to compile this file.  It
 * is NOT sufficient to just hand it to the C compiler.  It must first
 * be preprocessed.
 */
/* 
 * This file has been generated by 
 *
 *                 D. Richard Hipp
 *                 drh@acm.org
 *
 * The contributions of Dr. Hipp are placed in the public domain.  However,
 * portions of this file are subject to the copyrights shown below.
 *
 * The changes necessary to use TclX are by Michael Schumacher at
 * mike@hightec.saarlink.de.
 *
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
/*
**
** The function Et_Eval() is an extension of Tcl_VarEval().
**
** The first and second arguments are the name of the file which
** contains the call to Et_Eval() and the line number within that
** file from which Et_Eval() was called.  This information is used
** to print an error message to stderr if necessary.
**
** The third argument is a format string built from three characters:
** 's', 'd', and 'f'.  This format string determines the number and
** type of subsequent arguments.  Each 's' in the format string
** corresponds to a string argument, each 'd' cooresponds to an integer,
** and each 'f' corresponds to a double.
**
** A format string may now also contain a 'q' character.  'q' means that
** the any of the characters which have special meaning to the Tcl
** interpreter (any of  "{", "}", "[", "\"", "\\" or "$") are escaped.
**
** The operation of Et_Eval() is to concatenate all arguments and
** send the result to Tcl_GlobalEval().  The return of Tcl_GlobalEval()
** is returned from Et_Eval().
**
** In addition to Et_Eval(), this file defines three other functions:
**
**      Et_EvalInt()
**      Et_EvalString()
**      Et_EvalDouble()
**
** In each of these other functions, the value returned is not the status
** string from Tcl_VarEval(), but rather the result string.  The result
** string is converted to an integer or a double for Et_EvalInt() and
** Et_EvalDouble(), respectively.
**
**      Et_EvalInclude()
**
** This function is used to implement the ET_INCLUDE() macro of the ET
** system.  It takes two arguments which are the name of a file and 
** null-terminated string containing the contents of that file.  The
** the function simply calls Tcl_GlobalEval on the string, and then prints
** an appropriate error message if something goes wrong.
**
** The Tcl/Tk interpreter used by all these functions is obtained from
** the global variable "Tcl_Interp *Et_Interp;".  This variable
** should be set to a valid interpreter before calling any function
** in this file.
**
** The function Et_InstallCmd() creates a new command for the
** Tcl/Tk interpreter pointed to by the global variable Et_Interp.
** This function was added in support of the ET_INSTALL_COMMANDS macro.
**
** All of the above functions are normally called from ET macros, not
** directly by the user.  The next set of functions are called directly
** by the user:
**
**     Et_Init(int *,char **);
**     Et_ReadStdin(void);
**     Et_MainLoop(void);
**
** The Et_Init() function should be the first function called from within
** the main() procedure of an application.  This function initializes the
** ET interpreter.  Command line arguments used by the interpreter are
** removed from  argc and argv.
**
** Et_MainLoop() should be the last function in the main() procedure.  It
** implements the event loop.
**
** If the function Et_ReadStdin() is called prior to Et_MainLoop(), then
** arrangements are made to read standard input and pass the results to
** the ET interpreter.
**
********************* HOW TO COMPILE THIS FILE **************************
**
** This file is mostly C code, but it is not completely C code.  It can
** not be handed to the C compiler directory, but must first be preprocessed
** using the "et2c" macro preprocessors.
**
** This version of the ET library file is for use with Tk version 8.0 and
** Tcl version 8.0.
*/
/* For K&R code compile with -DK_AND_R */
#include "tk.h"
#ifdef K_AND_R
#include <varargs.h>
#define const
#else
#include <stdarg.h>
#endif
#include <ctype.h>

#ifndef UCHAR
# define UCHAR(c) ((unsigned char) (c))
#endif

/*
** Some external functions used
*/
extern void exit();
extern char *strrchr();
extern void free();
extern int atoi();
extern double atof();
extern int read();
extern int isatty();

/*
** The following variable points to the Tcl/Tk interpreter which is
** used by all functions in this file.
*/
Tcl_Interp *Et_Interp = 0;

/* The next variables are made available as a convenience to the
** ET programmer. */
Tk_Window Et_MainWindow;      /* The main window of the application */
Display *Et_Display;          /* The X11 display holding the main window */

/* This flag is TRUE if all scripts processed by ET() macros should
** be printed to standard output. This variable can only be set from
** within the debugger. */
static int et_trace_flag = 0;

/*
** This is the function which does most of the work.  All the Et_EvalXXXX()
** functions call this core to process the variable-length argument list,
** and then do different things with the return parameter
*/
static int
Et_VaEval(fileName,lineNumber,format,ap)
const char *fileName;      /* Name of the file containing the ET macro */
int lineNumber;            /* Line number of start of ET macro */
const char *format;        /* Format string */
va_list ap;                /* Pointer to the argument list */
{
  int i;                     /* Loop counter */
  int retc;                  /* Return code from Tcl_Eval() */
  char *buf;                 /* Buffer to hold the Tcl command string  */
  char *cp;                  /* For scanning strings */
  char c;                    /* Next character being scanned */
  char *next;                /* Pointer to the next unused slot in buf[] */
  int spaceNeeded;           /* Amount of spaced needed in buf to hold
                             ** the entire Tcl command string */
  va_list firstArg;          /* A pointer to the first argument of the
                             ** variant part of the argument list. */
  char smallSpace[40];       /* A space large enough to hold the ascii
                             ** value of an integer or floating point number */
  char bigSpace[1000];       /* The initial buffer.  Hopefully this is enough,
                             ** but if not we can malloc() for more */

  if( Et_Interp==0 ){
    fprintf(stderr,
      "ERROR: %s line %d: Et_Interp does not point to a valid Tk interpreter\n",
      fileName,lineNumber);
    return TCL_ERROR;
  }

  /* Make a pass thru the argument list and tally up the size of the
  ** buffer needed */
  firstArg = ap;
  spaceNeeded = 1;   /* One for the null-terminator */
  for(i=0; format[i]; i++){
    switch( format[i] ){
      case 's':    /* A string */
        spaceNeeded += strlen(va_arg(ap,char*));
        break;

      case 'd':    /* An integer */
        spaceNeeded += 20;
        (void)va_arg(ap,int);
        break;

      case 'f':    /* A double */
        spaceNeeded += 20;
        (void)va_arg(ap,double);
        break;

      case 'q':    /* A quoted string */
        cp = va_arg(ap,char*);
        while( (c=*cp++)!=0 ){
          if( c=='$' || c=='[' || c=='\"' || c=='\\' || c=='{' || c=='}' ){
            spaceNeeded++;
          }
          spaceNeeded++;
	}
        break;
    }
  }

  /* Get a buf which is large enough to hold it all */
  if( spaceNeeded<=sizeof(bigSpace) ){
    buf = bigSpace;
  }else{
    extern char *malloc();
    buf = malloc( spaceNeeded );
    if( buf==0 ){
       sprintf(bigSpace,"File %s line %d: can't allocate %d bytes of memory",
          fileName,lineNumber,spaceNeeded);
       Tcl_AppendResult(Et_Interp,bigSpace,0);
       return TCL_ERROR;
    }
  }

  /* Now make another pass thru the argument list in order to
  ** build the Tcl command string */
  ap = firstArg;
  next = buf;
  for(i=0; format[i]; i++){
    char *str;       /* Pointer to a source string which is to be
                     ** copied into buf */
    switch( format[i] ){
      case 's':    /* A string */
        str = va_arg(ap,char*);
        break;

      case 'd':    /* An integer */
        str = smallSpace;
        sprintf(str,"%d",va_arg(ap,int));
        break;

      case 'f':    /* A double */
        str = smallSpace;
        sprintf(str,"%g",va_arg(ap,double));
        break;

      case 'q':    /* A quoted string */
        str = va_arg(ap,char*);
        while( (c=*str)!=0 ){
          if( c=='$' || c=='[' || c=='\"' || c=='\\' || c=='{' || c=='}' ){
            *next++ = '\\';
	  }
          *next++ = c;
          str++;
	}
        break;

      default:     /* Can't happen */
        str = "";
        break;
    }
    while( (*next++ = *str++)!=0 );
    next--;
  }

  /* Evaluate the Tcl command string.  Generate an error message
  ** if an error occurs */
  retc = Tcl_GlobalEval(Et_Interp,buf);
  if( et_trace_flag ){
    char *cp = buf;
    while( *cp ){
      if( *cp=='\\' && cp[1]=='\n' ){ *cp=' '; cp[1]=' '; }
      cp++;
    }
    printf("%s\n",buf);
  }
  if( retc==TCL_ERROR ){
    char buf[40];
    fprintf(stderr,"ERROR at %s line %d: %s\n",
       fileName,Et_Interp->errorLine + lineNumber - 1,Et_Interp->result);
    sprintf(buf,"%d",Et_Interp->errorLine + lineNumber + 1);
    Tcl_VarEval(Et_Interp,"tkerror {",fileName," line ",buf,"}",0);
  }

  /* clean up and return */
  if( buf!=bigSpace ) free(buf);
  return retc;
}

/*
** This version of Et_Eval() evaluates a single string as the Tcl command,
** just as Tcl_Eval() would.  The difference is in the processing of
** error message.  This function is called by the ET_INCLUDE() macro.
** Et_Eval() could have been used, but this version avoids an extra
** copy of the script from one buffer into another.
*/
void
Et_EvalInclude(zFilename,script)
const char *zFilename; /* The file from which the script was origanally taken */
char *script;          /* The Tcl/Tk command script */
{
  if( Et_Interp==0 ){
    fprintf(stderr,
      "ERROR: %s: Et_Interp does not point to a valid Tk interpreter\n",
      zFilename);
    return;
  }
  if( Tcl_GlobalEval(Et_Interp,script)==TCL_ERROR ){
    char buf[40];
    fprintf(stderr,"ERROR at %s line %d: %s\n",
       zFilename,Et_Interp->errorLine,Et_Interp->result);
    sprintf(buf,"%d",Et_Interp->errorLine);
    Tcl_VarEval(Et_Interp,"tkerror {",zFilename," line ",buf,"}",0);
  }
}

/*
** Execute the Tcl/Tk command string and return an status code
*/
#ifdef K_AND_R
int
Et_Eval(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int retc;                  /* The Tcl_Eval() return code */
  char *filename;            /* The filename */
  int lineNumber;            /* The line number */
  char *format;              /* The format string */

  va_start(ap);
  filename = va_arg(ap,char*);
  lineNumber = va_arg(ap,int);
  format = va_arg(ap,char*);
  retc = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return retc;
}
#else
int Et_Eval(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int retc;
  va_start(ap,format);
  retc = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return retc;
}
#endif

/*
** Execute the Tcl/Tk command string and return the result string
*/
#ifdef K_AND_R
char *
Et_EvalString(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int status;                /* The status returned from Et_VaEval() */
  char *filename;            /* The filename */
  int lineNumber;            /* The line number */
  char *format;              /* The format string */

  va_start(ap);
  filename = va_arg(ap,char*);
  lineNumber = va_arg(ap,int);
  format = va_arg(ap,char*);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return Et_Interp->result;
}
#else
char *
Et_EvalString(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return Et_Interp->result;
}
#endif

/*
** Execute the Tcl/Tk command string and return the result converted
** into an integer
*/
#ifdef K_AND_R
int
Et_EvalInt(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int status;                /* The status returned from Et_VaEval() */
  char *filename;            /* The filename */
  int lineNumber;            /* The line number */
  char *format;              /* The format string */

  va_start(ap);
  filename = va_arg(ap,char*);
  lineNumber = va_arg(ap,int);
  format = va_arg(ap,char*);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return atoi(Et_Interp->result);
}
#else
int
Et_EvalInt(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return atoi(Et_Interp->result);
}
#endif

/*
** Execute the Tcl/Tk command string and return the result converted
** into an double
*/
#ifdef K_AND_R
double
Et_EvalDouble(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int status;                /* The status returned from Et_VaEval() */

  va_start(ap);
  status = Et_VaEval(ap);
  va_end(ap);
  return atof(Et_Interp->result);
}
#else
double
Et_EvalDouble(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return atof(Et_Interp->result);
}
#endif

/*
** Install a new command into the interpreter.
*/
#ifdef K_AND_R
void
Et_InstallCommand(zName,cmdProc)
char *zName;         /* Name of the command */
int (*cmdProc)();    /* Procedure which implements the command */
{
  Tcl_CreateCommand(Et_Interp,zName,cmdProc,Tk_MainWindow(Et_Interp),0);
}
#else
void
Et_InstallCommand(
  char *zName, 
  int (*cmdProc)(void*,struct Tcl_Interp*,int,char**)
){
  Tcl_CreateCommand(Et_Interp,zName,cmdProc,Tk_MainWindow(Et_Interp),0);
}
#endif


/* This routine executes the various Tcl/Tk start-up scripts.  This
** would normally be accomplished by the initScript[] script in the
** Initialize() function.
*/
static int ReadStartupScripts(interp)
  Tcl_Interp *interp;
{ 
  extern void TkCreateXEventSource();
  TkCreateXEventSource();

 /* Load the Tcl/Tk startup scripts.
  */
  Et_Eval(__FILE__,__LINE__,"s","set tk_library {}; set tcl_library {} ");
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[info commands package] == \"\"} {\n"
"error \"version mismatch: library\\nscripts expect Tcl version 7.5b1 or later but the loaded version is\\nonly [info patchlevel]\"\n"
"}\n"
"package require -exact Tcl 8.0\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {![info exists auto_path]} {\n"
"if {[info exist env(TCLLIBPATH)]} {\n"
"set auto_path $env(TCLLIBPATH)\n"
"} else {\n"
"set auto_path \"\"\n"
"}\n"
"}\n"
"if {[string compare [info library] {}]} {\n"
"foreach __dir [list [info library] [file dirname [info library]]] {\n"
"if {[lsearch -exact $auto_path $__dir] < 0} {\n"
"lappend auto_path $__dir\n"
"}\n"
"}\n"
"}\n"
"if {[info exist tcl_pkgPath]} {\n"
"foreach __dir $tcl_pkgPath {\n"
"if {[lsearch -exact $auto_path $__dir] < 0} {\n"
"lappend auto_path $__dir\n"
"}\n"
"}\n"
"}\n"
"if {[info exists __dir]} {\n"
"unset __dir\n"
"}\n"
"\n"
"\n"
"\n"
"if {(![interp issafe]) && ($tcl_platform(platform) == \"windows\")} {\n"
"namespace eval tcl {\n"
"proc envTraceProc {lo n1 n2 op} {\n"
"set x $::env($n2)\n"
"set ::env($lo) $x\n"
"set ::env([string toupper $lo]) $x\n"
"}\n"
"}\n"
"foreach p [array names env] {\n"
"set u [string toupper $p]\n"
"if {$u != $p} {\n"
"switch -- $u {\n"
"COMSPEC -\n"
"PATH {\n"
"if {![info exists env($u)]} {\n"
"set env($u) $env($p)\n"
"}\n"
"trace variable env($p) w [list tcl::envTraceProc $p]\n"
"trace variable env($u) w [list tcl::envTraceProc $p]\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if {[info exists p]} {\n"
"unset p\n"
"}\n"
"if {[info exists u]} {\n"
"unset u\n"
"}\n"
"if {![info exists env(COMSPEC)]} {\n"
"if {$tcl_platform(os) == {Windows NT}} {\n"
"set env(COMSPEC) cmd.exe\n"
"} else {\n"
"set env(COMSPEC) command.com\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"package unknown tclPkgUnknown\n"
"\n"
"\n"
"\n"
"if {[info commands exec] == \"\"} {\n"
"\n"
"\n"
"\n"
"\n"
"set auto_noexec 1\n"
"}\n"
"set errorCode \"\"\n"
"set errorInfo \"\"\n"
"\n"
"\n"
"\n"
"\n"
"if {[info commands tclLog] == \"\"} {\n"
"proc tclLog {string} {\n"
"catch {puts stderr $string}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc unknown args {\n"
"global auto_noexec auto_noload env unknown_pending tcl_interactive\n"
"global errorCode errorInfo\n"
"\n"
"\n"
"\n"
"\n"
"set cmd [lindex $args 0]\n"
"if {[regexp \"^namespace\\[ \\t\\n\\]+inscope\" $cmd] && [llength $cmd] == 4} {\n"
"set arglist [lrange $args 1 end]\n"
"set ret [catch {uplevel $cmd $arglist} result]\n"
"if {$ret == 0} {\n"
"return $result\n"
"} else {\n"
"return -code $ret -errorcode $errorCode $result\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set savedErrorCode $errorCode\n"
"set savedErrorInfo $errorInfo\n"
"set name [lindex $args 0]\n"
"if {![info exists auto_noload]} {\n"
"\n"
"\n"
"\n"
"if {[info exists unknown_pending($name)]} {\n"
"return -code error \"self-referential recursion in \\\"unknown\\\" for command \\\"$name\\\"\";\n"
"}\n"
"set unknown_pending($name) pending;\n"
"set ret [catch {auto_load $name [uplevel 1 {namespace current}]} msg]\n"
"unset unknown_pending($name);\n"
"if {$ret != 0} {\n"
"return -code $ret -errorcode $errorCode \\\n"
"\"error while autoloading \\\"$name\\\": $msg\"\n"
"}\n"
"if {![array size unknown_pending]} {\n"
"unset unknown_pending\n"
"}\n"
"if {$msg} {\n"
"set errorCode $savedErrorCode\n"
"set errorInfo $savedErrorInfo\n"
"set code [catch {uplevel 1 $args} msg]\n"
"if {$code ==  1} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set new [split $errorInfo \\n]\n"
"set new [join [lrange $new 0 [expr {[llength $new] - 6}]] \\n]\n"
"return -code error -errorcode $errorCode \\\n"
"-errorinfo $new $msg\n"
"} else {\n"
"return -code $code $msg\n"
"}\n"
"}\n"
"}\n"
"\n"
"if {([info level] == 1) && ([info script] == \"\") \\\n"
"&& [info exists tcl_interactive] && $tcl_interactive} {\n"
"if {![info exists auto_noexec]} {\n"
"set new [auto_execok $name]\n"
"if {$new != \"\"} {\n"
"set errorCode $savedErrorCode\n"
"set errorInfo $savedErrorInfo\n"
"set redir \"\"\n"
"if {[info commands console] == \"\"} {\n"
"set redir \">&@stdout <@stdin\"\n"
"}\n"
"return [uplevel exec $redir $new [lrange $args 1 end]]\n"
"}\n"
"}\n"
"set errorCode $savedErrorCode\n"
"set errorInfo $savedErrorInfo\n"
"if {$name == \"!!\"} {\n"
"set newcmd [history event]\n"
"} elseif {[regexp {^!(.+)$} $name dummy event]} {\n"
"set newcmd [history event $event]\n"
"} elseif {[regexp {^\\^([^^]*)\\^([^^]*)\\^?$} $name dummy old new]} {\n"
"set newcmd [history event -1]\n"
"catch {regsub -all -- $old $newcmd $new newcmd}\n"
"}\n"
"if {[info exists newcmd]} {\n"
"tclLog $newcmd\n"
"history change $newcmd 0\n"
"return [uplevel $newcmd]\n"
"}\n"
"\n"
"set ret [catch {set cmds [info commands $name*]} msg]\n"
"if {[string compare $name \"::\"] == 0} {\n"
"set name \"\"\n"
"}\n"
"if {$ret != 0} {\n"
"return -code $ret -errorcode $errorCode \\\n"
"\"error in unknown while checking if \\\"$name\\\" is a unique command abbreviation: $msg\"\n"
"}\n"
"if {[llength $cmds] == 1} {\n"
"return [uplevel [lreplace $args 0 0 $cmds]]\n"
"}\n"
"if {[llength $cmds] != 0} {\n"
"if {$name == \"\"} {\n"
"return -code error \"empty command name \\\"\\\"\"\n"
"} else {\n"
"return -code error \\\n"
"\"ambiguous command name \\\"$name\\\": [lsort $cmds]\"\n"
"}\n"
"}\n"
"}\n"
"return -code error \"invalid command name \\\"$name\\\"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_load {cmd {namespace {}}} {\n"
"global auto_index auto_oldpath auto_path\n"
"\n"
"if {[string length $namespace] == 0} {\n"
"set namespace [uplevel {namespace current}]\n"
"}\n"
"set nameList [auto_qualify $cmd $namespace]\n"
"\n"
"\n"
"lappend nameList $cmd\n"
"foreach name $nameList {\n"
"if {[info exists auto_index($name)]} {\n"
"uplevel #0 $auto_index($name)\n"
"return [expr {[info commands $name] != \"\"}]\n"
"}\n"
"}\n"
"if {![info exists auto_path]} {\n"
"return 0\n"
"}\n"
"\n"
"if {![auto_load_index]} {\n"
"return 0\n"
"}\n"
"\n"
"foreach name $nameList {\n"
"if {[info exists auto_index($name)]} {\n"
"uplevel #0 $auto_index($name)\n"
"if {[info commands $name] != \"\"} {\n"
"return 1\n"
"}\n"
"}\n"
"}\n"
"return 0\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_load_index {} {\n"
"global auto_index auto_oldpath auto_path errorInfo errorCode\n"
"\n"
"if {[info exists auto_oldpath]} {\n"
"if {$auto_oldpath == $auto_path} {\n"
"return 0\n"
"}\n"
"}\n"
"set auto_oldpath $auto_path\n"
"\n"
"\n"
"\n"
"\n"
"set issafe [interp issafe]\n"
"for {set i [expr {[llength $auto_path] - 1}]} {$i >= 0} {incr i -1} {\n"
"set dir [lindex $auto_path $i]\n"
"set f \"\"\n"
"if {$issafe} {\n"
"catch {source [file join $dir tclIndex]}\n"
"} elseif {[catch {set f [open [file join $dir tclIndex]]}]} {\n"
"continue\n"
"} else {\n"
"set error [catch {\n"
"set id [gets $f]\n"
"if {$id == \"# Tcl autoload index file, version 2.0\"} {\n"
"eval [read $f]\n"
"} elseif {$id == \\\n"
"\"# Tcl autoload index file: each line identifies a Tcl\"} {\n"
"while {[gets $f line] >= 0} {\n"
"if {([string index $line 0] == \"#\")\n"
"|| ([llength $line] != 2)} {\n"
"continue\n"
"}\n"
"set name [lindex $line 0]\n"
"set auto_index($name) \\\n"
"\"source [file join $dir [lindex $line 1]]\"\n"
"}\n"
"} else {\n"
"error \\\n"
"\"[file join $dir tclIndex] isn't a proper Tcl index file\"\n"
"}\n"
"} msg]\n"
"if {$f != \"\"} {\n"
"close $f\n"
"}\n"
"if {$error} {\n"
"error $msg $errorInfo $errorCode\n"
"}\n"
"}\n"
"}\n"
"return 1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_qualify {cmd namespace} {\n"
"\n"
"\n"
"\n"
"set n [regsub -all {::+} $cmd :: cmd]\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[regexp {^::(.*)$} $cmd x tail]} {\n"
"if {$n > 1} {\n"
"\n"
"return [list $cmd]\n"
"} else {\n"
"\n"
"return [list $tail]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {$n == 0} {\n"
"if {[string compare $namespace ::] == 0} {\n"
"\n"
"return [list $cmd]\n"
"} else {\n"
"\n"
"return [list ${namespace}::$cmd $cmd]\n"
"}\n"
"} else {\n"
"if {[string compare $namespace ::] == 0} {\n"
"\n"
"return [list ::$cmd]\n"
"} else {\n"
"\n"
"return [list ${namespace}::$cmd ::$cmd]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_import {pattern} {\n"
"global auto_index\n"
"\n"
"set ns [uplevel namespace current]\n"
"set patternList [auto_qualify $pattern $ns]\n"
"\n"
"auto_load_index\n"
"\n"
"foreach pattern $patternList {\n"
"foreach name [array names auto_index] {\n"
"if {[string match $pattern $name] && \"\" == [info commands $name]} {\n"
"uplevel #0 $auto_index($name)\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"if {[string compare $tcl_platform(platform) windows] == 0} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_execok name {\n"
"global auto_execs env tcl_platform\n"
"\n"
"if {[info exists auto_execs($name)]} {\n"
"return $auto_execs($name)\n"
"}\n"
"set auto_execs($name) \"\"\n"
"\n"
"if {[lsearch -exact {cls copy date del erase dir echo mkdir md rename \n"
"ren rmdir rd time type ver vol} $name] != -1} {\n"
"return [set auto_execs($name) [list $env(COMSPEC) /c $name]]\n"
"}\n"
"\n"
"if {[llength [file split $name]] != 1} {\n"
"foreach ext {{} .com .exe .bat} {\n"
"set file ${name}${ext}\n"
"if {[file exists $file] && ![file isdirectory $file]} {\n"
"return [set auto_execs($name) [list $file]]\n"
"}\n"
"}\n"
"return \"\"\n"
"}\n"
"\n"
"set path \"[file dirname [info nameof]];.;\"\n"
"if {[info exists env(WINDIR)]} {\n"
"set windir $env(WINDIR) \n"
"}\n"
"if {[info exists windir]} {\n"
"if {$tcl_platform(os) == \"Windows NT\"} {\n"
"append path \"$windir/system32;\"\n"
"}\n"
"append path \"$windir/system;$windir;\"\n"
"}\n"
"\n"
"if {[info exists env(PATH)]} {\n"
"append path $env(PATH)\n"
"}\n"
"\n"
"foreach dir [split $path {;}] {\n"
"if {$dir == \"\"} {\n"
"set dir .\n"
"}\n"
"foreach ext {{} .com .exe .bat} {\n"
"set file [file join $dir ${name}${ext}]\n"
"if {[file exists $file] && ![file isdirectory $file]} {\n"
"return [set auto_execs($name) [list $file]]\n"
"}\n"
"}\n"
"}\n"
"return \"\"\n"
"}\n"
"\n"
"} else {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_execok name {\n"
"global auto_execs env\n"
"\n"
"if {[info exists auto_execs($name)]} {\n"
"return $auto_execs($name)\n"
"}\n"
"set auto_execs($name) \"\"\n"
"if {[llength [file split $name]] != 1} {\n"
"if {[file executable $name] && ![file isdirectory $name]} {\n"
"set auto_execs($name) [list $name]\n"
"}\n"
"return $auto_execs($name)\n"
"}\n"
"foreach dir [split $env(PATH) :] {\n"
"if {$dir == \"\"} {\n"
"set dir .\n"
"}\n"
"set file [file join $dir $name]\n"
"if {[file executable $file] && ![file isdirectory $file]} {\n"
"set auto_execs($name) [list $file]\n"
"return $auto_execs($name)\n"
"}\n"
"}\n"
"return \"\"\n"
"}\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_reset {} {\n"
"global auto_execs auto_index auto_oldpath\n"
"foreach p [info procs] {\n"
"if {[info exists auto_index($p)] && ![string match auto_* $p]\n"
"&& ([lsearch -exact {unknown pkg_mkIndex tclPkgSetup\n"
"tcl_findLibrary pkg_compareExtension\n"
"tclMacPkgSearch tclPkgUnknown} $p] < 0)} {\n"
"rename $p {}\n"
"}\n"
"}\n"
"catch {unset auto_execs}\n"
"catch {unset auto_index}\n"
"catch {unset auto_oldpath}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tcl_findLibrary {basename version patch initScript enVarName varName} {\n"
"upvar #0 $varName the_library\n"
"global env errorInfo\n"
"\n"
"set dirs {}\n"
"set errors {}\n"
"\n"
"\n"
"\n"
"if {[info exist the_library] && [string compare $the_library {}]} {\n"
"lappend dirs $the_library\n"
"} else {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[info exists env($enVarName)]} {\n"
"lappend dirs $env($enVarName)\n"
"}\n"
"\n"
"\n"
"\n"
"lappend dirs [file join [file dirname [info library]] \\\n"
"$basename$version]\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set parentDir [file dirname [file dirname [info nameofexecutable]]]\n"
"set grandParentDir [file dirname $parentDir]\n"
"lappend dirs [file join $parentDir lib $basename$version]\n"
"lappend dirs [file join $grandParentDir lib $basename$version]\n"
"lappend dirs [file join $parentDir library]\n"
"lappend dirs [file join $grandParentDir library]\n"
"if {![regexp {.*[ab][0-9]*} $patch ver]} {\n"
"set ver $version\n"
"}\n"
"lappend dirs [file join $grandParentDir $basename$ver library]\n"
"lappend dirs [file join [file dirname $grandParentDir] $basename$ver library]\n"
"}\n"
"foreach i $dirs {\n"
"set the_library $i\n"
"set file [file join $i $initScript]\n"
"\n"
"\n"
"\n"
"\n"
"if {[interp issafe] || [file exists $file]} {\n"
"if {![catch {uplevel #0 [list source $file]} msg]} {\n"
"return\n"
"} else {\n"
"append errors \"$file: $msg\\n$errorInfo\\n\"\n"
"}\n"
"}\n"
"}\n"
"set msg \"Can't find a usable $initScript in the following directories: \\n\"\n"
"append msg \"    $dirs\\n\\n\"\n"
"append msg \"$errors\\n\\n\"\n"
"append msg \"This probably means that $basename wasn't installed properly.\\n\"\n"
"error $msg\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {! [interp issafe]} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex {dir args} {\n"
"global errorCode errorInfo\n"
"\n"
"set oldDir [pwd]\n"
"cd $dir\n"
"set dir [pwd]\n"
"\n"
"append index \"# Tcl autoload index file, version 2.0\\n\"\n"
"append index \"# This file is generated by the \\\"auto_mkindex\\\" command\\n\"\n"
"append index \"# and sourced to set up indexing information for one or\\n\"\n"
"append index \"# more commands.  Typically each line is a command that\\n\"\n"
"append index \"# sets an element in the auto_index array, where the\\n\"\n"
"append index \"# element name is the name of a command and the value is\\n\"\n"
"append index \"# a script that loads the command.\\n\\n\"\n"
"if {$args == \"\"} {\n"
"set args *.tcl\n"
"}\n"
"\n"
"auto_mkindex_parser::init\n"
"foreach file [eval glob $args] {\n"
"if {[catch {auto_mkindex_parser::mkindex $file} msg] == 0} {\n"
"append index $msg\n"
"} else {\n"
"set code $errorCode\n"
"set info $errorInfo\n"
"cd $oldDir\n"
"error $msg $info $code\n"
"}\n"
"}\n"
"auto_mkindex_parser::cleanup\n"
"\n"
"set fid [open \"tclIndex\" w]\n"
"puts $fid $index nonewline\n"
"close $fid\n"
"cd $oldDir\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_old {dir args} {\n"
"global errorCode errorInfo\n"
"set oldDir [pwd]\n"
"cd $dir\n"
"set dir [pwd]\n"
"append index \"# Tcl autoload index file, version 2.0\\n\"\n"
"append index \"# This file is generated by the \\\"auto_mkindex\\\" command\\n\"\n"
"append index \"# and sourced to set up indexing information for one or\\n\"\n"
"append index \"# more commands.  Typically each line is a command that\\n\"\n"
"append index \"# sets an element in the auto_index array, where the\\n\"\n"
"append index \"# element name is the name of a command and the value is\\n\"\n"
"append index \"# a script that loads the command.\\n\\n\"\n"
"if {$args == \"\"} {\n"
"set args *.tcl\n"
"}\n"
"foreach file [eval glob $args] {\n"
"set f \"\"\n"
"set error [catch {\n"
"set f [open $file]\n"
"while {[gets $f line] >= 0} {\n"
"if {[regexp {^proc[  ]+([^  ]*)} $line match procName]} {\n"
"set procName [lindex [auto_qualify $procName \"::\"] 0]\n"
"append index \"set [list auto_index($procName)]\"\n"
"append index \" \\[list source \\[file join \\$dir [list $file]\\]\\]\\n\"\n"
"}\n"
"}\n"
"close $f\n"
"} msg]\n"
"if {$error} {\n"
"set code $errorCode\n"
"set info $errorInfo\n"
"catch {close $f}\n"
"cd $oldDir\n"
"error $msg $info $code\n"
"}\n"
"}\n"
"set f \"\"\n"
"set error [catch {\n"
"set f [open tclIndex w]\n"
"puts $f $index nonewline\n"
"close $f\n"
"cd $oldDir\n"
"} msg]\n"
"if {$error} {\n"
"set code $errorCode\n"
"set info $errorInfo\n"
"catch {close $f}\n"
"cd $oldDir\n"
"error $msg $info $code\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"namespace eval auto_mkindex_parser {\n"
"variable parser \"\"          ;# parser used to build index\n"
"variable index \"\"           ;# maintains index as it is built\n"
"variable scriptFile \"\"      ;# name of file being processed\n"
"variable contextStack \"\"    ;# stack of namespace scopes\n"
"variable imports \"\"         ;# keeps track of all imported cmds\n"
"variable initCommands \"\"    ;# list of commands that create aliases\n"
"\n"
"proc init {} {\n"
"variable parser\n"
"variable initCommands\n"
"\n"
"if {![interp issafe]} {\n"
"set parser [interp create -safe]\n"
"$parser hide info\n"
"$parser hide rename\n"
"$parser hide proc\n"
"$parser hide namespace\n"
"$parser hide eval\n"
"$parser hide puts\n"
"$parser invokehidden namespace delete ::\n"
"$parser invokehidden proc unknown {args} {}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"$parser expose namespace\n"
"$parser invokehidden rename namespace _%@namespace\n"
"$parser expose eval\n"
"$parser invokehidden rename eval _%@eval\n"
"\n"
"\n"
"\n"
"foreach cmd $initCommands {\n"
"eval $cmd\n"
"}\n"
"}\n"
"}\n"
"proc cleanup {} {\n"
"variable parser\n"
"interp delete $parser\n"
"unset parser\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_parser::mkindex {file} {\n"
"variable parser\n"
"variable index\n"
"variable scriptFile\n"
"variable contextStack\n"
"variable imports\n"
"\n"
"set scriptFile $file\n"
"\n"
"set fid [open $file]\n"
"set contents [read $fid]\n"
"close $fid\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"regsub -all {([^\\$])\\$([^\\$])} $contents {\\1\\\\$\\2} contents\n"
"\n"
"set index \"\"\n"
"set contextStack \"\"\n"
"set imports \"\"\n"
"\n"
"$parser eval $contents\n"
"\n"
"foreach name $imports {\n"
"catch {$parser eval [list _%@namespace forget $name]}\n"
"}\n"
"return $index\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_parser::hook {cmd} {\n"
"variable initCommands\n"
"\n"
"lappend initCommands $cmd\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_parser::slavehook {cmd} {\n"
"variable initCommands\n"
"\n"
"lappend initCommands [list \\$parser eval $cmd]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_parser::command {name arglist body} {\n"
"hook [list auto_mkindex_parser::commandInit $name $arglist $body]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_parser::commandInit {name arglist body} {\n"
"variable parser\n"
"\n"
"set ns [namespace qualifiers $name]\n"
"set tail [namespace tail $name]\n"
"if {$ns == \"\"} {\n"
"set fakeName \"[namespace current]::_%@fake_$tail\"\n"
"} else {\n"
"set fakeName \"_%@fake_$name\"\n"
"regsub -all {::} $fakeName \"_\" fakeName\n"
"set fakeName \"[namespace current]::$fakeName\"\n"
"}\n"
"proc $fakeName $arglist $body\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[regexp {::} $name]} {\n"
"set exportCmd [list _%@namespace export [namespace tail $name]]\n"
"$parser eval [list _%@namespace eval $ns $exportCmd]\n"
"set alias [namespace tail $fakeName]\n"
"$parser invokehidden proc $name {args} [list _%@eval $alias \\$args]\n"
"$parser alias $alias $fakeName\n"
"} else {\n"
"$parser alias $name $fakeName\n"
"}\n"
"return\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc auto_mkindex_parser::fullname {name} {\n"
"variable contextStack\n"
"\n"
"if {![string match ::* $name]} {\n"
"foreach ns $contextStack {\n"
"set name \"${ns}::$name\"\n"
"if {[string match ::* $name]} {\n"
"break\n"
"}\n"
"}\n"
"}\n"
"\n"
"if {[namespace qualifiers $name] == \"\"} {\n"
"return [namespace tail $name]\n"
"} elseif {![string match ::* $name]} {\n"
"return \"::$name\"\n"
"}\n"
"return $name\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"auto_mkindex_parser::command proc {name args} {\n"
"variable index\n"
"variable scriptFile\n"
"append index [list set auto_index([fullname $name])] \\\n"
"\" \\[list source \\[file join \\$dir [list $scriptFile]\\]\\]\\n\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"auto_mkindex_parser::hook {\n"
"if {![catch {package require tbcload}]} {\n"
"if {[info commands tbcload::bcproc] == \"\"} {\n"
"auto_load tbcload::bcproc\n"
"}\n"
"load {} tbcload $auto_mkindex_parser::parser\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"auto_mkindex_parser::commandInit tbcload::bcproc {name args} {\n"
"variable index\n"
"variable scriptFile\n"
"append index [list set auto_index([fullname $name])] \\\n"
"\" \\[list source \\[file join \\$dir [list $scriptFile]\\]\\]\\n\"\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"auto_mkindex_parser::command namespace {op args} {\n"
"switch -- $op {\n"
"eval {\n"
"variable parser\n"
"variable contextStack\n"
"\n"
"set name [lindex $args 0]\n"
"set args [lrange $args 1 end]\n"
"\n"
"set contextStack [linsert $contextStack 0 $name]\n"
"$parser eval [list _%@namespace eval $name] $args\n"
"set contextStack [lrange $contextStack 1 end]\n"
"}\n"
"import {\n"
"variable parser\n"
"variable imports\n"
"foreach pattern $args {\n"
"if {$pattern != \"-force\"} {\n"
"lappend imports $pattern\n"
"}\n"
"}\n"
"catch {$parser eval [list _%@namespace import] $args}\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc pkg_compareExtension { fileName {ext {}} } {\n"
"global tcl_platform\n"
"if {[string length $ext] == 0} {\n"
"set ext [info sharedlibextension]\n"
"}\n"
"if {[string compare $tcl_platform(platform) \"windows\"] == 0} {\n"
"return [expr {[string compare \\\n"
"[string tolower [file extension $fileName]] \\\n"
"[string tolower $ext]] == 0}]\n"
"} else {\n"
"return [expr {[string compare [file extension $fileName] $ext] == 0}]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc pkg_mkIndex {args} {\n"
"global errorCode errorInfo\n"
"set usage {\"pkg_mkIndex ?-direct? ?-verbose? ?-load pattern? ?--? dir ?pattern ...?\"};\n"
"\n"
"set argCount [llength $args]\n"
"if {$argCount < 1} {\n"
"return -code error \"wrong # args: should be\\n$usage\"\n"
"}\n"
"\n"
"set more \"\"\n"
"set direct 0\n"
"set doVerbose 0\n"
"set loadPat \"\"\n"
"for {set idx 0} {$idx < $argCount} {incr idx} {\n"
"set flag [lindex $args $idx]\n"
"switch -glob -- $flag {\n"
"-- {\n"
"\n"
"incr idx\n"
"break\n"
"}\n"
"-verbose {\n"
"set doVerbose 1\n"
"}\n"
"-direct {\n"
"set direct 1\n"
"append more \" -direct\"\n"
"}\n"
"-load {\n"
"incr idx\n"
"set loadPat [lindex $args $idx]\n"
"append more \" -load $loadPat\"\n"
"}\n"
"-* {\n"
"return -code error \"unknown flag $flag: should be\\n$usage\"\n"
"}\n"
"default {\n"
"\n"
"break\n"
"}\n"
"}\n"
"}\n"
"\n"
"set dir [lindex $args $idx]\n"
"set patternList [lrange $args [expr {$idx + 1}] end]\n"
"if {[llength $patternList] == 0} {\n"
"set patternList [list \"*.tcl\" \"*[info sharedlibextension]\"]\n"
"}\n"
"\n"
"append index \"# Tcl package index file, version 1.1\\n\"\n"
"append index \"# This file is generated by the \\\"pkg_mkIndex$more\\\" command\\n\"\n"
"append index \"# and sourced either when an application starts up or\\n\"\n"
"append index \"# by a \\\"package unknown\\\" script.  It invokes the\\n\"\n"
"append index \"# \\\"package ifneeded\\\" command to set up package-related\\n\"\n"
"append index \"# information so that packages will be loaded automatically\\n\"\n"
"append index \"# in response to \\\"package require\\\" commands.  When this\\n\"\n"
"append index \"# script is sourced, the variable \\$dir must contain the\\n\"\n"
"append index \"# full path name of this file's directory.\\n\"\n"
"set oldDir [pwd]\n"
"cd $dir\n"
"\n"
"if {[catch {eval glob $patternList} fileList]} {\n"
"global errorCode errorInfo\n"
"cd $oldDir\n"
"return -code error -errorcode $errorCode -errorinfo $errorInfo $fileList\n"
"}\n"
"foreach file $fileList {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[string compare $file \"pkgIndex.tcl\"] == 0} {\n"
"continue\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"cd $oldDir\n"
"set c [interp create]\n"
"\n"
"\n"
"\n"
"\n"
"foreach pkg [info loaded] {\n"
"if {! [string match $loadPat [lindex $pkg 1]]} {\n"
"continue\n"
"}\n"
"if {[lindex $pkg 1] == \"Tk\"} {\n"
"$c eval {set argv {-geometry +0+0}}\n"
"}\n"
"if {[catch {\n"
"load [lindex $pkg 0] [lindex $pkg 1] $c\n"
"} err]} {\n"
"if {$doVerbose} {\n"
"tclLog \"warning: load [lindex $pkg 0] [lindex $pkg 1]\\nfailed with: $err\"\n"
"}\n"
"} else {\n"
"if {$doVerbose} {\n"
"tclLog \"loaded [lindex $pkg 0] [lindex $pkg 1]\"\n"
"}\n"
"}\n"
"}\n"
"cd $dir\n"
"\n"
"$c eval {\n"
"\n"
"\n"
"\n"
"rename package __package_orig\n"
"proc package {what args} {\n"
"switch -- $what {\n"
"require { return ; # ignore transitive requires }\n"
"default { eval __package_orig {$what} $args }\n"
"}\n"
"}\n"
"proc tclPkgUnknown args {}\n"
"package unknown tclPkgUnknown\n"
"\n"
"\n"
"\n"
"\n"
"proc unknown {args} {}\n"
"\n"
"\n"
"\n"
"proc auto_import {args} {}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"namespace eval ::tcl {\n"
"variable file  ;# Current file being processed\n"
"variable direct  ;# -direct flag value\n"
"variable x  ;# Loop variable\n"
"variable debug  ;# For debugging\n"
"variable type  ;# \"load\" or \"source\", for -direct\n"
"variable namespaces ;# Existing namespaces (e.g., ::tcl)\n"
"variable packages ;# Existing packages (e.g., Tcl)\n"
"variable origCmds ;# Existing commands\n"
"variable newCmds ;# Newly created commands\n"
"variable newPkgs {} ;# Newly created packages\n"
"}\n"
"}\n"
"\n"
"$c eval [list set ::tcl::file $file]\n"
"$c eval [list set ::tcl::direct $direct]\n"
"if {[catch {\n"
"$c eval {\n"
"set ::tcl::debug \"loading or sourcing\"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc ::tcl::GetAllNamespaces {{root ::}} {\n"
"set list $root\n"
"foreach ns [namespace children $root] {\n"
"eval lappend list [::tcl::GetAllNamespaces $ns]\n"
"}\n"
"return $list\n"
"}\n"
"\n"
"\n"
"\n"
"foreach ::tcl::x [::tcl::GetAllNamespaces] {\n"
"set ::tcl::namespaces($::tcl::x) 1\n"
"}\n"
"foreach ::tcl::x [package names] {\n"
"set ::tcl::packages($::tcl::x) 1\n"
"}\n"
"set ::tcl::origCmds [info commands]\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[pkg_compareExtension $::tcl::file [info sharedlibextension]]} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set ::tcl::debug loading\n"
"load [file join . $::tcl::file]\n"
"set ::tcl::type load\n"
"} else {\n"
"set ::tcl::debug sourcing\n"
"source $::tcl::file\n"
"set ::tcl::type source\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"foreach ::tcl::x [::tcl::GetAllNamespaces] {\n"
"if {! [info exists ::tcl::namespaces($::tcl::x)]} {\n"
"namespace import ${::tcl::x}::*\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"foreach ::tcl::x [info commands] {\n"
"set ::tcl::newCmds($::tcl::x) 1\n"
"}\n"
"foreach ::tcl::x $::tcl::origCmds {\n"
"catch {unset ::tcl::newCmds($::tcl::x)}\n"
"}\n"
"foreach ::tcl::x [array names ::tcl::newCmds] {\n"
"\n"
"\n"
"set ::tcl::abs [namespace origin $::tcl::x]\n"
"\n"
"\n"
"\n"
"\n"
"set ::tcl::abs [auto_qualify $::tcl::abs ::]\n"
"\n"
"if {[string compare $::tcl::x $::tcl::abs] != 0} {\n"
"\n"
"\n"
"set ::tcl::newCmds($::tcl::abs) 1\n"
"unset ::tcl::newCmds($::tcl::x)\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"foreach ::tcl::x [package names] {\n"
"if {([string compare [package provide $::tcl::x] \"\"] != 0) \\\n"
"&& ![info exists ::tcl::packages($::tcl::x)]} {\n"
"lappend ::tcl::newPkgs \\\n"
"[list $::tcl::x [package provide $::tcl::x]]\n"
"}\n"
"}\n"
"}\n"
"} msg] == 1} {\n"
"set what [$c eval set ::tcl::debug]\n"
"if {$doVerbose} {\n"
"tclLog \"warning: error while $what $file: $msg\"\n"
"}\n"
"} else {\n"
"set type [$c eval set ::tcl::type]\n"
"set cmds [lsort [$c eval array names ::tcl::newCmds]]\n"
"set pkgs [$c eval set ::tcl::newPkgs]\n"
"if {[llength $pkgs] > 1} {\n"
"tclLog \"warning: \\\"$file\\\" provides more than one package ($pkgs)\"\n"
"}\n"
"foreach pkg $pkgs {\n"
"\n"
"lappend files($pkg) [list $file $type $cmds]\n"
"}\n"
"\n"
"if {$doVerbose} {\n"
"tclLog \"processed $file\"\n"
"}\n"
"}\n"
"interp delete $c\n"
"}\n"
"\n"
"foreach pkg [lsort [array names files]] {\n"
"append index \"\\npackage ifneeded $pkg \"\n"
"if {$direct} {\n"
"set cmdList {}\n"
"foreach elem $files($pkg) {\n"
"set file [lindex $elem 0]\n"
"set type [lindex $elem 1]\n"
"lappend cmdList \"\\[list $type \\[file join \\$dir\\\n"
"[list $file]\\]\\]\"\n"
"}\n"
"append index [join $cmdList \"\\\\n\"]\n"
"} else {\n"
"append index \"\\[list tclPkgSetup \\$dir [lrange $pkg 0 0]\\\n"
"[lrange $pkg 1 1] [list $files($pkg)]\\]\"\n"
"}\n"
"}\n"
"set f [open pkgIndex.tcl w]\n"
"puts $f $index\n"
"close $f\n"
"cd $oldDir\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tclPkgSetup {dir pkg version files} {\n"
"global auto_index\n"
"\n"
"package provide $pkg $version\n"
"foreach fileInfo $files {\n"
"set f [lindex $fileInfo 0]\n"
"set type [lindex $fileInfo 1]\n"
"foreach cmd [lindex $fileInfo 2] {\n"
"if {$type == \"load\"} {\n"
"set auto_index($cmd) [list load [file join $dir $f] $pkg]\n"
"} else {\n"
"set auto_index($cmd) [list $type [file join $dir $f]]\n"
"} \n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tclMacPkgSearch {dir} {\n"
"foreach x [glob -nocomplain [file join $dir *.shlb]] {\n"
"if {[file isfile $x]} {\n"
"set res [resource open $x]\n"
"foreach y [resource list TEXT $res] {\n"
"if {$y == \"pkgIndex\"} {source -rsrc pkgIndex}\n"
"}\n"
"catch {resource close $res}\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tclPkgUnknown {name version {exact {}}} {\n"
"global auto_path tcl_platform env\n"
"\n"
"if {![info exists auto_path]} {\n"
"return\n"
"}\n"
"for {set i [expr {[llength $auto_path] - 1}]} {$i >= 0} {incr i -1} {\n"
"\n"
"\n"
"catch {\n"
"foreach file [glob -nocomplain [file join [lindex $auto_path $i] \\\n"
"* pkgIndex.tcl]] {\n"
"set dir [file dirname $file]\n"
"if {[catch {source $file} msg]} {\n"
"tclLog \"error reading package index file $file: $msg\"\n"
"}\n"
"}\n"
"}\n"
"set dir [lindex $auto_path $i]\n"
"set file [file join $dir pkgIndex.tcl]\n"
"\n"
"if {[interp issafe] || [file readable $file]} {\n"
"if {[catch {source $file} msg] && ![interp issafe]}  {\n"
"tclLog \"error reading package index file $file: $msg\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"if {(![interp issafe]) && ($tcl_platform(platform) == \"macintosh\")} {\n"
"set dir [lindex $auto_path $i]\n"
"tclMacPkgSearch $dir\n"
"foreach x [glob -nocomplain [file join $dir *]] {\n"
"if {[file isdirectory $x]} {\n"
"set dir $x\n"
"tclMacPkgSearch $dir\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"";
#line 496 "et80.c"
Et_EvalInclude("init.tcl",_ET_script_); };

  /* The native "tk.tcl" file won't work in ET.  The following is a
  ** substitute. */
  Et_Eval(__FILE__,__LINE__,"sssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss","\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"#\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#package require -exact Tk 8.0\n"
,"#package require -exact Tcl 8.0\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"if {[info exists auto_path]} {\n"
,"if {[lsearch -exact $auto_path $tk_library] < 0} {\n"
,"lappend auto_path $tk_library\n"
,"}\n"
,"}\n"
,"\n"
,"\n"
,"\n"
,"set tk_strictMotif 0\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"\n"
,"proc tkScreenChanged screen {\n"
,"set x [string last . $screen]\n"
,"if {$x > 0} {\n"
,"set disp [string range $screen 0 [expr $x - 1]]\n"
,"} else {\n"
,"set disp $screen\n"
,"}\n"
,"uplevel #0 upvar #0 tkPriv.$disp tkPriv\n"
,"global tkPriv tcl_platform\n"
,"if [info exists tkPriv] {\n"
,"set tkPriv(screen) $screen\n"
,"return\n"
,"}\n"
,"set tkPriv(activeMenu) {}\n"
,"set tkPriv(activeItem) {}\n"
,"set tkPriv(afterId) {}\n"
,"set tkPriv(buttons) 0\n"
,"set tkPriv(buttonWindow) {}\n"
,"set tkPriv(dragging) 0\n"
,"set tkPriv(focus) {}\n"
,"set tkPriv(grab) {}\n"
,"set tkPriv(initPos) {}\n"
,"set tkPriv(inMenubutton) {}\n"
,"set tkPriv(listboxPrev) {}\n"
,"set tkPriv(menuBar) {}\n"
,"set tkPriv(mouseMoved) 0\n"
,"set tkPriv(oldGrab) {}\n"
,"set tkPriv(popup) {}\n"
,"set tkPriv(postedMb) {}\n"
,"set tkPriv(pressX) 0\n"
,"set tkPriv(pressY) 0\n"
,"set tkPriv(prevPos) 0\n"
,"set tkPriv(screen) $screen\n"
,"set tkPriv(selectMode) char\n"
,"if {[string compare $tcl_platform(platform) \"unix\"] == 0} {\n"
,"set tkPriv(tearoff) 1\n"
,"} else {\n"
,"set tkPriv(tearoff) 0\n"
,"}\n"
,"set tkPriv(window) {}\n"
,"}\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"tkScreenChanged [winfo screen .]\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"\n"
,"proc tkEventMotifBindings {n1 dummy dummy} {\n"
,"upvar $n1 name\n"
,"\n"
,"if $name {\n"
,"set op delete\n"
,"} else {\n"
,"set op add\n"
,"}\n"
,"\n"
,"event $op <<Cut>> <Control-Key-w>\n"
,"event $op <<Copy>> <Meta-Key-w> \n"
,"event $op <<Paste>> <Control-Key-y>\n"
,"}\n"
,"\n"
,"#----------------------------------------------------------------------\n"
,"\n"
,"#----------------------------------------------------------------------\n"
,"\n"
,"switch $tcl_platform(platform) {\n"
,"\"unix\" {\n"
,"event add <<Cut>> <Control-Key-x> <Key-F20> \n"
,"event add <<Copy>> <Control-Key-c> <Key-F16>\n"
,"event add <<Paste>> <Control-Key-v> <Key-F18>\n"
,"trace variable tk_strictMotif w tkEventMotifBindings\n"
,"set tk_strictMotif $tk_strictMotif\n"
,"}\n"
,"\"windows\" {\n"
,"event add <<Cut>> <Control-Key-x> <Shift-Key-Delete>\n"
,"event add <<Copy>> <Control-Key-c> <Control-Key-Insert>\n"
,"event add <<Paste>> <Control-Key-v> <Shift-Key-Insert>\n"
,"}\n"
,"\"macintosh\" {\n"
,"event add <<Cut>> <Control-Key-x> <Key-F2> \n"
,"event add <<Copy>> <Control-Key-c> <Key-F3>\n"
,"event add <<Paste>> <Control-Key-v> <Key-F4>\n"
,"event add <<Clear>> <Clear>\n"
,"}\n"
,"}\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#if {$tcl_platform(platform) != \"macintosh\"} {\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#}\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"bind all <Tab> {tkTabToWindow [tk_focusNext %W]}\n"
,"bind all <Shift-Tab> {tkTabToWindow [tk_focusPrev %W]}\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"\n"
,"proc tkCancelRepeat {} {\n"
,"global tkPriv\n"
,"after cancel $tkPriv(afterId)\n"
,"set tkPriv(afterId) {}\n"
,"}\n"
,"\n"
,"\n"
,"\n"
,"\n"
,"#\n"
,"\n"
,"\n"
,"\n"
,"proc tkTabToWindow {w} {\n"
,"if {\"[winfo class $w]\" == \"Entry\"} {\n"
,"$w select range 0 end\n"
,"$w icur end\n"
,"}\n"
,"focus $w\n"
,"}\n"
);
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc bgerror err {\n"
"global errorInfo tcl_platform\n"
"\n"
"\n"
"set info $errorInfo ;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set ret [catch {tkerror $err} msg];\n"
"if {$ret != 1} {return -code $ret $msg}\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"set ok Ok\n"
"} else {\n"
"set ok OK\n"
"}\n"
"set button [tk_dialog .bgerrorDialog \"Error in Tcl Script\" \\\n"
"\"Error: $err\" error 0 $ok \"Skip Messages\" \"Stack Trace\"]\n"
"if {$button == 0} {\n"
"return\n"
"} elseif {$button == 1} {\n"
"return -code break\n"
"}\n"
"\n"
"set w .bgerrorTrace\n"
"catch {destroy $w}\n"
"toplevel $w -class ErrorTrace\n"
"wm minsize $w 1 1\n"
"wm title $w \"Stack Trace for Error\"\n"
"wm iconname $w \"Stack Trace\"\n"
"button $w.ok -text OK -command \"destroy $w\" -default active\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"text $w.text -relief flat -bd 2 -highlightthickness 0 -setgrid true \\\n"
"-yscrollcommand \"$w.scroll set\" -width 60 -height 20\n"
"} else {\n"
"text $w.text -relief sunken -bd 2 -yscrollcommand \"$w.scroll set\" \\\n"
"-setgrid true -width 60 -height 20\n"
"}\n"
"scrollbar $w.scroll -relief sunken -command \"$w.text yview\"\n"
"pack $w.ok -side bottom -padx 3m -pady 2m\n"
"pack $w.scroll -side right -fill y\n"
"pack $w.text -side left -expand yes -fill both\n"
"$w.text insert 0.0 $info\n"
"$w.text mark set insert 0.0\n"
"\n"
"bind $w <Return> \"destroy $w\"\n"
"bind $w.text <Return> \"destroy $w; break\"\n"
"\n"
"\n"
"\n"
"wm withdraw $w\n"
"update idletasks\n"
"set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n"
"- [winfo vrootx [winfo parent $w]]}]\n"
"set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n"
"- [winfo vrooty [winfo parent $w]]}]\n"
"wm geom $w +$x+$y\n"
"wm deiconify $w\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[grab current .] != \"\"} {\n"
"grab release [grab current .]\n"
"}\n"
"}\n"
"";
#line 688 "et80.c"
Et_EvalInclude("bgerror.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"bind Radiobutton <Enter> {\n"
"tkButtonEnter %W\n"
"}\n"
"bind Radiobutton <1> {\n"
"tkButtonDown %W\n"
"}\n"
"bind Radiobutton <ButtonRelease-1> {\n"
"tkButtonUp %W\n"
"}\n"
"bind Checkbutton <Enter> {\n"
"tkButtonEnter %W\n"
"}\n"
"bind Checkbutton <1> {\n"
"tkButtonDown %W\n"
"}\n"
"bind Checkbutton <ButtonRelease-1> {\n"
"tkButtonUp %W\n"
"}\n"
"}\n"
"if {$tcl_platform(platform) == \"windows\"} {\n"
"bind Checkbutton <equal> {\n"
"tkCheckRadioInvoke %W select\n"
"}\n"
"bind Checkbutton <plus> {\n"
"tkCheckRadioInvoke %W select\n"
"}\n"
"bind Checkbutton <minus> {\n"
"tkCheckRadioInvoke %W deselect\n"
"}\n"
"bind Checkbutton <1> {\n"
"tkCheckRadioDown %W\n"
"}\n"
"bind Checkbutton <ButtonRelease-1> {\n"
"tkButtonUp %W\n"
"}\n"
"bind Checkbutton <Enter> {\n"
"tkCheckRadioEnter %W\n"
"}\n"
"\n"
"bind Radiobutton <1> {\n"
"tkCheckRadioDown %W\n"
"}\n"
"bind Radiobutton <ButtonRelease-1> {\n"
"tkButtonUp %W\n"
"}\n"
"bind Radiobutton <Enter> {\n"
"tkCheckRadioEnter %W\n"
"}\n"
"}\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"bind Checkbutton <Return> {\n"
"if {!$tk_strictMotif} {\n"
"tkCheckRadioInvoke %W\n"
"}\n"
"}\n"
"bind Radiobutton <Return> {\n"
"if {!$tk_strictMotif} {\n"
"tkCheckRadioInvoke %W\n"
"}\n"
"}\n"
"bind Checkbutton <1> {\n"
"tkCheckRadioInvoke %W\n"
"}\n"
"bind Radiobutton <1> {\n"
"tkCheckRadioInvoke %W\n"
"}\n"
"bind Checkbutton <Enter> {\n"
"tkButtonEnter %W\n"
"}\n"
"bind Radiobutton <Enter> {\n"
"tkButtonEnter %W\n"
"}\n"
"}\n"
"\n"
"bind Button <space> {\n"
"tkButtonInvoke %W\n"
"}\n"
"bind Checkbutton <space> {\n"
"tkCheckRadioInvoke %W\n"
"}\n"
"bind Radiobutton <space> {\n"
"tkCheckRadioInvoke %W\n"
"}\n"
"\n"
"bind Button <FocusIn> {}\n"
"bind Button <Enter> {\n"
"tkButtonEnter %W\n"
"}\n"
"bind Button <Leave> {\n"
"tkButtonLeave %W\n"
"}\n"
"bind Button <1> {\n"
"tkButtonDown %W\n"
"}\n"
"bind Button <ButtonRelease-1> {\n"
"tkButtonUp %W\n"
"}\n"
"\n"
"bind Checkbutton <FocusIn> {}\n"
"bind Checkbutton <Leave> {\n"
"tkButtonLeave %W\n"
"}\n"
"\n"
"bind Radiobutton <FocusIn> {}\n"
"bind Radiobutton <Leave> {\n"
"tkButtonLeave %W\n"
"}\n"
"\n"
"if {$tcl_platform(platform) == \"windows\"} {\n"
"\n"
"########################\n"
"\n"
"########################\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonEnter w {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"if {$tkPriv(buttonWindow) == $w} {\n"
"$w configure -state active -relief sunken\n"
"}\n"
"}\n"
"set tkPriv(window) $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonLeave w {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"$w config -state normal\n"
"}\n"
"if {$w == $tkPriv(buttonWindow)} {\n"
"$w configure -relief $tkPriv(relief)\n"
"}\n"
"set tkPriv(window) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkCheckRadioEnter w {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"if {$tkPriv(buttonWindow) == $w} {\n"
"$w configure -state active\n"
"}\n"
"}\n"
"set tkPriv(window) $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonDown w {\n"
"global tkPriv\n"
"set tkPriv(relief) [lindex [$w conf -relief] 4]\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"set tkPriv(buttonWindow) $w\n"
"$w config -relief sunken -state active\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkCheckRadioDown w {\n"
"global tkPriv\n"
"set tkPriv(relief) [lindex [$w conf -relief] 4]\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"set tkPriv(buttonWindow) $w\n"
"$w config -state active\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonUp w {\n"
"global tkPriv\n"
"if {$w == $tkPriv(buttonWindow)} {\n"
"set tkPriv(buttonWindow) \"\"\n"
"if {($w == $tkPriv(window))\n"
"&& ([$w cget -state] != \"disabled\")} {\n"
"$w config -relief $tkPriv(relief) -state normal\n"
"uplevel #0 [list $w invoke]\n"
"}\n"
"}\n"
"}\n"
"\n"
"}\n"
"\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"\n"
"####################\n"
"\n"
"####################\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonEnter {w} {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"$w config -state active\n"
"if {$tkPriv(buttonWindow) == $w} {\n"
"$w configure -state active -relief sunken\n"
"}\n"
"}\n"
"set tkPriv(window) $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonLeave w {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"$w config -state normal\n"
"}\n"
"if {$w == $tkPriv(buttonWindow)} {\n"
"$w configure -relief $tkPriv(relief)\n"
"}\n"
"set tkPriv(window) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonDown w {\n"
"global tkPriv\n"
"set tkPriv(relief) [lindex [$w config -relief] 4]\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"set tkPriv(buttonWindow) $w\n"
"$w config -relief sunken\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonUp w {\n"
"global tkPriv\n"
"if {$w == $tkPriv(buttonWindow)} {\n"
"set tkPriv(buttonWindow) \"\"\n"
"$w config -relief $tkPriv(relief)\n"
"if {($w == $tkPriv(window))\n"
"&& ([$w cget -state] != \"disabled\")} {\n"
"uplevel #0 [list $w invoke]\n"
"}\n"
"}\n"
"}\n"
"\n"
"}\n"
"\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"\n"
"####################\n"
"\n"
"####################\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonEnter {w} {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"if {$tkPriv(buttonWindow) == $w} {\n"
"$w configure -state active\n"
"}\n"
"}\n"
"set tkPriv(window) $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonLeave w {\n"
"global tkPriv\n"
"if {$w == $tkPriv(buttonWindow)} {\n"
"$w configure -state normal\n"
"}\n"
"set tkPriv(window) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonDown w {\n"
"global tkPriv\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"set tkPriv(buttonWindow) $w\n"
"$w config -state active\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonUp w {\n"
"global tkPriv\n"
"if {$w == $tkPriv(buttonWindow)} {\n"
"$w config -state normal\n"
"set tkPriv(buttonWindow) \"\"\n"
"if {($w == $tkPriv(window))\n"
"&& ([$w cget -state] != \"disabled\")} {\n"
"uplevel #0 [list $w invoke]\n"
"}\n"
"}\n"
"}\n"
"\n"
"}\n"
"\n"
"##################\n"
"\n"
"##################\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkButtonInvoke w {\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"set oldRelief [$w cget -relief]\n"
"set oldState [$w cget -state]\n"
"$w configure -state active -relief sunken\n"
"update idletasks\n"
"after 100\n"
"$w configure -state $oldState -relief $oldRelief\n"
"uplevel #0 [list $w invoke]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkCheckRadioInvoke {w {cmd invoke}} {\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"uplevel #0 [list $w $cmd]\n"
"}\n"
"}\n"
"\n"
"";
#line 689 "et80.c"
Et_EvalInclude("button.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog {args} {\n"
"global tkPriv\n"
"set w .__tk__color\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"set data(lines,red,start)   0\n"
"set data(lines,red,last)   -1\n"
"set data(lines,green,start) 0\n"
"set data(lines,green,last) -1\n"
"set data(lines,blue,start)  0\n"
"set data(lines,blue,last)  -1\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set data(NUM_COLORBARS) 8\n"
"\n"
"\n"
"\n"
"set data(BARS_WIDTH) 128\n"
"\n"
"\n"
"\n"
"\n"
"set data(PLGN_HEIGHT) 10\n"
"\n"
"\n"
"\n"
"set data(PLGN_WIDTH) 10\n"
"\n"
"tkColorDialog_Config $w $args\n"
"tkColorDialog_InitValues $w\n"
"\n"
"if {![winfo exists $w]} {\n"
"toplevel $w -class tkColorDialog\n"
"tkColorDialog_BuildDialog $w\n"
"}\n"
"wm transient $w $data(-parent)\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"wm withdraw $w\n"
"update idletasks\n"
"set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n"
"- [winfo vrootx [winfo parent $w]]}]\n"
"set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n"
"- [winfo vrooty [winfo parent $w]]}]\n"
"wm geom $w +$x+$y\n"
"wm deiconify $w\n"
"wm title $w $data(-title)\n"
"\n"
"\n"
"\n"
"set oldFocus [focus]\n"
"set oldGrab [grab current $w]\n"
"if {$oldGrab != \"\"} {\n"
"set grabStatus [grab status $oldGrab]\n"
"}\n"
"grab $w\n"
"focus $data(okBtn)\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tkwait variable tkPriv(selectColor)\n"
"catch {focus $oldFocus}\n"
"grab release $w\n"
"destroy $w\n"
"unset data\n"
"if {$oldGrab != \"\"} {\n"
"if {$grabStatus == \"global\"} {\n"
"grab -global $oldGrab\n"
"} else {\n"
"grab $oldGrab\n"
"}\n"
"}\n"
"return $tkPriv(selectColor)\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_InitValues {w} {\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"set data(intensityIncr) [expr {256 / $data(NUM_COLORBARS)}]\n"
"\n"
"\n"
"set data(colorbarWidth) \\\n"
"[expr {$data(BARS_WIDTH) / $data(NUM_COLORBARS)}]\n"
"\n"
"\n"
"\n"
"\n"
"set data(indent) [expr {$data(PLGN_WIDTH) / 2}]\n"
"\n"
"set data(colorPad) 2\n"
"set data(selPad)   [expr {$data(PLGN_WIDTH) / 2}]\n"
"\n"
"\n"
"\n"
"\n"
"set data(minX) $data(indent)\n"
"\n"
"\n"
"\n"
"\n"
"set data(maxX) [expr {$data(BARS_WIDTH) + $data(indent)-1}]\n"
"\n"
"\n"
"\n"
"\n"
"set data(canvasWidth) [expr {$data(BARS_WIDTH) + \\\n"
"$data(PLGN_WIDTH)}]\n"
"\n"
"\n"
"\n"
"set data(selection) $data(-initialcolor)\n"
"set data(finalColor)  $data(-initialcolor)\n"
"set rgb [winfo rgb . $data(selection)]\n"
"\n"
"set data(red,intensity)   [expr {[lindex $rgb 0]/0x100}]\n"
"set data(green,intensity) [expr {[lindex $rgb 1]/0x100}]\n"
"set data(blue,intensity)  [expr {[lindex $rgb 2]/0x100}]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_Config {w argList} {\n"
"global tkPriv\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"set specs {\n"
"{-initialcolor \"\" \"\" \"\"}\n"
"{-parent \"\" \"\" \".\"}\n"
"{-title \"\" \"\" \"Color\"}\n"
"}\n"
"\n"
"\n"
"\n"
"tclParseConfigSpec $w $specs \"\" $argList\n"
"\n"
"if {![string compare $data(-title) \"\"]} {\n"
"set data(-title) \" \"\n"
"}\n"
"if {![string compare $data(-initialcolor) \"\"]} {\n"
"if {[info exists tkPriv(selectColor)] && \\\n"
"[string compare $tkPriv(selectColor) \"\"]} {\n"
"set data(-initialcolor) $tkPriv(selectColor)\n"
"} else {\n"
"set data(-initialcolor) [. cget -background]\n"
"}\n"
"} else {\n"
"if {[catch {winfo rgb . $data(-initialcolor)} err]} {\n"
"error $err\n"
"}\n"
"}\n"
"\n"
"if {![winfo exists $data(-parent)]} {\n"
"error \"bad window path name \\\"$data(-parent)\\\"\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_BuildDialog {w} {\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"set topFrame [frame $w.top -relief raised -bd 1]\n"
"\n"
"\n"
"set stripsFrame [frame $topFrame.colorStrip]\n"
"\n"
"foreach c { Red Green Blue } {\n"
"set color [string tolower $c]\n"
"\n"
"\n"
"set f [frame $stripsFrame.$color]\n"
"\n"
"\n"
"set box [frame $f.box]\n"
"\n"
"label $box.label -text $c: -width 6 -under 0 -anchor ne\n"
"entry $box.entry -textvariable [format %s $w]($color,intensity) \\\n"
"-width 4\n"
"pack $box.label -side left -fill y -padx 2 -pady 3\n"
"pack $box.entry -side left -anchor n -pady 0\n"
"pack $box -side left -fill both\n"
"\n"
"set height [expr \\\n"
"{[winfo reqheight $box.entry] - \\\n"
"2*([$box.entry cget -highlightthickness] + [$box.entry cget -bd])}]\n"
"\n"
"canvas $f.color -height $height\\\n"
"-width $data(BARS_WIDTH) -relief sunken -bd 2\n"
"canvas $f.sel -height $data(PLGN_HEIGHT) \\\n"
"-width $data(canvasWidth) -highlightthickness 0\n"
"pack $f.color -expand yes -fill both\n"
"pack $f.sel -expand yes -fill both\n"
"\n"
"pack $f -side top -fill x -padx 0 -pady 2\n"
"\n"
"set data($color,entry) $box.entry\n"
"set data($color,col) $f.color\n"
"set data($color,sel) $f.sel\n"
"\n"
"bind $data($color,col) <Configure> \\\n"
"\"tkColorDialog_DrawColorScale $w $color 1\"\n"
"bind $data($color,col) <Enter> \\\n"
"\"tkColorDialog_EnterColorBar $w $color\"\n"
"bind $data($color,col) <Leave> \\\n"
"\"tkColorDialog_LeaveColorBar $w $color\"\n"
"\n"
"bind $data($color,sel) <Enter> \\\n"
"\"tkColorDialog_EnterColorBar $w $color\"\n"
"bind $data($color,sel) <Leave> \\\n"
"\"tkColorDialog_LeaveColorBar $w $color\"\n"
"\n"
"bind $box.entry <Return> \"tkColorDialog_HandleRGBEntry $w\"\n"
"}\n"
"\n"
"pack $stripsFrame -side left -fill both -padx 4 -pady 10\n"
"\n"
"\n"
"\n"
"\n"
"set selFrame [frame $topFrame.sel]\n"
"set lab [label $selFrame.lab -text \"Selection:\" -under 0 -anchor sw]\n"
"set ent [entry $selFrame.ent -textvariable [format %s $w](selection) \\\n"
"-width 16]\n"
"set f1  [frame $selFrame.f1 -relief sunken -bd 2]\n"
"set data(finalCanvas) [frame $f1.demo -bd 0 -width 100 -height 70]\n"
"\n"
"pack $lab $ent -side top -fill x -padx 4 -pady 2\n"
"pack $f1 -expand yes -anchor nw -fill both -padx 6 -pady 10\n"
"pack $data(finalCanvas) -expand yes -fill both\n"
"\n"
"bind $ent <Return> \"tkColorDialog_HandleSelEntry $w\"\n"
"\n"
"pack $selFrame -side left -fill none -anchor nw\n"
"pack $topFrame -side top -expand yes -fill both -anchor nw\n"
"\n"
"\n"
"\n"
"set botFrame [frame $w.bot -relief raised -bd 1]\n"
"button $botFrame.ok     -text OK            -width 8 -under 0 \\\n"
"-command \"tkColorDialog_OkCmd $w\"\n"
"button $botFrame.cancel -text Cancel        -width 8 -under 0 \\\n"
"-command \"tkColorDialog_CancelCmd $w\"\n"
"\n"
"set data(okBtn)      $botFrame.ok\n"
"set data(cancelBtn)  $botFrame.cancel\n"
"\n"
"pack $botFrame.ok $botFrame.cancel \\\n"
"-padx 10 -pady 10 -expand yes -side left\n"
"pack $botFrame -side bottom -fill x\n"
"\n"
"\n"
"\n"
"\n"
"bind $w <Alt-r> \"focus $data(red,entry)\"\n"
"bind $w <Alt-g> \"focus $data(green,entry)\"\n"
"bind $w <Alt-b> \"focus $data(blue,entry)\"\n"
"bind $w <Alt-s> \"focus $ent\"\n"
"bind $w <KeyPress-Escape> \"tkButtonInvoke $data(cancelBtn)\"\n"
"bind $w <Alt-c> \"tkButtonInvoke $data(cancelBtn)\"\n"
"bind $w <Alt-o> \"tkButtonInvoke $data(okBtn)\"\n"
"\n"
"wm protocol $w WM_DELETE_WINDOW \"tkColorDialog_CancelCmd $w\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_SetRGBValue {w color} {\n"
"upvar #0 $w data \n"
"\n"
"set data(red,intensity)   [lindex $color 0]\n"
"set data(green,intensity) [lindex $color 1]\n"
"set data(blue,intensity)  [lindex $color 2]\n"
"\n"
"tkColorDialog_RedrawColorBars $w all\n"
"\n"
"\n"
"foreach color { red green blue } {\n"
"set x [tkColorDialog_RgbToX $w $data($color,intensity)]\n"
"tkColorDialog_MoveSelector $w $data($color,sel) $color $x 0\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_XToRgb {w x} {\n"
"upvar #0 $w data\n"
"\n"
"return [expr {($x * $data(intensityIncr))/ $data(colorbarWidth)}]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_RgbToX {w color} {\n"
"upvar #0 $w data\n"
"\n"
"return [expr {($color * $data(colorbarWidth)/ $data(intensityIncr))}]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_DrawColorScale {w c {create 0}} {\n"
"global lines\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"set col $data($c,col)\n"
"set sel $data($c,sel)\n"
"\n"
"\n"
"if {$create} {\n"
"\n"
"if { $data(lines,$c,last) > $data(lines,$c,start)} {\n"
"for {set i $data(lines,$c,start)} \\\n"
"{$i <= $data(lines,$c,last)} { incr i} {\n"
"$sel delete $i\n"
"}\n"
"}\n"
"\n"
"if {[info exists data($c,index)]} {\n"
"$sel delete $data($c,index)\n"
"}\n"
"\n"
"\n"
"tkColorDialog_CreateSelector $w $sel $c\n"
"$sel bind $data($c,index) <ButtonPress-1> \\\n"
"\"tkColorDialog_StartMove $w $sel $c %x $data(selPad) 1\"\n"
"$sel bind $data($c,index) <B1-Motion> \\\n"
"\"tkColorDialog_MoveSelector $w $sel $c %x $data(selPad)\"\n"
"$sel bind $data($c,index) <ButtonRelease-1> \\\n"
"\"tkColorDialog_ReleaseMouse $w $sel $c %x $data(selPad)\"\n"
"\n"
"set height [winfo height $col]\n"
"\n"
"\n"
"set data($c,clickRegion) [$sel create rectangle 0 0 \\\n"
"$data(canvasWidth) $height -fill {} -outline {}]\n"
"\n"
"bind $col <ButtonPress-1> \\\n"
"\"tkColorDialog_StartMove $w $sel $c %x $data(colorPad)\"\n"
"bind $col <B1-Motion> \\\n"
"\"tkColorDialog_MoveSelector $w $sel $c %x $data(colorPad)\"\n"
"bind $col <ButtonRelease-1> \\\n"
"\"tkColorDialog_ReleaseMouse $w $sel $c %x $data(colorPad)\"\n"
"\n"
"$sel bind $data($c,clickRegion) <ButtonPress-1> \\\n"
"\"tkColorDialog_StartMove $w $sel $c %x $data(selPad)\"\n"
"$sel bind $data($c,clickRegion) <B1-Motion> \\\n"
"\"tkColorDialog_MoveSelector $w $sel $c %x $data(selPad)\"\n"
"$sel bind $data($c,clickRegion) <ButtonRelease-1> \\\n"
"\"tkColorDialog_ReleaseMouse $w $sel $c %x $data(selPad)\"\n"
"} else {\n"
"\n"
"set l $data(lines,$c,start)\n"
"}\n"
"\n"
"\n"
"set highlightW [expr \\\n"
"{[$col cget -highlightthickness] + [$col cget -bd]}]\n"
"for {set i 0} { $i < $data(NUM_COLORBARS)} { incr i} {\n"
"set intensity [expr {$i * $data(intensityIncr)}]\n"
"set startx [expr {$i * $data(colorbarWidth) + $highlightW}]\n"
"if { $c == \"red\" } {\n"
"set color [format \"#%02x%02x%02x\" \\\n"
"$intensity \\\n"
"$data(green,intensity) \\\n"
"$data(blue,intensity)]\n"
"} elseif { $c == \"green\" } {\n"
"set color [format \"#%02x%02x%02x\" \\\n"
"$data(red,intensity) \\\n"
"$intensity \\\n"
"$data(blue,intensity)]\n"
"} else {\n"
"set color [format \"#%02x%02x%02x\" \\\n"
"$data(red,intensity) \\\n"
"$data(green,intensity) \\\n"
"$intensity]\n"
"}\n"
"\n"
"if {$create} {\n"
"set index [$col create rect $startx $highlightW \\\n"
"[expr {$startx +$data(colorbarWidth)}] \\\n"
"[expr {[winfo height $col] + $highlightW}]\\\n"
"-fill $color -outline $color]\n"
"} else {\n"
"$col itemconf $l -fill $color -outline $color\n"
"incr l\n"
"}\n"
"}\n"
"$sel raise $data($c,index)\n"
"\n"
"if {$create} {\n"
"set data(lines,$c,last) $index\n"
"set data(lines,$c,start) [expr {$index - $data(NUM_COLORBARS) + 1}]\n"
"}\n"
"\n"
"tkColorDialog_RedrawFinalColor $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_CreateSelector {w sel c } {\n"
"upvar #0 $w data\n"
"set data($c,index) [$sel create polygon \\\n"
"0 $data(PLGN_HEIGHT) \\\n"
"$data(PLGN_WIDTH) $data(PLGN_HEIGHT) \\\n"
"$data(indent) 0]\n"
"set data($c,x) [tkColorDialog_RgbToX $w $data($c,intensity)]\n"
"$sel move $data($c,index) $data($c,x) 0\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_RedrawFinalColor {w} {\n"
"upvar #0 $w data\n"
"\n"
"set color [format \"#%02x%02x%02x\" $data(red,intensity) \\\n"
"$data(green,intensity) $data(blue,intensity)]\n"
"\n"
"$data(finalCanvas) conf -bg $color\n"
"set data(finalColor) $color\n"
"set data(selection) $color\n"
"set data(finalRGB) [list \\\n"
"$data(red,intensity) \\\n"
"$data(green,intensity) \\\n"
"$data(blue,intensity)]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_RedrawColorBars {w colorChanged} {\n"
"upvar #0 $w data\n"
"\n"
"switch $colorChanged {\n"
"red { \n"
"tkColorDialog_DrawColorScale $w green\n"
"tkColorDialog_DrawColorScale $w blue\n"
"}\n"
"green {\n"
"tkColorDialog_DrawColorScale $w red\n"
"tkColorDialog_DrawColorScale $w blue\n"
"}\n"
"blue {\n"
"tkColorDialog_DrawColorScale $w red\n"
"tkColorDialog_DrawColorScale $w green\n"
"}\n"
"default {\n"
"tkColorDialog_DrawColorScale $w red\n"
"tkColorDialog_DrawColorScale $w green\n"
"tkColorDialog_DrawColorScale $w blue\n"
"}\n"
"}\n"
"tkColorDialog_RedrawFinalColor $w\n"
"}\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_StartMove {w sel color x delta {dontMove 0}} {\n"
"upvar #0 $w data\n"
"\n"
"if {!$dontMove} {\n"
"tkColorDialog_MoveSelector $w $sel $color $x $delta\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_MoveSelector {w sel color x delta} {\n"
"upvar #0 $w data\n"
"\n"
"incr x -$delta\n"
"\n"
"if { $x < 0 } {\n"
"set x 0\n"
"} elseif { $x >= $data(BARS_WIDTH)} {\n"
"set x [expr {$data(BARS_WIDTH) - 1}]\n"
"}\n"
"set diff [expr {$x - $data($color,x)}]\n"
"$sel move $data($color,index) $diff 0\n"
"set data($color,x) [expr {$data($color,x) + $diff}]\n"
"\n"
"\n"
"return $x\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_ReleaseMouse {w sel color x delta} {\n"
"upvar #0 $w data \n"
"\n"
"set x [tkColorDialog_MoveSelector $w $sel $color $x $delta]\n"
"\n"
"\n"
"set data($color,intensity) [tkColorDialog_XToRgb $w $x]\n"
"\n"
"tkColorDialog_RedrawColorBars $w $color\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_ResizeColorBars {w} {\n"
"upvar #0 $w data\n"
"\n"
"if { ($data(BARS_WIDTH) < $data(NUM_COLORBARS)) || \n"
"(($data(BARS_WIDTH) % $data(NUM_COLORBARS)) != 0)} {\n"
"set data(BARS_WIDTH) $data(NUM_COLORBARS)\n"
"}\n"
"tkColorDialog_InitValues $w\n"
"foreach color { red green blue } {\n"
"$data($color,col) conf -width $data(canvasWidth)\n"
"tkColorDialog_DrawColorScale $w $color 1\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_HandleSelEntry {w} {\n"
"upvar #0 $w data\n"
"\n"
"set text [string trim $data(selection)]\n"
"\n"
"if {[catch {set color [winfo rgb . $text]} ]} {\n"
"set data(selection) $data(finalColor)\n"
"return\n"
"}\n"
"\n"
"set R [expr {[lindex $color 0]/0x100}]\n"
"set G [expr {[lindex $color 1]/0x100}]\n"
"set B [expr {[lindex $color 2]/0x100}]\n"
"\n"
"tkColorDialog_SetRGBValue $w \"$R $G $B\"\n"
"set data(selection) $text\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_HandleRGBEntry {w} {\n"
"upvar #0 $w data\n"
"\n"
"foreach c {red green blue} {\n"
"if {[catch {\n"
"set data($c,intensity) [expr {int($data($c,intensity))}]\n"
"}]} {\n"
"set data($c,intensity) 0\n"
"}\n"
"\n"
"if {$data($c,intensity) < 0} {\n"
"set data($c,intensity) 0\n"
"}\n"
"if {$data($c,intensity) > 255} {\n"
"set data($c,intensity) 255\n"
"}\n"
"}\n"
"\n"
"tkColorDialog_SetRGBValue $w \"$data(red,intensity) $data(green,intensity) \\\n"
"$data(blue,intensity)\"\n"
"}    \n"
"\n"
"\n"
"\n"
"proc tkColorDialog_EnterColorBar {w color} {\n"
"upvar #0 $w data\n"
"\n"
"$data($color,sel) itemconfig $data($color,index) -fill red\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_LeaveColorBar {w color} {\n"
"upvar #0 $w data\n"
"\n"
"$data($color,sel) itemconfig $data($color,index) -fill black\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_OkCmd {w} {\n"
"global tkPriv\n"
"upvar #0 $w data\n"
"\n"
"set tkPriv(selectColor) $data(finalColor)\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkColorDialog_CancelCmd {w} {\n"
"global tkPriv\n"
"\n"
"set tkPriv(selectColor) \"\"\n"
"}\n"
"\n"
"";
#line 690 "et80.c"
Et_EvalInclude("clrpick.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tclParseConfigSpec {w specs flags argList} {\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"foreach spec $specs {\n"
"if {[llength $spec] < 4} {\n"
"error \"\\\"spec\\\" should contain 5 or 4 elements\"\n"
"}\n"
"set cmdsw [lindex $spec 0]\n"
"set cmd($cmdsw) \"\"\n"
"set rname($cmdsw)   [lindex $spec 1]\n"
"set rclass($cmdsw)  [lindex $spec 2]\n"
"set def($cmdsw)     [lindex $spec 3]\n"
"set verproc($cmdsw) [lindex $spec 4]\n"
"}\n"
"\n"
"if {([llength $argList]%2) != 0} {\n"
"foreach {cmdsw value} $argList {\n"
"if {![info exists cmd($cmdsw)]} {\n"
"error \"unknown option \\\"$cmdsw\\\", must be [tclListValidFlags cmd]\"\n"
"}\n"
"}\n"
"error \"value for \\\"[lindex $argList end]\\\" missing\"\n"
"}\n"
"\n"
"\n"
"\n"
"foreach cmdsw [array names cmd] {\n"
"set data($cmdsw) $def($cmdsw)\n"
"}\n"
"\n"
"\n"
"\n"
"foreach {cmdsw value} $argList {\n"
"if {![info exists cmd($cmdsw)]} {\n"
"error \"unknown option \\\"$cmdsw\\\", must be [tclListValidFlags cmd]\"\n"
"}\n"
"set data($cmdsw) $value\n"
"}\n"
"\n"
"\n"
"}\n"
"\n"
"proc tclListValidFlags {v} {\n"
"upvar $v cmd\n"
"\n"
"set len [llength [array names cmd]]\n"
"set i 1\n"
"set separator \"\"\n"
"set errormsg \"\"\n"
"foreach cmdsw [lsort [array names cmd]] {\n"
"append errormsg \"$separator$cmdsw\"\n"
"incr i\n"
"if {$i == $len} {\n"
"set separator \" or \"\n"
"} else {\n"
"set separator \", \"\n"
"}\n"
"}\n"
"return $errormsg\n"
"}\n"
"\n"
"\n"
"\n"
"proc tclSortNoCase {str1 str2} {\n"
"return [string compare [string toupper $str1] [string toupper $str2]]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tclVerifyInteger {string} {\n"
"lindex {1 2 3} $string\n"
"}\n"
"\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusGroup_Create {t} {\n"
"global tkPriv\n"
"if {[string compare [winfo toplevel $t] $t]} {\n"
"error \"$t is not a toplevel window\"\n"
"}\n"
"if {![info exists tkPriv(fg,$t)]} {\n"
"set tkPriv(fg,$t) 1\n"
"set tkPriv(focus,$t) \"\"\n"
"bind $t <FocusIn>  \"tkFocusGroup_In  $t %W %d\"\n"
"bind $t <FocusOut> \"tkFocusGroup_Out $t %W %d\"\n"
"bind $t <Destroy>  \"tkFocusGroup_Destroy $t %W\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusGroup_BindIn {t w cmd} {\n"
"global tkFocusIn tkPriv\n"
"if {![info exists tkPriv(fg,$t)]} {\n"
"error \"focus group \\\"$t\\\" doesn't exist\"\n"
"}\n"
"set tkFocusIn($t,$w) $cmd\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusGroup_BindOut {t w cmd} {\n"
"global tkFocusOut tkPriv\n"
"if {![info exists tkPriv(fg,$t)]} {\n"
"error \"focus group \\\"$t\\\" doesn't exist\"\n"
"}\n"
"set tkFocusOut($t,$w) $cmd\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusGroup_Destroy {t w} {\n"
"global tkPriv tkFocusIn tkFocusOut\n"
"\n"
"if {![string compare $t $w]} {\n"
"unset tkPriv(fg,$t)\n"
"unset tkPriv(focus,$t) \n"
"\n"
"foreach name [array names tkFocusIn $t,*] {\n"
"unset tkFocusIn($name)\n"
"}\n"
"foreach name [array names tkFocusOut $t,*] {\n"
"unset tkFocusOut($name)\n"
"}\n"
"} else {\n"
"if {[info exists tkPriv(focus,$t)]} {\n"
"if {![string compare $tkPriv(focus,$t) $w]} {\n"
"set tkPriv(focus,$t) \"\"\n"
"}\n"
"}\n"
"catch {\n"
"unset tkFocusIn($t,$w)\n"
"}\n"
"catch {\n"
"unset tkFocusOut($t,$w)\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusGroup_In {t w detail} {\n"
"global tkPriv tkFocusIn\n"
"\n"
"if {![info exists tkFocusIn($t,$w)]} {\n"
"set tkFocusIn($t,$w) \"\"\n"
"return\n"
"}\n"
"if {![info exists tkPriv(focus,$t)]} {\n"
"return\n"
"}\n"
"if {![string compare $tkPriv(focus,$t) $w]} {\n"
"\n"
"\n"
"return\n"
"} else {\n"
"set tkPriv(focus,$t) $w\n"
"eval $tkFocusIn($t,$w)\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusGroup_Out {t w detail} {\n"
"global tkPriv tkFocusOut\n"
"\n"
"if {[string compare $detail NotifyNonlinear] &&\n"
"[string compare $detail NotifyNonlinearVirtual]} {\n"
"\n"
"return\n"
"}\n"
"if {![info exists tkPriv(focus,$t)]} {\n"
"return\n"
"}\n"
"if {![info exists tkFocusOut($t,$w)]} {\n"
"return\n"
"} else {\n"
"eval $tkFocusOut($t,$w)\n"
"set tkPriv(focus,$t) \"\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDGetFileTypes {string} {\n"
"foreach t $string {\n"
"if {[llength $t] < 2 || [llength $t] > 3} {\n"
"error \"bad file type \\\"$t\\\", should be \\\"typeName {extension ?extensions ...?} ?{macType ?macTypes ...?}?\\\"\"\n"
"}\n"
"eval lappend [list fileTypes([lindex $t 0])] [lindex $t 1]\n"
"}\n"
"\n"
"set types {}\n"
"foreach t $string {\n"
"set label [lindex $t 0]\n"
"set exts {}\n"
"\n"
"if {[info exists hasDoneType($label)]} {\n"
"continue\n"
"}\n"
"\n"
"set name \"$label (\"\n"
"set sep \"\"\n"
"foreach ext $fileTypes($label) {\n"
"if {![string compare $ext \"\"]} {\n"
"continue\n"
"}\n"
"regsub {^[.]} $ext \"*.\" ext\n"
"if {![info exists hasGotExt($label,$ext)]} {\n"
"append name $sep$ext\n"
"lappend exts $ext\n"
"set hasGotExt($label,$ext) 1\n"
"}\n"
"set sep ,\n"
"}\n"
"append name \")\"\n"
"lappend types [list $name $exts]\n"
"\n"
"set hasDoneType($label) 1\n"
"}\n"
"\n"
"return $types\n"
"}\n"
"";
#line 691 "et80.c"
Et_EvalInclude("comdlg.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_dialog {w title text bitmap default args} {\n"
"global tkPriv tcl_platform\n"
"\n"
"\n"
"\n"
"\n"
"catch {destroy $w}\n"
"toplevel $w -class Dialog\n"
"wm title $w $title\n"
"wm iconname $w Dialog\n"
"wm protocol $w WM_DELETE_WINDOW { }\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"wm transient $w [winfo toplevel [winfo parent $w]]\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"unsupported1 style $w dBoxProc\n"
"}\n"
"\n"
"frame $w.bot\n"
"frame $w.top\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"$w.bot configure -relief raised -bd 1\n"
"$w.top configure -relief raised -bd 1\n"
"}\n"
"pack $w.bot -side bottom -fill both\n"
"pack $w.top -side top -fill both -expand 1\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"option add *Dialog.msg.wrapLength 3i widgetDefault\n"
"label $w.msg -justify left -text $text\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"$w.msg configure -font system\n"
"} else {\n"
"$w.msg configure -font {Times 18}\n"
"}\n"
"pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 3m -pady 3m\n"
"if {$bitmap != \"\"} {\n"
"if {($tcl_platform(platform) == \"macintosh\") && ($bitmap == \"error\")} {\n"
"set bitmap \"stop\"\n"
"}\n"
"label $w.bitmap -bitmap $bitmap\n"
"pack $w.bitmap -in $w.top -side left -padx 3m -pady 3m\n"
"}\n"
"\n"
"\n"
"\n"
"set i 0\n"
"foreach but $args {\n"
"button $w.button$i -text $but -command \"set tkPriv(button) $i\"\n"
"if {$i == $default} {\n"
"$w.button$i configure -default active\n"
"} else {\n"
"$w.button$i configure -default normal\n"
"}\n"
"grid $w.button$i -in $w.bot -column $i -row 0 -sticky ew -padx 10\n"
"grid columnconfigure $w.bot $i\n"
"\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"set tmp [string tolower $but]\n"
"if {($tmp == \"ok\") || ($tmp == \"cancel\")} {\n"
"grid columnconfigure $w.bot $i -minsize [expr 59 + 20]\n"
"}\n"
"}\n"
"incr i\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {$default >= 0} {\n"
"bind $w <Return> \"\n"
"$w.button$default configure -state active -relief sunken\n"
"update idletasks\n"
"after 100\n"
"set tkPriv(button) $default\n"
"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind $w <Destroy> {set tkPriv(button) -1}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"wm withdraw $w\n"
"update idletasks\n"
"set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n"
"- [winfo vrootx [winfo parent $w]]}]\n"
"set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n"
"- [winfo vrooty [winfo parent $w]]}]\n"
"wm geom $w +$x+$y\n"
"wm deiconify $w\n"
"\n"
"\n"
"\n"
"set oldFocus [focus]\n"
"set oldGrab [grab current $w]\n"
"if {$oldGrab != \"\"} {\n"
"set grabStatus [grab status $oldGrab]\n"
"}\n"
"grab $w\n"
"if {$default >= 0} {\n"
"focus $w.button$default\n"
"} else {\n"
"focus $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tkwait variable tkPriv(button)\n"
"catch {focus $oldFocus}\n"
"catch {\n"
"\n"
"\n"
"\n"
"\n"
"bind $w <Destroy> {}\n"
"destroy $w\n"
"}\n"
"if {$oldGrab != \"\"} {\n"
"if {$grabStatus == \"global\"} {\n"
"grab -global $oldGrab\n"
"} else {\n"
"grab $oldGrab\n"
"}\n"
"}\n"
"return $tkPriv(button)\n"
"}\n"
"";
#line 692 "et80.c"
Et_EvalInclude("dialog.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"bind Entry <<Cut>> {\n"
"if {![catch {set data [string range [%W get] [%W index sel.first]\\\n"
"[expr {[%W index sel.last] - 1}]]}]} {\n"
"clipboard clear -displayof %W\n"
"clipboard append -displayof %W $data\n"
"%W delete sel.first sel.last\n"
"}\n"
"}\n"
"bind Entry <<Copy>> {\n"
"if {![catch {set data [string range [%W get] [%W index sel.first]\\\n"
"[expr {[%W index sel.last] - 1}]]}]} {\n"
"clipboard clear -displayof %W\n"
"clipboard append -displayof %W $data\n"
"}\n"
"}\n"
"bind Entry <<Paste>> {\n"
"global tcl_platform\n"
"catch {\n"
"if {\"$tcl_platform(platform)\" != \"unix\"} {\n"
"catch {\n"
"%W delete sel.first sel.last\n"
"}\n"
"}\n"
"%W insert insert [selection get -displayof %W -selection CLIPBOARD]\n"
"tkEntrySeeInsert %W\n"
"}\n"
"}\n"
"bind Entry <<Clear>> {\n"
"%W delete sel.first sel.last\n"
"}\n"
"bind Entry <<PasteSelection>> {\n"
"if {!$tkPriv(mouseMoved) || $tk_strictMotif} {\n"
"tkEntryPaste %W %x\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"bind Entry <1> {\n"
"tkEntryButton1 %W %x\n"
"%W selection clear\n"
"}\n"
"bind Entry <B1-Motion> {\n"
"set tkPriv(x) %x\n"
"tkEntryMouseSelect %W %x\n"
"}\n"
"bind Entry <Double-1> {\n"
"set tkPriv(selectMode) word\n"
"tkEntryMouseSelect %W %x\n"
"catch {%W icursor sel.first}\n"
"}\n"
"bind Entry <Triple-1> {\n"
"set tkPriv(selectMode) line\n"
"tkEntryMouseSelect %W %x\n"
"%W icursor 0\n"
"}\n"
"bind Entry <Shift-1> {\n"
"set tkPriv(selectMode) char\n"
"%W selection adjust @%x\n"
"}\n"
"bind Entry <Double-Shift-1> {\n"
"set tkPriv(selectMode) word\n"
"tkEntryMouseSelect %W %x\n"
"}\n"
"bind Entry <Triple-Shift-1> {\n"
"set tkPriv(selectMode) line\n"
"tkEntryMouseSelect %W %x\n"
"}\n"
"bind Entry <B1-Leave> {\n"
"set tkPriv(x) %x\n"
"tkEntryAutoScan %W\n"
"}\n"
"bind Entry <B1-Enter> {\n"
"tkCancelRepeat\n"
"}\n"
"bind Entry <ButtonRelease-1> {\n"
"tkCancelRepeat\n"
"}\n"
"bind Entry <Control-1> {\n"
"%W icursor @%x\n"
"}\n"
"\n"
"bind Entry <Left> {\n"
"tkEntrySetCursor %W [expr {[%W index insert] - 1}]\n"
"}\n"
"bind Entry <Right> {\n"
"tkEntrySetCursor %W [expr {[%W index insert] + 1}]\n"
"}\n"
"bind Entry <Shift-Left> {\n"
"tkEntryKeySelect %W [expr {[%W index insert] - 1}]\n"
"tkEntrySeeInsert %W\n"
"}\n"
"bind Entry <Shift-Right> {\n"
"tkEntryKeySelect %W [expr {[%W index insert] + 1}]\n"
"tkEntrySeeInsert %W\n"
"}\n"
"bind Entry <Control-Left> {\n"
"tkEntrySetCursor %W [tkEntryPreviousWord %W insert]\n"
"}\n"
"bind Entry <Control-Right> {\n"
"tkEntrySetCursor %W [tkEntryNextWord %W insert]\n"
"}\n"
"bind Entry <Shift-Control-Left> {\n"
"tkEntryKeySelect %W [tkEntryPreviousWord %W insert]\n"
"tkEntrySeeInsert %W\n"
"}\n"
"bind Entry <Shift-Control-Right> {\n"
"tkEntryKeySelect %W [tkEntryNextWord %W insert]\n"
"tkEntrySeeInsert %W\n"
"}\n"
"bind Entry <Home> {\n"
"tkEntrySetCursor %W 0\n"
"}\n"
"bind Entry <Shift-Home> {\n"
"tkEntryKeySelect %W 0\n"
"tkEntrySeeInsert %W\n"
"}\n"
"bind Entry <End> {\n"
"tkEntrySetCursor %W end\n"
"}\n"
"bind Entry <Shift-End> {\n"
"tkEntryKeySelect %W end\n"
"tkEntrySeeInsert %W\n"
"}\n"
"\n"
"bind Entry <Delete> {\n"
"if {[%W selection present]} {\n"
"%W delete sel.first sel.last\n"
"} else {\n"
"%W delete insert\n"
"}\n"
"}\n"
"bind Entry <BackSpace> {\n"
"tkEntryBackspace %W\n"
"}\n"
"\n"
"bind Entry <Control-space> {\n"
"%W selection from insert\n"
"}\n"
"bind Entry <Select> {\n"
"%W selection from insert\n"
"}\n"
"bind Entry <Control-Shift-space> {\n"
"%W selection adjust insert\n"
"}\n"
"bind Entry <Shift-Select> {\n"
"%W selection adjust insert\n"
"}\n"
"bind Entry <Control-slash> {\n"
"%W selection range 0 end\n"
"}\n"
"bind Entry <Control-backslash> {\n"
"%W selection clear\n"
"}\n"
"bind Entry <KeyPress> {\n"
"tkEntryInsert %W %A\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Entry <Alt-KeyPress> {# nothing}\n"
"bind Entry <Meta-KeyPress> {# nothing}\n"
"bind Entry <Control-KeyPress> {# nothing}\n"
"bind Entry <Escape> {# nothing}\n"
"bind Entry <Return> {# nothing}\n"
"bind Entry <KP_Enter> {# nothing}\n"
"bind Entry <Tab> {# nothing}\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"bind Entry <Command-KeyPress> {# nothing}\n"
"}\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) != \"windows\"} {\n"
"bind Entry <Insert> {\n"
"catch {tkEntryInsert %W [selection get -displayof %W]}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"bind Entry <Control-a> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntrySetCursor %W 0\n"
"}\n"
"}\n"
"bind Entry <Control-b> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntrySetCursor %W [expr {[%W index insert] - 1}]\n"
"}\n"
"}\n"
"bind Entry <Control-d> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete insert\n"
"}\n"
"}\n"
"bind Entry <Control-e> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntrySetCursor %W end\n"
"}\n"
"}\n"
"bind Entry <Control-f> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntrySetCursor %W [expr {[%W index insert] + 1}]\n"
"}\n"
"}\n"
"bind Entry <Control-h> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntryBackspace %W\n"
"}\n"
"}\n"
"bind Entry <Control-k> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete insert end\n"
"}\n"
"}\n"
"bind Entry <Control-t> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntryTranspose %W\n"
"}\n"
"}\n"
"bind Entry <Meta-b> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntrySetCursor %W [tkEntryPreviousWord %W insert]\n"
"}\n"
"}\n"
"bind Entry <Meta-d> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete insert [tkEntryNextWord %W insert]\n"
"}\n"
"}\n"
"bind Entry <Meta-f> {\n"
"if {!$tk_strictMotif} {\n"
"tkEntrySetCursor %W [tkEntryNextWord %W insert]\n"
"}\n"
"}\n"
"bind Entry <Meta-BackSpace> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete [tkEntryPreviousWord %W insert] insert\n"
"}\n"
"}\n"
"bind Entry <Meta-Delete> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete [tkEntryPreviousWord %W insert] insert\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"bind Entry <2> {\n"
"if {!$tk_strictMotif} {\n"
"%W scan mark %x\n"
"set tkPriv(x) %x\n"
"set tkPriv(y) %y\n"
"set tkPriv(mouseMoved) 0\n"
"}\n"
"}\n"
"bind Entry <B2-Motion> {\n"
"if {!$tk_strictMotif} {\n"
"if {abs(%x-$tkPriv(x)) > 2} {\n"
"set tkPriv(mouseMoved) 1\n"
"}\n"
"%W scan dragto %x\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryClosestGap {w x} {\n"
"set pos [$w index @$x]\n"
"set bbox [$w bbox $pos]\n"
"if {($x - [lindex $bbox 0]) < ([lindex $bbox 2]/2)} {\n"
"return $pos\n"
"}\n"
"incr pos\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryButton1 {w x} {\n"
"global tkPriv\n"
"\n"
"set tkPriv(selectMode) char\n"
"set tkPriv(mouseMoved) 0\n"
"set tkPriv(pressX) $x\n"
"$w icursor [tkEntryClosestGap $w $x]\n"
"$w selection from insert\n"
"if {[lindex [$w configure -state] 4] == \"normal\"} {focus $w}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryMouseSelect {w x} {\n"
"global tkPriv\n"
"\n"
"set cur [tkEntryClosestGap $w $x]\n"
"set anchor [$w index anchor]\n"
"if {($cur != $anchor) || (abs($tkPriv(pressX) - $x) >= 3)} {\n"
"set tkPriv(mouseMoved) 1\n"
"}\n"
"switch $tkPriv(selectMode) {\n"
"char {\n"
"if {$tkPriv(mouseMoved)} {\n"
"if {$cur < $anchor} {\n"
"$w selection range $cur $anchor\n"
"} elseif {$cur > $anchor} {\n"
"$w selection range $anchor $cur\n"
"} else {\n"
"$w selection clear\n"
"}\n"
"}\n"
"}\n"
"word {\n"
"if {$cur < [$w index anchor]} {\n"
"set before [tcl_wordBreakBefore [$w get] $cur]\n"
"set after [tcl_wordBreakAfter [$w get] [expr {$anchor-1}]]\n"
"} else {\n"
"set before [tcl_wordBreakBefore [$w get] $anchor]\n"
"set after [tcl_wordBreakAfter [$w get] [expr {$cur - 1}]]\n"
"}\n"
"if {$before < 0} {\n"
"set before 0\n"
"}\n"
"if {$after < 0} {\n"
"set after end\n"
"}\n"
"$w selection range $before $after\n"
"}\n"
"line {\n"
"$w selection range 0 end\n"
"}\n"
"}\n"
"update idletasks\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryPaste {w x} {\n"
"global tkPriv\n"
"\n"
"$w icursor [tkEntryClosestGap $w $x]\n"
"catch {$w insert insert [selection get -displayof $w]}\n"
"if {[lindex [$w configure -state] 4] == \"normal\"} {focus $w}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryAutoScan {w} {\n"
"global tkPriv\n"
"set x $tkPriv(x)\n"
"if {![winfo exists $w]} return\n"
"if {$x >= [winfo width $w]} {\n"
"$w xview scroll 2 units\n"
"tkEntryMouseSelect $w $x\n"
"} elseif {$x < 0} {\n"
"$w xview scroll -2 units\n"
"tkEntryMouseSelect $w $x\n"
"}\n"
"set tkPriv(afterId) [after 50 tkEntryAutoScan $w]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryKeySelect {w new} {\n"
"if {![$w selection present]} {\n"
"$w selection from insert\n"
"$w selection to $new\n"
"} else {\n"
"$w selection adjust $new\n"
"}\n"
"$w icursor $new\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryInsert {w s} {\n"
"if {$s == \"\"} {\n"
"return\n"
"}\n"
"catch {\n"
"set insert [$w index insert]\n"
"if {([$w index sel.first] <= $insert)\n"
"&& ([$w index sel.last] >= $insert)} {\n"
"$w delete sel.first sel.last\n"
"}\n"
"}\n"
"$w insert insert $s\n"
"tkEntrySeeInsert $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryBackspace w {\n"
"if {[$w selection present]} {\n"
"$w delete sel.first sel.last\n"
"} else {\n"
"set x [expr {[$w index insert] - 1}]\n"
"if {$x >= 0} {$w delete $x}\n"
"if {[$w index @0] >= [$w index insert]} {\n"
"set range [$w xview]\n"
"set left [lindex $range 0]\n"
"set right [lindex $range 1]\n"
"$w xview moveto [expr {$left - ($right - $left)/2.0}]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntrySeeInsert w {\n"
"set c [$w index insert]\n"
"set left [$w index @0]\n"
"if {$left > $c} {\n"
"$w xview $c\n"
"return\n"
"}\n"
"set x [winfo width $w]\n"
"while {([$w index @$x] <= $c) && ($left < $c)} {\n"
"incr left\n"
"$w xview $left\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntrySetCursor {w pos} {\n"
"$w icursor $pos\n"
"$w selection clear\n"
"tkEntrySeeInsert $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryTranspose w {\n"
"set i [$w index insert]\n"
"if {$i < [$w index end]} {\n"
"incr i\n"
"}\n"
"set first [expr {$i-2}]\n"
"if {$first < 0} {\n"
"return\n"
"}\n"
"set new [string index [$w get] [expr {$i-1}]][string index [$w get] $first]\n"
"$w delete $first $i\n"
"$w insert insert $new\n"
"tkEntrySeeInsert $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"windows\"}  {\n"
"proc tkEntryNextWord {w start} {\n"
"set pos [tcl_endOfWord [$w get] [$w index $start]]\n"
"if {$pos >= 0} {\n"
"set pos [tcl_startOfNextWord [$w get] $pos]\n"
"}\n"
"if {$pos < 0} {\n"
"return end\n"
"}\n"
"return $pos\n"
"}\n"
"} else {\n"
"proc tkEntryNextWord {w start} {\n"
"set pos [tcl_endOfWord [$w get] [$w index $start]]\n"
"if {$pos < 0} {\n"
"return end\n"
"}\n"
"return $pos\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkEntryPreviousWord {w start} {\n"
"set pos [tcl_startOfPreviousWord [$w get] [$w index $start]]\n"
"if {$pos < 0} {\n"
"return 0\n"
"}\n"
"return $pos\n"
"}\n"
"\n"
"";
#line 693 "et80.c"
Et_EvalInclude("entry.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_focusNext w {\n"
"set cur $w\n"
"while 1 {\n"
"\n"
"\n"
"\n"
"set parent $cur\n"
"set children [winfo children $cur]\n"
"set i -1\n"
"\n"
"\n"
"\n"
"while 1 {\n"
"incr i\n"
"if {$i < [llength $children]} {\n"
"set cur [lindex $children $i]\n"
"if {[winfo toplevel $cur] == $cur} {\n"
"continue\n"
"} else {\n"
"break\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set cur $parent\n"
"if {[winfo toplevel $cur] == $cur} {\n"
"break\n"
"}\n"
"set parent [winfo parent $parent]\n"
"set children [winfo children $parent]\n"
"set i [lsearch -exact $children $cur]\n"
"}\n"
"if {($cur == $w) || [tkFocusOK $cur]} {\n"
"return $cur\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_focusPrev w {\n"
"set cur $w\n"
"while 1 {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[winfo toplevel $cur] == $cur}  {\n"
"set parent $cur\n"
"set children [winfo children $cur]\n"
"set i [llength $children]\n"
"} else {\n"
"set parent [winfo parent $cur]\n"
"set children [winfo children $parent]\n"
"set i [lsearch -exact $children $cur]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"while {$i > 0} {\n"
"incr i -1\n"
"set cur [lindex $children $i]\n"
"if {[winfo toplevel $cur] == $cur} {\n"
"continue\n"
"}\n"
"set parent $cur\n"
"set children [winfo children $parent]\n"
"set i [llength $children]\n"
"}\n"
"set cur $parent\n"
"if {($cur == $w) || [tkFocusOK $cur]} {\n"
"return $cur\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFocusOK w {\n"
"set code [catch {$w cget -takefocus} value]\n"
"if {($code == 0) && ($value != \"\")} {\n"
"if {$value == 0} {\n"
"return 0\n"
"} elseif {$value == 1} {\n"
"return [winfo viewable $w]\n"
"} else {\n"
"set value [uplevel #0 $value $w]\n"
"if {$value != \"\"} {\n"
"return $value\n"
"}\n"
"}\n"
"}\n"
"if {![winfo viewable $w]} {\n"
"return 0\n"
"}\n"
"set code [catch {$w cget -state} value]\n"
"if {($code == 0) && ($value == \"disabled\")} {\n"
"return 0\n"
"}\n"
"regexp Key|Focus \"[bind $w] [bind [winfo class $w]]\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_focusFollowsMouse {} {\n"
"set old [bind all <Enter>]\n"
"set script {\n"
"if {(\"%d\" == \"NotifyAncestor\") || (\"%d\" == \"NotifyNonlinear\")\n"
"|| (\"%d\" == \"NotifyInferior\")} {\n"
"if {[tkFocusOK %W]} {\n"
"focus %W\n"
"}\n"
"}\n"
"}\n"
"if {$old != \"\"} {\n"
"bind all <Enter> \"$old; $script\"\n"
"} else {\n"
"bind all <Enter> $script\n"
"}\n"
"}\n"
"";
#line 694 "et80.c"
Et_EvalInclude("focus.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#--------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#--------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Listbox <1> {\n"
"if {[winfo exists %W]} {\n"
"tkListboxBeginSelect %W [%W index @%x,%y]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Listbox <Double-1> {\n"
"\n"
"}\n"
"\n"
"bind Listbox <B1-Motion> {\n"
"set tkPriv(x) %x\n"
"set tkPriv(y) %y\n"
"tkListboxMotion %W [%W index @%x,%y]\n"
"}\n"
"bind Listbox <ButtonRelease-1> {\n"
"tkCancelRepeat\n"
"%W activate @%x,%y\n"
"}\n"
"bind Listbox <Shift-1> {\n"
"tkListboxBeginExtend %W [%W index @%x,%y]\n"
"}\n"
"bind Listbox <Control-1> {\n"
"tkListboxBeginToggle %W [%W index @%x,%y]\n"
"}\n"
"bind Listbox <B1-Leave> {\n"
"set tkPriv(x) %x\n"
"set tkPriv(y) %y\n"
"tkListboxAutoScan %W\n"
"}\n"
"bind Listbox <B1-Enter> {\n"
"tkCancelRepeat\n"
"}\n"
"\n"
"bind Listbox <Up> {\n"
"tkListboxUpDown %W -1\n"
"}\n"
"bind Listbox <Shift-Up> {\n"
"tkListboxExtendUpDown %W -1\n"
"}\n"
"bind Listbox <Down> {\n"
"tkListboxUpDown %W 1\n"
"}\n"
"bind Listbox <Shift-Down> {\n"
"tkListboxExtendUpDown %W 1\n"
"}\n"
"bind Listbox <Left> {\n"
"%W xview scroll -1 units\n"
"}\n"
"bind Listbox <Control-Left> {\n"
"%W xview scroll -1 pages\n"
"}\n"
"bind Listbox <Right> {\n"
"%W xview scroll 1 units\n"
"}\n"
"bind Listbox <Control-Right> {\n"
"%W xview scroll 1 pages\n"
"}\n"
"bind Listbox <Prior> {\n"
"%W yview scroll -1 pages\n"
"%W activate @0,0\n"
"}\n"
"bind Listbox <Next> {\n"
"%W yview scroll 1 pages\n"
"%W activate @0,0\n"
"}\n"
"bind Listbox <Control-Prior> {\n"
"%W xview scroll -1 pages\n"
"}\n"
"bind Listbox <Control-Next> {\n"
"%W xview scroll 1 pages\n"
"}\n"
"bind Listbox <Home> {\n"
"%W xview moveto 0\n"
"}\n"
"bind Listbox <End> {\n"
"%W xview moveto 1\n"
"}\n"
"bind Listbox <Control-Home> {\n"
"%W activate 0\n"
"%W see 0\n"
"%W selection clear 0 end\n"
"%W selection set 0\n"
"}\n"
"bind Listbox <Shift-Control-Home> {\n"
"tkListboxDataExtend %W 0\n"
"}\n"
"bind Listbox <Control-End> {\n"
"%W activate end\n"
"%W see end\n"
"%W selection clear 0 end\n"
"%W selection set end\n"
"}\n"
"bind Listbox <Shift-Control-End> {\n"
"tkListboxDataExtend %W [%W index end]\n"
"}\n"
"bind Listbox <<Copy>> {\n"
"if {[selection own -displayof %W] == \"%W\"} {\n"
"clipboard clear -displayof %W\n"
"clipboard append -displayof %W [selection get -displayof %W]\n"
"}\n"
"}\n"
"bind Listbox <space> {\n"
"tkListboxBeginSelect %W [%W index active]\n"
"}\n"
"bind Listbox <Select> {\n"
"tkListboxBeginSelect %W [%W index active]\n"
"}\n"
"bind Listbox <Control-Shift-space> {\n"
"tkListboxBeginExtend %W [%W index active]\n"
"}\n"
"bind Listbox <Shift-Select> {\n"
"tkListboxBeginExtend %W [%W index active]\n"
"}\n"
"bind Listbox <Escape> {\n"
"tkListboxCancel %W\n"
"}\n"
"bind Listbox <Control-slash> {\n"
"tkListboxSelectAll %W\n"
"}\n"
"bind Listbox <Control-backslash> {\n"
"if {[%W cget -selectmode] != \"browse\"} {\n"
"%W selection clear 0 end\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"bind Listbox <2> {\n"
"%W scan mark %x %y\n"
"}\n"
"bind Listbox <B2-Motion> {\n"
"%W scan dragto %x %y\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Listbox <MouseWheel> {\n"
"%W yview scroll [expr - (%D / 120) * 4] units\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxBeginSelect {w el} {\n"
"global tkPriv\n"
"if {[$w cget -selectmode]  == \"multiple\"} {\n"
"if {[$w selection includes $el]} {\n"
"$w selection clear $el\n"
"} else {\n"
"$w selection set $el\n"
"}\n"
"} else {\n"
"$w selection clear 0 end\n"
"$w selection set $el\n"
"$w selection anchor $el\n"
"set tkPriv(listboxSelection) {}\n"
"set tkPriv(listboxPrev) $el\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxMotion {w el} {\n"
"global tkPriv\n"
"if {$el == $tkPriv(listboxPrev)} {\n"
"return\n"
"}\n"
"set anchor [$w index anchor]\n"
"switch [$w cget -selectmode] {\n"
"browse {\n"
"$w selection clear 0 end\n"
"$w selection set $el\n"
"set tkPriv(listboxPrev) $el\n"
"}\n"
"extended {\n"
"set i $tkPriv(listboxPrev)\n"
"if {[$w selection includes anchor]} {\n"
"$w selection clear $i $el\n"
"$w selection set anchor $el\n"
"} else {\n"
"$w selection clear $i $el\n"
"$w selection clear anchor $el\n"
"}\n"
"while {($i < $el) && ($i < $anchor)} {\n"
"if {[lsearch $tkPriv(listboxSelection) $i] >= 0} {\n"
"$w selection set $i\n"
"}\n"
"incr i\n"
"}\n"
"while {($i > $el) && ($i > $anchor)} {\n"
"if {[lsearch $tkPriv(listboxSelection) $i] >= 0} {\n"
"$w selection set $i\n"
"}\n"
"incr i -1\n"
"}\n"
"set tkPriv(listboxPrev) $el\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxBeginExtend {w el} {\n"
"if {[$w cget -selectmode] == \"extended\"} {\n"
"if {[$w selection includes anchor]} {\n"
"tkListboxMotion $w $el\n"
"} else {\n"
"\n"
"\n"
"tkListboxBeginSelect $w $el\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxBeginToggle {w el} {\n"
"global tkPriv\n"
"if {[$w cget -selectmode] == \"extended\"} {\n"
"set tkPriv(listboxSelection) [$w curselection]\n"
"set tkPriv(listboxPrev) $el\n"
"$w selection anchor $el\n"
"if {[$w selection includes $el]} {\n"
"$w selection clear $el\n"
"} else {\n"
"$w selection set $el\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxAutoScan {w} {\n"
"global tkPriv\n"
"if {![winfo exists $w]} return\n"
"set x $tkPriv(x)\n"
"set y $tkPriv(y)\n"
"if {$y >= [winfo height $w]} {\n"
"$w yview scroll 1 units\n"
"} elseif {$y < 0} {\n"
"$w yview scroll -1 units\n"
"} elseif {$x >= [winfo width $w]} {\n"
"$w xview scroll 2 units\n"
"} elseif {$x < 0} {\n"
"$w xview scroll -2 units\n"
"} else {\n"
"return\n"
"}\n"
"tkListboxMotion $w [$w index @$x,$y]\n"
"set tkPriv(afterId) [after 50 tkListboxAutoScan $w]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxUpDown {w amount} {\n"
"global tkPriv\n"
"$w activate [expr {[$w index active] + $amount}]\n"
"$w see active\n"
"switch [$w cget -selectmode] {\n"
"browse {\n"
"$w selection clear 0 end\n"
"$w selection set active\n"
"}\n"
"extended {\n"
"$w selection clear 0 end\n"
"$w selection set active\n"
"$w selection anchor active\n"
"set tkPriv(listboxPrev) [$w index active]\n"
"set tkPriv(listboxSelection) {}\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxExtendUpDown {w amount} {\n"
"if {[$w cget -selectmode] != \"extended\"} {\n"
"return\n"
"}\n"
"$w activate [expr {[$w index active] + $amount}]\n"
"$w see active\n"
"tkListboxMotion $w [$w index active]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxDataExtend {w el} {\n"
"set mode [$w cget -selectmode]\n"
"if {$mode == \"extended\"} {\n"
"$w activate $el\n"
"$w see $el\n"
"if {[$w selection includes anchor]} {\n"
"tkListboxMotion $w $el\n"
"}\n"
"} elseif {$mode == \"multiple\"} {\n"
"$w activate $el\n"
"$w see $el\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxCancel w {\n"
"global tkPriv\n"
"if {[$w cget -selectmode] != \"extended\"} {\n"
"return\n"
"}\n"
"set first [$w index anchor]\n"
"set last $tkPriv(listboxPrev)\n"
"if {$first > $last} {\n"
"set tmp $first\n"
"set first $last\n"
"set last $tmp\n"
"}\n"
"$w selection clear $first $last\n"
"while {$first <= $last} {\n"
"if {[lsearch $tkPriv(listboxSelection) $first] >= 0} {\n"
"$w selection set $first\n"
"}\n"
"incr first\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkListboxSelectAll w {\n"
"set mode [$w cget -selectmode]\n"
"if {($mode == \"single\") || ($mode == \"browse\")} {\n"
"$w selection clear 0 end\n"
"$w selection set active\n"
"} else {\n"
"$w selection set 0 end\n"
"}\n"
"}\n"
"";
#line 695 "et80.c"
Et_EvalInclude("listbox.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"bind Menubutton <FocusIn> {}\n"
"bind Menubutton <Enter> {\n"
"tkMbEnter %W\n"
"}\n"
"bind Menubutton <Leave> {\n"
"tkMbLeave %W\n"
"}\n"
"bind Menubutton <1> {\n"
"if {$tkPriv(inMenubutton) != \"\"} {\n"
"tkMbPost $tkPriv(inMenubutton) %X %Y\n"
"}\n"
"}\n"
"bind Menubutton <Motion> {\n"
"tkMbMotion %W up %X %Y\n"
"}\n"
"bind Menubutton <B1-Motion> {\n"
"tkMbMotion %W down %X %Y\n"
"}\n"
"bind Menubutton <ButtonRelease-1> {\n"
"tkMbButtonUp %W\n"
"}\n"
"bind Menubutton <space> {\n"
"tkMbPost %W\n"
"tkMenuFirstEntry [%W cget -menu]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Menu <FocusIn> {}\n"
"\n"
"bind Menu <Enter> {\n"
"set tkPriv(window) %W\n"
"if {[%W cget -type] == \"tearoff\"} {\n"
"if {\"%m\" != \"NotifyUngrab\"} {\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"tk_menuSetFocus %W\n"
"}\n"
"}\n"
"}\n"
"tkMenuMotion %W %x %y %s\n"
"}\n"
"\n"
"bind Menu <Leave> {\n"
"tkMenuLeave %W %X %Y %s\n"
"}\n"
"bind Menu <Motion> {\n"
"tkMenuMotion %W %x %y %s\n"
"}\n"
"bind Menu <ButtonPress> {\n"
"tkMenuButtonDown %W\n"
"}\n"
"bind Menu <ButtonRelease> {\n"
"tkMenuInvoke %W 1\n"
"}\n"
"bind Menu <space> {\n"
"tkMenuInvoke %W 0\n"
"}\n"
"bind Menu <Return> {\n"
"tkMenuInvoke %W 0\n"
"}\n"
"bind Menu <Escape> {\n"
"tkMenuEscape %W\n"
"}\n"
"bind Menu <Left> {\n"
"tkMenuLeftArrow %W\n"
"}\n"
"bind Menu <Right> {\n"
"tkMenuRightArrow %W\n"
"}\n"
"bind Menu <Up> {\n"
"tkMenuUpArrow %W\n"
"}\n"
"bind Menu <Down> {\n"
"tkMenuDownArrow %W\n"
"}\n"
"bind Menu <KeyPress> {\n"
"tkTraverseWithinMenu %W %A\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"bind all <Alt-KeyPress> {\n"
"tkTraverseToMenu %W %A\n"
"}\n"
"\n"
"bind all <F10> {\n"
"tkFirstMenu %W\n"
"}\n"
"} else {\n"
"bind Menubutton <Alt-KeyPress> {\n"
"tkTraverseToMenu %W %A\n"
"}\n"
"\n"
"bind Menubutton <F10> {\n"
"tkFirstMenu %W\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMbEnter w {\n"
"global tkPriv\n"
"\n"
"if {$tkPriv(inMenubutton) != \"\"} {\n"
"tkMbLeave $tkPriv(inMenubutton)\n"
"}\n"
"set tkPriv(inMenubutton) $w\n"
"if {[$w cget -state] != \"disabled\"} {\n"
"$w configure -state active\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMbLeave w {\n"
"global tkPriv\n"
"\n"
"set tkPriv(inMenubutton) {}\n"
"if {![winfo exists $w]} {\n"
"return\n"
"}\n"
"if {[$w cget -state] == \"active\"} {\n"
"$w configure -state normal\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMbPost {w {x {}} {y {}}} {\n"
"global tkPriv errorInfo\n"
"global tcl_platform\n"
"\n"
"if {([$w cget -state] == \"disabled\") || ($w == $tkPriv(postedMb))} {\n"
"return\n"
"}\n"
"set menu [$w cget -menu]\n"
"if {$menu == \"\"} {\n"
"return\n"
"}\n"
"set tearoff [expr {($tcl_platform(platform) == \"unix\") \\\n"
"|| ([$menu cget -type] == \"tearoff\")}]\n"
"if {[string first $w $menu] != 0} {\n"
"error \"can't post $menu:  it isn't a descendant of $w (this is a new requirement in Tk versions 3.0 and later)\"\n"
"}\n"
"set cur $tkPriv(postedMb)\n"
"if {$cur != \"\"} {\n"
"tkMenuUnpost {}\n"
"}\n"
"set tkPriv(cursor) [$w cget -cursor]\n"
"set tkPriv(relief) [$w cget -relief]\n"
"$w configure -cursor arrow\n"
"$w configure -relief raised\n"
"\n"
"set tkPriv(postedMb) $w\n"
"set tkPriv(focus) [focus]\n"
"$menu activate none\n"
"tkGenerateMenuSelect $menu\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"update idletasks\n"
"if {[catch {\n"
"switch [$w cget -direction] {\n"
"above {\n"
"set x [winfo rootx $w]\n"
"set y [expr {[winfo rooty $w] - [winfo reqheight $menu]}]\n"
"$menu post $x $y\n"
"}\n"
"below {\n"
"set x [winfo rootx $w]\n"
"set y [expr {[winfo rooty $w] + [winfo height $w]}]\n"
"$menu post $x $y\n"
"}\n"
"left {\n"
"set x [expr {[winfo rootx $w] - [winfo reqwidth $menu]}]\n"
"set y [expr {(2 * [winfo rooty $w] + [winfo height $w]) / 2}]\n"
"set entry [tkMenuFindName $menu [$w cget -text]]\n"
"if {[$w cget -indicatoron]} {\n"
"if {$entry == [$menu index last]} {\n"
"incr y [expr {-([$menu yposition $entry] \\\n"
"+ [winfo reqheight $menu])/2}]\n"
"} else {\n"
"incr y [expr {-([$menu yposition $entry] \\\n"
"+ [$menu yposition [expr {$entry+1}]])/2}]\n"
"}\n"
"}\n"
"$menu post $x $y\n"
"if {($entry != {}) && ([$menu entrycget $entry -state] != \"disabled\")} {\n"
"$menu activate $entry\n"
"tkGenerateMenuSelect $menu\n"
"}\n"
"}\n"
"right {\n"
"set x [expr {[winfo rootx $w] + [winfo width $w]}]\n"
"set y [expr {(2 * [winfo rooty $w] + [winfo height $w]) / 2}]\n"
"set entry [tkMenuFindName $menu [$w cget -text]]\n"
"if {[$w cget -indicatoron]} {\n"
"if {$entry == [$menu index last]} {\n"
"incr y [expr {-([$menu yposition $entry] \\\n"
"+ [winfo reqheight $menu])/2}]\n"
"} else {\n"
"incr y [expr {-([$menu yposition $entry] \\\n"
"+ [$menu yposition [expr {$entry+1}]])/2}]\n"
"}\n"
"}\n"
"$menu post $x $y\n"
"if {($entry != {}) && ([$menu entrycget $entry -state] != \"disabled\")} {\n"
"$menu activate $entry\n"
"tkGenerateMenuSelect $menu\n"
"}\n"
"}\n"
"default {\n"
"if {[$w cget -indicatoron]} {\n"
"if {$y == \"\"} {\n"
"set x [expr {[winfo rootx $w] + [winfo width $w]/2}]\n"
"set y [expr {[winfo rooty $w] + [winfo height $w]/2}]\n"
"}\n"
"tkPostOverPoint $menu $x $y [tkMenuFindName $menu [$w cget -text]]\n"
"} else {\n"
"$menu post [winfo rootx $w] [expr {[winfo rooty $w]+[winfo height $w]}]\n"
"}  \n"
"}\n"
"}\n"
"} msg]} {\n"
"\n"
"\n"
"\n"
"set savedInfo $errorInfo\n"
"tkMenuUnpost {}\n"
"error $msg $savedInfo\n"
"\n"
"}\n"
"\n"
"set tkPriv(tearoff) $tearoff\n"
"if {$tearoff != 0} {\n"
"focus $menu\n"
"tkSaveGrabInfo $w\n"
"grab -global $w\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuUnpost menu {\n"
"global tcl_platform\n"
"global tkPriv\n"
"set mb $tkPriv(postedMb)\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"catch {focus $tkPriv(focus)}\n"
"set tkPriv(focus) \"\"\n"
"\n"
"\n"
"\n"
"\n"
"catch {\n"
"if {$mb != \"\"} {\n"
"set menu [$mb cget -menu]\n"
"$menu unpost\n"
"set tkPriv(postedMb) {}\n"
"$mb configure -cursor $tkPriv(cursor)\n"
"$mb configure -relief $tkPriv(relief)\n"
"} elseif {$tkPriv(popup) != \"\"} {\n"
"$tkPriv(popup) unpost\n"
"set tkPriv(popup) {}\n"
"} elseif {(!([$menu cget -type] == \"menubar\")\n"
"&& !([$menu cget -type] == \"tearoff\"))} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"while 1 {\n"
"set parent [winfo parent $menu]\n"
"if {([winfo class $parent] != \"Menu\")\n"
"|| ![winfo ismapped $parent]} {\n"
"break\n"
"}\n"
"$parent activate none\n"
"$parent postcascade none\n"
"tkGenerateMenuSelect $parent\n"
"set type [$parent cget -type]\n"
"if {($type == \"menubar\")|| ($type == \"tearoff\")} {\n"
"break\n"
"}\n"
"set menu $parent\n"
"}\n"
"if {[$menu cget -type] != \"menubar\"} {\n"
"$menu unpost\n"
"}\n"
"}\n"
"}\n"
"\n"
"if {($tkPriv(tearoff) != 0) || ($tkPriv(menuBar) != \"\")} {\n"
"\n"
"\n"
"\n"
"if {$menu != \"\"} {\n"
"set grab [grab current $menu]\n"
"if {$grab != \"\"} {\n"
"grab release $grab\n"
"}\n"
"}\n"
"tkRestoreOldGrab\n"
"if {$tkPriv(menuBar) != \"\"} {\n"
"$tkPriv(menuBar) configure -cursor $tkPriv(cursor)\n"
"set tkPriv(menuBar) {}\n"
"}\n"
"if {$tcl_platform(platform) != \"unix\"} {\n"
"set tkPriv(tearoff) 0\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMbMotion {w upDown rootx rooty} {\n"
"global tkPriv\n"
"\n"
"if {$tkPriv(inMenubutton) == $w} {\n"
"return\n"
"}\n"
"set new [winfo containing $rootx $rooty]\n"
"if {($new != $tkPriv(inMenubutton)) && (($new == \"\")\n"
"|| ([winfo toplevel $new] == [winfo toplevel $w]))} {\n"
"if {$tkPriv(inMenubutton) != \"\"} {\n"
"tkMbLeave $tkPriv(inMenubutton)\n"
"}\n"
"if {($new != \"\") && ([winfo class $new] == \"Menubutton\")\n"
"&& ([$new cget -indicatoron] == 0)\n"
"&& ([$w cget -indicatoron] == 0)} {\n"
"if {$upDown == \"down\"} {\n"
"tkMbPost $new $rootx $rooty\n"
"} else {\n"
"tkMbEnter $new\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMbButtonUp w {\n"
"global tkPriv\n"
"global tcl_platform\n"
"\n"
"set tearoff [expr {($tcl_platform(platform) == \"unix\") \\\n"
"|| ([[$w cget -menu] cget -type] == \"tearoff\")}]\n"
"if {($tearoff != 0) && ($tkPriv(postedMb) == $w) \n"
"&& ($tkPriv(inMenubutton) == $w)} {\n"
"tkMenuFirstEntry [$tkPriv(postedMb) cget -menu]\n"
"} else {\n"
"tkMenuUnpost {}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuMotion {menu x y state} {\n"
"global tkPriv\n"
"if {$menu == $tkPriv(window)} {\n"
"if {[$menu cget -type] == \"menubar\"} {\n"
"if {[info exists tkPriv(focus)] && \\\n"
"([string compare $menu $tkPriv(focus)] != 0)} {\n"
"$menu activate @$x,$y\n"
"tkGenerateMenuSelect $menu\n"
"}\n"
"} else {\n"
"$menu activate @$x,$y\n"
"tkGenerateMenuSelect $menu\n"
"}\n"
"}\n"
"if {($state & 0x1f00) != 0} {\n"
"$menu postcascade active\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuButtonDown menu {\n"
"global tkPriv\n"
"global tcl_platform\n"
"$menu postcascade active\n"
"if {$tkPriv(postedMb) != \"\"} {\n"
"grab -global $tkPriv(postedMb)\n"
"} else {\n"
"while {([$menu cget -type] == \"normal\") \n"
"&& ([winfo class [winfo parent $menu]] == \"Menu\")\n"
"&& [winfo ismapped [winfo parent $menu]]} {\n"
"set menu [winfo parent $menu]\n"
"}\n"
"\n"
"if {$tkPriv(menuBar) == {}} {\n"
"set tkPriv(menuBar) $menu\n"
"set tkPriv(cursor) [$menu cget -cursor]\n"
"$menu configure -cursor arrow\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {$menu != [grab current $menu]} {\n"
"tkSaveGrabInfo $menu\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"grab -global $menu\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuLeave {menu rootx rooty state} {\n"
"global tkPriv\n"
"set tkPriv(window) {}\n"
"if {[$menu index active] == \"none\"} {\n"
"return\n"
"}\n"
"if {([$menu type active] == \"cascade\")\n"
"&& ([winfo containing $rootx $rooty]\n"
"== [$menu entrycget active -menu])} {\n"
"return\n"
"}\n"
"$menu activate none\n"
"tkGenerateMenuSelect $menu\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuInvoke {w buttonRelease} {\n"
"global tkPriv\n"
"\n"
"if {$buttonRelease && ($tkPriv(window) == \"\")} {\n"
"\n"
"\n"
"\n"
"\n"
"$w postcascade none\n"
"$w activate none\n"
"event generate $w <<MenuSelect>>\n"
"tkMenuUnpost $w\n"
"return\n"
"}\n"
"if {[$w type active] == \"cascade\"} {\n"
"$w postcascade active\n"
"set menu [$w entrycget active -menu]\n"
"tkMenuFirstEntry $menu\n"
"} elseif {[$w type active] == \"tearoff\"} {\n"
"tkMenuUnpost $w\n"
"tkTearOffMenu $w\n"
"} elseif {[$w cget -type] == \"menubar\"} {\n"
"$w postcascade none\n"
"$w activate none\n"
"event generate $w <<MenuSelect>>\n"
"tkMenuUnpost $w\n"
"} else {\n"
"tkMenuUnpost $w\n"
"uplevel #0 [list $w invoke active]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuEscape menu {\n"
"set parent [winfo parent $menu]\n"
"if {([winfo class $parent] != \"Menu\")} {\n"
"tkMenuUnpost $menu\n"
"} elseif {([$parent cget -type] == \"menubar\")} {\n"
"tkMenuUnpost $menu\n"
"tkRestoreOldGrab\n"
"} else {\n"
"tkMenuNextMenu $menu left\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuUpArrow {menu} {\n"
"if {[$menu cget -type] == \"menubar\"} {\n"
"tkMenuNextMenu $menu left\n"
"} else {\n"
"tkMenuNextEntry $menu -1\n"
"}\n"
"}\n"
"\n"
"proc tkMenuDownArrow {menu} {\n"
"if {[$menu cget -type] == \"menubar\"} {\n"
"tkMenuNextMenu $menu right\n"
"} else {\n"
"tkMenuNextEntry $menu 1\n"
"}\n"
"}\n"
"\n"
"proc tkMenuLeftArrow {menu} {\n"
"if {[$menu cget -type] == \"menubar\"} {\n"
"tkMenuNextEntry $menu -1\n"
"} else {\n"
"tkMenuNextMenu $menu left\n"
"}\n"
"}\n"
"\n"
"proc tkMenuRightArrow {menu} {\n"
"if {[$menu cget -type] == \"menubar\"} {\n"
"tkMenuNextEntry $menu 1\n"
"} else {\n"
"tkMenuNextMenu $menu right\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuNextMenu {menu direction} {\n"
"global tkPriv\n"
"\n"
"\n"
"\n"
"if {$direction == \"right\"} {\n"
"set count 1\n"
"set parent [winfo parent $menu]\n"
"set class [winfo class $parent]\n"
"if {[$menu type active] == \"cascade\"} {\n"
"$menu postcascade active\n"
"set m2 [$menu entrycget active -menu]\n"
"if {$m2 != \"\"} {\n"
"tkMenuFirstEntry $m2\n"
"}\n"
"return\n"
"} else {\n"
"set parent [winfo parent $menu]\n"
"while {($parent != \".\")} {\n"
"if {([winfo class $parent] == \"Menu\")\n"
"&& ([$parent cget -type] == \"menubar\")} {\n"
"tk_menuSetFocus $parent\n"
"tkMenuNextEntry $parent 1\n"
"return\n"
"}\n"
"set parent [winfo parent $parent]\n"
"}\n"
"}\n"
"} else {\n"
"set count -1\n"
"set m2 [winfo parent $menu]\n"
"if {[winfo class $m2] == \"Menu\"} {\n"
"if {[$m2 cget -type] != \"menubar\"} {\n"
"$menu activate none\n"
"tkGenerateMenuSelect $menu\n"
"tk_menuSetFocus $m2\n"
"\n"
"\n"
"\n"
"set tmp [$m2 index active]\n"
"$m2 activate none\n"
"$m2 activate $tmp\n"
"return\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"set m2 [winfo parent $menu]\n"
"if {[winfo class $m2] == \"Menu\"} {\n"
"if {[$m2 cget -type] == \"menubar\"} {\n"
"tk_menuSetFocus $m2\n"
"tkMenuNextEntry $m2 -1\n"
"return\n"
"}\n"
"}\n"
"\n"
"set w $tkPriv(postedMb)\n"
"if {$w == \"\"} {\n"
"return\n"
"}\n"
"set buttons [winfo children [winfo parent $w]]\n"
"set length [llength $buttons]\n"
"set i [expr {[lsearch -exact $buttons $w] + $count}]\n"
"while 1 {\n"
"while {$i < 0} {\n"
"incr i $length\n"
"}\n"
"while {$i >= $length} {\n"
"incr i -$length\n"
"}\n"
"set mb [lindex $buttons $i]\n"
"if {([winfo class $mb] == \"Menubutton\")\n"
"&& ([$mb cget -state] != \"disabled\")\n"
"&& ([$mb cget -menu] != \"\")\n"
"&& ([[$mb cget -menu] index last] != \"none\")} {\n"
"break\n"
"}\n"
"if {$mb == $w} {\n"
"return\n"
"}\n"
"incr i $count\n"
"}\n"
"tkMbPost $mb\n"
"tkMenuFirstEntry [$mb cget -menu]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuNextEntry {menu count} {\n"
"global tkPriv\n"
"\n"
"if {[$menu index last] == \"none\"} {\n"
"return\n"
"}\n"
"set length [expr {[$menu index last]+1}]\n"
"set quitAfter $length\n"
"set active [$menu index active]\n"
"if {$active == \"none\"} {\n"
"set i 0\n"
"} else {\n"
"set i [expr {$active + $count}]\n"
"}\n"
"while 1 {\n"
"if {$quitAfter <= 0} {\n"
"\n"
"\n"
"\n"
"return\n"
"}\n"
"while {$i < 0} {\n"
"incr i $length\n"
"}\n"
"while {$i >= $length} {\n"
"incr i -$length\n"
"}\n"
"if {[catch {$menu entrycget $i -state} state] == 0} {\n"
"if {$state != \"disabled\"} {\n"
"break\n"
"}\n"
"}\n"
"if {$i == $active} {\n"
"return\n"
"}\n"
"incr i $count\n"
"incr quitAfter -1\n"
"}\n"
"$menu activate $i\n"
"tkGenerateMenuSelect $menu\n"
"if {[$menu type $i] == \"cascade\"} {\n"
"set cascade [$menu entrycget $i -menu]\n"
"if {[string compare $cascade \"\"] != 0} {\n"
"$menu postcascade $i\n"
"tkMenuFirstEntry $cascade\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuFind {w char} {\n"
"global tkPriv\n"
"set char [string tolower $char]\n"
"set windowlist [winfo child $w]\n"
"\n"
"foreach child $windowlist {\n"
"\n"
"if {[winfo toplevel [focus]] != [winfo toplevel $child] } {\n"
"continue\n"
"}\n"
"switch [winfo class $child] {\n"
"Menu {\n"
"if {[$child cget -type] == \"menubar\"} {\n"
"if {$char == \"\"} {\n"
"return $child\n"
"}\n"
"set last [$child index last]\n"
"for {set i [$child cget -tearoff]} {$i <= $last} {incr i} {\n"
"if {[$child type $i] == \"separator\"} {\n"
"continue\n"
"}\n"
"set char2 [string index [$child entrycget $i -label] \\\n"
"[$child entrycget $i -underline]]\n"
"if {([string compare $char [string tolower $char2]] \\\n"
"== 0) || ($char == \"\")} {\n"
"if {[$child entrycget $i -state] != \"disabled\"} {\n"
"return $child\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"foreach child $windowlist {\n"
"\n"
"if {[winfo toplevel [focus]] != [winfo toplevel $child] } {\n"
"continue\n"
"}\n"
"switch [winfo class $child] {\n"
"Menubutton {\n"
"set char2 [string index [$child cget -text] \\\n"
"[$child cget -underline]]\n"
"if {([string compare $char [string tolower $char2]] == 0)\n"
"|| ($char == \"\")} {\n"
"if {[$child cget -state] != \"disabled\"} {\n"
"return $child\n"
"}\n"
"}\n"
"}\n"
"\n"
"default {\n"
"set match [tkMenuFind $child $char]\n"
"if {$match != \"\"} {\n"
"return $match\n"
"}\n"
"}\n"
"}\n"
"}\n"
"return {}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTraverseToMenu {w char} {\n"
"global tkPriv\n"
"if {$char == \"\"} {\n"
"return\n"
"}\n"
"while {[winfo class $w] == \"Menu\"} {\n"
"if {([$w cget -type] != \"menubar\") && ($tkPriv(postedMb) == \"\")} {\n"
"return\n"
"}\n"
"if {[$w cget -type] == \"menubar\"} {\n"
"break\n"
"}\n"
"set w [winfo parent $w]\n"
"}\n"
"set w [tkMenuFind [winfo toplevel $w] $char]\n"
"if {$w != \"\"} {\n"
"if {[winfo class $w] == \"Menu\"} {\n"
"tk_menuSetFocus $w\n"
"set tkPriv(window) $w\n"
"tkSaveGrabInfo $w\n"
"grab -global $w\n"
"tkTraverseWithinMenu $w $char\n"
"} else {\n"
"tkMbPost $w\n"
"tkMenuFirstEntry [$w cget -menu]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFirstMenu w {\n"
"set w [tkMenuFind [winfo toplevel $w] \"\"]\n"
"if {$w != \"\"} {\n"
"if {[winfo class $w] == \"Menu\"} {\n"
"tk_menuSetFocus $w\n"
"set tkPriv(window) $w\n"
"tkSaveGrabInfo $w\n"
"grab -global $w\n"
"tkMenuFirstEntry $w\n"
"} else {\n"
"tkMbPost $w\n"
"tkMenuFirstEntry [$w cget -menu]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTraverseWithinMenu {w char} {\n"
"if {$char == \"\"} {\n"
"return\n"
"}\n"
"set char [string tolower $char]\n"
"set last [$w index last]\n"
"if {$last == \"none\"} {\n"
"return\n"
"}\n"
"for {set i 0} {$i <= $last} {incr i} {\n"
"if {[catch {set char2 [string index \\\n"
"[$w entrycget $i -label] \\\n"
"[$w entrycget $i -underline]]}]} {\n"
"continue\n"
"}\n"
"if {[string compare $char [string tolower $char2]] == 0} {\n"
"if {[$w type $i] == \"cascade\"} {\n"
"$w activate $i\n"
"$w postcascade active\n"
"event generate $w <<MenuSelect>>\n"
"set m2 [$w entrycget $i -menu]\n"
"if {$m2 != \"\"} {\n"
"tkMenuFirstEntry $m2\n"
"}\n"
"} else {\n"
"tkMenuUnpost $w\n"
"uplevel #0 [list $w invoke $i]\n"
"}\n"
"return\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuFirstEntry menu {\n"
"if {$menu == \"\"} {\n"
"return\n"
"}\n"
"tk_menuSetFocus $menu\n"
"if {[$menu index active] != \"none\"} {\n"
"return\n"
"}\n"
"set last [$menu index last]\n"
"if {$last == \"none\"} {\n"
"return\n"
"}\n"
"for {set i 0} {$i <= $last} {incr i} {\n"
"if {([catch {set state [$menu entrycget $i -state]}] == 0)\n"
"&& ($state != \"disabled\") && ([$menu type $i] != \"tearoff\")} {\n"
"$menu activate $i\n"
"tkGenerateMenuSelect $menu\n"
"if {[$menu type $i] == \"cascade\"} {\n"
"set cascade [$menu entrycget $i -menu]\n"
"if {[string compare $cascade \"\"] != 0} {\n"
"$menu postcascade $i\n"
"tkMenuFirstEntry $cascade\n"
"}\n"
"}\n"
"return\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuFindName {menu s} {\n"
"set i \"\"\n"
"if {![regexp {^active$|^last$|^none$|^[0-9]|^@} $s]} {\n"
"catch {set i [$menu index $s]}\n"
"return $i\n"
"}\n"
"set last [$menu index last]\n"
"if {$last == \"none\"} {\n"
"return\n"
"}\n"
"for {set i 0} {$i <= $last} {incr i} {\n"
"if {![catch {$menu entrycget $i -label} label]} {\n"
"if {$label == $s} {\n"
"return $i\n"
"}\n"
"}\n"
"}\n"
"return \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkPostOverPoint {menu x y {entry {}}}  {\n"
"global tcl_platform\n"
"\n"
"if {$entry != {}} {\n"
"if {$entry == [$menu index last]} {\n"
"incr y [expr {-([$menu yposition $entry] \\\n"
"+ [winfo reqheight $menu])/2}]\n"
"} else {\n"
"incr y [expr {-([$menu yposition $entry] \\\n"
"+ [$menu yposition [expr {$entry+1}]])/2}]\n"
"}\n"
"incr x [expr {-[winfo reqwidth $menu]/2}]\n"
"}\n"
"$menu post $x $y\n"
"if {($entry != {}) && ([$menu entrycget $entry -state] != \"disabled\")} {\n"
"$menu activate $entry\n"
"tkGenerateMenuSelect $menu\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkSaveGrabInfo w {\n"
"global tkPriv\n"
"set tkPriv(oldGrab) [grab current $w]\n"
"if {$tkPriv(oldGrab) != \"\"} {\n"
"set tkPriv(grabStatus) [grab status $tkPriv(oldGrab)]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkRestoreOldGrab {} {\n"
"global tkPriv\n"
"\n"
"if {$tkPriv(oldGrab) != \"\"} {\n"
"\n"
"\n"
"\n"
"\n"
"catch {\n"
"if {$tkPriv(grabStatus) == \"global\"} {\n"
"grab set -global $tkPriv(oldGrab)\n"
"} else {\n"
"grab set $tkPriv(oldGrab)\n"
"}\n"
"}\n"
"set tkPriv(oldGrab) \"\"\n"
"}\n"
"}\n"
"\n"
"proc tk_menuSetFocus {menu} {\n"
"global tkPriv\n"
"if {![info exists tkPriv(focus)] || [string length $tkPriv(focus)] == 0} {\n"
"set tkPriv(focus) [focus]\n"
"}\n"
"focus $menu\n"
"}\n"
"\n"
"proc tkGenerateMenuSelect {menu} {\n"
"global tkPriv\n"
"\n"
"if {([string compare $tkPriv(activeMenu) $menu] == 0) \\\n"
"&& ([string compare $tkPriv(activeItem) [$menu index active]] \\\n"
"== 0)} {\n"
"return\n"
"}\n"
"\n"
"set tkPriv(activeMenu) $menu\n"
"set tkPriv(activeItem) [$menu index active]\n"
"event generate $menu <<MenuSelect>>\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_popup {menu x y {entry {}}} {\n"
"global tkPriv\n"
"global tcl_platform\n"
"if {($tkPriv(popup) != \"\") || ($tkPriv(postedMb) != \"\")} {\n"
"tkMenuUnpost {}\n"
"}\n"
"tkPostOverPoint $menu $x $y $entry\n"
"if {$tcl_platform(platform) == \"unix\"} {\n"
"tkSaveGrabInfo $menu\n"
"grab -global $menu\n"
"set tkPriv(popup) $menu\n"
"tk_menuSetFocus $menu\n"
"}\n"
"}\n"
"";
#line 696 "et80.c"
Et_EvalInclude("menu.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMessageBox {args} {\n"
"global tkPriv tcl_platform\n"
"\n"
"set w tkPrivMsgBox\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set specs {\n"
"{-default \"\" \"\" \"\"}\n"
"{-icon \"\" \"\" \"info\"}\n"
"{-message \"\" \"\" \"\"}\n"
"{-parent \"\" \"\" .}\n"
"{-title \"\" \"\" \" \"}\n"
"{-type \"\" \"\" \"ok\"}\n"
"}\n"
"\n"
"tclParseConfigSpec $w $specs \"\" $args\n"
"\n"
"if {[lsearch {info warning error question} $data(-icon)] == -1} {\n"
"error \"invalid icon \\\"$data(-icon)\\\", must be error, info, question or warning\"\n"
"}\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"if {$data(-icon) == \"error\"} {\n"
"set data(-icon) \"stop\"\n"
"} elseif {$data(-icon) == \"warning\"} {\n"
"set data(-icon) \"caution\"\n"
"} elseif {$data(-icon) == \"info\"} {\n"
"set data(-icon) \"note\"\n"
"}\n"
"}\n"
"\n"
"if {![winfo exists $data(-parent)]} {\n"
"error \"bad window path name \\\"$data(-parent)\\\"\"\n"
"}\n"
"\n"
"switch -- $data(-type) {\n"
"abortretryignore {\n"
"set buttons {\n"
"{abort  -width 6 -text Abort -under 0}\n"
"{retry  -width 6 -text Retry -under 0}\n"
"{ignore -width 6 -text Ignore -under 0}\n"
"}\n"
"}\n"
"ok {\n"
"set buttons {\n"
"{ok -width 6 -text OK -under 0}\n"
"}\n"
"if {$data(-default) == \"\"} {\n"
"set data(-default) \"ok\"\n"
"}\n"
"}\n"
"okcancel {\n"
"set buttons {\n"
"{ok     -width 6 -text OK     -under 0}\n"
"{cancel -width 6 -text Cancel -under 0}\n"
"}\n"
"}\n"
"retrycancel {\n"
"set buttons {\n"
"{retry  -width 6 -text Retry  -under 0}\n"
"{cancel -width 6 -text Cancel -under 0}\n"
"}\n"
"}\n"
"yesno {\n"
"set buttons {\n"
"{yes    -width 6 -text Yes -under 0}\n"
"{no     -width 6 -text No  -under 0}\n"
"}\n"
"}\n"
"yesnocancel {\n"
"set buttons {\n"
"{yes    -width 6 -text Yes -under 0}\n"
"{no     -width 6 -text No  -under 0}\n"
"{cancel -width 6 -text Cancel -under 0}\n"
"}\n"
"}\n"
"default {\n"
"error \"invalid message box type \\\"$data(-type)\\\", must be abortretryignore, ok, okcancel, retrycancel, yesno or yesnocancel\"\n"
"}\n"
"}\n"
"\n"
"if {[string compare $data(-default) \"\"]} {\n"
"set valid 0\n"
"foreach btn $buttons {\n"
"if {![string compare [lindex $btn 0] $data(-default)]} {\n"
"set valid 1\n"
"break\n"
"}\n"
"}\n"
"if {!$valid} {\n"
"error \"invalid default button \\\"$data(-default)\\\"\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {[string compare $data(-parent) .]} {\n"
"set w $data(-parent).__tk__messagebox\n"
"} else {\n"
"set w .__tk__messagebox\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"catch {destroy $w}\n"
"toplevel $w -class Dialog\n"
"wm title $w $data(-title)\n"
"wm iconname $w Dialog\n"
"wm protocol $w WM_DELETE_WINDOW { }\n"
"wm transient $w $data(-parent)\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"unsupported1 style $w dBoxProc\n"
"}\n"
"\n"
"frame $w.bot\n"
"pack $w.bot -side bottom -fill both\n"
"frame $w.top\n"
"pack $w.top -side top -fill both -expand 1\n"
"if {$tcl_platform(platform) != \"macintosh\"} {\n"
"$w.bot configure -relief raised -bd 1\n"
"$w.top configure -relief raised -bd 1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"option add *Dialog.msg.wrapLength 3i widgetDefault\n"
"label $w.msg -justify left -text $data(-message)\n"
"catch {$w.msg configure -font \\\n"
"-Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*\n"
"}\n"
"pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 3m -pady 3m\n"
"if {$data(-icon) != \"\"} {\n"
"label $w.bitmap -bitmap $data(-icon)\n"
"pack $w.bitmap -in $w.top -side left -padx 3m -pady 3m\n"
"}\n"
"\n"
"\n"
"\n"
"set i 0\n"
"foreach but $buttons {\n"
"set name [lindex $but 0]\n"
"set opts [lrange $but 1 end]\n"
"if {![string compare $opts {}]} {\n"
"\n"
"set capName \\\n"
"[string toupper \\\n"
"[string index $name 0]][string range $name 1 end]\n"
"set opts [list -text $capName]\n"
"}\n"
"\n"
"eval button $w.$name $opts -command [list \"set tkPriv(button) $name\"]\n"
"\n"
"if {![string compare $name $data(-default)]} {\n"
"$w.$name configure -default active\n"
"}\n"
"pack $w.$name -in $w.bot -side left -expand 1 \\\n"
"-padx 3m -pady 2m\n"
"\n"
"\n"
"\n"
"set underIdx [$w.$name cget -under]\n"
"if {$underIdx >= 0} {\n"
"set key [string index [$w.$name cget -text] $underIdx]\n"
"bind $w <Alt-[string tolower $key]>  \"$w.$name invoke\"\n"
"bind $w <Alt-[string toupper $key]>  \"$w.$name invoke\"\n"
"}\n"
"incr i\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {[string compare $data(-default) \"\"]} {\n"
"bind $w <Return> \"tkButtonInvoke $w.$data(-default)\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"wm withdraw $w\n"
"update idletasks\n"
"set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n"
"- [winfo vrootx [winfo parent $w]]}]\n"
"set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n"
"- [winfo vrooty [winfo parent $w]]}]\n"
"wm geom $w +$x+$y\n"
"wm deiconify $w\n"
"\n"
"\n"
"\n"
"set oldFocus [focus]\n"
"set oldGrab [grab current $w]\n"
"if {$oldGrab != \"\"} {\n"
"set grabStatus [grab status $oldGrab]\n"
"}\n"
"grab $w\n"
"if {[string compare $data(-default) \"\"]} {\n"
"focus $w.$data(-default)\n"
"} else {\n"
"focus $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tkwait variable tkPriv(button)\n"
"catch {focus $oldFocus}\n"
"destroy $w\n"
"if {$oldGrab != \"\"} {\n"
"if {$grabStatus == \"global\"} {\n"
"grab -global $oldGrab\n"
"} else {\n"
"grab $oldGrab\n"
"}\n"
"}\n"
"return $tkPriv(button)\n"
"}\n"
"";
#line 697 "et80.c"
Et_EvalInclude("msgbox.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_menuBar args {}\n"
"proc tk_bindForTraversal args {}\n"
"";
#line 698 "et80.c"
Et_EvalInclude("obsolete.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_optionMenu {w varName firstValue args} {\n"
"upvar #0 $varName var\n"
"\n"
"if {![info exists var]} {\n"
"set var $firstValue\n"
"}\n"
"menubutton $w -textvariable $varName -indicatoron 1 -menu $w.menu \\\n"
"-relief raised -bd 2 -highlightthickness 2 -anchor c \\\n"
"-direction flush\n"
"menu $w.menu -tearoff 0\n"
"$w.menu add radiobutton -label $firstValue -variable $varName\n"
"foreach i $args {\n"
"$w.menu add radiobutton -label $i -variable $varName\n"
"}\n"
"return $w.menu\n"
"}\n"
"";
#line 699 "et80.c"
Et_EvalInclude("optMenu.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_setPalette {args} {\n"
"global tkPalette\n"
"\n"
"\n"
"\n"
"\n"
"if {[llength $args] == 1} {\n"
"set new(background) [lindex $args 0]\n"
"} else {\n"
"array set new $args\n"
"}\n"
"if {![info exists new(background)]} {\n"
"error \"must specify a background color\"\n"
"}\n"
"if {![info exists new(foreground)]} {\n"
"set new(foreground) black\n"
"}\n"
"set bg [winfo rgb . $new(background)]\n"
"set fg [winfo rgb . $new(foreground)]\n"
"set darkerBg [format #%02x%02x%02x [expr {(9*[lindex $bg 0])/2560}] \\\n"
"[expr {(9*[lindex $bg 1])/2560}] [expr {(9*[lindex $bg 2])/2560}]]\n"
"foreach i {activeForeground insertBackground selectForeground \\\n"
"highlightColor} {\n"
"if {![info exists new($i)]} {\n"
"set new($i) $new(foreground)\n"
"}\n"
"}\n"
"if {![info exists new(disabledForeground)]} {\n"
"set new(disabledForeground) [format #%02x%02x%02x \\\n"
"[expr {(3*[lindex $bg 0] + [lindex $fg 0])/1024}] \\\n"
"[expr {(3*[lindex $bg 1] + [lindex $fg 1])/1024}] \\\n"
"[expr {(3*[lindex $bg 2] + [lindex $fg 2])/1024}]]\n"
"}\n"
"if {![info exists new(highlightBackground)]} {\n"
"set new(highlightBackground) $new(background)\n"
"}\n"
"if {![info exists new(activeBackground)]} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"foreach i {0 1 2} {\n"
"set light($i) [expr {[lindex $bg $i]/256}]\n"
"set inc1 [expr {($light($i)*15)/100}]\n"
"set inc2 [expr {(255-$light($i))/3}]\n"
"if {$inc1 > $inc2} {\n"
"incr light($i) $inc1\n"
"} else {\n"
"incr light($i) $inc2\n"
"}\n"
"if {$light($i) > 255} {\n"
"set light($i) 255\n"
"}\n"
"}\n"
"set new(activeBackground) [format #%02x%02x%02x $light(0) \\\n"
"$light(1) $light(2)]\n"
"}\n"
"if {![info exists new(selectBackground)]} {\n"
"set new(selectBackground) $darkerBg\n"
"}\n"
"if {![info exists new(troughColor)]} {\n"
"set new(troughColor) $darkerBg\n"
"}\n"
"if {![info exists new(selectColor)]} {\n"
"set new(selectColor) #b03060\n"
"}\n"
"\n"
"\n"
"\n"
"toplevel .___tk_set_palette\n"
"wm withdraw .___tk_set_palette\n"
"foreach q {button canvas checkbutton entry frame label listbox menubutton menu message \\\n"
"radiobutton scale scrollbar text} {\n"
"$q .___tk_set_palette.$q\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"eval [tkRecolorTree . new]\n"
"\n"
"catch {destroy .___tk_set_palette}\n"
"\n"
"\n"
"\n"
"\n"
"foreach option [array names new] {\n"
"option add *$option $new($option) widgetDefault\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"array set tkPalette [array get new]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkRecolorTree {w colors} {\n"
"global tkPalette\n"
"upvar $colors c\n"
"set result {}\n"
"foreach dbOption [array names c] {\n"
"set option -[string tolower $dbOption]\n"
"if {![catch {$w config $option} value]} {\n"
"\n"
"\n"
"\n"
"set defaultcolor [option get $w $dbOption widgetDefault]\n"
"if {[string match {} $defaultcolor]} {\n"
"set defaultcolor [winfo rgb . [lindex $value 3]]\n"
"} else {\n"
"set defaultcolor [winfo rgb . $defaultcolor]\n"
"}\n"
"set chosencolor [winfo rgb . [lindex $value 4]]\n"
"if {[string match $defaultcolor $chosencolor]} {\n"
"\n"
"\n"
"append result \";\\noption add [list \\\n"
"*[winfo class $w].$dbOption $c($dbOption) 60]\"\n"
"$w configure $option $c($dbOption)\n"
"}\n"
"}\n"
"}\n"
"foreach child [winfo children $w] {\n"
"append result \";\\n[tkRecolorTree $child c]\"\n"
"}\n"
"return $result\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkDarken {color percent} {\n"
"set l [winfo rgb . $color]\n"
"set red [expr {[lindex $l 0]/256}]\n"
"set green [expr {[lindex $l 1]/256}]\n"
"set blue [expr {[lindex $l 2]/256}]\n"
"set red [expr {($red*$percent)/100}]\n"
"if {$red > 255} {\n"
"set red 255\n"
"}\n"
"set green [expr {($green*$percent)/100}]\n"
"if {$green > 255} {\n"
"set green 255\n"
"}\n"
"set blue [expr {($blue*$percent)/100}]\n"
"if {$blue > 255} {\n"
"set blue 255\n"
"}\n"
"format #%02x%02x%02x $red $green $blue\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_bisque {} {\n"
"tk_setPalette activeBackground #e6ceb1 activeForeground black \\\n"
"background #ffe4c4 disabledForeground #b0b0b0 foreground black \\\n"
"highlightBackground #ffe4c4 highlightColor black \\\n"
"insertBackground black selectColor #b03060 \\\n"
"selectBackground #e6ceb1 selectForeground black \\\n"
"troughColor #cdb79e\n"
"}\n"
"";
#line 700 "et80.c"
Et_EvalInclude("palette.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc parray {a {pattern *}} {\n"
"upvar 1 $a array\n"
"if {![array exists array]} {\n"
"error \"\\\"$a\\\" isn't an array\"\n"
"}\n"
"set maxl 0\n"
"foreach name [lsort [array names array $pattern]] {\n"
"if {[string length $name] > $maxl} {\n"
"set maxl [string length $name]\n"
"}\n"
"}\n"
"set maxl [expr {$maxl + [string length $a] + 2}]\n"
"foreach name [lsort [array names array $pattern]] {\n"
"set nameString [format %s(%s) $a $name]\n"
"puts stdout [format \"%-*s = %s\" $maxl $nameString $array($name)]\n"
"}\n"
"}\n"
"";
#line 701 "et80.c"
Et_EvalInclude("parray.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"bind Scale <Enter> {\n"
"if {$tk_strictMotif} {\n"
"set tkPriv(activeBg) [%W cget -activebackground]\n"
"%W config -activebackground [%W cget -background]\n"
"}\n"
"tkScaleActivate %W %x %y\n"
"}\n"
"bind Scale <Motion> {\n"
"tkScaleActivate %W %x %y\n"
"}\n"
"bind Scale <Leave> {\n"
"if {$tk_strictMotif} {\n"
"%W config -activebackground $tkPriv(activeBg)\n"
"}\n"
"if {[%W cget -state] == \"active\"} {\n"
"%W configure -state normal\n"
"}\n"
"}\n"
"bind Scale <1> {\n"
"tkScaleButtonDown %W %x %y\n"
"}\n"
"bind Scale <B1-Motion> {\n"
"tkScaleDrag %W %x %y\n"
"}\n"
"bind Scale <B1-Leave> { }\n"
"bind Scale <B1-Enter> { }\n"
"bind Scale <ButtonRelease-1> {\n"
"tkCancelRepeat\n"
"tkScaleEndDrag %W\n"
"tkScaleActivate %W %x %y\n"
"}\n"
"bind Scale <2> {\n"
"tkScaleButton2Down %W %x %y\n"
"}\n"
"bind Scale <B2-Motion> {\n"
"tkScaleDrag %W %x %y\n"
"}\n"
"bind Scale <B2-Leave> { }\n"
"bind Scale <B2-Enter> { }\n"
"bind Scale <ButtonRelease-2> {\n"
"tkCancelRepeat\n"
"tkScaleEndDrag %W\n"
"tkScaleActivate %W %x %y\n"
"}\n"
"bind Scale <Control-1> {\n"
"tkScaleControlPress %W %x %y\n"
"}\n"
"bind Scale <Up> {\n"
"tkScaleIncrement %W up little noRepeat\n"
"}\n"
"bind Scale <Down> {\n"
"tkScaleIncrement %W down little noRepeat\n"
"}\n"
"bind Scale <Left> {\n"
"tkScaleIncrement %W up little noRepeat\n"
"}\n"
"bind Scale <Right> {\n"
"tkScaleIncrement %W down little noRepeat\n"
"}\n"
"bind Scale <Control-Up> {\n"
"tkScaleIncrement %W up big noRepeat\n"
"}\n"
"bind Scale <Control-Down> {\n"
"tkScaleIncrement %W down big noRepeat\n"
"}\n"
"bind Scale <Control-Left> {\n"
"tkScaleIncrement %W up big noRepeat\n"
"}\n"
"bind Scale <Control-Right> {\n"
"tkScaleIncrement %W down big noRepeat\n"
"}\n"
"bind Scale <Home> {\n"
"%W set [%W cget -from]\n"
"}\n"
"bind Scale <End> {\n"
"%W set [%W cget -to]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleActivate {w x y} {\n"
"global tkPriv\n"
"if {[$w cget -state] == \"disabled\"} {\n"
"return;\n"
"}\n"
"if {[$w identify $x $y] == \"slider\"} {\n"
"$w configure -state active\n"
"} else {\n"
"$w configure -state normal\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleButtonDown {w x y} {\n"
"global tkPriv\n"
"set tkPriv(dragging) 0\n"
"set el [$w identify $x $y]\n"
"if {$el == \"trough1\"} {\n"
"tkScaleIncrement $w up little initial\n"
"} elseif {$el == \"trough2\"} {\n"
"tkScaleIncrement $w down little initial\n"
"} elseif {$el == \"slider\"} {\n"
"set tkPriv(dragging) 1\n"
"set tkPriv(initValue) [$w get]\n"
"set coords [$w coords]\n"
"set tkPriv(deltaX) [expr {$x - [lindex $coords 0]}]\n"
"set tkPriv(deltaY) [expr {$y - [lindex $coords 1]}]\n"
"$w configure -sliderrelief sunken\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleDrag {w x y} {\n"
"global tkPriv\n"
"if {!$tkPriv(dragging)} {\n"
"return\n"
"}\n"
"$w set [$w get [expr {$x - $tkPriv(deltaX)}] \\\n"
"[expr {$y - $tkPriv(deltaY)}]]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleEndDrag {w} {\n"
"global tkPriv\n"
"set tkPriv(dragging) 0\n"
"$w configure -sliderrelief raised\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleIncrement {w dir big repeat} {\n"
"global tkPriv\n"
"if {![winfo exists $w]} return\n"
"if {$big == \"big\"} {\n"
"set inc [$w cget -bigincrement]\n"
"if {$inc == 0} {\n"
"set inc [expr {abs([$w cget -to] - [$w cget -from])/10.0}]\n"
"}\n"
"if {$inc < [$w cget -resolution]} {\n"
"set inc [$w cget -resolution]\n"
"}\n"
"} else {\n"
"set inc [$w cget -resolution]\n"
"}\n"
"if {([$w cget -from] > [$w cget -to]) ^ ($dir == \"up\")} {\n"
"set inc [expr {-$inc}]\n"
"}\n"
"$w set [expr {[$w get] + $inc}]\n"
"\n"
"if {$repeat == \"again\"} {\n"
"set tkPriv(afterId) [after [$w cget -repeatinterval] \\\n"
"tkScaleIncrement $w $dir $big again]\n"
"} elseif {$repeat == \"initial\"} {\n"
"set delay [$w cget -repeatdelay]\n"
"if {$delay > 0} {\n"
"set tkPriv(afterId) [after $delay \\\n"
"tkScaleIncrement $w $dir $big again]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleControlPress {w x y} {\n"
"set el [$w identify $x $y]\n"
"if {$el == \"trough1\"} {\n"
"$w set [$w cget -from]\n"
"} elseif {$el == \"trough2\"} {\n"
"$w set [$w cget -to]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScaleButton2Down {w x y} {\n"
"global tkPriv\n"
"\n"
"if {[$w cget -state] == \"disabled\"} {\n"
"return;\n"
"}\n"
"$w configure -state active\n"
"$w set [$w get $x $y]\n"
"set tkPriv(dragging) 1\n"
"set tkPriv(initValue) [$w get]\n"
"set coords \"$x $y\"\n"
"set tkPriv(deltaX) 0\n"
"set tkPriv(deltaY) 0\n"
"}\n"
"";
#line 702 "et80.c"
Et_EvalInclude("scale.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"if {($tcl_platform(platform) != \"windows\") &&\n"
"($tcl_platform(platform) != \"macintosh\")} {\n"
"bind Scrollbar <Enter> {\n"
"if {$tk_strictMotif} {\n"
"set tkPriv(activeBg) [%W cget -activebackground]\n"
"%W config -activebackground [%W cget -background]\n"
"}\n"
"%W activate [%W identify %x %y]\n"
"}\n"
"bind Scrollbar <Motion> {\n"
"%W activate [%W identify %x %y]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Scrollbar <Leave> {\n"
"if {$tk_strictMotif && [info exists tkPriv(activeBg)]} {\n"
"%W config -activebackground $tkPriv(activeBg)\n"
"}\n"
"%W activate {}\n"
"}\n"
"bind Scrollbar <1> {\n"
"tkScrollButtonDown %W %x %y\n"
"}\n"
"bind Scrollbar <B1-Motion> {\n"
"tkScrollDrag %W %x %y\n"
"}\n"
"bind Scrollbar <B1-B2-Motion> {\n"
"tkScrollDrag %W %x %y\n"
"}\n"
"bind Scrollbar <ButtonRelease-1> {\n"
"tkScrollButtonUp %W %x %y\n"
"}\n"
"bind Scrollbar <B1-Leave> {\n"
"\n"
"}\n"
"bind Scrollbar <B1-Enter> {\n"
"\n"
"}\n"
"bind Scrollbar <2> {\n"
"tkScrollButton2Down %W %x %y\n"
"}\n"
"bind Scrollbar <B1-2> {\n"
"\n"
"}\n"
"bind Scrollbar <B2-1> {\n"
"\n"
"}\n"
"bind Scrollbar <B2-Motion> {\n"
"tkScrollDrag %W %x %y\n"
"}\n"
"bind Scrollbar <ButtonRelease-2> {\n"
"tkScrollButtonUp %W %x %y\n"
"}\n"
"bind Scrollbar <B1-ButtonRelease-2> {\n"
"\n"
"}\n"
"bind Scrollbar <B2-ButtonRelease-1> {\n"
"\n"
"}\n"
"bind Scrollbar <B2-Leave> {\n"
"\n"
"}\n"
"bind Scrollbar <B2-Enter> {\n"
"\n"
"}\n"
"bind Scrollbar <Control-1> {\n"
"tkScrollTopBottom %W %x %y\n"
"}\n"
"bind Scrollbar <Control-2> {\n"
"tkScrollTopBottom %W %x %y\n"
"}\n"
"\n"
"bind Scrollbar <Up> {\n"
"tkScrollByUnits %W v -1\n"
"}\n"
"bind Scrollbar <Down> {\n"
"tkScrollByUnits %W v 1\n"
"}\n"
"bind Scrollbar <Control-Up> {\n"
"tkScrollByPages %W v -1\n"
"}\n"
"bind Scrollbar <Control-Down> {\n"
"tkScrollByPages %W v 1\n"
"}\n"
"bind Scrollbar <Left> {\n"
"tkScrollByUnits %W h -1\n"
"}\n"
"bind Scrollbar <Right> {\n"
"tkScrollByUnits %W h 1\n"
"}\n"
"bind Scrollbar <Control-Left> {\n"
"tkScrollByPages %W h -1\n"
"}\n"
"bind Scrollbar <Control-Right> {\n"
"tkScrollByPages %W h 1\n"
"}\n"
"bind Scrollbar <Prior> {\n"
"tkScrollByPages %W hv -1\n"
"}\n"
"bind Scrollbar <Next> {\n"
"tkScrollByPages %W hv 1\n"
"}\n"
"bind Scrollbar <Home> {\n"
"tkScrollToPos %W 0\n"
"}\n"
"bind Scrollbar <End> {\n"
"tkScrollToPos %W 1\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollButtonDown {w x y} {\n"
"global tkPriv\n"
"set tkPriv(relief) [$w cget -activerelief]\n"
"$w configure -activerelief sunken\n"
"set element [$w identify $x $y]\n"
"if {$element == \"slider\"} {\n"
"tkScrollStartDrag $w $x $y\n"
"} else {\n"
"tkScrollSelect $w $element initial\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollButtonUp {w x y} {\n"
"global tkPriv\n"
"tkCancelRepeat\n"
"$w configure -activerelief $tkPriv(relief)\n"
"tkScrollEndDrag $w $x $y\n"
"$w activate [$w identify $x $y]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollSelect {w element repeat} {\n"
"global tkPriv\n"
"if {![winfo exists $w]} return\n"
"if {$element == \"arrow1\"} {\n"
"tkScrollByUnits $w hv -1\n"
"} elseif {$element == \"trough1\"} {\n"
"tkScrollByPages $w hv -1\n"
"} elseif {$element == \"trough2\"} {\n"
"tkScrollByPages $w hv 1\n"
"} elseif {$element == \"arrow2\"} {\n"
"tkScrollByUnits $w hv 1\n"
"} else {\n"
"return\n"
"}\n"
"if {$repeat == \"again\"} {\n"
"set tkPriv(afterId) [after [$w cget -repeatinterval] \\\n"
"tkScrollSelect $w $element again]\n"
"} elseif {$repeat == \"initial\"} {\n"
"set delay [$w cget -repeatdelay]\n"
"if {$delay > 0} {\n"
"set tkPriv(afterId) [after $delay tkScrollSelect $w $element again]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollStartDrag {w x y} {\n"
"global tkPriv\n"
"\n"
"if {[$w cget -command] == \"\"} {\n"
"return\n"
"}\n"
"set tkPriv(pressX) $x\n"
"set tkPriv(pressY) $y\n"
"set tkPriv(initValues) [$w get]\n"
"set iv0 [lindex $tkPriv(initValues) 0]\n"
"if {[llength $tkPriv(initValues)] == 2} {\n"
"set tkPriv(initPos) $iv0\n"
"} else {\n"
"if {$iv0 == 0} {\n"
"set tkPriv(initPos) 0.0\n"
"} else {\n"
"set tkPriv(initPos) [expr {(double([lindex $tkPriv(initValues) 2])) \\\n"
"/ [lindex $tkPriv(initValues) 0]}]\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollDrag {w x y} {\n"
"global tkPriv\n"
"\n"
"if {$tkPriv(initPos) == \"\"} {\n"
"return\n"
"}\n"
"set delta [$w delta [expr {$x - $tkPriv(pressX)}] [expr {$y - $tkPriv(pressY)}]]\n"
"if {[$w cget -jump]} {\n"
"if {[llength $tkPriv(initValues)] == 2} {\n"
"$w set [expr {[lindex $tkPriv(initValues) 0] + $delta}] \\\n"
"[expr {[lindex $tkPriv(initValues) 1] + $delta}]\n"
"} else {\n"
"set delta [expr {round($delta * [lindex $tkPriv(initValues) 0])}]\n"
"eval $w set [lreplace $tkPriv(initValues) 2 3 \\\n"
"[expr {[lindex $tkPriv(initValues) 2] + $delta}] \\\n"
"[expr {[lindex $tkPriv(initValues) 3] + $delta}]]\n"
"}\n"
"} else {\n"
"tkScrollToPos $w [expr {$tkPriv(initPos) + $delta}]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollEndDrag {w x y} {\n"
"global tkPriv\n"
"\n"
"if {$tkPriv(initPos) == \"\"} {\n"
"return\n"
"}\n"
"if {[$w cget -jump]} {\n"
"set delta [$w delta [expr {$x - $tkPriv(pressX)}] \\\n"
"[expr {$y - $tkPriv(pressY)}]]\n"
"tkScrollToPos $w [expr {$tkPriv(initPos) + $delta}]\n"
"}\n"
"set tkPriv(initPos) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollByUnits {w orient amount} {\n"
"set cmd [$w cget -command]\n"
"if {($cmd == \"\") || ([string first \\\n"
"[string index [$w cget -orient] 0] $orient] < 0)} {\n"
"return\n"
"}\n"
"set info [$w get]\n"
"if {[llength $info] == 2} {\n"
"uplevel #0 $cmd scroll $amount units\n"
"} else {\n"
"uplevel #0 $cmd [expr {[lindex $info 2] + $amount}]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollByPages {w orient amount} {\n"
"set cmd [$w cget -command]\n"
"if {($cmd == \"\") || ([string first \\\n"
"[string index [$w cget -orient] 0] $orient] < 0)} {\n"
"return\n"
"}\n"
"set info [$w get]\n"
"if {[llength $info] == 2} {\n"
"uplevel #0 $cmd scroll $amount pages\n"
"} else {\n"
"uplevel #0 $cmd [expr {[lindex $info 2] + $amount*([lindex $info 1] - 1)}]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollToPos {w pos} {\n"
"set cmd [$w cget -command]\n"
"if {($cmd == \"\")} {\n"
"return\n"
"}\n"
"set info [$w get]\n"
"if {[llength $info] == 2} {\n"
"uplevel #0 $cmd moveto $pos\n"
"} else {\n"
"uplevel #0 $cmd [expr {round([lindex $info 0]*$pos)}]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollTopBottom {w x y} {\n"
"global tkPriv\n"
"set element [$w identify $x $y]\n"
"if {[string match *1 $element]} {\n"
"tkScrollToPos $w 0\n"
"} elseif {[string match *2 $element]} {\n"
"tkScrollToPos $w 1\n"
"}\n"
"\n"
"\n"
"\n"
"set tkPriv(relief) [$w cget -activerelief]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkScrollButton2Down {w x y} {\n"
"global tkPriv\n"
"set element [$w identify $x $y]\n"
"if {($element == \"arrow1\") || ($element == \"arrow2\")} {\n"
"tkScrollButtonDown $w $x $y\n"
"return\n"
"}\n"
"tkScrollToPos $w [$w fraction $x $y]\n"
"set tkPriv(relief) [$w cget -activerelief]\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"update idletasks\n"
"$w configure -activerelief sunken\n"
"$w activate slider\n"
"tkScrollStartDrag $w $x $y\n"
"}\n"
"";
#line 703 "et80.c"
Et_EvalInclude("scrlbar.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTearOffMenu {w {x 0} {y 0}} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {$x == 0} {\n"
"set x [winfo rootx $w]\n"
"}\n"
"if {$y == 0} {\n"
"set y [winfo rooty $w]\n"
"}\n"
"\n"
"set parent [winfo parent $w]\n"
"while {([winfo toplevel $parent] != $parent)\n"
"|| ([winfo class $parent] == \"Menu\")} {\n"
"set parent [winfo parent $parent]\n"
"}\n"
"if {$parent == \".\"} {\n"
"set parent \"\"\n"
"}\n"
"for {set i 1} 1 {incr i} {\n"
"set menu $parent.tearoff$i\n"
"if {![winfo exists $menu]} {\n"
"break\n"
"}\n"
"}\n"
"\n"
"$w clone $menu tearoff\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set parent [winfo parent $w]\n"
"if {[$menu cget -title] != \"\"} {\n"
"wm title $menu [$menu cget -title]\n"
"} else {\n"
"switch [winfo class $parent] {\n"
"Menubutton {\n"
"wm title $menu [$parent cget -text]\n"
"}\n"
"Menu {\n"
"wm title $menu [$parent entrycget active -label]\n"
"}\n"
"}\n"
"}\n"
"\n"
"$menu post $x $y\n"
"\n"
"if {[winfo exists $menu] == 0} {\n"
"return \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind $menu <Enter> {\n"
"set tkPriv(focus) %W\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"set cmd [$w cget -tearoffcommand]\n"
"if {$cmd != \"\"} {\n"
"uplevel #0 $cmd $w $menu\n"
"}\n"
"return $menu\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMenuDup {src dst type} {\n"
"set cmd [list menu $dst -type $type]\n"
"foreach option [$src configure] {\n"
"if {[llength $option] == 2} {\n"
"continue\n"
"}\n"
"if {[string compare [lindex $option 0] \"-type\"] == 0} {\n"
"continue\n"
"}\n"
"lappend cmd [lindex $option 0] [lindex $option 4]\n"
"}\n"
"eval $cmd\n"
"set last [$src index last]\n"
"if {$last == \"none\"} {\n"
"return\n"
"}\n"
"for {set i [$src cget -tearoff]} {$i <= $last} {incr i} {\n"
"set cmd [list $dst add [$src type $i]]\n"
"foreach option [$src entryconfigure $i]  {\n"
"lappend cmd [lindex $option 0] [lindex $option 4]\n"
"}\n"
"eval $cmd\n"
"}\n"
"\n"
"\n"
"\n"
"regsub -all . $src {\\\\&} quotedSrc\n"
"regsub -all . $dst {\\\\&} quotedDst\n"
"regsub -all $quotedSrc [bindtags $src] $dst x\n"
"bindtags $dst $x\n"
"foreach event [bind $src] {\n"
"regsub -all $quotedSrc [bind $src $event] $dst x\n"
"bind $dst $event $x\n"
"}\n"
"}\n"
"";
#line 704 "et80.c"
Et_EvalInclude("tearoff.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"bind Text <1> {\n"
"tkTextButton1 %W %x %y\n"
"%W tag remove sel 0.0 end\n"
"}\n"
"bind Text <B1-Motion> {\n"
"set tkPriv(x) %x\n"
"set tkPriv(y) %y\n"
"tkTextSelectTo %W %x %y\n"
"}\n"
"bind Text <Double-1> {\n"
"set tkPriv(selectMode) word\n"
"tkTextSelectTo %W %x %y\n"
"catch {%W mark set insert sel.first}\n"
"}\n"
"bind Text <Triple-1> {\n"
"set tkPriv(selectMode) line\n"
"tkTextSelectTo %W %x %y\n"
"catch {%W mark set insert sel.first}\n"
"}\n"
"bind Text <Shift-1> {\n"
"tkTextResetAnchor %W @%x,%y\n"
"set tkPriv(selectMode) char\n"
"tkTextSelectTo %W %x %y\n"
"}\n"
"bind Text <Double-Shift-1> {\n"
"set tkPriv(selectMode) word\n"
"tkTextSelectTo %W %x %y\n"
"}\n"
"bind Text <Triple-Shift-1> {\n"
"set tkPriv(selectMode) line\n"
"tkTextSelectTo %W %x %y\n"
"}\n"
"bind Text <B1-Leave> {\n"
"set tkPriv(x) %x\n"
"set tkPriv(y) %y\n"
"tkTextAutoScan %W\n"
"}\n"
"bind Text <B1-Enter> {\n"
"tkCancelRepeat\n"
"}\n"
"bind Text <ButtonRelease-1> {\n"
"tkCancelRepeat\n"
"}\n"
"bind Text <Control-1> {\n"
"%W mark set insert @%x,%y\n"
"}\n"
"bind Text <Left> {\n"
"tkTextSetCursor %W insert-1c\n"
"}\n"
"bind Text <Right> {\n"
"tkTextSetCursor %W insert+1c\n"
"}\n"
"bind Text <Up> {\n"
"tkTextSetCursor %W [tkTextUpDownLine %W -1]\n"
"}\n"
"bind Text <Down> {\n"
"tkTextSetCursor %W [tkTextUpDownLine %W 1]\n"
"}\n"
"bind Text <Shift-Left> {\n"
"tkTextKeySelect %W [%W index {insert - 1c}]\n"
"}\n"
"bind Text <Shift-Right> {\n"
"tkTextKeySelect %W [%W index {insert + 1c}]\n"
"}\n"
"bind Text <Shift-Up> {\n"
"tkTextKeySelect %W [tkTextUpDownLine %W -1]\n"
"}\n"
"bind Text <Shift-Down> {\n"
"tkTextKeySelect %W [tkTextUpDownLine %W 1]\n"
"}\n"
"bind Text <Control-Left> {\n"
"tkTextSetCursor %W [tkTextPrevPos %W insert tcl_startOfPreviousWord]\n"
"}\n"
"bind Text <Control-Right> {\n"
"tkTextSetCursor %W [tkTextNextWord %W insert]\n"
"}\n"
"bind Text <Control-Up> {\n"
"tkTextSetCursor %W [tkTextPrevPara %W insert]\n"
"}\n"
"bind Text <Control-Down> {\n"
"tkTextSetCursor %W [tkTextNextPara %W insert]\n"
"}\n"
"bind Text <Shift-Control-Left> {\n"
"tkTextKeySelect %W [tkTextPrevPos %W insert tcl_startOfPreviousWord]\n"
"}\n"
"bind Text <Shift-Control-Right> {\n"
"tkTextKeySelect %W [tkTextNextWord %W insert]\n"
"}\n"
"bind Text <Shift-Control-Up> {\n"
"tkTextKeySelect %W [tkTextPrevPara %W insert]\n"
"}\n"
"bind Text <Shift-Control-Down> {\n"
"tkTextKeySelect %W [tkTextNextPara %W insert]\n"
"}\n"
"bind Text <Prior> {\n"
"tkTextSetCursor %W [tkTextScrollPages %W -1]\n"
"}\n"
"bind Text <Shift-Prior> {\n"
"tkTextKeySelect %W [tkTextScrollPages %W -1]\n"
"}\n"
"bind Text <Next> {\n"
"tkTextSetCursor %W [tkTextScrollPages %W 1]\n"
"}\n"
"bind Text <Shift-Next> {\n"
"tkTextKeySelect %W [tkTextScrollPages %W 1]\n"
"}\n"
"bind Text <Control-Prior> {\n"
"%W xview scroll -1 page\n"
"}\n"
"bind Text <Control-Next> {\n"
"%W xview scroll 1 page\n"
"}\n"
"\n"
"bind Text <Home> {\n"
"tkTextSetCursor %W {insert linestart}\n"
"}\n"
"bind Text <Shift-Home> {\n"
"tkTextKeySelect %W {insert linestart}\n"
"}\n"
"bind Text <End> {\n"
"tkTextSetCursor %W {insert lineend}\n"
"}\n"
"bind Text <Shift-End> {\n"
"tkTextKeySelect %W {insert lineend}\n"
"}\n"
"bind Text <Control-Home> {\n"
"tkTextSetCursor %W 1.0\n"
"}\n"
"bind Text <Control-Shift-Home> {\n"
"tkTextKeySelect %W 1.0\n"
"}\n"
"bind Text <Control-End> {\n"
"tkTextSetCursor %W {end - 1 char}\n"
"}\n"
"bind Text <Control-Shift-End> {\n"
"tkTextKeySelect %W {end - 1 char}\n"
"}\n"
"\n"
"bind Text <Tab> {\n"
"tkTextInsert %W \\t\n"
"focus %W\n"
"break\n"
"}\n"
"bind Text <Shift-Tab> {\n"
"\n"
"\n"
"break\n"
"}\n"
"bind Text <Control-Tab> {\n"
"focus [tk_focusNext %W]\n"
"}\n"
"bind Text <Control-Shift-Tab> {\n"
"focus [tk_focusPrev %W]\n"
"}\n"
"bind Text <Control-i> {\n"
"tkTextInsert %W \\t\n"
"}\n"
"bind Text <Return> {\n"
"tkTextInsert %W \\n\n"
"}\n"
"bind Text <Delete> {\n"
"if {[%W tag nextrange sel 1.0 end] != \"\"} {\n"
"%W delete sel.first sel.last\n"
"} else {\n"
"%W delete insert\n"
"%W see insert\n"
"}\n"
"}\n"
"bind Text <BackSpace> {\n"
"if {[%W tag nextrange sel 1.0 end] != \"\"} {\n"
"%W delete sel.first sel.last\n"
"} elseif {[%W compare insert != 1.0]} {\n"
"%W delete insert-1c\n"
"%W see insert\n"
"}\n"
"}\n"
"\n"
"bind Text <Control-space> {\n"
"%W mark set anchor insert\n"
"}\n"
"bind Text <Select> {\n"
"%W mark set anchor insert\n"
"}\n"
"bind Text <Control-Shift-space> {\n"
"set tkPriv(selectMode) char\n"
"tkTextKeyExtend %W insert\n"
"}\n"
"bind Text <Shift-Select> {\n"
"set tkPriv(selectMode) char\n"
"tkTextKeyExtend %W insert\n"
"}\n"
"bind Text <Control-slash> {\n"
"%W tag add sel 1.0 end\n"
"}\n"
"bind Text <Control-backslash> {\n"
"%W tag remove sel 1.0 end\n"
"}\n"
"bind Text <<Cut>> {\n"
"tk_textCut %W\n"
"}\n"
"bind Text <<Copy>> {\n"
"tk_textCopy %W\n"
"}\n"
"bind Text <<Paste>> {\n"
"tk_textPaste %W\n"
"}\n"
"bind Text <<Clear>> {\n"
"catch {%W delete sel.first sel.last}\n"
"}\n"
"bind Text <<PasteSelection>> {\n"
"if {!$tkPriv(mouseMoved) || $tk_strictMotif} {\n"
"tkTextPaste %W %x %y\n"
"}\n"
"}\n"
"bind Text <Insert> {\n"
"catch {tkTextInsert %W [selection get -displayof %W]}\n"
"}\n"
"bind Text <KeyPress> {\n"
"tkTextInsert %W %A\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Text <Alt-KeyPress> {# nothing }\n"
"bind Text <Meta-KeyPress> {# nothing}\n"
"bind Text <Control-KeyPress> {# nothing}\n"
"bind Text <Escape> {# nothing}\n"
"bind Text <KP_Enter> {# nothing}\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"bind Text <Command-KeyPress> {# nothing}\n"
"}\n"
"\n"
"\n"
"\n"
"bind Text <Control-a> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W {insert linestart}\n"
"}\n"
"}\n"
"bind Text <Control-b> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W insert-1c\n"
"}\n"
"}\n"
"bind Text <Control-d> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete insert\n"
"}\n"
"}\n"
"bind Text <Control-e> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W {insert lineend}\n"
"}\n"
"}\n"
"bind Text <Control-f> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W insert+1c\n"
"}\n"
"}\n"
"bind Text <Control-k> {\n"
"if {!$tk_strictMotif} {\n"
"if {[%W compare insert == {insert lineend}]} {\n"
"%W delete insert\n"
"} else {\n"
"%W delete insert {insert lineend}\n"
"}\n"
"}\n"
"}\n"
"bind Text <Control-n> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W [tkTextUpDownLine %W 1]\n"
"}\n"
"}\n"
"bind Text <Control-o> {\n"
"if {!$tk_strictMotif} {\n"
"%W insert insert \\n\n"
"%W mark set insert insert-1c\n"
"}\n"
"}\n"
"bind Text <Control-p> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W [tkTextUpDownLine %W -1]\n"
"}\n"
"}\n"
"bind Text <Control-t> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextTranspose %W\n"
"}\n"
"}\n"
"\n"
"if {$tcl_platform(platform) != \"windows\"} {\n"
"bind Text <Control-v> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextScrollPages %W 1\n"
"}\n"
"}\n"
"}\n"
"\n"
"bind Text <Meta-b> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W [tkTextPrevPos %W insert tcl_startOfPreviousWord]\n"
"}\n"
"}\n"
"bind Text <Meta-d> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete insert [tkTextNextWord %W insert]\n"
"}\n"
"}\n"
"bind Text <Meta-f> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W [tkTextNextWord %W insert]\n"
"}\n"
"}\n"
"bind Text <Meta-less> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W 1.0\n"
"}\n"
"}\n"
"bind Text <Meta-greater> {\n"
"if {!$tk_strictMotif} {\n"
"tkTextSetCursor %W end-1c\n"
"}\n"
"}\n"
"bind Text <Meta-BackSpace> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete [tkTextPrevPos %W insert tcl_startOfPreviousWord] insert\n"
"}\n"
"}\n"
"bind Text <Meta-Delete> {\n"
"if {!$tk_strictMotif} {\n"
"%W delete [tkTextPrevPos %W insert tcl_startOfPreviousWord] insert\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"macintosh\"} {\n"
"bind Text <FocusIn> {\n"
"%W tag configure sel -borderwidth 0\n"
"%W configure -selectbackground systemHighlight -selectforeground systemHighlightText\n"
"}\n"
"bind Text <FocusOut> {\n"
"%W tag configure sel -borderwidth 1\n"
"%W configure -selectbackground white -selectforeground black\n"
"}\n"
"bind Text <Option-Left> {\n"
"tkTextSetCursor %W [tkTextPrevPos %W insert tcl_startOfPreviousWord]\n"
"}\n"
"bind Text <Option-Right> {\n"
"tkTextSetCursor %W [tkTextNextWord %W insert]\n"
"}\n"
"bind Text <Option-Up> {\n"
"tkTextSetCursor %W [tkTextPrevPara %W insert]\n"
"}\n"
"bind Text <Option-Down> {\n"
"tkTextSetCursor %W [tkTextNextPara %W insert]\n"
"}\n"
"bind Text <Shift-Option-Left> {\n"
"tkTextKeySelect %W [tkTextPrevPos %W insert tcl_startOfPreviousWord]\n"
"}\n"
"bind Text <Shift-Option-Right> {\n"
"tkTextKeySelect %W [tkTextNextWord %W insert]\n"
"}\n"
"bind Text <Shift-Option-Up> {\n"
"tkTextKeySelect %W [tkTextPrevPara %W insert]\n"
"}\n"
"bind Text <Shift-Option-Down> {\n"
"tkTextKeySelect %W [tkTextNextPara %W insert]\n"
"}\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"bind Text <Control-h> {\n"
"if {!$tk_strictMotif} {\n"
"if {[%W compare insert != 1.0]} {\n"
"%W delete insert-1c\n"
"%W see insert\n"
"}\n"
"}\n"
"}\n"
"bind Text <2> {\n"
"if {!$tk_strictMotif} {\n"
"%W scan mark %x %y\n"
"set tkPriv(x) %x\n"
"set tkPriv(y) %y\n"
"set tkPriv(mouseMoved) 0\n"
"}\n"
"}\n"
"bind Text <B2-Motion> {\n"
"if {!$tk_strictMotif} {\n"
"if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {\n"
"set tkPriv(mouseMoved) 1\n"
"}\n"
"if {$tkPriv(mouseMoved)} {\n"
"%W scan dragto %x %y\n"
"}\n"
"}\n"
"}\n"
"set tkPriv(prevPos) {}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"bind Text <MouseWheel> {\n"
"%W yview scroll [expr - (%D / 120) * 4] units\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextClosestGap {w x y} {\n"
"set pos [$w index @$x,$y]\n"
"set bbox [$w bbox $pos]\n"
"if {![string compare $bbox \"\"]} {\n"
"return $pos\n"
"}\n"
"if {($x - [lindex $bbox 0]) < ([lindex $bbox 2]/2)} {\n"
"return $pos\n"
"}\n"
"$w index \"$pos + 1 char\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextButton1 {w x y} {\n"
"global tkPriv\n"
"\n"
"set tkPriv(selectMode) char\n"
"set tkPriv(mouseMoved) 0\n"
"set tkPriv(pressX) $x\n"
"$w mark set insert [tkTextClosestGap $w $x $y]\n"
"$w mark set anchor insert\n"
"if {[$w cget -state] == \"normal\"} {focus $w}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextSelectTo {w x y} {\n"
"global tkPriv tcl_platform\n"
"\n"
"set cur [tkTextClosestGap $w $x $y]\n"
"if {[catch {$w index anchor}]} {\n"
"$w mark set anchor $cur\n"
"}\n"
"set anchor [$w index anchor]\n"
"if {[$w compare $cur != $anchor] || (abs($tkPriv(pressX) - $x) >= 3)} {\n"
"set tkPriv(mouseMoved) 1\n"
"}\n"
"switch $tkPriv(selectMode) {\n"
"char {\n"
"if {[$w compare $cur < anchor]} {\n"
"set first $cur\n"
"set last anchor\n"
"} else {\n"
"set first anchor\n"
"set last $cur\n"
"}\n"
"}\n"
"word {\n"
"if {[$w compare $cur < anchor]} {\n"
"set first [tkTextPrevPos $w \"$cur + 1c\" tcl_wordBreakBefore]\n"
"set last [tkTextNextPos $w \"anchor\" tcl_wordBreakAfter]\n"
"} else {\n"
"set first [tkTextPrevPos $w anchor tcl_wordBreakBefore]\n"
"set last [tkTextNextPos $w \"$cur - 1c\" tcl_wordBreakAfter]\n"
"}\n"
"}\n"
"line {\n"
"if {[$w compare $cur < anchor]} {\n"
"set first [$w index \"$cur linestart\"]\n"
"set last [$w index \"anchor - 1c lineend + 1c\"]\n"
"} else {\n"
"set first [$w index \"anchor linestart\"]\n"
"set last [$w index \"$cur lineend + 1c\"]\n"
"}\n"
"}\n"
"}\n"
"if {$tkPriv(mouseMoved) || ($tkPriv(selectMode) != \"char\")} {\n"
"if {$tcl_platform(platform) != \"unix\" && [$w compare $cur < anchor]} {\n"
"$w mark set insert $first\n"
"} else {\n"
"$w mark set insert $last\n"
"}\n"
"$w tag remove sel 0.0 $first\n"
"$w tag add sel $first $last\n"
"$w tag remove sel $last end\n"
"update idletasks\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextKeyExtend {w index} {\n"
"global tkPriv\n"
"\n"
"set cur [$w index $index]\n"
"if {[catch {$w index anchor}]} {\n"
"$w mark set anchor $cur\n"
"}\n"
"set anchor [$w index anchor]\n"
"if {[$w compare $cur < anchor]} {\n"
"set first $cur\n"
"set last anchor\n"
"} else {\n"
"set first anchor\n"
"set last $cur\n"
"}\n"
"$w tag remove sel 0.0 $first\n"
"$w tag add sel $first $last\n"
"$w tag remove sel $last end\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextPaste {w x y} {\n"
"$w mark set insert [tkTextClosestGap $w $x $y]\n"
"catch {$w insert insert [selection get -displayof $w]}\n"
"if {[$w cget -state] == \"normal\"} {focus $w}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextAutoScan {w} {\n"
"global tkPriv\n"
"if {![winfo exists $w]} return\n"
"if {$tkPriv(y) >= [winfo height $w]} {\n"
"$w yview scroll 2 units\n"
"} elseif {$tkPriv(y) < 0} {\n"
"$w yview scroll -2 units\n"
"} elseif {$tkPriv(x) >= [winfo width $w]} {\n"
"$w xview scroll 2 units\n"
"} elseif {$tkPriv(x) < 0} {\n"
"$w xview scroll -2 units\n"
"} else {\n"
"return\n"
"}\n"
"tkTextSelectTo $w $tkPriv(x) $tkPriv(y)\n"
"set tkPriv(afterId) [after 50 tkTextAutoScan $w]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextSetCursor {w pos} {\n"
"global tkPriv\n"
"\n"
"if {[$w compare $pos == end]} {\n"
"set pos {end - 1 chars}\n"
"}\n"
"$w mark set insert $pos\n"
"$w tag remove sel 1.0 end\n"
"$w see insert\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextKeySelect {w new} {\n"
"global tkPriv\n"
"\n"
"if {[$w tag nextrange sel 1.0 end] == \"\"} {\n"
"if {[$w compare $new < insert]} {\n"
"$w tag add sel $new insert\n"
"} else {\n"
"$w tag add sel insert $new\n"
"}\n"
"$w mark set anchor insert\n"
"} else {\n"
"if {[$w compare $new < anchor]} {\n"
"set first $new\n"
"set last anchor\n"
"} else {\n"
"set first anchor\n"
"set last $new\n"
"}\n"
"$w tag remove sel 1.0 $first\n"
"$w tag add sel $first $last\n"
"$w tag remove sel $last end\n"
"}\n"
"$w mark set insert $new\n"
"$w see insert\n"
"update idletasks\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextResetAnchor {w index} {\n"
"global tkPriv\n"
"\n"
"if {[$w tag ranges sel] == \"\"} {\n"
"$w mark set anchor $index\n"
"return\n"
"}\n"
"set a [$w index $index]\n"
"set b [$w index sel.first]\n"
"set c [$w index sel.last]\n"
"if {[$w compare $a < $b]} {\n"
"$w mark set anchor sel.last\n"
"return\n"
"}\n"
"if {[$w compare $a > $c]} {\n"
"$w mark set anchor sel.first\n"
"return\n"
"}\n"
"scan $a \"%d.%d\" lineA chA\n"
"scan $b \"%d.%d\" lineB chB\n"
"scan $c \"%d.%d\" lineC chC\n"
"if {$lineB < $lineC+2} {\n"
"set total [string length [$w get $b $c]]\n"
"if {$total <= 2} {\n"
"return\n"
"}\n"
"if {[string length [$w get $b $a]] < ($total/2)} {\n"
"$w mark set anchor sel.last\n"
"} else {\n"
"$w mark set anchor sel.first\n"
"}\n"
"return\n"
"}\n"
"if {($lineA-$lineB) < ($lineC-$lineA)} {\n"
"$w mark set anchor sel.last\n"
"} else {\n"
"$w mark set anchor sel.first\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextInsert {w s} {\n"
"if {($s == \"\") || ([$w cget -state] == \"disabled\")} {\n"
"return\n"
"}\n"
"catch {\n"
"if {[$w compare sel.first <= insert]\n"
"&& [$w compare sel.last >= insert]} {\n"
"$w delete sel.first sel.last\n"
"}\n"
"}\n"
"$w insert insert $s\n"
"$w see insert\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextUpDownLine {w n} {\n"
"global tkPriv\n"
"\n"
"set i [$w index insert]\n"
"scan $i \"%d.%d\" line char\n"
"if {[string compare $tkPriv(prevPos) $i] != 0} {\n"
"set tkPriv(char) $char\n"
"}\n"
"set new [$w index [expr {$line + $n}].$tkPriv(char)]\n"
"if {[$w compare $new == end] || [$w compare $new == \"insert linestart\"]} {\n"
"set new $i\n"
"}\n"
"set tkPriv(prevPos) $new\n"
"return $new\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextPrevPara {w pos} {\n"
"set pos [$w index \"$pos linestart\"]\n"
"while 1 {\n"
"if {(([$w get \"$pos - 1 line\"] == \"\\n\") && ([$w get $pos] != \"\\n\"))\n"
"|| ($pos == \"1.0\")} {\n"
"if {[regexp -indices {^[  ]+(.)} [$w get $pos \"$pos lineend\"] \\\n"
"dummy index]} {\n"
"set pos [$w index \"$pos + [lindex $index 0] chars\"]\n"
"}\n"
"if {[$w compare $pos != insert] || ($pos == \"1.0\")} {\n"
"return $pos\n"
"}\n"
"}\n"
"set pos [$w index \"$pos - 1 line\"]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextNextPara {w start} {\n"
"set pos [$w index \"$start linestart + 1 line\"]\n"
"while {[$w get $pos] != \"\\n\"} {\n"
"if {[$w compare $pos == end]} {\n"
"return [$w index \"end - 1c\"]\n"
"}\n"
"set pos [$w index \"$pos + 1 line\"]\n"
"}\n"
"while {[$w get $pos] == \"\\n\"} {\n"
"set pos [$w index \"$pos + 1 line\"]\n"
"if {[$w compare $pos == end]} {\n"
"return [$w index \"end - 1c\"]\n"
"}\n"
"}\n"
"if {[regexp -indices {^[  ]+(.)} [$w get $pos \"$pos lineend\"] \\\n"
"dummy index]} {\n"
"return [$w index \"$pos + [lindex $index 0] chars\"]\n"
"}\n"
"return $pos\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextScrollPages {w count} {\n"
"set bbox [$w bbox insert]\n"
"$w yview scroll $count pages\n"
"if {$bbox == \"\"} {\n"
"return [$w index @[expr {[winfo height $w]/2}],0]\n"
"}\n"
"return [$w index @[lindex $bbox 0],[lindex $bbox 1]]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextTranspose w {\n"
"set pos insert\n"
"if {[$w compare $pos != \"$pos lineend\"]} {\n"
"set pos [$w index \"$pos + 1 char\"]\n"
"}\n"
"set new [$w get \"$pos - 1 char\"][$w get  \"$pos - 2 char\"]\n"
"if {[$w compare \"$pos - 1 char\" == 1.0]} {\n"
"return\n"
"}\n"
"$w delete \"$pos - 2 char\" $pos\n"
"$w insert insert $new\n"
"$w see insert\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_textCopy w {\n"
"if {![catch {set data [$w get sel.first sel.last]}]} {\n"
"clipboard clear -displayof $w\n"
"clipboard append -displayof $w $data\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_textCut w {\n"
"if {![catch {set data [$w get sel.first sel.last]}]} {\n"
"clipboard clear -displayof $w\n"
"clipboard append -displayof $w $data\n"
"$w delete sel.first sel.last\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tk_textPaste w {\n"
"global tcl_platform\n"
"catch {\n"
"if {\"$tcl_platform(platform)\" != \"unix\"} {\n"
"catch {\n"
"$w delete sel.first sel.last\n"
"}\n"
"}\n"
"$w insert insert [selection get -displayof $w -selection CLIPBOARD]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"windows\"}  {\n"
"proc tkTextNextWord {w start} {\n"
"tkTextNextPos $w [tkTextNextPos $w $start tcl_endOfWord] \\\n"
"tcl_startOfNextWord\n"
"}\n"
"} else {\n"
"proc tkTextNextWord {w start} {\n"
"tkTextNextPos $w $start tcl_endOfWord\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextNextPos {w start op} {\n"
"set text \"\"\n"
"set cur $start\n"
"while {[$w compare $cur < end]} {\n"
"set text \"$text[$w get $cur \"$cur lineend + 1c\"]\"\n"
"set pos [$op $text 0]\n"
"if {$pos >= 0} {\n"
"return [$w index \"$start + $pos c\"]\n"
"}\n"
"set cur [$w index \"$cur lineend +1c\"]\n"
"}\n"
"return end\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkTextPrevPos {w start op} {\n"
"set text \"\"\n"
"set cur $start\n"
"while {[$w compare $cur > 0.0]} {\n"
"set text \"[$w get \"$cur linestart - 1c\" $cur]$text\"\n"
"set pos [$op $text end]\n"
"if {$pos >= 0} {\n"
"return [$w index \"$cur linestart - 1c + $pos c\"]\n"
"}\n"
"set cur [$w index \"$cur linestart - 1c\"]\n"
"}\n"
"return 0.0\n"
"}\n"
"\n"
"";
#line 705 "et80.c"
Et_EvalInclude("text.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList {w args} {\n"
"upvar #0 $w data\n"
"\n"
"tkIconList_Config $w $args\n"
"tkIconList_Create $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_Config {w argList} {\n"
"upvar #0 $w data\n"
"\n"
"\n"
"\n"
"set specs {\n"
"{-browsecmd \"\" \"\" \"\"}\n"
"{-command \"\" \"\" \"\"}\n"
"}\n"
"\n"
"\n"
"\n"
"tclParseConfigSpec $w $specs \"\" $argList\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_Create {w} {\n"
"upvar #0 $w data\n"
"\n"
"frame $w\n"
"set data(sbar)   [scrollbar $w.sbar -orient horizontal \\\n"
"-highlightthickness 0 -takefocus 0]\n"
"set data(canvas) [canvas $w.canvas -bd 2 -relief sunken \\\n"
"-width 400 -height 120 -takefocus 1]\n"
"pack $data(sbar) -side bottom -fill x -padx 2\n"
"pack $data(canvas) -expand yes -fill both\n"
"\n"
"$data(sbar) config -command \"$data(canvas) xview\"\n"
"$data(canvas) config -xscrollcommand \"$data(sbar) set\"\n"
"\n"
"\n"
"\n"
"set data(maxIW) 1\n"
"set data(maxIH) 1\n"
"set data(maxTW) 1\n"
"set data(maxTH) 1\n"
"set data(numItems) 0\n"
"set data(curItem)  {}\n"
"set data(noScroll) 1\n"
"\n"
"\n"
"\n"
"bind $data(canvas) <Configure> \"tkIconList_Arrange $w\"\n"
"\n"
"bind $data(canvas) <1>         \"tkIconList_Btn1 $w %x %y\"\n"
"bind $data(canvas) <B1-Motion> \"tkIconList_Motion1 $w %x %y\"\n"
"bind $data(canvas) <Double-1>  \"tkIconList_Double1 $w %x %y\"\n"
"bind $data(canvas) <ButtonRelease-1> \"tkCancelRepeat\"\n"
"bind $data(canvas) <B1-Leave>  \"tkIconList_Leave1 $w %x %y\"\n"
"bind $data(canvas) <B1-Enter>  \"tkCancelRepeat\"\n"
"\n"
"bind $data(canvas) <Up>        \"tkIconList_UpDown $w -1\"\n"
"bind $data(canvas) <Down>      \"tkIconList_UpDown $w  1\"\n"
"bind $data(canvas) <Left>      \"tkIconList_LeftRight $w -1\"\n"
"bind $data(canvas) <Right>     \"tkIconList_LeftRight $w  1\"\n"
"bind $data(canvas) <Return>    \"tkIconList_ReturnKey $w\"\n"
"bind $data(canvas) <KeyPress>  \"tkIconList_KeyPress $w %A\"\n"
"bind $data(canvas) <Control-KeyPress> \";\"\n"
"bind $data(canvas) <Alt-KeyPress>  \";\"\n"
"\n"
"bind $data(canvas) <FocusIn>   \"tkIconList_FocusIn $w\"\n"
"\n"
"return $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_AutoScan {w} {\n"
"upvar #0 $w data\n"
"global tkPriv\n"
"\n"
"if {![winfo exists $w]} return\n"
"set x $tkPriv(x)\n"
"set y $tkPriv(y)\n"
"\n"
"if {$data(noScroll)} {\n"
"return\n"
"}\n"
"if {$x >= [winfo width $data(canvas)]} {\n"
"$data(canvas) xview scroll 1 units\n"
"} elseif {$x < 0} {\n"
"$data(canvas) xview scroll -1 units\n"
"} elseif {$y >= [winfo height $data(canvas)]} {\n"
"\n"
"} elseif {$y < 0} {\n"
"\n"
"} else {\n"
"return\n"
"}\n"
"\n"
"tkIconList_Motion1 $w $x $y\n"
"set tkPriv(afterId) [after 50 tkIconList_AutoScan $w]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_DeleteAll {w} {\n"
"upvar #0 $w data\n"
"upvar #0 $w:itemList itemList\n"
"\n"
"$data(canvas) delete all\n"
"catch {unset data(selected)}\n"
"catch {unset data(rect)}\n"
"catch {unset data(list)}\n"
"catch {unset itemList}\n"
"set data(maxIW) 1\n"
"set data(maxIH) 1\n"
"set data(maxTW) 1\n"
"set data(maxTH) 1\n"
"set data(numItems) 0\n"
"set data(curItem)  {}\n"
"set data(noScroll) 1\n"
"$data(sbar) set 0.0 1.0\n"
"$data(canvas) xview moveto 0\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkIconList_Add {w image text} {\n"
"upvar #0 $w data\n"
"upvar #0 $w:itemList itemList\n"
"upvar #0 $w:textList textList\n"
"\n"
"set iTag [$data(canvas) create image 0 0 -image $image -anchor nw]\n"
"set tTag [$data(canvas) create text  0 0 -text  $text  -anchor nw \\\n"
"-font $data(font)]\n"
"set rTag [$data(canvas) create rect  0 0 0 0 -fill \"\" -outline \"\"]\n"
"\n"
"set b [$data(canvas) bbox $iTag]\n"
"set iW [expr {[lindex $b 2]-[lindex $b 0]}]\n"
"set iH [expr {[lindex $b 3]-[lindex $b 1]}]\n"
"if {$data(maxIW) < $iW} {\n"
"set data(maxIW) $iW\n"
"}\n"
"if {$data(maxIH) < $iH} {\n"
"set data(maxIH) $iH\n"
"}\n"
"\n"
"set b [$data(canvas) bbox $tTag]\n"
"set tW [expr {[lindex $b 2]-[lindex $b 0]}]\n"
"set tH [expr {[lindex $b 3]-[lindex $b 1]}]\n"
"if {$data(maxTW) < $tW} {\n"
"set data(maxTW) $tW\n"
"}\n"
"if {$data(maxTH) < $tH} {\n"
"set data(maxTH) $tH\n"
"}\n"
"\n"
"lappend data(list) [list $iTag $tTag $rTag $iW $iH $tW $tH $data(numItems)]\n"
"set itemList($rTag) [list $iTag $tTag $text $data(numItems)]\n"
"set textList($data(numItems)) [string tolower $text]\n"
"incr data(numItems)\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkIconList_Arrange {w} {\n"
"upvar #0 $w data\n"
"\n"
"if {![info exists data(list)]} {\n"
"if {[info exists data(canvas)] && [winfo exists $data(canvas)]} {\n"
"set data(noScroll) 1\n"
"$data(sbar) config -command \"\"\n"
"}\n"
"return\n"
"}\n"
"\n"
"set W [winfo width  $data(canvas)]\n"
"set H [winfo height $data(canvas)]\n"
"set pad [expr {[$data(canvas) cget -highlightthickness] + \\\n"
"[$data(canvas) cget -bd]}]\n"
"if {$pad < 2} {\n"
"set pad 2\n"
"}\n"
"\n"
"incr W -[expr {$pad*2}]\n"
"incr H -[expr {$pad*2}]\n"
"\n"
"set dx [expr {$data(maxIW) + $data(maxTW) + 8}]\n"
"if {$data(maxTH) > $data(maxIH)} {\n"
"set dy $data(maxTH)\n"
"} else {\n"
"set dy $data(maxIH)\n"
"}\n"
"incr dy 2\n"
"set shift [expr {$data(maxIW) + 4}]\n"
"\n"
"set x [expr {$pad * 2}]\n"
"set y [expr {$pad * 1}] ; # Why * 1 ?\n"
"set usedColumn 0\n"
"foreach sublist $data(list) {\n"
"set usedColumn 1\n"
"set iTag [lindex $sublist 0]\n"
"set tTag [lindex $sublist 1]\n"
"set rTag [lindex $sublist 2]\n"
"set iW   [lindex $sublist 3]\n"
"set iH   [lindex $sublist 4]\n"
"set tW   [lindex $sublist 5]\n"
"set tH   [lindex $sublist 6]\n"
"\n"
"set i_dy [expr {($dy - $iH)/2}]\n"
"set t_dy [expr {($dy - $tH)/2}]\n"
"\n"
"$data(canvas) coords $iTag $x                    [expr {$y + $i_dy}]\n"
"$data(canvas) coords $tTag [expr {$x + $shift}]  [expr {$y + $t_dy}]\n"
"$data(canvas) coords $tTag [expr {$x + $shift}]  [expr {$y + $t_dy}]\n"
"$data(canvas) coords $rTag $x $y [expr {$x+$dx}] [expr {$y+$dy}]\n"
"\n"
"incr y $dy\n"
"if {($y + $dy) > $H} {\n"
"set y [expr {$pad * 1}] ; # *1 ?\n"
"incr x $dx\n"
"set usedColumn 0\n"
"}\n"
"}\n"
"\n"
"if {$usedColumn} {\n"
"set sW [expr {$x + $dx}]\n"
"} else {\n"
"set sW $x\n"
"}\n"
"\n"
"if {$sW < $W} {\n"
"$data(canvas) config -scrollregion \"$pad $pad $sW $H\"\n"
"$data(sbar) config -command \"\"\n"
"$data(canvas) xview moveto 0\n"
"set data(noScroll) 1\n"
"} else {\n"
"$data(canvas) config -scrollregion \"$pad $pad $sW $H\"\n"
"$data(sbar) config -command \"$data(canvas) xview\"\n"
"set data(noScroll) 0\n"
"}\n"
"\n"
"set data(itemsPerColumn) [expr {($H-$pad)/$dy}]\n"
"if {$data(itemsPerColumn) < 1} {\n"
"set data(itemsPerColumn) 1\n"
"}\n"
"\n"
"if {$data(curItem) != {}} {\n"
"tkIconList_Select $w [lindex [lindex $data(list) $data(curItem)] 2] 0\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_Invoke {w} {\n"
"upvar #0 $w data\n"
"\n"
"if {[string compare $data(-command) \"\"] && [info exists data(selected)]} {\n"
"eval $data(-command)\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_See {w rTag} {\n"
"upvar #0 $w data\n"
"upvar #0 $w:itemList itemList\n"
"\n"
"if {$data(noScroll)} {\n"
"return\n"
"}\n"
"set sRegion [$data(canvas) cget -scrollregion]\n"
"if {![string compare $sRegion {}]} {\n"
"return\n"
"}\n"
"\n"
"if {![info exists itemList($rTag)]} {\n"
"return\n"
"}\n"
"\n"
"\n"
"set bbox [$data(canvas) bbox $rTag]\n"
"set pad [expr {[$data(canvas) cget -highlightthickness] + \\\n"
"[$data(canvas) cget -bd]}]\n"
"\n"
"set x1 [lindex $bbox 0]\n"
"set x2 [lindex $bbox 2]\n"
"incr x1 -[expr {$pad * 2}]\n"
"incr x2 -[expr {$pad * 1}] ; # *1 ?\n"
"\n"
"set cW [expr {[winfo width $data(canvas)] - $pad*2}]\n"
"\n"
"set scrollW [expr {[lindex $sRegion 2]-[lindex $sRegion 0]+1}]\n"
"set dispX [expr {int([lindex [$data(canvas) xview] 0]*$scrollW)}]\n"
"set oldDispX $dispX\n"
"\n"
"\n"
"\n"
"if {($x2 - $dispX) >= $cW} {\n"
"set dispX [expr {$x2 - $cW}]\n"
"}\n"
"\n"
"\n"
"if {($x1 - $dispX) < 0} {\n"
"set dispX $x1\n"
"}\n"
"\n"
"if {$oldDispX != $dispX} {\n"
"set fraction [expr {double($dispX)/double($scrollW)}]\n"
"$data(canvas) xview moveto $fraction\n"
"}\n"
"}\n"
"\n"
"proc tkIconList_SelectAtXY {w x y} {\n"
"upvar #0 $w data\n"
"\n"
"tkIconList_Select $w [$data(canvas) find closest \\\n"
"[$data(canvas) canvasx $x] [$data(canvas) canvasy $y]]\n"
"}\n"
"\n"
"proc tkIconList_Select {w rTag {callBrowse 1}} {\n"
"upvar #0 $w data\n"
"upvar #0 $w:itemList itemList\n"
"\n"
"if {![info exists itemList($rTag)]} {\n"
"return\n"
"}\n"
"set iTag   [lindex $itemList($rTag) 0]\n"
"set tTag   [lindex $itemList($rTag) 1]\n"
"set text   [lindex $itemList($rTag) 2]\n"
"set serial [lindex $itemList($rTag) 3]\n"
"\n"
"if {![info exists data(rect)]} {\n"
"set data(rect) [$data(canvas) create rect 0 0 0 0 \\\n"
"-fill #a0a0ff -outline #a0a0ff]\n"
"}\n"
"$data(canvas) lower $data(rect)\n"
"set bbox [$data(canvas) bbox $tTag]\n"
"eval $data(canvas) coords $data(rect) $bbox\n"
"\n"
"set data(curItem) $serial\n"
"set data(selected) $text\n"
"\n"
"if {$callBrowse} {\n"
"if {[string compare $data(-browsecmd) \"\"]} {\n"
"eval $data(-browsecmd) [list $text]\n"
"}\n"
"}\n"
"}\n"
"\n"
"proc tkIconList_Unselect {w} {\n"
"upvar #0 $w data\n"
"\n"
"if {[info exists data(rect)]} {\n"
"$data(canvas) delete $data(rect)\n"
"unset data(rect)\n"
"}\n"
"if {[info exists data(selected)]} {\n"
"unset data(selected)\n"
"}\n"
"set data(curItem)  {}\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkIconList_Get {w} {\n"
"upvar #0 $w data\n"
"\n"
"if {[info exists data(selected)]} {\n"
"return $data(selected)\n"
"} else {\n"
"return \"\"\n"
"}\n"
"}\n"
"\n"
"\n"
"proc tkIconList_Btn1 {w x y} {\n"
"upvar #0 $w data\n"
"\n"
"focus $data(canvas)\n"
"tkIconList_SelectAtXY $w $x $y\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkIconList_Motion1 {w x y} {\n"
"global tkPriv\n"
"set tkPriv(x) $x\n"
"set tkPriv(y) $y\n"
"\n"
"tkIconList_SelectAtXY $w $x $y\n"
"}\n"
"\n"
"proc tkIconList_Double1 {w x y} {\n"
"upvar #0 $w data\n"
"\n"
"if {$data(curItem) != {}} {\n"
"tkIconList_Invoke $w\n"
"}\n"
"}\n"
"\n"
"proc tkIconList_ReturnKey {w} {\n"
"tkIconList_Invoke $w\n"
"}\n"
"\n"
"proc tkIconList_Leave1 {w x y} {\n"
"global tkPriv\n"
"\n"
"set tkPriv(x) $x\n"
"set tkPriv(y) $y\n"
"tkIconList_AutoScan $w\n"
"}\n"
"\n"
"proc tkIconList_FocusIn {w} {\n"
"upvar #0 $w data\n"
"\n"
"if {![info exists data(list)]} {\n"
"return\n"
"}\n"
"\n"
"if {$data(curItem) == {}} {\n"
"set rTag [lindex [lindex $data(list) 0] 2]\n"
"tkIconList_Select $w $rTag\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_UpDown {w amount} {\n"
"upvar #0 $w data\n"
"\n"
"if {![info exists data(list)]} {\n"
"return\n"
"}\n"
"\n"
"if {$data(curItem) == {}} {\n"
"set rTag [lindex [lindex $data(list) 0] 2]\n"
"} else {\n"
"set oldRTag [lindex [lindex $data(list) $data(curItem)] 2]\n"
"set rTag [lindex [lindex $data(list) [expr {$data(curItem)+$amount}]] 2]\n"
"if {![string compare $rTag \"\"]} {\n"
"set rTag $oldRTag\n"
"}\n"
"}\n"
"\n"
"if {[string compare $rTag \"\"]} {\n"
"tkIconList_Select $w $rTag\n"
"tkIconList_See $w $rTag\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_LeftRight {w amount} {\n"
"upvar #0 $w data\n"
"\n"
"if {![info exists data(list)]} {\n"
"return\n"
"}\n"
"if {$data(curItem) == {}} {\n"
"set rTag [lindex [lindex $data(list) 0] 2]\n"
"} else {\n"
"set oldRTag [lindex [lindex $data(list) $data(curItem)] 2]\n"
"set newItem [expr {$data(curItem)+($amount*$data(itemsPerColumn))}]\n"
"set rTag [lindex [lindex $data(list) $newItem] 2]\n"
"if {![string compare $rTag \"\"]} {\n"
"set rTag $oldRTag\n"
"}\n"
"}\n"
"\n"
"if {[string compare $rTag \"\"]} {\n"
"tkIconList_Select $w $rTag\n"
"tkIconList_See $w $rTag\n"
"}\n"
"}\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkIconList_KeyPress {w key} {\n"
"global tkPriv\n"
"\n"
"append tkPriv(ILAccel,$w) $key\n"
"tkIconList_Goto $w $tkPriv(ILAccel,$w)\n"
"catch {\n"
"after cancel $tkPriv(ILAccel,$w,afterId)\n"
"}\n"
"set tkPriv(ILAccel,$w,afterId) [after 500 tkIconList_Reset $w]\n"
"}\n"
"\n"
"proc tkIconList_Goto {w text} {\n"
"upvar #0 $w data\n"
"upvar #0 $w:textList textList\n"
"global tkPriv\n"
"\n"
"if {![info exists data(list)]} {\n"
"return\n"
"}\n"
"\n"
"if {[string length $text] == 0} {\n"
"return\n"
"}\n"
"\n"
"if {$data(curItem) == {} || $data(curItem) == 0} {\n"
"set start  0\n"
"} else {\n"
"set start  $data(curItem)\n"
"}\n"
"\n"
"set text [string tolower $text]\n"
"set theIndex -1\n"
"set less 0\n"
"set len [string length $text]\n"
"set len0 [expr {$len-1}]\n"
"set i $start\n"
"\n"
"\n"
"\n"
"while 1 {\n"
"set sub [string range $textList($i) 0 $len0]\n"
"if {[string compare $text $sub] == 0} {\n"
"set theIndex $i\n"
"break\n"
"}\n"
"incr i\n"
"if {$i == $data(numItems)} {\n"
"set i 0\n"
"}\n"
"if {$i == $start} {\n"
"break\n"
"}\n"
"}\n"
"\n"
"if {$theIndex > -1} {\n"
"set rTag [lindex [lindex $data(list) $theIndex] 2]\n"
"tkIconList_Select $w $rTag 0\n"
"tkIconList_See $w $rTag\n"
"}\n"
"}\n"
"\n"
"proc tkIconList_Reset {w} {\n"
"global tkPriv\n"
"\n"
"catch {unset tkPriv(ILAccel,$w)}\n"
"}\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"#----------------------------------------------------------------------\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog {args} {\n"
"global tkPriv\n"
"set w __tk_filedialog\n"
"upvar #0 $w data\n"
"\n"
"if {![string compare [lindex [info level 0] 0] tk_getOpenFile]} {\n"
"set type open\n"
"} else {\n"
"set type save\n"
"}\n"
"\n"
"tkFDialog_Config $w $type $args\n"
"\n"
"if {![string compare $data(-parent) .]} {\n"
"set w .$w\n"
"} else {\n"
"set w $data(-parent).$w\n"
"}\n"
"\n"
"\n"
"\n"
"if {![winfo exists $w]} {\n"
"tkFDialog_Create $w\n"
"} elseif {[string compare [winfo class $w] TkFDialog]} {\n"
"destroy $w\n"
"tkFDialog_Create $w\n"
"} else {\n"
"set data(dirMenuBtn) $w.f1.menu\n"
"set data(dirMenu) $w.f1.menu.menu\n"
"set data(upBtn) $w.f1.up\n"
"set data(icons) $w.icons\n"
"set data(ent) $w.f2.ent\n"
"set data(typeMenuLab) $w.f3.lab\n"
"set data(typeMenuBtn) $w.f3.menu\n"
"set data(typeMenu) $data(typeMenuBtn).m\n"
"set data(okBtn) $w.f2.ok\n"
"set data(cancelBtn) $w.f3.cancel\n"
"}\n"
"wm transient $w $data(-parent)\n"
"\n"
"\n"
"\n"
"if {$data(-filetypes) != {}} {\n"
"$data(typeMenu) delete 0 end\n"
"foreach type $data(-filetypes) {\n"
"set title  [lindex $type 0]\n"
"set filter [lindex $type 1]\n"
"$data(typeMenu) add command -label $title \\\n"
"-command [list tkFDialog_SetFilter $w $type]\n"
"}\n"
"tkFDialog_SetFilter $w [lindex $data(-filetypes) 0]\n"
"$data(typeMenuBtn) config -state normal\n"
"$data(typeMenuLab) config -state normal\n"
"} else {\n"
"set data(filter) \"*\"\n"
"$data(typeMenuBtn) config -state disabled -takefocus 0\n"
"$data(typeMenuLab) config -state disabled\n"
"}\n"
"\n"
"tkFDialog_UpdateWhenIdle $w\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"wm withdraw $w\n"
"update idletasks\n"
"set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n"
"- [winfo vrootx [winfo parent $w]]}]\n"
"set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n"
"- [winfo vrooty [winfo parent $w]]}]\n"
"wm geom $w [winfo reqwidth $w]x[winfo reqheight $w]+$x+$y\n"
"wm deiconify $w\n"
"wm title $w $data(-title)\n"
"\n"
"\n"
"\n"
"set oldFocus [focus]\n"
"set oldGrab [grab current $w]\n"
"if {$oldGrab != \"\"} {\n"
"set grabStatus [grab status $oldGrab]\n"
"}\n"
"grab $w\n"
"focus $data(ent)\n"
"$data(ent) delete 0 end\n"
"$data(ent) insert 0 $data(selectFile)\n"
"$data(ent) select from 0\n"
"$data(ent) select to   end\n"
"$data(ent) icursor end\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tkwait variable tkPriv(selectFilePath)\n"
"catch {focus $oldFocus}\n"
"grab release $w\n"
"wm withdraw $w\n"
"if {$oldGrab != \"\"} {\n"
"if {$grabStatus == \"global\"} {\n"
"grab -global $oldGrab\n"
"} else {\n"
"grab $oldGrab\n"
"}\n"
"}\n"
"return $tkPriv(selectFilePath)\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_Config {w type argList} {\n"
"upvar #0 $w data\n"
"\n"
"set data(type) $type\n"
"\n"
"\n"
"\n"
"set specs {\n"
"{-defaultextension \"\" \"\" \"\"}\n"
"{-filetypes \"\" \"\" \"\"}\n"
"{-initialdir \"\" \"\" \"\"}\n"
"{-initialfile \"\" \"\" \"\"}\n"
"{-parent \"\" \"\" \".\"}\n"
"{-title \"\" \"\" \"\"}\n"
"}\n"
"\n"
"\n"
"\n"
"if {![info exists data(selectPath)]} {\n"
"\n"
"set data(selectPath) [pwd]\n"
"set data(selectFile) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"tclParseConfigSpec $w $specs \"\" $argList\n"
"\n"
"if {![string compare $data(-title) \"\"]} {\n"
"if {![string compare $type \"open\"]} {\n"
"set data(-title) \"Open\"\n"
"} else {\n"
"set data(-title) \"Save As\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {[string compare $data(-initialdir) \"\"]} {\n"
"\n"
"if {[file isdirectory $data(-initialdir)]} {\n"
"set data(selectPath) [glob $data(-initialdir)]\n"
"} else {\n"
"set data(selectPath) [pwd]\n"
"}\n"
"\n"
"\n"
"\n"
"set old [pwd]\n"
"cd $data(selectPath)\n"
"set data(selectPath) [pwd]\n"
"cd $old\n"
"}\n"
"set data(selectFile) $data(-initialfile)\n"
"\n"
"\n"
"\n"
"set data(-filetypes) [tkFDGetFileTypes $data(-filetypes)]\n"
"\n"
"if {![winfo exists $data(-parent)]} {\n"
"error \"bad window path name \\\"$data(-parent)\\\"\"\n"
"}\n"
"}\n"
"\n"
"proc tkFDialog_Create {w} {\n"
"set dataName [lindex [split $w .] end]\n"
"upvar #0 $dataName data\n"
"global tk_library\n"
"\n"
"toplevel $w -class TkFDialog\n"
"\n"
"\n"
"\n"
"set f1 [frame $w.f1]\n"
"label $f1.lab -text \"Directory:\" -under 0\n"
"set data(dirMenuBtn) $f1.menu\n"
"set data(dirMenu) [tk_optionMenu $f1.menu [format %s(selectPath) $dataName] \"\"]\n"
"set data(upBtn) [button $f1.up]\n"
"if {![info exists tkPriv(updirImage)]} {\n"
"set tkPriv(updirImage) [image create bitmap -data {\n"
"#define updir_width 28\n"
"#define updir_height 16\n"
"static char updir_bits[] = {\n"
"0x00, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00,\n"
"0x20, 0x40, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x01, 0x10, 0x00, 0x00, 0x01,\n"
"0x10, 0x02, 0x00, 0x01, 0x10, 0x07, 0x00, 0x01, 0x90, 0x0f, 0x00, 0x01,\n"
"0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01,\n"
"0x10, 0xfe, 0x07, 0x01, 0x10, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x01,\n"
"0xf0, 0xff, 0xff, 0x01};}]\n"
"}\n"
"$data(upBtn) config -image $tkPriv(updirImage)\n"
"\n"
"$f1.menu config -takefocus 1 -highlightthickness 2\n"
"\n"
"pack $data(upBtn) -side right -padx 4 -fill both\n"
"pack $f1.lab -side left -padx 4 -fill both\n"
"pack $f1.menu -expand yes -fill both -padx 4\n"
"\n"
"\n"
"\n"
"set data(icons) [tkIconList $w.icons \\\n"
"-browsecmd \"tkFDialog_ListBrowse $w\" \\\n"
"-command   \"tkFDialog_OkCmd $w\"]\n"
"\n"
"\n"
"\n"
"set f2 [frame $w.f2 -bd 0]\n"
"label $f2.lab -text \"File name:\" -anchor e -width 14 -under 5 -pady 0\n"
"set data(ent) [entry $f2.ent]\n"
"\n"
"\n"
"\n"
"global $w.icons\n"
"set $w.icons(font) [$data(ent) cget -font]\n"
"\n"
"\n"
"\n"
"set f3 [frame $w.f3 -bd 0]\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set data(typeMenuLab) [button $f3.lab -text \"Files of type:\" \\\n"
"-anchor e -width 14 -under 9 \\\n"
"-bd [$f2.lab cget -bd] \\\n"
"-highlightthickness [$f2.lab cget -highlightthickness] \\\n"
"-relief [$f2.lab cget -relief] \\\n"
"-padx [$f2.lab cget -padx] \\\n"
"-pady [$f2.lab cget -pady]]\n"
"bindtags $data(typeMenuLab) [list $data(typeMenuLab) Label \\\n"
"[winfo toplevel $data(typeMenuLab)] all]\n"
"\n"
"set data(typeMenuBtn) [menubutton $f3.menu -indicatoron 1 -menu $f3.menu.m]\n"
"set data(typeMenu) [menu $data(typeMenuBtn).m -tearoff 0]\n"
"$data(typeMenuBtn) config -takefocus 1 -highlightthickness 2 \\\n"
"-relief raised -bd 2 -anchor w\n"
"\n"
"\n"
"\n"
"set data(okBtn)     [button $f2.ok     -text OK     -under 0 -width 6 \\\n"
"-default active -pady 3]\n"
"set data(cancelBtn) [button $f3.cancel -text Cancel -under 0 -width 6\\\n"
"-default normal -pady 3]\n"
"\n"
"\n"
"\n"
"pack $data(okBtn) -side right -padx 4 -anchor e\n"
"pack $f2.lab -side left -padx 4\n"
"pack $f2.ent -expand yes -fill x -padx 2 -pady 0\n"
"\n"
"pack $data(cancelBtn) -side right -padx 4 -anchor w\n"
"pack $data(typeMenuLab) -side left -padx 4\n"
"pack $data(typeMenuBtn) -expand yes -fill x -side right\n"
"\n"
"\n"
"\n"
"pack $f1 -side top -fill x -pady 4\n"
"pack $f3 -side bottom -fill x\n"
"pack $f2 -side bottom -fill x\n"
"pack $data(icons) -expand yes -fill both -padx 4 -pady 1\n"
"\n"
"\n"
"\n"
"bind $data(ent) <Return>  \"tkFDialog_ActivateEnt $w\"\n"
"\n"
"$data(upBtn)     config -command \"tkFDialog_UpDirCmd $w\"\n"
"$data(okBtn)     config -command \"tkFDialog_OkCmd $w\"\n"
"$data(cancelBtn) config -command \"tkFDialog_CancelCmd $w\"\n"
"\n"
"trace variable data(selectPath) w \"tkFDialog_SetPath $w\"\n"
"\n"
"bind $w <Alt-d> \"focus $data(dirMenuBtn)\"\n"
"bind $w <Alt-t> [format {\n"
"if {\"[%s cget -state]\" == \"normal\"} {\n"
"focus %s\n"
"}\n"
"} $data(typeMenuBtn) $data(typeMenuBtn)]\n"
"bind $w <Alt-n> \"focus $data(ent)\"\n"
"bind $w <KeyPress-Escape> \"tkButtonInvoke $data(cancelBtn)\"\n"
"bind $w <Alt-c> \"tkButtonInvoke $data(cancelBtn)\"\n"
"bind $w <Alt-o> \"tkFDialog_InvokeBtn $w Open\"\n"
"bind $w <Alt-s> \"tkFDialog_InvokeBtn $w Save\"\n"
"\n"
"wm protocol $w WM_DELETE_WINDOW \"tkFDialog_CancelCmd $w\"\n"
"\n"
"\n"
"\n"
"tkFocusGroup_Create $w\n"
"tkFocusGroup_BindIn $w  $data(ent) \"tkFDialog_EntFocusIn $w\"\n"
"tkFocusGroup_BindOut $w $data(ent) \"tkFDialog_EntFocusOut $w\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_UpdateWhenIdle {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {[info exists data(updateId)]} {\n"
"return\n"
"} else {\n"
"set data(updateId) [after idle tkFDialog_Update $w]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_Update {w} {\n"
"\n"
"\n"
"\n"
"if {![winfo exists $w] || [string compare [winfo class $w] TkFDialog]} {\n"
"return\n"
"}\n"
"\n"
"set dataName [winfo name $w]\n"
"upvar #0 $dataName data\n"
"global tk_library tkPriv\n"
"catch {unset data(updateId)}\n"
"\n"
"if {![info exists tkPriv(folderImage)]} {\n"
"set tkPriv(folderImage) [image create photo -data {\n"
"R0lGODlhEAAMAKEAAAD//wAAAPD/gAAAACH5BAEAAAAALAAAAAAQAAwAAAIghINhyycvVFsB\n"
"QtmS3rjaH1Hg141WaT5ouprt2HHcUgAAOw==}]\n"
"set tkPriv(fileImage)   [image create photo -data {\n"
"R0lGODlhDAAMAKEAALLA3AAAAP//8wAAACH5BAEAAAAALAAAAAAMAAwAAAIgRI4Ha+IfWHsO\n"
"rSASvJTGhnhcV3EJlo3kh53ltF5nAhQAOw==}]\n"
"}\n"
"set folder $tkPriv(folderImage)\n"
"set file   $tkPriv(fileImage)\n"
"\n"
"set appPWD [pwd]\n"
"if {[catch {\n"
"cd $data(selectPath)\n"
"}]} {\n"
"\n"
"\n"
"\n"
"\n"
"tk_messageBox -type ok -parent $data(-parent) -message \\\n"
"\"Cannot change to the directory \\\"$data(selectPath)\\\".\\nPermission denied.\"\\\n"
"-icon warning\n"
"cd $appPWD\n"
"return\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"set entCursor [$data(ent) cget -cursor]\n"
"set dlgCursor [$w         cget -cursor]\n"
"$data(ent) config -cursor watch\n"
"$w         config -cursor watch\n"
"update idletasks\n"
"\n"
"tkIconList_DeleteAll $data(icons)\n"
"\n"
"\n"
"\n"
"foreach f [lsort -dictionary [glob -nocomplain .* *]] {\n"
"if {![string compare $f .]} {\n"
"continue\n"
"}\n"
"if {![string compare $f ..]} {\n"
"continue\n"
"}\n"
"if {[file isdir ./$f]} {\n"
"if {![info exists hasDoneDir($f)]} {\n"
"tkIconList_Add $data(icons) $folder $f\n"
"set hasDoneDir($f) 1\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"if {![string compare $data(filter) *]} {\n"
"set files [lsort -dictionary \\\n"
"[glob -nocomplain .* *]]\n"
"} else {\n"
"set files [lsort -dictionary \\\n"
"[eval glob -nocomplain $data(filter)]]\n"
"}\n"
"\n"
"set top 0\n"
"foreach f $files {\n"
"if {![file isdir ./$f]} {\n"
"if {![info exists hasDoneFile($f)]} {\n"
"tkIconList_Add $data(icons) $file $f\n"
"set hasDoneFile($f) 1\n"
"}\n"
"}\n"
"}\n"
"\n"
"tkIconList_Arrange $data(icons)\n"
"\n"
"\n"
"\n"
"set list \"\"\n"
"set dir \"\"\n"
"foreach subdir [file split $data(selectPath)] {\n"
"set dir [file join $dir $subdir]\n"
"lappend list $dir\n"
"}\n"
"\n"
"$data(dirMenu) delete 0 end\n"
"set var [format %s(selectPath) $dataName]\n"
"foreach path $list {\n"
"$data(dirMenu) add command -label $path -command [list set $var $path]\n"
"}\n"
"\n"
"\n"
"\n"
"cd $appPWD\n"
"\n"
"\n"
"\n"
"$data(ent) config -cursor $entCursor\n"
"$w         config -cursor $dlgCursor\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_SetPathSilently {w path} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"trace vdelete  data(selectPath) w \"tkFDialog_SetPath $w\"\n"
"set data(selectPath) $path\n"
"trace variable data(selectPath) w \"tkFDialog_SetPath $w\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_SetPath {w name1 name2 op} {\n"
"if {[winfo exists $w]} {\n"
"upvar #0 [winfo name $w] data\n"
"tkFDialog_UpdateWhenIdle $w\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkFDialog_SetFilter {w type} {\n"
"upvar #0 [winfo name $w] data\n"
"upvar \\#0 $data(icons) icons\n"
"\n"
"set data(filter) [lindex $type 1]\n"
"$data(typeMenuBtn) config -text [lindex $type 0] -indicatoron 1\n"
"\n"
"$icons(sbar) set 0.0 0.0\n"
"\n"
"tkFDialog_UpdateWhenIdle $w\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialogResolveFile {context text defaultext} {\n"
"\n"
"set appPWD [pwd]\n"
"\n"
"set path [tkFDialog_JoinFile $context $text]\n"
"\n"
"if {[file ext $path] == \"\"} {\n"
"set path \"$path$defaultext\"\n"
"}\n"
"\n"
"\n"
"if {[catch {file exists $path}]} {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"return [list ERROR $path \"\"]\n"
"}\n"
"\n"
"if {[file exists $path]} {\n"
"if {[file isdirectory $path]} {\n"
"if {[catch {\n"
"cd $path\n"
"}]} {\n"
"return [list CHDIR $path \"\"]\n"
"}\n"
"set directory [pwd]\n"
"set file \"\"\n"
"set flag OK\n"
"cd $appPWD\n"
"} else {\n"
"if {[catch {\n"
"cd [file dirname $path]\n"
"}]} {\n"
"return [list CHDIR [file dirname $path] \"\"]\n"
"}\n"
"set directory [pwd]\n"
"set file [file tail $path]\n"
"set flag OK\n"
"cd $appPWD\n"
"}\n"
"} else {\n"
"set dirname [file dirname $path]\n"
"if {[file exists $dirname]} {\n"
"if {[catch {\n"
"cd $dirname\n"
"}]} {\n"
"return [list CHDIR $dirname \"\"]\n"
"}\n"
"set directory [pwd]\n"
"set file [file tail $path]\n"
"if {[regexp {[*]|[?]} $file]} {\n"
"set flag PATTERN\n"
"} else {\n"
"set flag FILE\n"
"}\n"
"cd $appPWD\n"
"} else {\n"
"set directory $dirname\n"
"set file [file tail $path]\n"
"set flag PATH\n"
"}\n"
"}\n"
"\n"
"return [list $flag $directory $file]\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_EntFocusIn {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {[string compare [$data(ent) get] \"\"]} {\n"
"$data(ent) selection from 0\n"
"$data(ent) selection to   end\n"
"$data(ent) icursor end\n"
"} else {\n"
"$data(ent) selection clear\n"
"}\n"
"\n"
"tkIconList_Unselect $data(icons)\n"
"\n"
"if {![string compare $data(type) open]} {\n"
"$data(okBtn) config -text \"Open\"\n"
"} else {\n"
"$data(okBtn) config -text \"Save\"\n"
"}\n"
"}\n"
"\n"
"proc tkFDialog_EntFocusOut {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"$data(ent) selection clear\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_ActivateEnt {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"set text [string trim [$data(ent) get]]\n"
"set list [tkFDialogResolveFile $data(selectPath) $text \\\n"
"$data(-defaultextension)]\n"
"set flag [lindex $list 0]\n"
"set path [lindex $list 1]\n"
"set file [lindex $list 2]\n"
"\n"
"switch -- $flag {\n"
"OK {\n"
"if {![string compare $file \"\"]} {\n"
"\n"
"set data(selectPath) $path\n"
"$data(ent) delete 0 end\n"
"} else {\n"
"tkFDialog_SetPathSilently $w $path\n"
"set data(selectFile) $file\n"
"tkFDialog_Done $w\n"
"}\n"
"}\n"
"PATTERN {\n"
"set data(selectPath) $path\n"
"set data(filter) $file\n"
"}\n"
"FILE {\n"
"if {![string compare $data(type) open]} {\n"
"tk_messageBox -icon warning -type ok -parent $data(-parent) \\\n"
"-message \"File \\\"[file join $path $file]\\\" does not exist.\"\n"
"$data(ent) select from 0\n"
"$data(ent) select to   end\n"
"$data(ent) icursor end\n"
"} else {\n"
"tkFDialog_SetPathSilently $w $path\n"
"set data(selectFile) $file\n"
"tkFDialog_Done $w\n"
"}\n"
"}\n"
"PATH {\n"
"tk_messageBox -icon warning -type ok -parent $data(-parent) \\\n"
"-message \"Directory \\\"$path\\\" does not exist.\"\n"
"$data(ent) select from 0\n"
"$data(ent) select to   end\n"
"$data(ent) icursor end\n"
"}\n"
"CHDIR {\n"
"tk_messageBox -type ok -parent $data(-parent) -message \\\n"
"\"Cannot change to the directory \\\"$path\\\".\\nPermission denied.\"\\\n"
"-icon warning\n"
"$data(ent) select from 0\n"
"$data(ent) select to   end\n"
"$data(ent) icursor end\n"
"}\n"
"ERROR {\n"
"tk_messageBox -type ok -parent $data(-parent) -message \\\n"
"\"Invalid file name \\\"$path\\\".\"\\\n"
"-icon warning\n"
"$data(ent) select from 0\n"
"$data(ent) select to   end\n"
"$data(ent) icursor end\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkFDialog_InvokeBtn {w key} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {![string compare [$data(okBtn) cget -text] $key]} {\n"
"tkButtonInvoke $data(okBtn)\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkFDialog_UpDirCmd {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {[string compare $data(selectPath) \"/\"]} {\n"
"set data(selectPath) [file dirname $data(selectPath)]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_JoinFile {path file} {\n"
"if {[string match {~*} $file] && [file exists $path/$file]} {\n"
"return [file join $path ./$file]\n"
"} else {\n"
"return [file join $path $file]\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_OkCmd {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"set text [tkIconList_Get $data(icons)]\n"
"if {[string compare $text \"\"]} {\n"
"set file [tkFDialog_JoinFile $data(selectPath) $text]\n"
"if {[file isdirectory $file]} {\n"
"tkFDialog_ListInvoke $w $text\n"
"return\n"
"}\n"
"}\n"
"\n"
"tkFDialog_ActivateEnt $w\n"
"}\n"
"\n"
"\n"
"\n"
"proc tkFDialog_CancelCmd {w} {\n"
"upvar #0 [winfo name $w] data\n"
"global tkPriv\n"
"\n"
"set tkPriv(selectFilePath) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_ListBrowse {w text} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {$text == \"\"} {\n"
"return\n"
"}\n"
"\n"
"set file [tkFDialog_JoinFile $data(selectPath) $text]\n"
"if {![file isdirectory $file]} {\n"
"$data(ent) delete 0 end\n"
"$data(ent) insert 0 $text\n"
"\n"
"if {![string compare $data(type) open]} {\n"
"$data(okBtn) config -text \"Open\"\n"
"} else {\n"
"$data(okBtn) config -text \"Save\"\n"
"}\n"
"} else {\n"
"$data(okBtn) config -text \"Open\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_ListInvoke {w text} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {$text == \"\"} {\n"
"return\n"
"}\n"
"\n"
"set file [tkFDialog_JoinFile $data(selectPath) $text]\n"
"\n"
"if {[file isdirectory $file]} {\n"
"set appPWD [pwd]\n"
"if {[catch {cd $file}]} {\n"
"tk_messageBox -type ok -parent $data(-parent) -message \\\n"
"\"Cannot change to the directory \\\"$file\\\".\\nPermission denied.\"\\\n"
"-icon warning\n"
"} else {\n"
"cd $appPWD\n"
"set data(selectPath) $file\n"
"}\n"
"} else {\n"
"set data(selectFile) $file\n"
"tkFDialog_Done $w\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkFDialog_Done {w {selectFilePath \"\"}} {\n"
"upvar #0 [winfo name $w] data\n"
"global tkPriv\n"
"\n"
"if {![string compare $selectFilePath \"\"]} {\n"
"set selectFilePath [tkFDialog_JoinFile $data(selectPath) \\\n"
"$data(selectFile)]\n"
"set tkPriv(selectFile)     $data(selectFile)\n"
"set tkPriv(selectPath)     $data(selectPath)\n"
"\n"
"if {[file exists $selectFilePath] && \n"
"![string compare $data(type) save]} {\n"
"\n"
"set reply [tk_messageBox -icon warning -type yesno\\\n"
"-parent $data(-parent) -message \"File\\\n"
"\\\"$selectFilePath\\\" already exists.\\nDo\\\n"
"you want to overwrite it?\"]\n"
"if {![string compare $reply \"no\"]} {\n"
"return\n"
"}\n"
"}\n"
"}\n"
"set tkPriv(selectFilePath) $selectFilePath\n"
"}\n"
"\n"
"";
#line 706 "et80.c"
Et_EvalInclude("tkfbox.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMotifFDialog {args} {\n"
"global tkPriv\n"
"set w __tk_filedialog\n"
"upvar #0 $w data\n"
"\n"
"if {![string compare [lindex [info level 0] 0] tk_getOpenFile]} {\n"
"set type open\n"
"} else {\n"
"set type save\n"
"}\n"
"\n"
"tkMotifFDialog_Config $w $type $args\n"
"\n"
"if {![string compare $data(-parent) .]} {\n"
"set w .$w\n"
"} else {\n"
"set w $data(-parent).$w\n"
"}\n"
"\n"
"\n"
"\n"
"if {![winfo exists $w]} {\n"
"tkMotifFDialog_Create $w\n"
"} elseif {[string compare [winfo class $w] TkMotifFDialog]} {\n"
"destroy $w\n"
"tkMotifFDialog_Create $w\n"
"} else {\n"
"set data(fEnt) $w.top.f1.ent\n"
"set data(dList) $w.top.f2.a.l\n"
"set data(fList) $w.top.f2.b.l\n"
"set data(sEnt) $w.top.f3.ent\n"
"set data(okBtn) $w.bot.ok\n"
"set data(filterBtn) $w.bot.filter\n"
"set data(cancelBtn) $w.bot.cancel\n"
"}\n"
"wm transient $w $data(-parent)\n"
"\n"
"tkMotifFDialog_Update $w\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"wm withdraw $w\n"
"update idletasks\n"
"set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n"
"- [winfo vrootx [winfo parent $w]]}]\n"
"set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n"
"- [winfo vrooty [winfo parent $w]]}]\n"
"wm geom $w +$x+$y\n"
"wm deiconify $w\n"
"wm title $w $data(-title)\n"
"\n"
"\n"
"\n"
"set oldFocus [focus]\n"
"set oldGrab [grab current $w]\n"
"if {$oldGrab != \"\"} {\n"
"set grabStatus [grab status $oldGrab]\n"
"}\n"
"grab $w\n"
"focus $data(sEnt)\n"
"$data(sEnt) select from 0\n"
"$data(sEnt) select to   end\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tkwait variable tkPriv(selectFilePath)\n"
"catch {focus $oldFocus}\n"
"grab release $w\n"
"wm withdraw $w\n"
"if {$oldGrab != \"\"} {\n"
"if {$grabStatus == \"global\"} {\n"
"grab -global $oldGrab\n"
"} else {\n"
"grab $oldGrab\n"
"}\n"
"}\n"
"return $tkPriv(selectFilePath)\n"
"}\n"
"\n"
"proc tkMotifFDialog_Config {w type argList} {\n"
"upvar #0 $w data\n"
"\n"
"set data(type) $type\n"
"\n"
"\n"
"\n"
"set specs {\n"
"{-defaultextension \"\" \"\" \"\"}\n"
"{-filetypes \"\" \"\" \"\"}\n"
"{-initialdir \"\" \"\" \"\"}\n"
"{-initialfile \"\" \"\" \"\"}\n"
"{-parent \"\" \"\" \".\"}\n"
"{-title \"\" \"\" \"\"}\n"
"}\n"
"\n"
"\n"
"\n"
"if {![info exists data(selectPath)]} {\n"
"\n"
"set data(selectPath) [pwd]\n"
"set data(selectFile) \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"tclParseConfigSpec $w $specs \"\" $argList\n"
"\n"
"if {![string compare $data(-title) \"\"]} {\n"
"if {![string compare $type \"open\"]} {\n"
"set data(-title) \"Open\"\n"
"} else {\n"
"set data(-title) \"Save As\"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if {[string compare $data(-initialdir) \"\"]} {\n"
"if {[file isdirectory $data(-initialdir)]} {\n"
"set data(selectPath) [glob $data(-initialdir)]\n"
"} else {\n"
"set data(selectPath) [pwd]\n"
"}\n"
"\n"
"\n"
"\n"
"set old [pwd]\n"
"cd $data(selectPath)\n"
"set data(selectPath) [pwd]\n"
"cd $old\n"
"}\n"
"set data(selectFile) $data(-initialfile)\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set data(-filetypes) [tkFDGetFileTypes $data(-filetypes)]\n"
"\n"
"if {![info exists data(filter)]} {\n"
"set data(filter) *\n"
"}\n"
"if {![winfo exists $data(-parent)]} {\n"
"error \"bad window path name \\\"$data(-parent)\\\"\"\n"
"}\n"
"}\n"
"\n"
"proc tkMotifFDialog_Create {w} {\n"
"set dataName [lindex [split $w .] end]\n"
"upvar #0 $dataName data\n"
"\n"
"\n"
"\n"
"toplevel $w -class TkMotifFDialog\n"
"set top [frame $w.top -relief raised -bd 1]\n"
"set bot [frame $w.bot -relief raised -bd 1]\n"
"\n"
"pack $w.bot -side bottom -fill x\n"
"pack $w.top -side top -expand yes -fill both\n"
"\n"
"set f1 [frame $top.f1]\n"
"set f2 [frame $top.f2]\n"
"set f3 [frame $top.f3]\n"
"\n"
"pack $f1 -side top    -fill x\n"
"pack $f3 -side bottom -fill x\n"
"pack $f2 -expand yes -fill both\n"
"\n"
"set f2a [frame $f2.a]\n"
"set f2b [frame $f2.b]\n"
"\n"
"grid $f2a -row 0 -column 0 -rowspan 1 -columnspan 1 -padx 4 -pady 4 \\\n"
"-sticky news\n"
"grid $f2b -row 0 -column 1 -rowspan 1 -columnspan 1 -padx 4 -pady 4 \\\n"
"-sticky news\n"
"grid rowconfig $f2 0    -minsize 0   -weight 1\n"
"grid columnconfig $f2 0 -minsize 0   -weight 1\n"
"grid columnconfig $f2 1 -minsize 150 -weight 2\n"
"\n"
"\n"
"\n"
"label $f1.lab -text \"Filter:\" -under 3 -anchor w\n"
"entry $f1.ent\n"
"pack $f1.lab -side top -fill x -padx 6 -pady 4\n"
"pack $f1.ent -side top -fill x -padx 4 -pady 0\n"
"set data(fEnt) $f1.ent\n"
"\n"
"\n"
"\n"
"set data(dList) [tkMotifFDialog_MakeSList $w $f2a Directory: 0 DList]\n"
"set data(fList) [tkMotifFDialog_MakeSList $w $f2b Files:     2 FList]\n"
"\n"
"\n"
"\n"
"label $f3.lab -text \"Selection:\" -under 0 -anchor w\n"
"entry $f3.ent\n"
"pack $f3.lab -side top -fill x -padx 6 -pady 0\n"
"pack $f3.ent -side top -fill x -padx 4 -pady 4\n"
"set data(sEnt) $f3.ent\n"
"\n"
"\n"
"\n"
"set data(okBtn) [button $bot.ok     -text OK     -width 6 -under 0 \\\n"
"-command \"tkMotifFDialog_OkCmd $w\"]\n"
"set data(filterBtn) [button $bot.filter -text Filter -width 6 -under 0 \\\n"
"-command \"tkMotifFDialog_FilterCmd $w\"]\n"
"set data(cancelBtn) [button $bot.cancel -text Cancel -width 6 -under 0 \\\n"
"-command \"tkMotifFDialog_CancelCmd $w\"]\n"
"\n"
"pack $bot.ok $bot.filter $bot.cancel -padx 10 -pady 10 -expand yes \\\n"
"-side left\n"
"\n"
"\n"
"\n"
"bind $w <Alt-t> \"focus $data(fEnt)\"\n"
"bind $w <Alt-d> \"focus $data(dList)\"\n"
"bind $w <Alt-l> \"focus $data(fList)\"\n"
"bind $w <Alt-s> \"focus $data(sEnt)\"\n"
"\n"
"bind $w <Alt-o> \"tkButtonInvoke $bot.ok    \"\n"
"bind $w <Alt-f> \"tkButtonInvoke $bot.filter\"\n"
"bind $w <Alt-c> \"tkButtonInvoke $bot.cancel\"\n"
"\n"
"bind $data(fEnt) <Return> \"tkMotifFDialog_ActivateFEnt $w\"\n"
"bind $data(sEnt) <Return> \"tkMotifFDialog_ActivateSEnt $w\"\n"
"\n"
"wm protocol $w WM_DELETE_WINDOW \"tkMotifFDialog_CancelCmd $w\"\n"
"}\n"
"\n"
"proc tkMotifFDialog_MakeSList {w f label under cmd} {\n"
"label $f.lab -text $label -under $under -anchor w\n"
"listbox $f.l -width 12 -height 5 -selectmode browse -exportselection 0\\\n"
"-xscrollcommand \"$f.h set\" \\\n"
"-yscrollcommand \"$f.v set\" \n"
"scrollbar $f.v -orient vertical   -takefocus 0 \\\n"
"-command \"$f.l yview\"\n"
"scrollbar $f.h -orient horizontal -takefocus 0 \\\n"
"-command \"$f.l xview\"\n"
"grid $f.lab -row 0 -column 0 -sticky news -rowspan 1 -columnspan 2 \\\n"
"-padx 2 -pady 2\n"
"grid $f.l -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news\n"
"grid $f.v -row 1 -column 1 -rowspan 1 -columnspan 1 -sticky news\n"
"grid $f.h -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news\n"
"\n"
"grid rowconfig    $f 0 -weight 0 -minsize 0\n"
"grid rowconfig    $f 1 -weight 1 -minsize 0\n"
"grid columnconfig $f 0 -weight 1 -minsize 0\n"
"\n"
"\n"
"\n"
"set list $f.l\n"
"bind $list <Up>        \"tkMotifFDialog_Browse$cmd $w\"\n"
"bind $list <Down>      \"tkMotifFDialog_Browse$cmd $w\"\n"
"bind $list <space>     \"tkMotifFDialog_Browse$cmd $w\"\n"
"bind $list <1>         \"tkMotifFDialog_Browse$cmd $w\"\n"
"bind $list <B1-Motion> \"tkMotifFDialog_Browse$cmd $w\"\n"
"bind $list <Double-1>  \"tkMotifFDialog_Activate$cmd $w\"\n"
"bind $list <Return>    \"tkMotifFDialog_Browse$cmd $w; tkMotifFDialog_Activate$cmd $w\"\n"
"\n"
"bindtags $list \"Listbox $list [winfo toplevel $list] all\"\n"
"tkListBoxKeyAccel_Set $list\n"
"\n"
"return $f.l\n"
"}\n"
"\n"
"proc tkMotifFDialog_BrowseDList {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"focus $data(dList)\n"
"if {![string compare [$data(dList) curselection] \"\"]} {\n"
"return\n"
"}\n"
"set subdir [$data(dList) get [$data(dList) curselection]]\n"
"if {![string compare $subdir \"\"]} {\n"
"return\n"
"}\n"
"\n"
"$data(fList) selection clear 0 end\n"
"\n"
"set list [tkMotifFDialog_InterpFilter $w]\n"
"set data(filter) [lindex $list 1]\n"
"\n"
"switch -- $subdir {\n"
". {\n"
"set newSpec [file join $data(selectPath) $data(filter)]\n"
"}\n"
".. {\n"
"set newSpec [file join [file dirname $data(selectPath)] \\\n"
"$data(filter)]\n"
"}\n"
"default {\n"
"set newSpec [file join $data(selectPath) $subdir $data(filter)]\n"
"}\n"
"}\n"
"\n"
"$data(fEnt) delete 0 end\n"
"$data(fEnt) insert 0 $newSpec\n"
"}\n"
"\n"
"proc tkMotifFDialog_ActivateDList {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {![string compare [$data(dList) curselection] \"\"]} {\n"
"return\n"
"}\n"
"set subdir [$data(dList) get [$data(dList) curselection]]\n"
"if {![string compare $subdir \"\"]} {\n"
"return\n"
"}\n"
"\n"
"$data(fList) selection clear 0 end\n"
"\n"
"switch -- $subdir {\n"
". {\n"
"set newDir $data(selectPath)\n"
"}\n"
".. {\n"
"set newDir [file dirname $data(selectPath)]\n"
"}\n"
"default {\n"
"set newDir [file join $data(selectPath) $subdir]\n"
"}\n"
"}\n"
"\n"
"set data(selectPath) $newDir\n"
"tkMotifFDialog_Update $w\n"
"\n"
"if {[string compare $subdir ..]} {\n"
"$data(dList) selection set 0\n"
"$data(dList) activate 0\n"
"} else {\n"
"$data(dList) selection set 1\n"
"$data(dList) activate 1\n"
"}\n"
"}\n"
"\n"
"proc tkMotifFDialog_BrowseFList {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"focus $data(fList)\n"
"if {![string compare [$data(fList) curselection] \"\"]} {\n"
"return\n"
"}\n"
"set data(selectFile) [$data(fList) get [$data(fList) curselection]]\n"
"if {![string compare $data(selectFile) \"\"]} {\n"
"return\n"
"}\n"
"\n"
"$data(dList) selection clear 0 end\n"
"\n"
"$data(fEnt) delete 0 end\n"
"$data(fEnt) insert 0 [file join $data(selectPath) $data(filter)]\n"
"$data(fEnt) xview end\n"
"\n"
"$data(sEnt) delete 0 end\n"
"$data(sEnt) insert 0 [file join $data(selectPath) $data(selectFile)]\n"
"$data(sEnt) xview end\n"
"}\n"
"\n"
"proc tkMotifFDialog_ActivateFList {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"if {![string compare [$data(fList) curselection] \"\"]} {\n"
"return\n"
"}\n"
"set data(selectFile) [$data(fList) get [$data(fList) curselection]]\n"
"if {![string compare $data(selectFile) \"\"]} {\n"
"return\n"
"} else {\n"
"tkMotifFDialog_ActivateSEnt $w\n"
"}\n"
"}\n"
"\n"
"proc tkMotifFDialog_ActivateFEnt {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"set list [tkMotifFDialog_InterpFilter $w]\n"
"set data(selectPath) [lindex $list 0]\n"
"set data(filter)    [lindex $list 1]\n"
"\n"
"tkMotifFDialog_Update $w\n"
"}\n"
"\n"
"proc tkMotifFDialog_InterpFilter {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"set text [string trim [$data(fEnt) get]]\n"
"\n"
"\n"
"if {![string compare [string index $text 0] ~]} {\n"
"set list [file split $text]\n"
"set tilde [lindex $list 0]\n"
"catch {\n"
"set tilde [glob $tilde]\n"
"}\n"
"set text [eval file join [concat $tilde [lrange $list 1 end]]]\n"
"}\n"
"\n"
"set resolved [file join [file dirname $text] [file tail $text]]\n"
"\n"
"if {[file isdirectory $resolved]} {\n"
"set dir $resolved\n"
"set fil $data(filter)\n"
"} else {\n"
"set dir [file dirname $resolved]\n"
"set fil [file tail    $resolved]\n"
"}\n"
"\n"
"return [list $dir $fil]\n"
"}\n"
"\n"
"\n"
"proc tkMotifFDialog_ActivateSEnt {w} {\n"
"global tkPriv\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"set selectFilePath [string trim [$data(sEnt) get]]\n"
"set selectFile     [file tail    $selectFilePath]\n"
"set selectPath     [file dirname $selectFilePath]\n"
"\n"
"\n"
"if {![string compare $selectFilePath \"\"]} {\n"
"tkMotifFDialog_FilterCmd $w\n"
"return\n"
"}\n"
"\n"
"if {[file isdirectory $selectFilePath]} {\n"
"set data(selectPath) [glob $selectFilePath]\n"
"set data(selectFile) \"\"\n"
"tkMotifFDialog_Update $w\n"
"return\n"
"}\n"
"\n"
"if {[string compare [file pathtype $selectFilePath] \"absolute\"]} {\n"
"tk_messageBox -icon warning -type ok \\\n"
"-message \"\\\"$selectFilePath\\\" must be an absolute pathname\"\n"
"return\n"
"}\n"
"\n"
"if {![file exists $selectPath]} {\n"
"tk_messageBox -icon warning -type ok \\\n"
"-message \"Directory \\\"$selectPath\\\" does not exist.\"\n"
"return\n"
"}\n"
"\n"
"if {![file exists $selectFilePath]} {\n"
"if {![string compare $data(type) open]} {\n"
"tk_messageBox -icon warning -type ok \\\n"
"-message \"File \\\"$selectFilePath\\\" does not exist.\"\n"
"return\n"
"}\n"
"} else {\n"
"if {![string compare $data(type) save]} {\n"
"set message [format %s%s \\\n"
"\"File \\\"$selectFilePath\\\" already exists.\\n\\n\" \\\n"
"\"Replace existing file?\"]\n"
"set answer [tk_messageBox -icon warning -type yesno \\\n"
"-message $message]\n"
"if {![string compare $answer \"no\"]} {\n"
"return\n"
"}\n"
"}\n"
"}\n"
"\n"
"set tkPriv(selectFilePath) $selectFilePath\n"
"set tkPriv(selectFile)     $selectFile\n"
"set tkPriv(selectPath)     $selectPath\n"
"}\n"
"\n"
"\n"
"proc tkMotifFDialog_OkCmd {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"tkMotifFDialog_ActivateSEnt $w\n"
"}\n"
"\n"
"proc tkMotifFDialog_FilterCmd {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"tkMotifFDialog_ActivateFEnt $w\n"
"}\n"
"\n"
"proc tkMotifFDialog_CancelCmd {w} {\n"
"global tkPriv\n"
"\n"
"set tkPriv(selectFilePath) \"\"\n"
"set tkPriv(selectFile)     \"\"\n"
"set tkPriv(selectPath)     \"\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tkMotifFDialog_Update {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"$data(fEnt) delete 0 end\n"
"$data(fEnt) insert 0 [file join $data(selectPath) $data(filter)]\n"
"$data(sEnt) delete 0 end\n"
"$data(sEnt) insert 0 [file join $data(selectPath) $data(selectFile)]\n"
"\n"
"tkMotifFDialog_LoadFiles $w\n"
"}\n"
"\n"
"proc tkMotifFDialog_LoadFiles {w} {\n"
"upvar #0 [winfo name $w] data\n"
"\n"
"$data(dList) delete 0 end\n"
"$data(fList) delete 0 end\n"
"\n"
"set appPWD [pwd]\n"
"if {[catch {\n"
"cd $data(selectPath)\n"
"}]} {\n"
"cd $appPWD\n"
"\n"
"$data(dList) insert end \"..\"\n"
"return\n"
"}\n"
"\n"
"\n"
"\n"
"foreach f [lsort -command tclSortNoCase [glob -nocomplain .* *]] {\n"
"if {[file isdirectory $f]} {\n"
"$data(dList) insert end $f\n"
"}\n"
"}\n"
"\n"
"\n"
"if {![string compare $data(filter) *]} {\n"
"set files [lsort -command tclSortNoCase [glob -nocomplain .* *]]\n"
"} else {\n"
"set files [lsort -command tclSortNoCase \\\n"
"[glob -nocomplain $data(filter)]]\n"
"}\n"
"\n"
"set top 0\n"
"foreach f $files {\n"
"if {![file isdir $f]} {\n"
"$data(fList) insert end $f\n"
"if {[string match .* $f]} {\n"
"incr top\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"$data(fList) yview $top\n"
"\n"
"cd $appPWD\n"
"}\n"
"\n"
"proc tkListBoxKeyAccel_Set {w} {\n"
"bind Listbox <Any-KeyPress> \"\"\n"
"bind $w <Destroy> \"tkListBoxKeyAccel_Unset $w\"\n"
"bind $w <Any-KeyPress> \"tkListBoxKeyAccel_Key $w %A\"\n"
"}\n"
"\n"
"proc tkListBoxKeyAccel_Unset {w} {\n"
"global tkPriv\n"
"\n"
"catch {after cancel $tkPriv(lbAccel,$w,afterId)}\n"
"catch {unset tkPriv(lbAccel,$w)}\n"
"catch {unset tkPriv(lbAccel,$w,afterId)}\n"
"}\n"
"\n"
"proc tkListBoxKeyAccel_Key {w key} {\n"
"global tkPriv\n"
"\n"
"append tkPriv(lbAccel,$w) $key\n"
"tkListBoxKeyAccel_Goto $w $tkPriv(lbAccel,$w)\n"
"catch {\n"
"after cancel $tkPriv(lbAccel,$w,afterId)\n"
"}\n"
"set tkPriv(lbAccel,$w,afterId) [after 500 tkListBoxKeyAccel_Reset $w]\n"
"}\n"
"\n"
"proc tkListBoxKeyAccel_Goto {w string} {\n"
"global tkPriv\n"
"\n"
"set string [string tolower $string]\n"
"set end [$w index end]\n"
"set theIndex -1\n"
"\n"
"for {set i 0} {$i < $end} {incr i} {\n"
"set item [string tolower [$w get $i]]\n"
"if {[string compare $string $item] >= 0} {\n"
"set theIndex $i\n"
"}\n"
"if {[string compare $string $item] <= 0} {\n"
"set theIndex $i\n"
"break\n"
"}\n"
"}\n"
"\n"
"if {$theIndex >= 0} {\n"
"$w selection clear 0 end\n"
"$w selection set $theIndex $theIndex\n"
"$w activate $theIndex\n"
"$w see $theIndex\n"
"}\n"
"}\n"
"\n"
"proc tkListBoxKeyAccel_Reset {w} {\n"
"global tkPriv\n"
"\n"
"catch {unset tkPriv(lbAccel,$w)}\n"
"}\n"
"\n"
"";
#line 707 "et80.c"
Et_EvalInclude("xmfbox.tcl",_ET_script_); };
  { static char _ET_script_[] = 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {$tcl_platform(platform) == \"windows\"} {\n"
"\n"
"set tcl_wordchars \"\\[^ \\t\\n\\]\"\n"
"set tcl_nonwordchars \"\\[ \\t\\n\\]\"\n"
"} else {\n"
"\n"
"set tcl_wordchars {[a-zA-Z0-9_]}\n"
"set tcl_nonwordchars {[^a-zA-Z0-9_]}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tcl_wordBreakAfter {str start} {\n"
"global tcl_nonwordchars tcl_wordchars\n"
"set str [string range $str $start end]\n"
"if {[regexp -indices \"$tcl_wordchars$tcl_nonwordchars|$tcl_nonwordchars$tcl_wordchars\" $str result]} {\n"
"return [expr {[lindex $result 1] + $start}]\n"
"}\n"
"return -1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tcl_wordBreakBefore {str start} {\n"
"global tcl_nonwordchars tcl_wordchars\n"
"if {[string compare $start end] == 0} {\n"
"set start [string length $str]\n"
"}\n"
"if {[regexp -indices \"^.*($tcl_wordchars$tcl_nonwordchars|$tcl_nonwordchars$tcl_wordchars)\" [string range $str 0 $start] result]} {\n"
"return [lindex $result 1]\n"
"}\n"
"return -1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tcl_endOfWord {str start} {\n"
"global tcl_nonwordchars tcl_wordchars\n"
"if {[regexp -indices \"$tcl_nonwordchars*$tcl_wordchars+$tcl_nonwordchars\" \\\n"
"[string range $str $start end] result]} {\n"
"return [expr {[lindex $result 1] + $start}]\n"
"}\n"
"return -1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tcl_startOfNextWord {str start} {\n"
"global tcl_nonwordchars tcl_wordchars\n"
"if {[regexp -indices \"$tcl_wordchars*$tcl_nonwordchars+$tcl_wordchars\" \\\n"
"[string range $str $start end] result]} {\n"
"return [expr {[lindex $result 1] + $start}]\n"
"}\n"
"return -1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc tcl_startOfPreviousWord {str start} {\n"
"global tcl_nonwordchars tcl_wordchars\n"
"if {[string compare $start end] == 0} {\n"
"set start [string length $str]\n"
"}\n"
"if {[regexp -indices \\\n"
"\"$tcl_nonwordchars*($tcl_wordchars+)$tcl_nonwordchars*\\$\" \\\n"
"[string range $str 0 [expr {$start - 1}]] result word]} {\n"
"return [lindex $word 0]\n"
"}\n"
"return -1\n"
"}\n"
"";
#line 708 "et80.c"
Et_EvalInclude("word.tcl",_ET_script_); };
  Et_Eval(__FILE__,__LINE__,"s","proc init {} {# do nothing}; init ");
  Et_Eval(__FILE__,__LINE__,"s","set Win32 0");
  return ET_OK;
}

/**************************************************************************
** The following code is copied from generic/tkWindow.c with slight
** modifications.
*/
/*
 * The variables and table below are used to parse arguments from
 * the "argv" variable in Tk_Init.
 */

static int synchronize = 0;
static char *name = NULL;
static char *display = NULL;
static char *geometry = NULL;
static char *colormap = NULL;
static char *use = NULL;
static char *visual = NULL;
static int rest = 0;

static Tk_ArgvInfo argTable[] = {
    {"-colormap", TK_ARGV_STRING, (char *) NULL, (char *) &colormap,
	"Colormap for main window"},
    {"-display", TK_ARGV_STRING, (char *) NULL, (char *) &display,
	"Display to use"},
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,
	"Initial geometry for window"},
    {"-name", TK_ARGV_STRING, (char *) NULL, (char *) &name,
	"Name to use for application"},
    {"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
    {"-visual", TK_ARGV_STRING, (char *) NULL, (char *) &visual,
	"Visual for main window"},
    {"-use", TK_ARGV_STRING, (char *) NULL, (char *) &use,
	"Id of window in which to embed application"},
    {"--", TK_ARGV_REST, (char *) 1, (char *) &rest,
	"Pass all remaining arguments through to script"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};
static int
Initialize(interp)
    Tcl_Interp *interp;		/* Interpreter to initialize. */
{
    char *p;
    int argc, code;
    char **argv, *args[20];
    Tcl_DString class;
    char buffer[30];

    /*
     * Start by initializing all the static variables to default acceptable
     * values so that no information is leaked from a previous run of this
     * code.
     */

    synchronize = 0;
    name = NULL;
    display = NULL;
    geometry = NULL;
    colormap = NULL;
    use = NULL;
    visual = NULL;
    rest = 0;

    /*
     * Tk is only allowed to be loaded in a safe interpreter whos
     * Master is non-safe, not in its slaves. Otherwise the slave
     * could create new toplevels, which is a security risk.
     */

    if (Tcl_IsSafe(Tcl_GetMaster(interp))) {
	Tcl_AppendResult(interp, "Cannot initialize Tk: would create",
		" new toplevel window", (char *) NULL);
    }

    /*
     * If there is an "argv" variable, get its value, extract out
     * relevant arguments from it, and rewrite the variable without
     * the arguments that we used.
     */

    p = Tcl_GetVar2(interp, "argv", (char *) NULL, TCL_GLOBAL_ONLY);
    argv = NULL;
    if (p != NULL) {
	if (Tcl_SplitList(interp, p, &argc, &argv) != TCL_OK) {
	    argError:
	    Tcl_AddErrorInfo(interp,
		    "\n    (processing arguments in argv variable)");
	    return TCL_ERROR;
	}
	if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv,
		argTable, TK_ARGV_DONT_SKIP_FIRST_ARG|TK_ARGV_NO_DEFAULTS)
		!= TCL_OK) {
	    ckfree((char *) argv);
	    goto argError;
	}
	p = Tcl_Merge(argc, argv);
	Tcl_SetVar2(interp, "argv", (char *) NULL, p, TCL_GLOBAL_ONLY);
	sprintf(buffer, "%d", argc);
	Tcl_SetVar2(interp, "argc", (char *) NULL, buffer, TCL_GLOBAL_ONLY);
	ckfree(p);
    }

    /*
     * Figure out the application's name and class.
     */

    Tcl_DStringInit(&class);
    if (name == NULL) {
	int offset;
	TkpGetAppName(interp, &class);
	offset = Tcl_DStringLength(&class)+1;
	Tcl_DStringSetLength(&class, offset);
	Tcl_DStringAppend(&class, Tcl_DStringValue(&class), offset-1);
	name = Tcl_DStringValue(&class) + offset;
    } else {
	Tcl_DStringAppend(&class, name, -1);
    }

    p = Tcl_DStringValue(&class);
    if (islower(UCHAR(*p))) {
	*p = toupper(UCHAR(*p));
    }

    /*
     * Create an argument list for creating the top-level window,
     * using the information parsed from argv, if any.
     */

    args[0] = "toplevel";
    args[1] = ".";
    args[2] = "-class";
    args[3] = Tcl_DStringValue(&class);
    argc = 4;
    if (display != NULL) {
	args[argc] = "-screen";
	args[argc+1] = display;
	argc += 2;

	/*
	 * If this is the first application for this process, save
	 * the display name in the DISPLAY environment variable so
	 * that it will be available to subprocesses created by us.
	 */

	Tcl_SetVar2(interp, "env", "DISPLAY", display, TCL_GLOBAL_ONLY);
    }
    if (colormap != NULL) {
	args[argc] = "-colormap";
	args[argc+1] = colormap;
	argc += 2;
        colormap = NULL;
    }
    if (use != NULL) {
	args[argc] = "-use";
	args[argc+1] = use;
	argc += 2;
        use = NULL;
    }
    if (visual != NULL) {
	args[argc] = "-visual";
	args[argc+1] = visual;
	argc += 2;
        visual = NULL;
    }
    args[argc] = NULL;
    code = TkCreateFrame((ClientData) NULL, interp, argc, args, 1, name);

    Tcl_DStringFree(&class);
    if (code != TCL_OK) {
	goto done;
    }
    Tcl_ResetResult(interp);
    if (synchronize) {
	XSynchronize(Tk_Display(Tk_MainWindow(interp)), True);
    }

    /*
     * Set the geometry of the main window, if requested.  Put the
     * requested geometry into the "geometry" variable.
     */

    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    goto done;
	}
        geometry = NULL;
    }
    if (Tcl_PkgRequire(interp, "Tcl", TCL_VERSION, 1) == NULL) {
	code = TCL_ERROR;
	goto done;
    }
    code = Tcl_PkgProvide(interp, "Tk", TK_VERSION);
    if (code != TCL_OK) {
	goto done;
    }

    /*
     * Invoke platform-specific initialization.
     */

    /* code = TkpInit(interp); */
    code = ReadStartupScripts(interp);

    done:
    if (argv != NULL) {
	ckfree((char *) argv);
    }
    if (code != TCL_ERROR) {
	code = TCL_OK;
    }
    return code;
}
/*
** End of the code from generic/tkWindow.c
***********************************************************************/

/*
** Initialize the Tcl/Tk interpreter.
**
** This is a highly modified version of "main()" from the
** file "tkMain.c" in the standard Tcl/Tk distribution.
*/
void
Et_Init(pargc,argv)
int *pargc;
char **argv;
{
    char *args;

    if( getenv("DISPLAY")==0 ){
      fprintf(stderr,"%s: DISPLAY environment variable is not set.\n",argv[0]);
      exit(1);
    }
    Tcl_FindExecutable(argv[0]);
    Et_Interp = Tcl_CreateInterp();

    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".
     */

    args = Tcl_Merge(*pargc-1, argv+1);
    Tcl_SetVar(Et_Interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    Et_Eval(__FILE__,__LINE__,"sds","set argc ",(*pargc-1)," ");
    Et_Eval(__FILE__,__LINE__,"sqs","set argv0 \"",(argv[0]),"\" ");

    /*
     * Set the "tcl_interactive" variable.
     */
    Et_Eval(__FILE__,__LINE__,"sds","set tcl_interactive ",(isatty(0))," ");

    /*
     * Invoke application-specific initialization.
     */
    if( Initialize(Et_Interp)!=TCL_OK ){
      fprintf(stderr,"%s: Can't initialize the display.\n", argv[0]);
      fprintf(stderr,"Check your DISPLAY environment variable.\n");
      exit(1);
    }
    Tcl_StaticPackage(Et_Interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);

    /* Set the et_trace_flag */
    Tcl_LinkVar(Et_Interp, "et_trace_flag", (char*)&et_trace_flag,TCL_LINK_INT);

    /* Set up some convenience global variables.
    **
    ** This only works if there is a single display and screen.  But, then
    ** again, ET only works with a single screen...
    */
    Et_MainWindow = Tk_MainWindow(Et_Interp);
    Et_Display = Tk_Display(Et_MainWindow);

    /*
     * Create variables "cmd_name" and "cmd_dir" which contain the
     * base name of the application and the name of the directory 
     * which contains the executable for the application.
     */
    Et_Eval(__FILE__,__LINE__,"sssssssssss","\n"
,"set cmd_name [file tail $argv0]\n"
,"set cmd_dir [file dirname $argv0]\n"
,"if \"![file readable $argv0] || ![file isfile $argv0]\" {\n"
,"foreach i [split $env(PATH) :] {\n"
,"if \"[file readable $i/$cmd_name] && [file isfile $i/$cmd_name]\" {\n"
,"set cmd_dir $i\n"
,"break;\n"
,"}\n"
,"}\n"
,"}\n"
);
}

/*
** Process Tk events until the last window is destroyed, then return.
*/
void
Et_MainLoop(){
    Tk_MainLoop();
}

/*
** Static variables used by the interactive Tcl/Tk processing
*/
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static Tcl_DString line;	/* Used to read the next line from the
                                 * terminal input. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */


/*
 *----------------------------------------------------------------------
 *
 * Prompt --
 *
 *	Issue a prompt on standard output, or invoke a script
 *	to issue the prompt.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	A prompt gets output, and a Tcl script may be evaluated
 *	in interp.
 *
 *----------------------------------------------------------------------
 */

static void
Prompt(interp, partial)
    Tcl_Interp *interp;			/* Interpreter to use for prompting. */
    int partial;			/* Non-zero means there already
					 * exists a partial command, so use
					 * the secondary prompt. */
{
    char *promptCmd;
    int code;
    Tcl_Channel outChannel, errChannel;

    errChannel = Tcl_GetChannel(interp, "stderr", NULL);

    promptCmd = Tcl_GetVar(interp,
	partial ? "tcl_prompt2" : "tcl_prompt1", TCL_GLOBAL_ONLY);
    if (promptCmd == NULL) {
defaultPrompt:
	if (!partial) {

            /*
             * We must check that outChannel is a real channel - it
             * is possible that someone has transferred stdout out of
             * this interpreter with "interp transfer".
             */

	    outChannel = Tcl_GetChannel(interp, "stdout", NULL);
            if (outChannel != (Tcl_Channel) NULL) {
                Tcl_Write(outChannel, "% ", 2);
            }
	}
    } else {
	code = Tcl_Eval(interp, promptCmd);
	if (code != TCL_OK) {
	    Tcl_AddErrorInfo(interp,"\n    (script that generates prompt)");

            /*
             * We must check that errChannel is a real channel - it
             * is possible that someone has transferred stderr out of
             * this interpreter with "interp transfer".
             */
	    errChannel = Tcl_GetChannel(interp, "stderr", NULL);
            if (errChannel != (Tcl_Channel) NULL) {
                Tcl_Write(errChannel, interp->result, -1);
                Tcl_Write(errChannel, "\n", 1);
            }
	    goto defaultPrompt;
	}
    }
    outChannel = Tcl_GetChannel(interp, "stdout", NULL);
    if (outChannel != (Tcl_Channel) NULL) {
        Tcl_Flush(outChannel);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * StdinProc --
 *
 *	This procedure is invoked by the event dispatcher whenever
 *	standard input becomes readable.  It grabs the next line of
 *	input characters, adds them to a command being assembled, and
 *	executes the command if it's complete.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Could be almost arbitrary, depending on the command that's
 *	typed.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
static void
StdinProc(clientData, mask)
    ClientData clientData;		/* Not used. */
    int mask;				/* Not used. */
{
    static int gotPartial = 0;
    char *cmd;
    int code, count;
    Tcl_Channel chan = (Tcl_Channel) clientData;

    count = Tcl_Gets(chan, &line);

    if (count < 0) {
	if (!gotPartial) {
	    if (tty) {
		Tcl_Exit(0);
	    } else {
		Tcl_DeleteChannelHandler(chan, StdinProc, (ClientData) chan);
	    }
	    return;
	} else {
	    count = 0;
	}
    }

    (void) Tcl_DStringAppend(&command, Tcl_DStringValue(&line), -1);
    cmd = Tcl_DStringAppend(&command, "\n", -1);
    Tcl_DStringFree(&line);
    
    if (!Tcl_CommandComplete(cmd)) {
        gotPartial = 1;
        goto prompt;
    }
    gotPartial = 0;

    /*
     * Disable the stdin channel handler while evaluating the command;
     * otherwise if the command re-enters the event loop we might
     * process commands from stdin before the current command is
     * finished.  Among other things, this will trash the text of the
     * command being evaluated.
     */

    Tcl_CreateChannelHandler(chan, 0, StdinProc, (ClientData) chan);
    code = Tcl_RecordAndEval(Et_Interp, cmd, TCL_EVAL_GLOBAL);
    Tcl_CreateChannelHandler(chan, TCL_READABLE, StdinProc,
	    (ClientData) chan);
    Tcl_DStringFree(&command);
    if (*Et_Interp->result != 0) {
	if ((code != TCL_OK) || (tty)) {
	    /*
	     * The statement below used to call "printf", but that resulted
	     * in core dumps under Solaris 2.3 if the result was very long.
             *
             * NOTE: This probably will not work under Windows either.
	     */

	    puts(Et_Interp->result);
	}
    }

    /*
     * Output a prompt.
     */

    prompt:
    if (tty) {
	Prompt(Et_Interp, gotPartial);
    }
    Tcl_ResetResult(Et_Interp);
}

/*
** Make arrangements to read and interpret standard input
*/
void
Et_ReadStdin()
{
  Tcl_Channel inChannel;

  tty = isatty(0);
  inChannel = Tcl_GetStdChannel(TCL_STDIN);
  if (inChannel) {
    Tcl_CreateChannelHandler(inChannel, TCL_READABLE, StdinProc,
                             (ClientData) inChannel);
  }
  if( tty ){
    Et_Eval(__FILE__,__LINE__,"sssssss","\n"
,"if ![info exists tcl_prompt1] {\n"
,"set tcl_prompt1 { puts -nonewline stdout [file tail $argv0]> }\n"
,"}\n"
,"if ![info exists tcl_prompt2] {\n"
,"set tcl_prompt2 { puts -nonewline stdout => }\n"
,"}\n"
);
    Prompt(Et_Interp, 0);
  }
  Tcl_DStringInit(&command);
}

/******* Automatically generated code follows ********/
#ifdef __cplusplus
#  define EXTERN extern "C"
#else
#  define EXTERN extern
#endif
EXTERN void Et_InstallCommand(char *,int (*)(void*,struct Tcl_Interp*,int,char**));
void Et_Init_et80_c(void){
}
