#ifndef security_h
#define security_h

/*
 * $Id$
 *
 * NAME:
 *	security.h  -- Copyright (C) 1998 David Corcoran
 *               corcordt@cs.purdue.edu
 *
 * DESCRIPTION:
 *	These functions return the status of the function.  
 *       The hex representation of the command is sent back by
 *       BinData struct along with the size.
 *
 * AUTHOR:
 *	David Corcoran, 3/17/98
 *
 * LICENSE: See file LICENSE.
 *
 */

#include "defines.h"

bool
Security_Verify(
	BYTE qualifier,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
Security_InternalAuth(
	BYTE keynumber,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
Security_ExternalAuth(
	BYTE keynumber,
	BYTE *data,
	struct BinData *bindata
);

bool
Security_GetChallenge(
	BYTE size,
	struct BinData *bindata
);

bool
Security_VerifyKey(
	BYTE keynumber,
	BYTE keysize,
	BYTE *key,
	struct BinData *bindata
);

bool
Security_VerifyCHV(
	BYTE keysize,
	BYTE *key,
	struct BinData *bindata
);

bool
Security_ChangeCHV(
	BYTE keysizes,
	BYTE *keys,
	struct BinData *bindata
);

bool
Security_UnblockCHV(
	BYTE keysizes,
	BYTE *keys,
	struct BinData *bindata
);

bool
Security_Invalidate(
	BYTE cryptosize,
	BYTE *cryptogram,
	struct BinData *bindata
);

bool
Security_Rehabilitate(
	BYTE cryptosize,
	BYTE *cryptogram,
	struct BinData *bindata
);

bool
Security_IntAut(
	BYTE keynumber,
	BYTE cryptosize,
	BYTE *rsa,
	struct BinData *bindata
);

bool
Security_LoadCertificate(
	BYTE keynumber,
	BYTE *rsaid,
	BYTE *rsa,
	struct BinData *bindata
);

bool
Security_VerifyPubKey(
	BYTE *publickey,
	struct BinData *bindata
);

bool
Security_VerifyData(
	BYTE keynumber,
	BYTE *rsarand,
	BYTE *rsa,
	struct BinData *bindata
);

bool
Security_UpdateKeyEnc(
	BYTE highbyte,
	BYTE lowbyte,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
Security_VerifyPIN(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

/* The following are non-standard functions for export regulations */

bool
Security_FullDesAuth(
	BYTE mode,
	BYTE keynum,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
Security_RSAKeyGen(
	BYTE keynum,
	struct BinData *bindata
);

#endif
