/*
 * NAME:
 *	security.c -- Copyright (C) 1998 David Corcoran
 *	Modifications for Open16K, Copyright (C) 1998 Schlumberger, All Rights Reserved.
 *
 * DESCRIPTION:
 *      This provides some card security type functions available.
 * 
 * AUTHOR:
 *	David Corcoran, 3/17/98
 *	Danny Kumamoto, 1-Nov-1998 make it work for Cyberflex Open16K
 *
 * LICENSE: See file LICENSE.
 *
 */
#include <assert.h>
#include <string.h>

#include "security.h"

static char _rcsid[] UNUSED = "$Id$";

bool Security_VerifyKey(BYTE keynumber, BYTE size, BYTE *key, struct BinData *bindata) { 

  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }
  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0x2a;			/* Instruction  */
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = keynumber;		/* P2		*/
  bindata->Header[4] = size;			/* P3		*/

  memcpy(bindata->TxBuffer, key, size);  /* Key to be Verified 		*/

  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_VerifyCHV(BYTE size, BYTE *key, struct BinData *bindata) {

  /* FIX: Why is this not finished ? */

  key=NULL;
  size=0;
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_ChangeCHV(BYTE size, BYTE *keys, struct BinData *bindata) {
 
  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }

  bindata->Header[0] = EXCEPTION_CLASS;			/* Class	*/
  bindata->Header[1] = 0x24;			/* Instruction  */
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = 0x01;			/* P2		*/
  bindata->Header[4] = size; 			/* P3		*/

  memcpy(bindata->TxBuffer, keys, size);/* Old CHV/New CHV  		*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_UnblockCHV(BYTE size, BYTE *keys, struct BinData *bindata) {
 
  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }
  bindata->Header[0] = EXCEPTION_CLASS;			/* Class	*/
  bindata->Header[1] = 0x2c;			/* Instruction  */
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = 0x01;			/* P2		*/
  bindata->Header[4] = size; 			/* P3		*/

  memcpy(bindata->TxBuffer, keys, size); /* Unblocking CHV/New CHV	*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_Invalidate(BYTE size, BYTE *cryptogram, struct BinData *bindata) { 

  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }
  bindata->Header[0] = EXCEPTION_CLASS;			/* Class	*/
  bindata->Header[1] = 0x04;			/* Instruction 	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = 0x00;			/* P2		*/
  bindata->Header[4] = size;			/* P3		*/

  memcpy(bindata->TxBuffer, cryptogram, size); /* Cryptogram		*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_Rehabilitate(BYTE size, BYTE *cryptogram, struct BinData *bindata) {
 
  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }
  bindata->Header[0] = EXCEPTION_CLASS;			/* Class	*/
  bindata->Header[1] = 0x44;			/* Instruction	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = 0x00;			/* P2		*/
  bindata->Header[4] = size;			/* P3		*/

  memcpy(bindata->TxBuffer, cryptogram, size); /* Cryptogram	*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_IntAut(BYTE keynumber, BYTE size, BYTE *rsa, struct BinData *bindata) { 

  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }
  bindata->Header[0] = 0x94;			/* Class	*/
  bindata->Header[1] = 0x42;			/* Instruction	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = keynumber;		/* P2		*/
  bindata->Header[4] = 0x80;			/* P3		*/

  memcpy(bindata->TxBuffer, rsa, size); /* RSA Key		*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_LoadCertificate(BYTE keynumber, BYTE *rsaid, BYTE *rsa, struct BinData *bindata) { 

  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0x84;			/* Instruction	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = keynumber;		/* P2		*/
  bindata->Header[4] = 0x80;			/* P3		*/

  memcpy(bindata->TxBuffer, rsaid, 4);	  /* RSA Id		*/
  memcpy(&bindata->TxBuffer[4], rsa, 124); /* RSA Key		*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_VerifyPubKey(BYTE *publickey, struct BinData *bindata) {
 
  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0x86;			/* Instruction	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = 0x00;			/* P2		*/
  bindata->Header[4] = 0x80;			/* P3		*/

  memcpy(bindata->TxBuffer, publickey, 128); /* Public Key	*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_VerifyData (BYTE keynumber, BYTE *rsarand, BYTE *rsa, struct BinData *bindata) {
 
  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0x82;			/* Instruction  */
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = keynumber;		/* P2		*/
  bindata->Header[4] = 0x80;			/* P3		*/

  memcpy(bindata->TxBuffer, rsarand, 4);	  /*	Challenge	*/ 
  memcpy(&bindata->TxBuffer[4], rsa, 124); /*	RSA Key		*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_UpdateKeyEnc(BYTE highbyte, BYTE lowbyte, BYTE size, BYTE *data, struct BinData *bindata) {
 
  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }
  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0xde; 			/* Instruction	*/
  bindata->Header[2] = highbyte;		/* P1		*/
  bindata->Header[3] = lowbyte;		/* P2		*/
  bindata->Header[4] = size;			/* P3		*/

  memcpy(bindata->TxBuffer, data, size);	/* FIX: What the hell ?	*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_GetChallenge(BYTE size, struct BinData *bindata) {

	bindata->Header[0] = CARD_CLASS;	     /* Class	    */
	bindata->Header[1] = 0x84; 	     /*	Instruction */
	bindata->Header[2] = 0x00;	     /*	P1	    */
	bindata->Header[3] = 0x00; 	     /*	P2	    */
	bindata->Header[4] = size;	     /*	P3	    */

	return (TRUE);
}

bool Security_VerifyPIN(BYTE size, BYTE *data, struct BinData *bindata) {
  
  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }

  bindata->Header[0] = EXCEPTION_CLASS;			/* Class	*/
  bindata->Header[1] = 0x20; 			/* Instruction	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = 0x01;			/* P2		*/
  bindata->Header[4] = size;			/* P3		*/

  memcpy(bindata->TxBuffer, data, size);	/* Value to be removed	*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

/* The following are non-standard functions for export regulations */


bool Security_FullDesAuth(BYTE mode, BYTE keynum, BYTE size, BYTE *challenge, struct BinData *bindata) {

  if (size + 5 > MAX_BUFFER_SIZE) {
 	bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
	return FALSE;
  }

  if ((mode != 0)&&(mode != 1))         /* Mode 0 -> DES-1 */
	return ISO_INVALID_PARAMETER;   /* Mode 1 -> DES   */

  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0x88; 			/* Instruction	*/
  bindata->Header[2] = mode;			/* P1		*/
  bindata->Header[3] = keynum;			/* P2		*/
  bindata->Header[4] = size;			/* P3		*/

  memcpy(bindata->TxBuffer, challenge, size);	/* Value to be removed	*/
  
  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}

bool Security_RSAKeyGen(BYTE keynum, struct BinData *bindata) {

  if (keynum > 0x0E)         			/* Wrong key num ? */
	return ISO_INVALID_PARAMETER;

  bindata->Header[0] = CARD_CLASS;			/* Class	*/
  bindata->Header[1] = 0x14; 			/* Instruction	*/
  bindata->Header[2] = 0x00;			/* P1		*/
  bindata->Header[3] = keynum;			/* P2		*/
  bindata->Header[4] = 00;			/* P3		*/

  bindata->CommandStatus = ISO_COMMAND_SUCCESS;
  return TRUE;
}
