/*
 * NAME:
 *	operation.c -- Copyright (C) 1998 David Corcoran
 *                 corcordt@cs.purdue.edu
 *	Modifications for Open16K, Copyright (C) 1998 Schlumberger, All Rights Reserved.
 *
 * DESCRIPTION:
 *      This provides some card operation type function definitions
 *
 * AUTHOR:
 *	David Corcoran, 4/16/98
 *	Danny Kumamoto, 1-Nov-1998 make it work for Cyberflex Open16K
 *
 * LICENSE: See file LICENSE.
 *
 */

#include <assert.h>
#include <string.h>

#include "operation.h"

static char _rcsid[] UNUSED = "$Id$";

bool Operation_GetResponse(BYTE size, struct BinData *bindata) {

	bindata->Header[0] = EXCEPTION_CLASS;	     /* Class	    */
	bindata->Header[1] = 0xc0; 	     /*	Instruction */
	bindata->Header[2] = 0x00;	     /*	P1	    */
	bindata->Header[3] = 0x00;	     /*	P2	    */
	bindata->Header[4] = size;	     /*	P3	    */

	return TRUE;
}

bool Operation_ManageChannel(BYTE status, BYTE identity, struct BinData *bindata) {

	bindata->Header[0] = CARD_CLASS;	     /* Class       */
	bindata->Header[1] = 0x70; 	     /*	Instruction */
	bindata->Header[2] = status;	     /*	P1	    */
	bindata->Header[3] = identity;	     /*	P2	    */
	bindata->Header[4] = 0x00;	     /*	P3	    */
  
	return TRUE;
}

bool Operation_Envelope(BYTE size, BYTE *data, struct BinData *bindata) {

	if (size + 5 > MAX_BUFFER_SIZE) {
		bindata->CommandStatus = ISO_INVALID_COMMAND_SIZE;
		return FALSE;
	}

	bindata->Header[0] = CARD_CLASS;	     /* Class	    */
	bindata->Header[1] = 0xc2;	     /*	Instruction */
	bindata->Header[2] = 0x00;	     /*	P1	    */
	bindata->Header[3] = 0x00;	     /*	P2	    */
	bindata->Header[4] = size;	     /*	P3	    */

	memcpy(bindata->TxBuffer, data, size); /* Data to write		*/
	return TRUE;
}

bool Operation_JavaExeInitApp(BYTE *fileid, BYTE mode, struct BinData *bindata) {

	bindata->Header[0] = CARD_CLASS;	     /* Class       */
	bindata->Header[1] = 0xF2; 	     /*	Instruction */
	bindata->Header[2] = fileid[0];	     /*	P1	    */
	bindata->Header[3] = fileid[1];	     /*	P2	    */
	bindata->Header[4] = 1;	     	     /*	P3	    */

					/* Init/Exe Mode		*/
					/* 0x80 - Immediate launch 	*/
	bindata->TxBuffer[0] = mode;	/* 0x08 - Launch at next Reset 	*/
					/* 0x00 - Reset to default	*/
  return TRUE;
}
