#ifndef FILESYSTEM_H
#define FILESYSTEM_H

/*
 * $Id$
 *
 * NAME:
 *	filesystem.h -- Copyright (C) 1998 David Corcoran
 *                     corcordt@cs.purdue.edu
 *	Modifications for Open16K, Copyright (C) 1998 Schlumberger, All Rights Reserved.
 *
 * DESCRIPTION:
 *	The functions in this module create File System type commands from their
 *	arguments. The result is fit to be passed to the card reader.
 *
 * AUTHOR:   David Corcoran, 4/16/98
 *		Danny Kumamoto, 2-Nov-1998, Support Open16K/Siemens correctly
 *
 * LICENSE: See file LICENSE.
 *
 */

#include "defines.h"

/* for file creation */

#define ISO_FILE_DEDICATED		(BYTE)0x20	/* Dedicated File (Directory)      */
#define ISO_FILE_APPLICATION		(BYTE)0x21	/* Application File		   */
#define ISO_FILE_BINARY			(BYTE)0x02	/* Binary Elementary File 	   */
#define ISO_FILE_PROGRAM		(BYTE)0x03	/* Program Elementary File 	   */
#define ISO_FILE_CYCLIC			(BYTE)0x1D	/* Cyclic Elementary File 	   */
#define ISO_FILE_VARIABLE_RECORD	(BYTE)0x19	/* Variable Record Elementary File */	
#define ISO_FILE_FIXED_RECORD		(BYTE)0x0C	/* Fixed Record Elementary File	   */

/* file type when getting select/directory result (actually TE9 standard) */

#define ISO_FILETYPE_MASTER		0x01
#define ISO_FILETYPE_DEDICATED		0x02
#define ISO_FILETYPE_ELEMENTARY		0x04

#define ISO_STRUCTYPE_BINARY		0x01
#define ISO_STRUCTYPE_VARIABLE_RECORD	0x02
#define ISO_STRUCTYPE_CYCLIC		0x03
#define ISO_STRUCTYPE_FIXED_RECORD	0x04

bool
File_CreateFile(
	BYTE init,
	BYTE numrecords,
	BYTE *size,
	BYTE *fileid,
	BYTE filetype,
	BYTE *access,
	BYTE status,
	BYTE *keys,
	BYTE rlength,
	struct BinData *bindata
);

bool
File_Dir(
	BYTE dirnumb,
	struct BinData *bindata
);

bool
File_CreateRecord(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_DeleteFile(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_ReadBin(
	BYTE high,
	BYTE low,
	BYTE size,
	struct BinData *bindata
);

bool
File_WriteBin(
	BYTE high,
	BYTE low,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_UpdateBin(
	BYTE high,
	BYTE low,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_EraseBin(
	BYTE high,
	BYTE low,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_Seek(
	BYTE offset,
	BYTE mode,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_Increase(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_Decrease(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_ReadRec(
	BYTE recordnumber,
	BYTE mode,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_WriteRec(
	BYTE recordnumber,
	BYTE mode,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_AppendRec(
	BYTE high,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_UpdateRec(
	BYTE recordnumber,
	BYTE mode,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_GetData(
	BYTE object,
	BYTE identifier,
	BYTE size,
	struct BinData *bindata
);

bool
File_PutData(
	BYTE object,
	BYTE identifier,
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_Select(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool
File_SelectDF(
	struct BinData *bindata
);

bool
File_SelectApplet(
	BYTE size,
	BYTE *data,
	struct BinData *bindata
);

bool 
File_ManageProgramValidate(
	BYTE size,
	BYTE *data, 
	struct BinData *bindata
);

void 
File_ManageProgramReset(struct BinData *bindata);

#endif /* FILESYSTEM_H */
