#ifndef DEFINES_H
#define DEFINES_H

/*
 * $Id$
 *
 * NAME:
 *	defines.h -- Copyright (C) 1998 David Corcoran
 *                corcordt@cs.purdue.edu
 *
 * DESCRIPTION:
 *       Some global definitions and typedefs
 *
 * AUTHOR:
 *	David Corcoran, 3/17/98
 *
 *	Modified for Macintosh by Mark Hartman
 */

#include <winscard.h>

#ifdef OPEN16K
#define SC_MORE_INFO	(0x9F) /* TE9 for get more info */

/* Open16K card used both F0 and A0 */
#define CARD_CLASS (0xF0)
#define EXCEPTION_CLASS (0xA0)
#else

/* we assume we have Access cards */
#define ACCESS
#define SC_MORE_INFO	(0x61) /* ISO for get more info */

/* Access cards can be all 00 or all F0 -- default is 00 for this release */
#ifdef ACCESS_00
#define CARD_CLASS (0x00)
#define EXCEPTION_CLASS (0x00)
#elif ACCESS_F0
#define CARD_CLASS (0xF0)
#define EXCEPTION_CLASS (0xF0)
#else
  !!! compile error !!!;
Unknown Access card (must be ACCESS_00 or ACCESS_F0) !;
#endif /* non ACCESS */
#endif /* !OPEN16K */

#ifdef ACL_ALL
#define ACL_NON_AUT0 (0xFF)
#else
#ifdef ACL_NONE
#define ACL_NON_AUT0 (0x00)
#endif /* NONE */
#endif /* ALL */

/* #define CPU_PC_UNIX - 
 *     Any Unix machine including SUN
 *
 * #define CPU_MAC_OS  - 
 *     Any Macintosh machine with Device Toolkit
 */

#define CPU_PC_UNIX

/*
 * Pervasive constant: The card readed buffer size (also the maximal
 * length of a command), Status byte size.
 */

#ifndef MAX_BUFFER_SIZE
#define MAX_BUFFER_SIZE		258
#endif /* MAX_BUFFER_SIZE */
#ifdef MAXPATHLEN
#define MAX_PATH_LEN		(MAXPATHLEN)
#else
#define MAX_PATH_LEN		1024
#endif /* MAXPATHLEN */
#define STATUS_SIZE		2
#define MAX_AID_LENGTH		16

/*
 * Boolean constants
 */

#ifndef TRUE

  #define TRUE	1
  #define FALSE	0

#endif

/*
 * Type definitions
 */

#ifndef HANDLE

 #ifdef CPU_MAC_OS
   typedef Handle HANDLE;
 #endif

 #ifdef CPU_PC_UNIX
   typedef int HANDLE;
 #endif

#endif

#ifndef bool

 typedef int bool;

#endif


struct BinData {
  BYTE Header[MAX_BUFFER_SIZE];	        /* Cla, Ins, P1, P2, P3 	*/
  BYTE TxBuffer[MAX_BUFFER_SIZE];	/* Data with size P3		*/
  BYTE CommandStatus;		        /* Status of last command 	*/
};


#define ISO_INVALID_COMMAND_SIZE   (unsigned char)0xA0 /* Command > MAX_BUFFER_SIZE       */
#define ISO_INVALID_SEEK_MODE	   (unsigned char)0xA1	/* Invalid File Seek Mode	   */
#define ISO_COMMAND_SUCCESS	   (unsigned char)0xA2	/* Command Executed Successfully   */
#define ISO_INVALID_PARAMETER	   (unsigned char)0xA3  /* Invalid parameter given to function */

/*
 * Compiler dependencies
 */

#ifdef __GNUC__
#define UNUSED __attribute__((unused))
#else
#define UNUSED
#endif

#endif /* DEFINES_H */
