#ifndef DBIISO_H
#define DBIISO_H

/*
 * $Id$
 *
 * NAME:
 *	dbiiso.h - Copyright (C) 1998 David Corcoran
 *                 corcordt@cs.purdue.edu
 *
 * DESCRIPTION:
 *      Definitions for dbiiso.c
 *
 * AUTHOR:
 *	David Corcoran, 3/17/98
 *
 * LICENSE: See file LICENSE.
 *
 */

#include "defines.h"

/*
 * Definitions for Reflex Reader commands
 */

#define PC_to_RDR_SetMode       (unsigned char)0x61 
#define PC_to_RDR_CardPowerOn   (unsigned char)0x62 
#define PC_to_RDR_CardPowerOff  (unsigned char)0x63 
#define PC_to_RDR_Reset         (unsigned char)0x64 
#define PC_to_RDR_GetRdrStatus  (unsigned char)0x65 
#define PC_to_RDR_SendRdrByte   (unsigned char)0x66 
#define PC_to_RDR_SendRdrBlock  (unsigned char)0x67 
#define PC_to_RDR_ResendBlock   (unsigned char)0x68 
#define PC_to_RDR_GetRdrCap     (unsigned char)0x69 
#define PC_to_RDR_DeActivateRdr (unsigned char)0x6A 
#define PC_to_RDR_Escape        (unsigned char)0x6B 
#define PC_to_RDR_SPE		(unsigned char)0x10 

#define RDR_to_PC_Type          (unsigned char)0x60 
#define RDR_to_PC_Status        (unsigned char)0x61 
#define RDR_to_PC_Ack           (unsigned char)0x62 
#define RDR_to_PC_DataByte      (unsigned char)0x63 
#define RDR_to_PC_DataBlock     (unsigned char)0x64 
#define RDR_to_PC_CardIn        (unsigned char)0x65 
#define RDR_to_PC_CardOut       (unsigned char)0x66 
#define RDR_to_PC_Nack          (unsigned char)0x67 
#define RDR_to_PC_Cap           (unsigned char)0x68 
#define RDR_to_PC_Escape        (unsigned char)0x69
#define RDR_to_PC_PIN		(unsigned char)0x2A 

#define ISO_GET_RESET		1
#define ISO_GET_SW		2
#define ISO_GET_ACTUAL_BAUD	3

#define DBI_FAST_OK		1
#define DBI_FAST_NULL_POINTER	0
#define DBI_FAST_INIT_ERROR	0

#define CRYPTO_SUCCESS		(unsigned char)0x90
#define CRYPTO_ACCESS		(unsigned char)0x63

HANDLE				/* Handle to initialized reader port	*/
InitializeReaderPort(	        /* Initialize the reader port		*/
	int baudrate,
	int bits,
	char parity,
	char *reader
);

bool
DisposeReaderPort(
	void
);

BYTE *
Reflex_ReturnRdrStatus(void);

BYTE * 
Reflex_CardResponse(void);

bool
Reflex_GetRdrType(void);

bool
Reflex_SetRdrMode(void);

int
Reflex_Reset(
	BYTE Atr[], 
	int *Length
);

bool
Reflex_GetRdrStatus(void);

bool
Reflex_GetRdrCap(void);

bool
Reflex_DeActivateRdr(void);

bool
Reflex_SecurePinEntry(void);

bool
Reflex_CardCommand(
	BYTE cardbuffer[MAX_BUFFER_SIZE],
	int size
);

/***********************************************************************
 *
 *   American Biometrics smartcard API
 *
 ***********************************************************************/

int DBI_IsoReset (BYTE *Atr, int *Length);
int DBI_IsoPts   (int Speed, int Protocol);
int DBI_IsoOff   (void);
int DBI_IsoRaw   (int TxLength, BYTE *TxBuffer, int RxLength, BYTE *RxBuffer);
int DBI_IsoCase1 (BYTE *Header);
int DBI_IsoCase2 (BYTE *Header, BYTE *RxBuffer);
int DBI_IsoCase3 (BYTE *Header, BYTE *TxBuffer);
int DBI_IsoSet   (int Parameter, int Value);
int DBI_IsoGet   (int Parameter, BYTE *Value);

#endif
