#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "ctapi.h"
#include "ctbcs.h"
#include "atr.h"

int main(int argc, char* argv[]) {
  
	unsigned int pn;
	unsigned int ctn = 1;
	unsigned int lr = 264;
	unsigned int lc = 0;
	unsigned char cmd[264];
	unsigned char res[264];
	unsigned char select_file[7] = {0xC0,0xA4,0x00,0x00,0x02,0x00,0x00};
	unsigned char get_response[5] = {0xC0,0xC0,0x00,0x00,0x00};
	unsigned char verify_key[13] = {0xF0,0x24,0x00,0x01,0x08,0x47,0x46,0x58,0x49,0x32,0x56,0x78,0x40};
	unsigned char update_binary[264] = {0xC0,0xD6,0x00,0x00,0x00};
	unsigned char deactv_card[2] = {CTBCS_CLA,CTBCS_INS_EJECT};
	unsigned char dad;
	unsigned char sad;
	unsigned char protocol;
	int ret;
	int i;
	char option;

	if (argc < 2) {
		fprintf(stderr,"Usage: tester COM_number\n");
		exit(1);
	}

	pn = (unsigned) atoi(argv[1]) - 1;

	printf("Initialicing reader at COM%d...\n",pn + 1);

	ret = CT_init(ctn,pn);
	if (ret != OK) {
		fprintf(stderr,"Error on port allocation: %d\n", ret);
		exit(1);
	}

	cmd[0] = CTBCS_CLA;
	cmd[1] = CTBCS_INS_STATUS;

	printf("Please introduce a card in the reader\n");
	
	while (1) {
		printf(".");
		fflush(stdout);

		dad = 1;
		sad = 2;
		lr = 264;

		ret = CT_data(ctn,&dad,&sad,2,cmd,&lr,res);
		if (ret != OK) {
			fprintf(stderr,"\nError getting status of reader: %s\n",ret);
			exit(1);
		}

		if ( res[0] == CTBCS_DATA_STATUS_CARD ) {
			printf("\n");
			break;
		}

		sleep(2);
	}


	printf("\nActivating card...\n");

	dad = 1;
	sad = 2;
	lr = 264;
	cmd[0] = CTBCS_CLA;
	cmd[1] = CTBCS_INS_RESET;
	cmd[2] = CTBCS_P1_CT_KERNEL;
	cmd[3] = CTBCS_P2_RESET_GET_ATR;

	ret = CT_data(ctn,&dad,&sad,4,cmd,&lr,res);
	if (ret != OK) {
		fprintf(stderr,"Error activating card: %d\n", ret);
		exit(1);
	}
	
	printf("ATR: ");
	for (i=0;i<(lr -2);i++) 
		printf("%X ", res[i]);

	ATR_Protocol(res,lr-2,&protocol);
	printf("\nProtocol %s\n",protocol==ATR_PROTOCOL_T0?"T=0":"T=1");


	while (option != 'q' && option != 'Q') {

		printf("Select option:\n");
		printf("s: Select File (Cryptoflex)\n");
		printf("g: Get Response (Cryptoflex)\n");
		printf("v: Verify Key (Cryptoflex)\n");
		printf("b: Update Binary with 0x00 (Cryptoflex)\n");
		printf("e: Enter APDU\n");
		printf("q: Desactivate card and quit\n");
		printf("> ");

		scanf("%s",&option);

		switch (option) {

			case 's':
			case 'S':

				// Select File
				printf("File ID: ");
				scanf("%X %X", select_file + 5, select_file + 6);

				dad = 0;
				sad = 2;
				lr = 264;

				printf("Command: ");
				for (i=0;i<7;i++) 
					printf("%X ", select_file[i]);
				printf("\n");

				ret = CT_data(ctn,&dad,&sad,7,select_file,&lr,res);
				if (ret != OK) {
					fprintf(stderr,"Error on SELECT FILE: %d\n", ret);
					option = 'q';
					break;
				}

				printf("Response: ");
				for (i=0;i<lr;i++) 
					printf("%X ", res[i]);
				printf("\n");
				
				break;

			case 'g': 
			case 'G':
				// Get Response
				printf("Response size: ");
				scanf("%X", get_response + 4);

				dad = 0;
				sad = 2;
				lr = 264;

				printf("Command: ");
				for (i=0;i<5;i++) 
					printf("%X ", get_response[i]);
				printf("\n");

				ret = CT_data(ctn,&dad,&sad,5,get_response,&lr,res);
				if (ret != OK) {
					fprintf(stderr,"Error on GET RESPONSE: %d\n", ret);
					option = 'q';
					break;
				}

				printf("Response: ");
				for (i=0;i<lr;i++) 
					printf("%X ", res[i]);
				printf("\n");

				break;

			case 'v': 
			case 'V':
				// Verify Key
				dad = 0;
				sad = 2;
				lr = 264;

				printf("Command: ");
				for (i=0;i<13;i++) 
					printf("%X ", verify_key[i]);
				printf("\n");

				ret = CT_data(ctn,&dad,&sad,13,verify_key,&lr,res);
				if (ret != OK) {
					fprintf(stderr,"Error on VERIFY KEY: %d\n", ret);
					option = 'q';
					break;
				}

				printf("Response: ");
				for (i=0;i<lr;i++) 
					printf("%X ", res[i]);
				printf("\n");

				break;

			case 'b': 
			case 'B':
				// Update binary 
				printf("File size: ");
				scanf("%X", update_binary + 4);

				for (i=5;i<(int)update_binary[4] + 5;i++) {
					update_binary[i] = 0x05;
				}
				
				dad = 0;
				sad = 2;
				lr = 264;

				printf("Command: ");
				for (i=0;i< (int)update_binary[4] + 5 ;i++) 
					printf("%X ", update_binary[i]);
				printf("\n");

				ret = CT_data(ctn,&dad,&sad,(int)update_binary[4] + 5,update_binary,&lr,res);
				if (ret != OK) {
					fprintf(stderr,"Error on UPDATE BYNARY: %d\n", ret);
					option = 'q';
					break;
				}

				printf("Response: ");
				for (i=0;i<lr;i++) 
					printf("%X ", res[i]);
				printf("\n");

				break;

			case 'e': 
			case 'E':
				// Other APDU
				printf("Length: ");
				scanf("%d",&lc);
				lc = (lc > 264) ? 264 : lc;

				for (i=0;i<lc;i++) {
					printf("Byte %d/%d: ",i+1,lc);
					scanf("%x",cmd+i);
				}

				dad = 0;
				sad = 2;
				lr = 264;

				printf("Command: ");
				for (i=0;i<lc;i++) 
					printf("%X ", cmd[i]);
				printf("\n");

				ret = CT_data(ctn,&dad,&sad,lc,cmd,&lr,res);
				if (ret != OK) {
					fprintf(stderr,"Error on Command: %d\n", ret);
					option = 'q';
					break;
				}

				printf("Response: ");
				for (i=0;i<lr;i++) 
					printf("%X ", res[i]);
				printf("\n");

				break;

		}
	
	}

	// Deactivate Card
	dad = 1;
	sad = 2;
	lr = 264;
	
	ret = CT_data(ctn,&dad,&sad,2,deactv_card,&lr,res);
	if (ret != OK) 
		fprintf(stderr,"Error deactivating card: %d\n", ret);

	CT_close(ctn);
	exit(0);
}
