/*
 *
 * NAME:
 *      towitoko.h
 *      Copyright (C) 1998 Carlos Prados
 *
 * DESCRIPTION:
 *      Functions for communication with the Towitoko terminals.
 *
 * AUTHOR:
 *      Carlos Prados Bocos, October 1998.
 *      cprados@atos-ods.es
 *
 * LICENSE:
 *      See file COPYING
 */

#ifndef _TOWITOKO_
#define _TOWITOKO_

#include "defines.h"

/* 
 * Definitions of terminal type codes
 */
#define TOWITOKO_CHIPDRIVE_EXT_II	0x88
#define TOWITOKO_CHIPDRIVE_EXT_I	0x84
#define TOWITOKO_CHIPDRIVE_INT		0x90
#define	TOWITOKO_KARTENZWERG		0x80
#define	TOWITOKO_CHIPDRIVE_MICRO	0x61

/*
 * Definitions for Towitoko commands/responses
 */

#define TOWITOKO_NOCARD_NOCHANGE	0x00
#define	TOWITOKO_NOCARD_CHANGE		0x80
#define TOWITOKO_CARD_NOCHANGE		0x40
#define TOWITOKO_CARD_CHANGE		0xC0 
#define TOWITOKO_CARD(status)		(((status) & 0x40)==0x40)
#define TOWITOKO_LED_OFF		0x00
#define TOWITOKO_LED_RED		0x01
#define TOWITOKO_LED_GREEN		0x02
#define TOWITOKO_LED_YELLOW		0x03

/*
 * Definitions of towitoko protocol functions
 */

/*
 * Gets reader type
 * Parameters:
 *	type: returnet reader type
 * Returns:
 *	TRUE if reader type can be determined
 */

extern bool
Towitoko_GetReaderType(BYTE* type); 

/*
 * Forms a card command and sends it to the card.
 * Parameters:
 * 	buffer: data bytes to be sent transparently to the card.
 *	size: number of bytes. 
 * Returns:
 * 	TRUE if size bytes are correctly sent to the card. 
 */

extern bool 
Towitoko_CardCommand(BYTE* buffer, int size);

/*
 * Gets reader/card status.
 * Output parameter:
 *      result:
 *              0x00: No card / no change
 *              0x80: No card / cahnge
 *              0x40: Card present / no change
 *              0xC0: Card present / change
 * Returns:
 *      TRUE if reader status can be determined.
 */

extern bool
Towitoko_GetRdrStatus(BYTE* result); 

/*
 * Sets LED red/green/yellow/off.
 * Parameters: 
 *	color:
 *		0x00 - off
 *		0x01 - red
 *		0x02 - green
 *		0x03 - yellow
 * Returns: 
 *	TRUE if LED color can be set
 */

extern bool 
Towitoko_SetLED(BYTE color);

/*
 * Activates the card.
 * Returns:
 *	TRUE if card can be activated.
 */

extern bool 
Towitoko_ActivateCard(void); 

/*
 * Deactivates the card.
 * Returns:
 *      TRUE if card can be deactivated.
 */

extern bool 
Towitoko_DeactivateCard(void); 

/*
 * Resets card and gets its answer to reset.
 * Output parameters:
 *	Atr: returned ATR
 *	Length: length of the returned ATR
 * Returns:
 *	TRUE if card can be correctly reseted.
 */

extern bool 
Towitoko_ResetCard(BYTE Atr[], int *Length); 

/*
 * Sets terminal (not COM port) parity to even/odd
 * Parameters:
 *	parity: '0' odd parity, 'E' even parity.
 * Returns: 
 *	TRUE if terminal parity can be set.	
 */

extern bool 
Towitoko_SetTerminalParity(char parity); 

#endif /* _TOWITOKO_ */
