/* Title  : Tester for PC/SC Lite
   Author : David Corcoran
   Purpose: Waits for card insertion, then 
            connects and queries random
            generator if exists.
*/

#include <stdio.h>
#include <winscard.h>
#include <configfile.h>

/* #define REPEAT_TEST 1 */


int main( int argc, char **argv ) {
  SCARDHANDLE hCard;
  SCARDCONTEXT hContext;
  struct ReaderContext *rContext;
  SCARD_IO_REQUEST sSendPci, sRecvPci;
  SCARD_READERSTATE_A rgReaderStates;
  DWORD dwReaderLen, dwState, dwProt, dwAtrLen;
  DWORD dwSendLength, dwRecvLength, dwPref, dwReaders;
  LPSTR pcReaders, mszReaders;
  BYTE pbAtr[MAX_ATR_SIZE];
  BYTE s[7], r[20];
  LPCSTR mszGroups;
  LONG rv;
  int i, p, iReader;
  int iList[16];
  char pcHost[50];

  int t = 0;

  printf("\nWinscard PC/SC Lite Test Program\n\n");

  printf("Please enter the desired host (localhost for this machine): ");
  scanf("%s", pcHost);

  printf("Testing SCardEstablishContext \n");
  rv = SCardEstablishContext( SCARD_SCOPE_GLOBAL, pcHost, NULL, &hContext );

  if ( rv != SCARD_S_SUCCESS ) {
    printf("ERROR :: Cannot Connect to Resource Manager\n");
    return 1;
  }

  printf("Testing SCardListReaders \n");

  mszGroups = 0;
  SCardListReaders( hContext, mszGroups, 0, &dwReaders );
  mszReaders = (char *)malloc(sizeof(char)*dwReaders);
  printf("Allocated %d space for readers\n", dwReaders);
  SCardListReaders( hContext, mszGroups, mszReaders, &dwReaders );

  /* Have to understand the multi-string here */
  p = 0;
  for ( i=0; i < dwReaders - 1; i++ ) {
    ++p;
    printf("Reader %02d: %s\n", p, &mszReaders[i]);
    iList[p] = i;
    while ( mszReaders[++i] != 0 );
  }

#ifdef REPEAT_TEST
  if ( t==0 ) { 
#endif

  do {
    printf("Enter the desired reader number : " );
    scanf("%d", &iReader);
    printf("\n");

    if ( iReader > p || iReader <= 0 ) {
      printf("Invalid Value - try again\n");
    }
  } while ( iReader > p || iReader <= 0 );

#ifdef REPEAT_TEST
  t=1; 
  }    
#endif

  rgReaderStates.szReader       = &mszReaders[iList[iReader]];
  rgReaderStates.dwCurrentState = SCARD_STATE_EMPTY;

  printf("Status before %d\n", rgReaderStates.dwCurrentState);
  SCardGetStatusChange( hContext, 0, &rgReaderStates, 1 );
  printf("Status after %d\n", rgReaderStates.dwEventState);

  printf("Testing SCardConnect \n");
  rv = SCardConnect(hContext, &mszReaders[iList[iReader]], 
		    SCARD_SHARE_EXCLUSIVE, SCARD_PROTOCOL_T0, 
		    &hCard, &dwPref);
  printf("SCardConnect Returns %d\n", rv);

#ifdef REPEAT_TEST
  do { 
#endif

  printf("Testing SCardStatus \n");

  dwReaderLen = 50;
  pcReaders   = (char*)malloc(sizeof(char)*50);
  
  rv = SCardStatus( hCard, pcReaders, &dwReaderLen, &dwState, &dwProt,
		    pbAtr, &dwAtrLen );

  printf("SCardStatus Returns %d\n", rv);
  printf("Current Reader Name      %s\n", pcReaders);
  printf("Current Reader State     %x\n", dwState);
  printf("Current Reader Protocol  %x\n", dwProt - 1);
  printf("Current Reader Size ATR  %x\n", dwAtrLen);

  for (i=0; i < dwAtrLen; i++) {
    printf("%x ", pbAtr[i]);
  } printf("\n");


  s[0] = 0x00;   s[1] = 0x84;
  s[2] = 0x00;   s[3] = 0x00;
  s[4] = 0x26;   s[5] = 0x00;
  s[6] = 0x07;   dwSendLength = 5;

  dwRecvLength = s[4] + 2;

  printf("Testing SCardTransmit \n");

  if ( dwProt == SCARD_PROTOCOL_T0 ) {
    rv = SCardTransmit( hCard, SCARD_PCI_T0, s, dwSendLength, &sRecvPci, r,
		        &dwRecvLength );
  } else if ( dwProt == SCARD_PROTOCOL_T1 ) {
    rv = SCardTransmit( hCard, SCARD_PCI_T1, s, dwSendLength, &sRecvPci, r,
		        &dwRecvLength );
  }
  printf("SCardTransmit Returns %d\n", rv);
  printf("Bytes Received %d\n", dwRecvLength);

  for (i=0; i < dwRecvLength; i++) {
    printf("%x ", r[i]);
  } printf("\n");

free (pcReaders);

#ifdef REPEAT_TEST
 } while (1); 
#endif


  printf("Testing SCardDisconnect \n");
  SCardDisconnect( hCard, SCARD_UNPOWER_CARD );



  printf("Testing SCardReleaseContext \n");
  SCardReleaseContext( hContext );
  printf("\a");


  return 0;
}
