
/******************************************************************

	MUSCLE SmartCard Development ( http://www.linuxnet.com )
	    Title  : sys_unix.c
	    Package: pcsc lite
            Author : David Corcoran
            Date   : 11/8/99
            Purpose: This handles abstract system level calls. 
	            
********************************************************************/

#include <sys_generic.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/wait.h>
#include <errno.h>

extern int errno;

int SYS_Sleep( int iTimeVal ) {
  sleep( iTimeVal );
}

int SYS_USleep( int iTimeVal ) {
  usleep( iTimeVal );
}

int SYS_MutexInit( void *vMutex ) {

}

int SYS_MutexLock( void *vMutex ) {

}

int SYS_MutexUnlock( void *vMutex ) {

}

int SYS_OpenFile( char *pcFile, int flags, int mode ) {
  return open( pcFile, flags, mode );
}

int SYS_SeekFile( int iHandle, int iSeekLength ) {
  int iOffset;
  iOffset = lseek( iHandle, iSeekLength, SEEK_SET );
}

int SYS_ReadFile( int iHandle, char *pcBuffer, int iLength ) {


}

int SYS_WriteFile( int iHandle, char *pcBuffer, int iLength ) {
  write( iHandle, pcBuffer, iLength );
}

void *SYS_MemoryMap( int iSize, int iFid, int iOffset ) {

  void *vAddress;
  vAddress = mmap( 0, iSize, PROT_READ | PROT_WRITE,
		   MAP_SHARED, iFid, iOffset ); 

  /*

  switch( errno ) {
  case EINVAL:
    printf("EINVAL\n");
  case EBADF:
    printf("EBADF");
    break;
  case EACCES:
    printf("EACCES");
    break;
  case EAGAIN:
    printf("EAGAIN");
    break;
  case ENOMEM:
    printf("ENOMEM");
    break;

  }

  */

  return vAddress;
}

int SYS_Fork() {
  return fork();
}

int SYS_Wait( int iPid, int iWait ) {

 waitpid( -1, 0, WNOHANG );

}

int SYS_Stat( int iFd ) {
  struct stat sStatus;
  return fstat( iFd, &sStatus );
}
