/******************************************************************

            Title  : winscard_rpc_svc.c
            Package: PC/SC Lite RPC
            Author : David Corcoran
            Date   : 10/24/99
            Purpose: This handles the RPC server services.
            LICENSE: See LICENSE

********************************************************************/

#include "winscard_rpc.h"
#include <winscard.h>
#include <stdio.h>
#include <stdlib.h>/* getenv, exit */
#include <rpc/pmap_clnt.h> /* for pmap_unset */
#include <string.h> /* strcmp */ 
#include <memory.h>
#include <signal.h>
#include <sys_generic.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef __STDC__
#define SIG_PF void(*)(int)
#endif

static void
display_prg_1(struct svc_req *rqstp, register SVCXPRT *transp)
{
	union {
		establish_struct scardestablishcontext_1_arg;
		release_struct scardreleasecontext_1_arg;
		connect_struct scardconnect_1_arg;
		disconnect_struct scarddisconnect_1_arg;
		begin_struct scardbegintransaction_1_arg;
		end_struct scardendtransaction_1_arg;
		cancel_struct scardcanceltransaction_1_arg;
		status_struct scardstatus_1_arg;
		statuschange_struct scardgetstatuschange_1_arg;
		transmit_struct scardtransmit_1_arg;
		cancellock_struct scardcancel_1_arg;
		list_struct scardlistreaders_1_arg;
		read_struct scardreadmemory_1_arg;
		write_struct scardwritememory_1_arg;
	} argument;
	char *result;
	xdrproc_t xdr_argument, xdr_result;
	char *(*local)(char *, struct svc_req *);

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, (xdrproc_t) xdr_void, (char *)NULL);
		return;

	case SCARDESTABLISHCONTEXT:
		xdr_argument = (xdrproc_t) xdr_establish_struct;
		xdr_result = (xdrproc_t) xdr_establish_struct;
		local = (char *(*)(char *, struct svc_req *)) scardestablishcontext_1_svc;
		break;

	case SCARDRELEASECONTEXT:
		xdr_argument = (xdrproc_t) xdr_release_struct;
		xdr_result = (xdrproc_t) xdr_release_struct;
		local = (char *(*)(char *, struct svc_req *)) scardreleasecontext_1_svc;
		break;

	case SCARDCONNECT:
		xdr_argument = (xdrproc_t) xdr_connect_struct;
		xdr_result = (xdrproc_t) xdr_connect_struct;
		local = (char *(*)(char *, struct svc_req *)) scardconnect_1_svc;
		break;

	case SCARDDISCONNECT:
		xdr_argument = (xdrproc_t) xdr_disconnect_struct;
		xdr_result = (xdrproc_t) xdr_disconnect_struct;
		local = (char *(*)(char *, struct svc_req *)) scarddisconnect_1_svc;
		break;

	case SCARDBEGINTRANSACTION:
		xdr_argument = (xdrproc_t) xdr_begin_struct;
		xdr_result = (xdrproc_t) xdr_begin_struct;
		local = (char *(*)(char *, struct svc_req *)) scardbegintransaction_1_svc;
		break;

	case SCARDENDTRANSACTION:
		xdr_argument = (xdrproc_t) xdr_end_struct;
		xdr_result = (xdrproc_t) xdr_end_struct;
		local = (char *(*)(char *, struct svc_req *)) scardendtransaction_1_svc;
		break;

	case SCARDCANCELTRANSACTION:
		xdr_argument = (xdrproc_t) xdr_cancel_struct;
		xdr_result = (xdrproc_t) xdr_cancel_struct;
		local = (char *(*)(char *, struct svc_req *)) scardcanceltransaction_1_svc;
		break;

	case SCARDSTATUS:
		xdr_argument = (xdrproc_t) xdr_status_struct;
		xdr_result = (xdrproc_t) xdr_status_struct;
		local = (char *(*)(char *, struct svc_req *)) scardstatus_1_svc;
		break;

	case SCARDGETSTATUSCHANGE:
		xdr_argument = (xdrproc_t) xdr_statuschange_struct;
		xdr_result = (xdrproc_t) xdr_statuschange_struct;
		local = (char *(*)(char *, struct svc_req *)) scardgetstatuschange_1_svc;
		break;

	case SCARDTRANSMIT:
		xdr_argument = (xdrproc_t) xdr_transmit_struct;
		xdr_result = (xdrproc_t) xdr_transmit_struct;
		local = (char *(*)(char *, struct svc_req *)) scardtransmit_1_svc;
		break;

	case SCARDCANCEL:
		xdr_argument = (xdrproc_t) xdr_cancellock_struct;
		xdr_result = (xdrproc_t) xdr_cancellock_struct;
		local = (char *(*)(char *, struct svc_req *)) scardcancel_1_svc;
		break;

	case SCARDLISTREADERS:
		xdr_argument = (xdrproc_t) xdr_list_struct;
		xdr_result = (xdrproc_t) xdr_list_struct;
		local = (char *(*)(char *, struct svc_req *)) scardlistreaders_1_svc;
		break;

	case SCARDREADMEMORY:
		xdr_argument = (xdrproc_t) xdr_read_struct;
		xdr_result = (xdrproc_t) xdr_read_struct;
		local = (char *(*)(char *, struct svc_req *)) scardreadmemory_1_svc;
		break;

	case SCARDWRITEMEMORY:
		xdr_argument = (xdrproc_t) xdr_write_struct;
		xdr_result = (xdrproc_t) xdr_write_struct;
		local = (char *(*)(char *, struct svc_req *)) scardwritememory_1_svc;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, xdr_argument, (caddr_t) &argument)) {
		svcerr_decode(transp);
		return;
	}

	/* Addition of multi-process server */
	/* Parent goes back to listening    */
	/* Child does the work              */

	if ( rqstp->rq_proc == SCARDGETSTATUSCHANGE ) {
	  int pid;

	  if ( (pid = SYS_Fork()) != 0 ) {
	    return;                
	  }                         
	}

	result = (*local)((char *)&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
	  svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, (caddr_t) &argument)) {
	  fprintf(stderr, "unable to free arguments");
	  exit(1);
	}

	if ( rqstp->rq_proc == SCARDGETSTATUSCHANGE ) {
	  exit(1);
	}

	return;
}


int
main(int argc, char **argv)
{
	register SVCXPRT *transp;
	int rv;

	(void) pmap_unset(DISPLAY_PRG, DISPLAY_VER);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, DISPLAY_PRG, DISPLAY_VER, display_prg_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (DISPLAY_PRG, DISPLAY_VER, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, DISPLAY_PRG, DISPLAY_VER, display_prg_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (DISPLAY_PRG, DISPLAY_VER, tcp).");
		exit(1);
	}

        /* Grab the information from the reader.conf */


        DBUpdateReaders ( PCSCLITE_READER_CONFIG );
        g_rgSCardT0Pci.dwProtocol  = SCARD_PROTOCOL_T0;
        g_rgSCardT1Pci.dwProtocol  = SCARD_PROTOCOL_T1;  

	DebugLogA("PC/SC Lite Server Ready\n", __FILE__, __LINE__);

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}
