/*
 * This is sample code generated by rpcgen.
 * These are only templates and you can use them
 * as a guideline for developing your own functions.
 */

#include "winscard_rpc.h"
#include <winscard.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#define PCSC_DEBUG 1

extern int errno;

static struct _psChannelMap {
  SCARDCONTEXT hContext;
  SCARDCONTEXT hStaticContext;
  SCARDHANDLE  hCardTable[PCSCLITE_MAX_CONTEXTS];
  DWORD        dwTableSize;
  DWORD        psClient;
  CLIENT       *psChannel;
  LPSTR        psHost;
} psChannelMap[PCSCLITE_MAX_CHANNELS];

static DWORD dwChannelNum = 0;

static LONG SCardAddChannel    ( SCARDCONTEXT );
static LONG SCardRemoveChannel ( SCARDCONTEXT );
static LONG SCardGetContext    ( SCARDCONTEXT, SCARDHANDLE );
static LONG SCardAddContext    ( SCARDCONTEXT, SCARDHANDLE );
static LONG SCardRemoveContext ( SCARDHANDLE );
static void SCardCollectZombies( int );

establish_struct * 
scardestablishcontext_1_svc(establish_struct *argp, struct svc_req *rqstp)
{
  LONG liIndex, rv;
  SCARDCONTEXT hContext;
  static establish_struct  result;

  /* Lets clean up and see if their are any 
     zombie connections still in existence   */

  SCardCollectZombies(rqstp->rq_xprt->xp_sock);
  rv = SCardEstablishContext( argp->dwScope, 0, 0, &argp->phContext );
  result.phContext = argp->phContext;
  
  if ( rv == SCARD_S_SUCCESS ) {
    hContext = *((SCARDCONTEXT *) &rqstp->rq_xprt->xp_raddr);
    rv       = SCardAddChannel( hContext );
    
    if ( rv == SCARD_S_SUCCESS ) {
      liIndex = SCardGetContext( hContext, 0 );
      psChannelMap[liIndex].psClient       = rqstp->rq_xprt->xp_sock;
      psChannelMap[liIndex].hStaticContext = argp->phContext; 

#ifdef PCSC_DEBUG
      DebugLogB("scardestablishcontext_1_svc: Current Channel: %d\n",
		liIndex, __FILE__, __LINE__ );
#endif
    }
  }

  result.rv = rv;
  return(&result);
}

release_struct * 
scardreleasecontext_1_svc(release_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  SCARDCONTEXT hContext;
  static release_struct  result;

  hContext = *((SCARDCONTEXT *) &rqstp->rq_xprt->xp_raddr);

  rv = SCardRemoveChannel( hContext );
  
  if ( rv == SCARD_S_SUCCESS ) {
#ifdef PCSC_DEBUG
    DebugLogB("scardreleasecontext_1_svc: Release Channel: %d\n",
	      hContext, __FILE__, __LINE__ );
#endif
    
    rv = SCardReleaseContext( argp->hContext );
  }

  result.rv = rv;  
  return(&result);
}

connect_struct * 
scardconnect_1_svc(connect_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  SCARDCONTEXT hContext;
  static connect_struct  result;


  hContext     = *((SCARDCONTEXT *) &rqstp->rq_xprt->xp_raddr);
  argp->phCard = 0;

  rv = SCardConnect( argp->hContext, argp->szReader.RPC_LPCSTR_val, 
		     argp->dwShareMode, argp->dwPreferredProtocols, 
		     &argp->phCard, &argp->pdwActiveProtocol );

  result.phCard            = argp->phCard;
  result.pdwActiveProtocol = argp->pdwActiveProtocol;

  /* Add the hCard to the list */
  if ( rv == SCARD_S_SUCCESS ) {
    SCardAddContext( hContext, result.phCard );
  }

  result.rv = rv;
  return(&result);
}

disconnect_struct * 
scarddisconnect_1_svc(disconnect_struct *argp, struct svc_req *rqstp)
{
  LONG rv, liIndex;
  static disconnect_struct  result;

  /* FIX :: Remove the hCard from the list */\
  rv = SCardRemoveContext( argp->hCard );

  if ( rv == SCARD_S_SUCCESS ) {
    rv = SCardDisconnect( argp->hCard, argp->dwDisposition );
  }

  result.rv = rv;
  return(&result);
}

begin_struct * 
scardbegintransaction_1_svc(begin_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static begin_struct  result;
  rv = SCardBeginTransaction( argp->hCard );
  result.rv = rv;
  return(&result);
}

end_struct * 
scardendtransaction_1_svc(end_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static end_struct  result;
  rv = SCardEndTransaction( argp->hCard, argp->dwDisposition );
  result.rv = rv;
  return(&result);
}

cancel_struct * 
scardcanceltransaction_1_svc(cancel_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static cancel_struct  result;
  rv = SCardCancel( argp->hCard );
  result.rv = rv;
  return(&result);
}

status_struct * 
scardstatus_1_svc(status_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static status_struct  result;
  BYTE pbAtr[MAX_ATR_SIZE];
  LPSTR mszReaders;

  mszReaders = (LPSTR)malloc(sizeof(char)*argp->pcchReaderLen);

  rv = SCardStatus( argp->hCard, mszReaders,
		    &argp->pcchReaderLen, &argp->pdwState,
		    &argp->pdwProtocol, pbAtr,
		    &argp->pcbAtrLen );

  if ( rv == SCARD_S_SUCCESS ) {

    /* Set the lengths      */
    result.mszReaderNames.RPC_LPSTR_len  = argp->pcchReaderLen; 
    result.pbAtr.RPC_LPBYTE_len          = argp->pcbAtrLen;
    

    /* Free up previously allocated memory */
    if ( result.pbAtr.RPC_LPBYTE_val != 0 ) {
      free ( result.pbAtr.RPC_LPBYTE_val );
    }

    if ( result.mszReaderNames.RPC_LPSTR_val != 0 ) {
      free ( result.mszReaderNames.RPC_LPSTR_val );
    }

    /* Allocate some memory */
    result.pbAtr.RPC_LPBYTE_val = (LPBYTE)
      malloc(sizeof(BYTE)*argp->pcbAtrLen);
    result.mszReaderNames.RPC_LPSTR_val = 
      strdup(mszReaders);

    /* Copy the memory      */
    memcpy( result.pbAtr.RPC_LPBYTE_val, pbAtr, argp->pcbAtrLen );
  }

  result.pcchReaderLen                 = argp->pcchReaderLen;
  result.pdwState                      = argp->pdwState;
  result.pdwProtocol                   = argp->pdwProtocol;
  result.pcbAtrLen                     = argp->pcbAtrLen;
  result.rv                            = rv;

#ifdef PCSC_DEBUG
      DebugLogB("SCardStatus %d\n",
		4, __FILE__, __LINE__ );
#endif

  free (mszReaders);
  return(&result);
}

statuschange_struct * 
scardgetstatuschange_1_svc(statuschange_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static statuschange_struct  result;
  SCARD_READERSTATE_A sTempState;

  /* RPC does not like to pass voids so I have to remove the void
     and pass it along in a modified structure and then recopy it */

  sTempState.szReader       = argp->rgReaderStates.szReader.RPC_LPCSTR_val;
  sTempState.dwCurrentState = argp->rgReaderStates.dwCurrentState;
  sTempState.dwEventState   = argp->rgReaderStates.dwEventState;
  
  rv = SCardGetStatusChange( argp->hContext, argp->dwTimeout,
			     &sTempState, argp->cReaders );
  
  if ( result.rgReaderStates.szReader.RPC_LPCSTR_val != 0 ) {
    free ( result.rgReaderStates.szReader.RPC_LPCSTR_val );
  }

  result.rgReaderStates.szReader.RPC_LPCSTR_val = strdup(sTempState.szReader);
  result.rgReaderStates.szReader.RPC_LPCSTR_len = strlen(sTempState.szReader)+1;
  result.rgReaderStates.dwCurrentState          = sTempState.dwCurrentState;
  result.rgReaderStates.dwEventState            = sTempState.dwEventState;
  result.rgReaderStates.cbAtr                   = sTempState.cbAtr;

  if ( sTempState.cbAtr <= MAX_ATR_SIZE ) {

    /* Free up any previously allocated memory */
    if ( result.rgReaderStates.rgbAtr.RPC_LPBYTE_val != 0 ) {
      free ( result.rgReaderStates.rgbAtr.RPC_LPBYTE_val );
    }

    result.rgReaderStates.rgbAtr.RPC_LPBYTE_val = (BYTE *)malloc
      (sizeof(BYTE)*sTempState.cbAtr);
    result.rgReaderStates.rgbAtr.RPC_LPBYTE_len = sTempState.cbAtr;
    memcpy( result.rgReaderStates.rgbAtr.RPC_LPBYTE_val, sTempState.rgbAtr, 
	    sTempState.cbAtr ); 
  } else {
    result.rgReaderStates.cbAtr = 0;
  }   

  result.rv = rv;

  return(&result);
}

transmit_struct * 
scardtransmit_1_svc(transmit_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static transmit_struct  result;
  SCARD_IO_REQUEST pioSendPci;
  SCARD_IO_REQUEST pioRecvPci;
  BYTE pbRecvBuffer[RPC_MAX_BUFFER_SIZE];
  
  pioSendPci.dwProtocol  = argp->pioSendPci.dwProtocol;
  pioSendPci.cbPciLength = argp->pioSendPci.cbPciLength;
  result.pcbRecvLength   = argp->pcbRecvLength; 

  rv = SCardTransmit( argp->hCard, &pioSendPci, 
 		      argp->pbSendBuffer.RPC_LPCBYTE_val,
		      argp->cbSendLength, &pioRecvPci, 
		      pbRecvBuffer, 
		      &result.pcbRecvLength );

  result.pbRecvBuffer.RPC_LPBYTE_len = result.pcbRecvLength;

  /* Free up any previously allocated memory */
  if ( result.pbRecvBuffer.RPC_LPBYTE_val != 0 ) {
    free (result.pbRecvBuffer.RPC_LPBYTE_val);
  }

  result.pbRecvBuffer.RPC_LPBYTE_val = (char *)malloc
    (sizeof(char)*result.pcbRecvLength);

  memcpy( result.pbRecvBuffer.RPC_LPBYTE_val, pbRecvBuffer, 
	  result.pcbRecvLength );

  memcpy( &result.pioRecvPci, &pioRecvPci, 
	  sizeof(SCARD_IO_REQUEST) );
  
  result.rv = rv;
  
  return(&result);
}

list_struct * 
scardlistreaders_1_svc(list_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static list_struct  result;
  
  if ( argp->mszReaders.RPC_LPSTR_len != 0 ) {

    result.mszReaders.RPC_LPSTR_len = argp->pcchReaders;

    if ( result.mszReaders.RPC_LPSTR_val != 0 ) {
      free (result.mszReaders.RPC_LPSTR_val);
    }

    result.mszReaders.RPC_LPSTR_val = 
      (char *)malloc(sizeof(char)*argp->pcchReaders);

    rv = SCardListReaders( argp->hContext, argp->mszGroups.RPC_LPCSTR_val,
			   result.mszReaders.RPC_LPSTR_val, &result.pcchReaders );

  } else {
    rv = SCardListReaders( argp->hContext, argp->mszGroups.RPC_LPCSTR_val,
			   0, &result.pcchReaders );
  }

  result.rv = rv;
  return(&result);
}

cancellock_struct *
scardcancel_1_svc(cancellock_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static cancellock_struct  result;
  rv = SCardCancel( argp->hContext );
  result.rv = rv;
  return(&result);
}                                                    

read_struct * 
scardreadmemory_1_svc(read_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static read_struct  result;
  BYTE pbBuffer[RPC_MAX_BUFFER_SIZE];

  rv = SCardReadMemory( argp->hCard, argp->dwCardType, argp->dwCardSize,
			argp->dwAddress, pbBuffer, argp->dwLength );

  if ( result.pbBuffer.RPC_LPBYTE_val != 0 ) {
    free( result.pbBuffer.RPC_LPBYTE_val );
  }

  result.pbBuffer.RPC_LPBYTE_val = (char *)malloc
    (sizeof(char)*argp->dwLength);

  result.pbBuffer.RPC_LPBYTE_len = argp->dwLength;

  memcpy( result.pbBuffer.RPC_LPBYTE_val, pbBuffer, argp->dwLength );
  result.rv = rv;
  
  return(&result);
}

write_struct * 
scardwritememory_1_svc(write_struct *argp, struct svc_req *rqstp)
{
  LONG rv;
  static write_struct  result;

  rv = SCardReadMemory( argp->hCard, argp->dwCardType, argp->dwCardSize,
			argp->dwAddress, argp->pcbBuffer.RPC_LPCBYTE_val, 
			argp->dwLength );

  result.pcbBuffer.RPC_LPCBYTE_len = 0;
  result.rv                        = rv;
  
  return(&result);
}

LONG SCardGetContext( SCARDCONTEXT hContext, SCARDHANDLE hCard ) {

  int i, p;

  if ( hCard == 0 ) {
    for ( i=0; i<dwChannelNum; i++ ) {
      if ( hContext == psChannelMap[i].hContext ) {
	return i;
      }
    }
  } else {
    for ( i=0; i<dwChannelNum; i++ ) {
      for (p=0; p < psChannelMap[i].dwTableSize; p++) {
	if ( hCard == psChannelMap[i].hCardTable[p] ) {
	  return i;
	}
      }
    }
  }    
  
  return -1;
}

LONG SCardAddChannel( SCARDCONTEXT hContext ) {
  
  int i;

  if ( dwChannelNum >= PCSCLITE_MAX_CHANNELS ) {
    return SCARD_E_INSUFFICIENT_BUFFER;
  }
  
  psChannelMap[dwChannelNum].hContext    = hContext;
  psChannelMap[dwChannelNum].dwTableSize = 0;
  psChannelMap[dwChannelNum].psClient    = 0;
  psChannelMap[dwChannelNum].psChannel   = 0;
  psChannelMap[dwChannelNum].psHost      = 0;

  dwChannelNum += 1;

  return SCARD_S_SUCCESS;
}

LONG SCardRemoveChannel( SCARDCONTEXT hContext ) {
  
  LONG rv, liIndex;
  int i;
  
  liIndex = SCardGetContext( hContext, 0 );
  
  if ( liIndex != -1 ) {
    
    SCardCancel( psChannelMap[liIndex].hStaticContext );
    
    for ( i=0; i < psChannelMap[liIndex].dwTableSize; i++ ) {
      rv = SCardDisconnect( psChannelMap[liIndex].hCardTable[i], 
			    SCARD_UNPOWER_CARD );      
    }
    
    dwChannelNum          -= 1;
    psChannelMap[liIndex]  = psChannelMap[dwChannelNum];
    return SCARD_S_SUCCESS;
  } 
  
  return SCARD_E_INVALID_HANDLE;
}

LONG SCardAddContext( SCARDCONTEXT hContext, SCARDHANDLE hCard ) {

  /* Add a SCARDHANDLE to the current Channel
     Increment the Table Size                 */


  LONG rv, liIndex;
  int i;
  
  liIndex = SCardGetContext( hContext, 0 );
  
  if ( liIndex != -1 ) {
    if ( psChannelMap[liIndex].dwTableSize >= PCSCLITE_MAX_CONTEXTS ) {
      return SCARD_E_INSUFFICIENT_BUFFER;
    }
    
    psChannelMap[liIndex].hCardTable[psChannelMap[liIndex].
				     dwTableSize] = hCard;
    psChannelMap[liIndex].dwTableSize += 1;
    return SCARD_S_SUCCESS;
  }

  return SCARD_E_INVALID_HANDLE;
}

LONG SCardRemoveContext ( SCARDHANDLE hCard ) {

  int i,p;

  /* Lookup the hCard in all the Context Structures
     Delete it and decrement the counter.
     Note: There is a very low probability that two
     Channels might have the same hCard value in
     which this might fail.  FIX : There is a 1:65536
     chance of this happenning only if connections
     are made to more than 1 resource manager        */

  for (i=0; i < dwChannelNum; i++) {
    for (p=0; p < psChannelMap[i].dwTableSize; p++) {
      if ( psChannelMap[i].hCardTable[p] == hCard ) {
	psChannelMap[i].dwTableSize -= 1;
	psChannelMap[i].hCardTable[p] = 
	  psChannelMap[i].hCardTable[psChannelMap[i].dwTableSize];
      }
    }
  }

  return SCARD_S_SUCCESS;
}

void SCardCollectZombies( int portfd ) {

  int i, ret;
  DWORD psClient, dwChannels;

  DebugLogA("SCardCollectZombies: Collecting Zombies\n",
            __FILE__, __LINE__);     
   
  /* Clean up zombie processes from 
     SCardGetStatusChange           */

  SYS_Wait( 0, 0 ); 

  /* This is kind of strange in the meantime
     If a client dies the operating system will
     free the file descriptor associated with that
     socket connection so I check to see if the current
     descriptor matches a previous and remove any previous
  */

  dwChannels = dwChannelNum;
  for (i=0; i < dwChannels; i++) {
    psClient = psChannelMap[i].psClient;
    if ( psClient == portfd ) {
      DebugLogB("SCardCollectZombies: Client %d Died\n", i,
		__FILE__, __LINE__);     
      SCardRemoveChannel( psChannelMap[i].hContext );
    } else {
      ret = SYS_Stat( psClient );
      if ( ret == -1 ) {
	DebugLogB("SCardCollectZombies: Client %d Died\n", i,
		  __FILE__, __LINE__);
	SCardRemoveChannel( psChannelMap[i].hContext );    
      }
    }
  }    
}
